/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.checker.items;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunChecker;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.checker.items.AbstractChecker;
import kd.epm.eb.common.constant.BgBaseConstant;
import org.jetbrains.annotations.NotNull;

public class EASSchemaChecker
extends AbstractChecker {
    public static IRunChecker get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASSchemaChecker(param, context);
    }

    protected EASSchemaChecker(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getCategoryInfo() {
        return "checker-schema";
    }

    @Override
    public List<IEASUpgradeResult> check() {
        Object row2;
        String[] checkTables = new String[]{"T_MBG_BGSCHEME"};
        if (!this.existTables(this.getParam(), this.getResults(), null, null, this.getCategoryInfo(), checkTables)) {
            return this.getResults();
        }
        String syncDimSetMember = this.getParam().getSyncTableName("T_MBG_BGDIMSETTINGSMEMBER");
        String syncDimSet = this.getParam().getSyncTableName("T_MBG_BGDIMSETTINGS");
        String syncDimView = this.getParam().getSyncTableName("T_MBG_MBGVIEW");
        String syncDim = this.getParam().getSyncTableName("T_MBG_MBGDIM");
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t.fid, t.fdimnumber, m.fmemberid, v.fstandby from " + syncDimSet + " t join " + syncDimSetMember + " m on t.fid = m.fbgdimsettingsid join " + syncDimView + " v on m.fmemberid = v.fid where t.fbgschemeid = ? and t.fdimnumber in (select fnumber from " + syncDim + ") and v.fstandby = 0", new Object[]{this.getContext().getEASSchema().getSchemaId()});
        HashSet dimNumbers = Sets.newHashSetWithExpectedSize((int)32);
        dimNumbers.add("BG_Organization");
        dimNumbers.add("BG_Account");
        dimNumbers.add("BG_Period");
        dimNumbers.add("BG_Scenario");
        dimNumbers.add("BG_Version");
        dimNumbers.add("BG_Currency");
        dimNumbers.add("BG_Element");
        try (DataSet ds = DB.queryDataSet((String)"queryEASDims", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Object row2 : ds) {
                    if ("BG_Consolidation".equals(row2.getString("fdimnumber"))) continue;
                    dimNumbers.add(row2.getString("fdimnumber"));
                }
            }
        }
        if (dimNumbers.size() >= 17) {
            String msg = ResManager.loadResFormat((String)"EAS\u6a21\u578b\u4e0b\u5b58\u572816\u4e2a\u4ee5\u4e0a\u7684\u7ef4\u5ea6\uff0c\u7cfb\u7edf\u65e0\u6cd5\u5347\u7ea7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASSchemaChecker_0", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), msg));
            return this.getResults();
        }
        String syncPeriodType = this.getParam().getSyncTableName("T_MBG_BgPeriodType");
        sql = new SqlBuilder();
        sql.append("select t.fid, t.fnumber, t.fname_l1, t.fname_l2, t.fname_l3, t.fiscalyear, t.fstartyear, t.fendyear, t.fstartmonth, t.fyear, t.fhalfyear, t.fquarter, t.fmonth, t.ftenday, t.fyearweek, t.fmothweek, t.fday, t.fselfdefined from " + syncPeriodType + " t join " + syncDimSetMember + " m on t.fid = m.fmemberid join " + syncDimSet + " dim on m.fbgdimsettingsid = dim.fid where dim.fbgschemeid = ?", new Object[]{this.getContext().getEASSchema().getSchemaId()});
        HashSet<String> periodTypes = new HashSet<String>(32);
        DataSet ds = DB.queryDataSet((String)"queryEASDims", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        row2 = null;
        try {
            if (ds != null) {
                for (Row row3 : ds) {
                    if (!this.canDealCustomPeriod(row3)) continue;
                    periodTypes.add(row3.getString("fnumber"));
                }
            }
        }
        catch (Throwable throwable) {
            row2 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (row2 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row2).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (periodTypes.isEmpty()) {
            String msg = ResManager.loadKDString((String)"EAS\u65b9\u6848\u5173\u8054\u7684\u671f\u95f4\u5206\u7c7b\u4e0d\u53ef\u5347\u7ea7\uff08\u4e0d\u652f\u6301\u65ec\u3001\u5e74\u5468\u3001\u6708\u5468\u3001\u65e5\u671f\u95f4\uff09\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASDimsUpgrade_1", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResults().add(EASUpgradeResult.warring(this.getCategoryInfo(), msg));
            return this.getResults();
        }
        String defaultType = (String)periodTypes.iterator().next();
        if (!(periodTypes.size() <= 1 && "MONT".equals(defaultType) || dimNumbers.size() < 16)) {
            String msg = ResManager.loadKDString((String)"EAS\u6a21\u578b\u4e0b\u5b58\u572815\u4e2a\u4ee5\u4e0a\u7684\u7ef4\u5ea6\uff08\u9700\u8981\u5347\u7ea7\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7ef4\u5ea6\uff09\uff0c\u7cfb\u7edf\u65e0\u6cd5\u5347\u7ea7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASSchemaChecker_1", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), msg));
        }
        return this.getResults();
    }
}

