/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.checker.items;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunChecker;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.checker.items.AbstractChecker;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.SqlBatchUtils;
import org.jetbrains.annotations.NotNull;

public class EASSysVersionChecker
extends AbstractChecker {
    public static IRunChecker get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASSysVersionChecker(param, context);
    }

    protected EASSysVersionChecker(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getCategoryInfo() {
        return "checker-sys-ver";
    }

    @Override
    public List<IEASUpgradeResult> check() {
        String syncTable = this.getParam().getSyncTableName("T_SYS_DATACENTER");
        if (!SqlBatchUtils.hasTable((String)syncTable)) {
            String msg = ResManager.loadResFormat((String)"EAS\u540c\u6b65\u6570\u636e\u8868\uff08%1\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASSysVersionChecker_1", (String)"epm-eb-business", (Object[])new Object[]{"T_SYS_DATACENTER"});
            this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), msg));
            return this.getResults();
        }
        boolean checked = false;
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fmajor, fminor from ", new Object[0]).append(syncTable, new Object[0]).append(" where ftype = 'APP'", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"queryEASDC", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                int mainVer = row.getInteger("fmajor");
                int minVer = row.getInteger("fminor");
                if (mainVer == 8 && minVer >= 5 || mainVer > 9) {
                    checked = true;
                }
            }
        }
        if (!checked) {
            String msg = ResManager.loadKDString((String)"EAS\u6570\u636e\u5347\u7ea7\u4ec5\u652f\u63018.5\u53ca\u4ee5\u540e\u7248\u672c\u3002", (String)"EASSysVersionChecker_0", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), msg));
        }
        return this.getResults();
    }
}

