/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.checker.items;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.easupgrade.constant.EasUpgradeConstants;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunChecker;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.checker.items.AbstractChecker;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.SqlBatchUtils;
import org.jetbrains.annotations.NotNull;

public class EASTableChecker
extends AbstractChecker {
    public static IRunChecker get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASTableChecker(param, context);
    }

    protected EASTableChecker(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getCategoryInfo() {
        return "checker-table";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IEASUpgradeResult> check() {
        LogStats stats = new LogStats("budget-update-log : ");
        stats.addInfo("begin-table-exist.");
        try {
            for (String _table : EasUpgradeConstants.UPGRADE_TABLES) {
                String _syncTable = this.getParam().getSyncTableName(_table);
                if (!SqlBatchUtils.hasTable((String)_syncTable)) {
                    String msg = ResManager.loadResFormat((String)"\u6570\u636e\u8868\u68c0\u67e5 - %1 \u6570\u636e\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASTableChecker_1", (String)"epm-eb-business", (Object[])new Object[]{_syncTable});
                    this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), msg));
                }
                stats.addInfo("check:" + _syncTable);
            }
        }
        catch (Exception ex) {
            log.error("eas-TableChecker-error:", (Throwable)ex);
            this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), ex));
        }
        finally {
            stats.addInfo("end-table-exist.");
            log.info(stats.toString());
        }
        return this.getResults();
    }
}

