/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.context;

import com.google.common.collect.Maps;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.easupgrade.face.IRunData;
import kd.epm.eb.business.easupgrade.impl.dao.EASPeriod;
import kd.epm.eb.business.easupgrade.impl.dao.EasDataUpgradeDetail;
import kd.epm.eb.business.easupgrade.impl.dao.EasDataUpgradeLog;
import kd.epm.eb.business.easupgrade.impl.dao.NewMember;
import kd.epm.eb.business.easupgrade.impl.dao.PeriodMember;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.model.serviceHelper.DataSetServiceHelper;
import org.jetbrains.annotations.NotNull;

public class RunData
implements IRunData {
    private Long modelId = null;
    private IModelCacheHelper modelCache = null;
    private DynamicObject model = null;
    private final Map<Long, DynamicObject> dimensionsMap = Maps.newHashMapWithExpectedSize((int)32);
    private Long userId = null;
    private Date time = null;
    private Long currencyId = null;
    private SecureRandom random = new SecureRandom();
    private DynamicObject busModel = null;
    private DynamicObject dataset = null;
    private EASPeriod easPeriod = null;
    private boolean hasCustomPeriodDim = false;
    private final Map<String, Long> dimIdMap = new ConcurrentHashMap<String, Long>();
    private final Map<String, String> dimNumMap = new ConcurrentHashMap<String, String>();
    private final Map<Long, String> newDimIdMap = new ConcurrentHashMap<Long, String>();
    private final Map<String, String> newDimNumMap = new ConcurrentHashMap<String, String>();
    private final Map<String, Map<String, NewMember>> idMappingMap = new ConcurrentHashMap<String, Map<String, NewMember>>();
    private final Map<String, Map<String, NewMember>> numberMappingMap = new ConcurrentHashMap<String, Map<String, NewMember>>();
    private Map<String, PeriodMember> periodIdMemberMap;
    private Map<String, String> scenrioIdTypeMap;
    private Long successCount = 0L;
    private EasDataUpgradeLog easDataUpgradeLog;
    private List<EasDataUpgradeDetail> easDataUpgradeDetails;
    private Map<String, String> bgOrgUnits = new ConcurrentHashMap<String, String>();
    private Map<String, String> baseOrgUnits = new ConcurrentHashMap<String, String>();
    private Map<String, String> unionIds = new ConcurrentHashMap<String, String>();
    private Map<String, String> baseUnionIds = new ConcurrentHashMap<String, String>();
    private Map<String, Long> unionIdViewIdMap = new HashMap<String, Long>(16);

    @Override
    public void setModelId(@NotNull Long modelId) {
        this.modelId = modelId;
    }

    @Override
    public Long getModelId() {
        return this.modelId;
    }

    @Override
    public IModelCacheHelper getModelCache() {
        if (this.modelCache == null && this.modelId != null) {
            this.modelCache = ModelCacheContext.getOrCreate((Long)this.modelId);
        }
        return this.modelCache;
    }

    @Override
    public void updateModelCache() {
        if (this.modelId != null) {
            this.modelCache = ModelCacheContext.getOrCreate((Long)this.modelId);
        }
    }

    @Override
    public IModelCacheHelper getModelCacheByReBuilder() {
        this.modelCache = ModelCacheContext.getOrCreate((Long)this.modelId, (boolean)true);
        return this.modelCache;
    }

    @Override
    public DynamicObject getModel() {
        if (this.model == null) {
            this.model = BusinessDataServiceHelper.loadSingleFromCache((Object)this.modelCache.getModelobj().getId(), (String)"epm_model");
        }
        return this.model;
    }

    @Override
    public DynamicObject getDimension(@NotNull Long dimensionId) {
        return this.dimensionsMap.computeIfAbsent(dimensionId, f -> BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"epm_dimension"));
    }

    @Override
    public Long getUserId() {
        if (this.userId == null) {
            this.userId = UserUtils.getUserId();
        }
        return this.userId;
    }

    @Override
    public Date getTime() {
        if (this.time == null) {
            this.time = new Date();
        }
        return this.time;
    }

    @Override
    public Long getDefaultCurrency() {
        if (this.currencyId == null) {
            Member member;
            Dimension dimension = this.getModelCache().getDimension(SysDimensionEnum.Currency.getNumber());
            if (dimension != null && (member = dimension.getMember(null, "CNY")) != null) {
                this.currencyId = member.getId();
            }
            if (this.currencyId == null) {
                this.currencyId = 0L;
            }
        }
        return this.currencyId;
    }

    @Override
    public int getRandomVal() {
        return this.random.nextInt(99999);
    }

    @Override
    public DynamicObject getDefaultBusModel() {
        if (this.busModel == null) {
            this.busModel = BusinessModelServiceHelper.getInstance().getDefaultBusModel(Long.valueOf(this.getModel().getLong("id")), null);
        }
        return this.busModel;
    }

    @Override
    public DynamicObject getDefaultDataset() {
        if (this.dataset == null) {
            this.dataset = DataSetServiceHelper.loadDefault(this.getModel().getLong("id"));
        }
        return this.dataset;
    }

    @Override
    public EASPeriod getEASPeriod() {
        if (this.easPeriod == null) {
            this.easPeriod = new EASPeriod();
        }
        return this.easPeriod;
    }

    @Override
    public void setHasCustomPeriodDim(boolean hasCustomPeriodDim) {
        this.hasCustomPeriodDim = hasCustomPeriodDim;
    }

    @Override
    public boolean hasCustomPeriodDim() {
        return this.hasCustomPeriodDim;
    }

    @Override
    public Map<String, String> getDimNumMap() {
        return this.dimNumMap;
    }

    @Override
    public Map<String, String> getNewDimNumMap() {
        return this.newDimNumMap;
    }

    @Override
    public void addDimMapping(@NotNull String oldDimId, @NotNull String oldDimNumber, @NotNull Long newDimId, @NotNull String newDimNumber) {
        this.dimIdMap.put(oldDimId, newDimId);
        this.newDimIdMap.put(newDimId, oldDimId);
        this.dimNumMap.put(oldDimNumber, newDimNumber);
        this.newDimNumMap.put(newDimNumber, oldDimNumber);
    }

    @Override
    public String getOldDimId(Long newDimId) {
        return this.newDimIdMap.get(newDimId);
    }

    @Override
    public String getOldDimNumber(String newDimNumber) {
        return this.newDimNumMap.get(newDimNumber);
    }

    @Override
    public Long getNewDimId(String oldDimId) {
        return this.dimIdMap.get(oldDimId);
    }

    @Override
    public String getNewDimNumber(String oldDimNumber) {
        return this.dimNumMap.get(oldDimNumber);
    }

    @Override
    public Map<String, Map<String, NewMember>> getIdMappingMap() {
        return this.idMappingMap;
    }

    @Override
    public Map<String, Map<String, NewMember>> getNumberMappingMap() {
        return this.numberMappingMap;
    }

    @Override
    public void addMemberMapping(@NotNull String dimNumber, @NotNull Map<String, NewMember> memberIdMapping, @NotNull Map<String, NewMember> memberNumMapping) {
        if (memberIdMapping.isEmpty() || memberNumMapping.isEmpty()) {
            return;
        }
        Map idsMap = this.getIdMappingMap().computeIfAbsent(dimNumber, f -> Maps.newLinkedHashMap());
        idsMap.putAll(memberIdMapping);
        Map numsMap = this.getNumberMappingMap().computeIfAbsent(dimNumber, f -> Maps.newLinkedHashMap());
        numsMap.putAll(memberNumMapping);
    }

    @Override
    public Long getIdByMapping(String dimNumber, String idOrNumber) {
        Long newId = null;
        NewMember newMember = this.getMappingValue(dimNumber, idOrNumber, this.getIdMappingMap());
        if (newMember != null) {
            newId = newMember.getId();
        }
        if (newId == null && (newMember = this.getMappingValue(dimNumber, idOrNumber, this.getNumberMappingMap())) != null) {
            newId = newMember.getId();
        }
        return newId;
    }

    @Override
    public String getNumberByMapping(String dimNumber, String idOrNumber) {
        String newNumber = null;
        NewMember newMember = this.getMappingValue(dimNumber, idOrNumber, this.getIdMappingMap());
        if (newMember != null) {
            newNumber = newMember.getNumber();
        }
        if (newNumber == null && (newMember = this.getMappingValue(dimNumber, idOrNumber, this.getNumberMappingMap())) != null) {
            newNumber = newMember.getNumber();
        }
        return newNumber;
    }

    private NewMember getMappingValue(String dimNumber, String memberIdOrNumber, Map<String, Map<String, NewMember>> mappingMap) {
        Map<String, NewMember> idsMap = mappingMap.get(dimNumber);
        if (idsMap != null) {
            return idsMap.get(memberIdOrNumber);
        }
        return null;
    }

    @Override
    public Map<String, PeriodMember> getPeriodIdMemberMap() {
        return this.periodIdMemberMap;
    }

    @Override
    public void setPeriodIdMemberMap(Map<String, PeriodMember> periodIdMemberMap) {
        this.periodIdMemberMap = periodIdMemberMap;
    }

    @Override
    public Map<String, String> getScenrioIdTypeMap() {
        return this.scenrioIdTypeMap;
    }

    @Override
    public void setScenrioIdTypeMap(Map<String, String> scenrioIdTypeMap) {
        this.scenrioIdTypeMap = scenrioIdTypeMap;
    }

    @Override
    public Long getSuccessCount() {
        return this.successCount;
    }

    @Override
    public void setSuccessCount(Long successCount) {
        this.successCount = successCount;
    }

    @Override
    public void setSuccessCountIncr(Long successCount) {
        RunData runData = this;
        runData.successCount = runData.successCount + successCount;
    }

    @Override
    public EasDataUpgradeLog getEasDataUpgradeLog() {
        if (this.easDataUpgradeLog == null) {
            this.easDataUpgradeLog = new EasDataUpgradeLog();
            this.easDataUpgradeLog.setCreater(this.getUserId());
            this.easDataUpgradeLog.setCreatedate(TimeServiceHelper.now());
            this.easDataUpgradeLog.setModelId(this.getModelId());
        }
        return this.easDataUpgradeLog;
    }

    @Override
    public void setEasDataUpgradeLog(EasDataUpgradeLog easDataUpgradeLog) {
        this.easDataUpgradeLog = easDataUpgradeLog;
    }

    @Override
    public List<EasDataUpgradeDetail> getEasDataUpgradeDetails() {
        if (this.easDataUpgradeDetails == null) {
            this.easDataUpgradeDetails = new ArrayList<EasDataUpgradeDetail>(10);
        }
        return this.easDataUpgradeDetails;
    }

    @Override
    public void addEasDataUpgradeDetails(EasDataUpgradeDetail easDataUpgradeDetail) {
        if (this.easDataUpgradeDetails == null) {
            this.easDataUpgradeDetails = new ArrayList<EasDataUpgradeDetail>(10);
        }
        this.easDataUpgradeDetails.add(easDataUpgradeDetail);
    }

    @Override
    public void clearEasDataUpgradeDetails() {
        if (this.easDataUpgradeDetails != null) {
            this.easDataUpgradeDetails.clear();
        }
    }

    @Override
    public Map<String, String> getBgOrgUnits() {
        return this.bgOrgUnits;
    }

    @Override
    public Map<String, String> getBaseOrgUnits() {
        return this.baseOrgUnits;
    }

    @Override
    public Map<String, String> getUnionIds() {
        return this.unionIds;
    }

    @Override
    public Map<String, String> getBaseUnionIds() {
        return this.baseUnionIds;
    }

    @Override
    public Map<String, Long> getUnionIdViewIdMap() {
        return this.unionIdViewIdMap;
    }

    @Override
    public void setUnionIdViewIdMap(Map<String, Long> unionIdViewIdMap) {
        this.unionIdViewIdMap = unionIdViewIdMap;
    }
}

