/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.dao;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import org.jetbrains.annotations.NotNull;

public class DynamicTree {
    public final DynamicObject member;
    public Map<Long, DynamicTree> children = null;

    public DynamicTree(@NotNull DynamicObject member) {
        this.member = member;
    }

    public void addChild(@NotNull DynamicTree child) {
        if (this.children == null) {
            this.children = new LinkedHashMap<Long, DynamicTree>();
        }
        this.children.putIfAbsent(child.member.getLong("id"), child);
    }

    public void buildData(int seqIndex) {
        this.member.set("isleaf", (Object)(this.children == null || this.children.isEmpty() ? 1 : 0));
        if (this.children != null) {
            int index = 1 + seqIndex;
            int level = this.member.getInt("level");
            List sort = this.children.values().stream().sorted(Comparator.comparing(m -> m.member.getString("number"))).collect(Collectors.toList());
            for (DynamicTree child : sort) {
                String longNumber = this.member.getString("longnumber") + '!' + child.member.getString("number");
                child.member.set("longnumber", (Object)longNumber);
                child.member.set("level", (Object)(level + 1));
                child.member.set("dseq", (Object)index++);
                child.buildData(0);
            }
        }
    }
}

