/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.upgrade.EasDataUpgradeLogService;
import kd.epm.eb.business.easupgrade.impl.upgrade.EasUpgradeLogService;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASAccountUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASAfterMemberUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASCslUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASCurrencyUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASCusMemberUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASDataClearUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASDataUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASDimsUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASElementUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASEntityUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASPeriodUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASPropertyUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASScenarioUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASSchemaUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.EASVersionUpgrade;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import org.jetbrains.annotations.NotNull;

public class EASDataUpgradeImpl {
    private static final Log log = LogFactory.getLog(EASDataUpgradeImpl.class);
    private final IEASUpgradeParam param;
    private final IEASUpgradeContext context;
    private final List<IEASUpgradeResult> results = Collections.synchronizedList(new ArrayList());
    private final List<IRunUpgrade> relies = new ArrayList<IRunUpgrade>(32);
    private final List<IRunUpgrade> upgrades = new ArrayList<IRunUpgrade>(32);
    private final List<IRunUpgrade> afterUpgrade = new ArrayList<IRunUpgrade>(32);

    public static EASDataUpgradeImpl get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASDataUpgradeImpl(param, context);
    }

    protected final IEASUpgradeParam getParam() {
        return this.param;
    }

    protected IEASUpgradeContext getContext() {
        return this.context;
    }

    public List<IEASUpgradeResult> getResults() {
        return this.results;
    }

    protected final List<IRunUpgrade> getRelies() {
        return this.relies;
    }

    protected final List<IRunUpgrade> getUpgrades() {
        return this.upgrades;
    }

    protected final List<IRunUpgrade> getAfterUpgrade() {
        return this.afterUpgrade;
    }

    public EASDataUpgradeImpl(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        this.param = param;
        this.context = context;
        if (this.getParam().isUpgradeBaseData()) {
            this.getRelies().add(EASSchemaUpgrade.get(param, context));
            this.getRelies().add(EASDimsUpgrade.get(param, context));
            this.getUpgrades().add(EASEntityUpgrade.get(param, context));
            this.getUpgrades().add(EASAccountUpgrade.get(param, context));
            this.getUpgrades().add(EASPeriodUpgrade.get(param, context));
            this.getUpgrades().add(EASScenarioUpgrade.get(param, context));
            this.getUpgrades().add(EASVersionUpgrade.get(param, context));
            this.getUpgrades().add(EASCurrencyUpgrade.get(param, context));
            this.getUpgrades().add(EASElementUpgrade.get(param, context));
            this.getUpgrades().add(EASCusMemberUpgrade.get(param, context));
            this.getAfterUpgrade().add(EASCslUpgrade.get(param, context));
            this.getAfterUpgrade().add(EASPropertyUpgrade.get(param, context));
            this.getAfterUpgrade().add(EASAfterMemberUpgrade.get(param, context));
        }
        if (this.getParam().isUpgradeData()) {
            this.getAfterUpgrade().add(EASDataUpgrade.get(param, context));
        }
    }

    public void beforeUpgrade() {
        LogStats stats = new LogStats("budget-update-log : ");
        stats.addInfo("begin-before-upgrade.");
        try {
            this.getResults().addAll(EASDataClearUpgrade.get(this.getParam(), this.getContext()).upgrade());
            if (this.param.isUpgradeBaseData()) {
                EasUpgradeLogService easUpgradeLogService = EasUpgradeLogService.getInstance();
                easUpgradeLogService.delete(this.param.getUpgradeModelId());
            }
            EasDataUpgradeLogService easDataUpgradeLogService = EasDataUpgradeLogService.getInstance();
            easDataUpgradeLogService.delete(this.param.getUpgradeModelId());
        }
        catch (Exception ex) {
            this.dealException(ex);
        }
        finally {
            stats.addInfo("end-before-upgrade.");
            log.info(stats.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade() {
        block11: {
            LogStats stats = new LogStats("budget-update-log : ");
            stats.addInfo("begin-upgrade.");
            ArrayList<Future> futures = new ArrayList<Future>(this.getUpgrades().size());
            try {
                for (IRunUpgrade upgrade : this.getRelies()) {
                    this.getResults().addAll(upgrade.upgrade());
                }
                if (!EASUpgradeResult.isSuccess(this.getResults())) break block11;
                RequestContext _context = RequestContext.getOrCreate();
                CountDownLatch cdl = new CountDownLatch(this.getUpgrades().size());
                for (IRunUpgrade runUpgrade : this.getUpgrades()) {
                    runUpgrade.setCountDownLatch(cdl);
                    Future _result = EpmThreadPools.CommPools.submit((Callable)runUpgrade, _context);
                    if (_result == null) continue;
                    futures.add(_result);
                }
                try {
                    cdl.await();
                }
                catch (InterruptedException ex) {
                    this.dealException(ex);
                }
                for (Future future : futures) {
                    this.getResults().addAll((Collection)future.get());
                }
                for (IRunUpgrade upgrade : this.getAfterUpgrade()) {
                    this.getResults().addAll(upgrade.upgrade());
                }
                String modelId = IDUtils.toString((Object)this.getContext().getRunData().getModelId());
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"LanguageDimUpgradeService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{modelId, null, null, null});
            }
            catch (Exception ex) {
                this.dealException(ex);
            }
            finally {
                stats.addInfo("end-upgrade.");
                log.info(stats.toString());
            }
        }
    }

    private void dealException(Exception ex) {
        log.error("eas-upgrade-error:", (Throwable)ex);
        this.getResults().add(EASUpgradeResult.error("checker", ex));
    }
}

