/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.easupgrade.impl.dao.EasDataUpgradeDetail;
import kd.epm.eb.business.easupgrade.impl.dao.EasDataUpgradeLog;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.StringUtils;

public class EasDataUpgradeLogService {
    private static final Log loggger = LogFactory.getLog(EasDataUpgradeLogService.class);

    public static EasDataUpgradeLogService getInstance() {
        return InnerClass.instance;
    }

    private EasDataUpgradeLogService() {
    }

    public void delete(Long upgradeModelId) {
        QFilter qFilter = new QFilter("upgrademodel", "=", (Object)upgradeModelId);
        DeleteServiceHelper.delete((String)"eb_eas_data_upgrade_log", (QFilter[])qFilter.toArray());
        DeleteServiceHelper.delete((String)"eb_eas_data_upgrade_det", (QFilter[])qFilter.toArray());
    }

    public Long add(EasDataUpgradeLog easDataUpgradeLog) {
        this.delete(easDataUpgradeLog.getUpgradeModelId());
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"eb_eas_data_upgrade_log");
        long id = GlobalIdUtil.genGlobalLongId();
        log.set("id", (Object)id);
        log.set("upgrademodel", (Object)easDataUpgradeLog.getUpgradeModelId());
        log.set("model", (Object)easDataUpgradeLog.getModelId());
        log.set("creater", (Object)easDataUpgradeLog.getCreater());
        log.set("createdate", (Object)easDataUpgradeLog.getCreatedate());
        log.set("info", (Object)StringUtils.substring((String)easDataUpgradeLog.getInfo(), (int)2000));
        log.set("status", (Object)easDataUpgradeLog.getStatus());
        log.set("successcount", (Object)easDataUpgradeLog.getSuccessCount());
        log.set("failcount", (Object)easDataUpgradeLog.getFailCount());
        log.set("totalcount", (Object)easDataUpgradeLog.getTotalCount());
        log.set("waitcount", (Object)easDataUpgradeLog.getWaitCount());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        return id;
    }

    public void update(EasDataUpgradeLog easDataUpgradeLog) {
        QFilter qFilter = new QFilter("upgrademodel", "=", (Object)easDataUpgradeLog.getUpgradeModelId());
        DynamicObject log = BusinessDataServiceHelper.loadSingle((String)"eb_eas_data_upgrade_log", (String)"info,status,successcount,failcount,totalcount,percent,waitcount", (QFilter[])qFilter.toArray());
        if (easDataUpgradeLog.getInfo() != null) {
            log.set("info", (Object)StringUtils.substring((String)easDataUpgradeLog.getInfo(), (int)2000));
        }
        if (easDataUpgradeLog.getStatus() != null) {
            log.set("status", (Object)easDataUpgradeLog.getStatus());
        }
        if (easDataUpgradeLog.getSuccessCount() != null) {
            log.set("successcount", (Object)easDataUpgradeLog.getSuccessCount());
        }
        if (easDataUpgradeLog.getFailCount() != null) {
            log.set("failcount", (Object)easDataUpgradeLog.getFailCount());
        }
        if (easDataUpgradeLog.getTotalCount() != null) {
            log.set("totalcount", (Object)easDataUpgradeLog.getTotalCount());
        }
        if (easDataUpgradeLog.getPercent() != null) {
            log.set("percent", (Object)easDataUpgradeLog.getPercent());
        }
        if (easDataUpgradeLog.getWaitCount() != null) {
            log.set("waitcount", (Object)easDataUpgradeLog.getWaitCount());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public void addDetailsLogs(List<EasDataUpgradeDetail> dataUpgradeDetails) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dataUpgradeDetails.size());
        for (EasDataUpgradeDetail detailLog : dataUpgradeDetails) {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"eb_eas_data_upgrade_det");
            log.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            log.set("upgrademodel", (Object)detailLog.getUpgradeModelId());
            log.set("createdate", (Object)detailLog.getCreatedate());
            log.set("info", (Object)StringUtils.substring((String)detailLog.getInfo(), (int)2000));
            log.set("status", (Object)detailLog.getStatus());
            log.set("dataJson", (Object)detailLog.getDataJson());
            list.add(log);
        }
        if (list.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    private static class InnerClass {
        private static EasDataUpgradeLogService instance = new EasDataUpgradeLogService();

        private InnerClass() {
        }
    }
}

