/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.dao.EasDimUpgradeLog;
import kd.epm.eb.business.easupgrade.impl.dao.EasMemberUpgradeLog;
import kd.epm.eb.business.easupgrade.impl.dao.EasUpgradeLog;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.StringUtils;

public class EasUpgradeLogService {
    private static final Log loggger = LogFactory.getLog(EasUpgradeLogService.class);

    public static EasUpgradeLogService getInstance() {
        return InnerClass.instance;
    }

    private EasUpgradeLogService() {
    }

    public DynamicObject get(Long upgradeModelId) {
        QFilter qFilter = new QFilter("upgrademodel", "=", (Object)upgradeModelId);
        return QueryServiceHelper.queryOne((String)"eb_eas_upgrade_log", (String)"id, model.id", (QFilter[])qFilter.toArray());
    }

    public void delete(Long upgradeModelId) {
        QFilter qFilter = new QFilter("upgrademodel", "=", (Object)upgradeModelId);
        DeleteServiceHelper.delete((String)"eb_eas_upgrade_log", (QFilter[])qFilter.toArray());
        DeleteServiceHelper.delete((String)"eb_eas_mem_upgrade_log", (QFilter[])qFilter.toArray());
    }

    public void add(EasUpgradeLog easUpgradeLog) {
        this.delete(easUpgradeLog.getUpgradeModelId());
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"eb_eas_upgrade_log");
        log.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        log.set("upgrademodel", (Object)easUpgradeLog.getUpgradeModelId());
        log.set("model", (Object)easUpgradeLog.getModelId());
        log.set("creater", (Object)easUpgradeLog.getCreater());
        log.set("createdate", (Object)easUpgradeLog.getCreatedate());
        log.set("modelloginfo", (Object)StringUtils.substring((String)easUpgradeLog.getInfo(), (int)2000));
        log.set("status", (Object)easUpgradeLog.getStatus());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public void addDimLogs(Long upgradeModelId, List<EasDimUpgradeLog> dimUpgradeLogs) {
        QFilter qFilter = new QFilter("upgrademodel", "=", (Object)upgradeModelId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_eas_upgrade_log", (String)"id", (QFilter[])qFilter.toArray());
        DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"eb_eas_upgrade_log");
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dimUpgradeLogs.size());
        DynamicObjectCollection dimLogs = log.getDynamicObjectCollection("dimuplog");
        for (EasDimUpgradeLog dimUpgradeLog : dimUpgradeLogs) {
            DynamicObject dimLog = dimLogs.addNew();
            EASDim easDim = dimUpgradeLog.getEasDim();
            dimLog.set("easdimnumber", (Object)easDim.getNumber());
            ILocaleString dimName = easDim.getName();
            if (dimName != null) {
                dimLog.set("easdimname", (Object)dimName.getLocaleValue());
            }
            Dimension dimension = dimUpgradeLog.getDimension();
            dimLog.set("dimid", (Object)dimension.getId());
            dimLog.set("dimnumber", (Object)dimension.getNumber());
            dimLog.set("dimname", (Object)dimension.getName());
            View view = dimUpgradeLog.getView();
            if (dimUpgradeLog.getView() != null) {
                dimLog.set("viewid", (Object)view.getId());
                dimLog.set("viewnumber", (Object)view.getNumber());
                dimLog.set("viewname", (Object)view.getName());
            }
            dimLog.set("dimloginfo", (Object)StringUtils.substring((String)dimUpgradeLog.getDimLogInfo(), (int)2000));
            dimLog.set("dimstatus", (Object)dimUpgradeLog.getStatus());
            if (dimUpgradeLog.getEasunionid() == null) continue;
            dimLog.set("easunionid", (Object)dimUpgradeLog.getEasunionid());
        }
        list.add(log);
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    public void addMemberLogs(Long upgradeModelId, String easdimnumber, String viewNumber, List<EasMemberUpgradeLog> memberUpgradeLogs) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(memberUpgradeLogs.size());
        for (EasMemberUpgradeLog memberUpgradeLog : memberUpgradeLogs) {
            DynamicObject memberLog = BusinessDataServiceHelper.newDynamicObject((String)"eb_eas_mem_upgrade_log");
            memberLog.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            memberLog.set("upgrademodel", (Object)upgradeModelId);
            memberLog.set("easdimnumber", (Object)easdimnumber);
            if (viewNumber != null) {
                memberLog.set("viewnumber", (Object)viewNumber);
            }
            if (memberUpgradeLog.getEasunionid() != null) {
                memberLog.set("easunionid", (Object)memberUpgradeLog.getEasunionid());
            }
            EASMember easMember = memberUpgradeLog.getEasMember();
            memberLog.set("easmemid", (Object)easMember.getMemberId());
            memberLog.set("easmemnumber", (Object)easMember.getNumber());
            ILocaleString memberName = easMember.getName();
            if (memberName != null) {
                memberLog.set("easmemname", (Object)easMember.getName().getLocaleValue());
            }
            Member member = memberUpgradeLog.getMember();
            memberLog.set("memid", (Object)member.getId());
            memberLog.set("memnumber", (Object)member.getNumber());
            memberLog.set("memname", (Object)member.getName());
            memberLog.set("memloginfo", (Object)StringUtils.substring((String)memberUpgradeLog.getMemLogInfo(), (int)2000));
            memberLog.set("status", (Object)memberUpgradeLog.getStatus());
            list.add(memberLog);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    private static class InnerClass {
        private static EasUpgradeLogService instance = new EasUpgradeLogService();

        private InnerClass() {
        }
    }
}

