/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.easupgrade.enums.UpgradeStatus;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunChecker;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeParam;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASSysVersionChecker;
import kd.epm.eb.business.easupgrade.impl.context.EASUpgradeContext;
import kd.epm.eb.business.easupgrade.sync.BaseDataSyncImpl;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;

public class EasUpgradeService {
    private static final Log loggger = LogFactory.getLog(EasUpgradeService.class);

    public static EasUpgradeService getInstance() {
        return InnerClass.instance;
    }

    private EasUpgradeService() {
    }

    public void easModeltoEbModel(Long easDbId) {
        String dataCenter = EASUpgradeUtils.getDataCenter(easDbId);
        String schemeTable = EASDimUpgradeUtils.getSyncTable(easDbId, dataCenter, "T_MBG_BGSCHEME");
        String schemeTypeTable = EASDimUpgradeUtils.getSyncTable(easDbId, dataCenter, "T_MBG_BgSchemeType");
        if (!SqlBatchUtils.hasTable((String)schemeTable) || !SqlBatchUtils.hasTable((String)schemeTypeTable)) {
            return;
        }
        String sql = "select a.fid, a.fnumber, a.frefcube,a.fname_l1, a.fname_l2, a.fname_l3,a.fdatefrom, a.fdateto, b.fschemetype from " + schemeTable + " a left join " + schemeTypeTable + " b on a.fbgschemetypeid = b.fid where b.fschemetype in (68, 69)";
        DataSet dataSet = DB.queryDataSet((String)"EasModelSyncImpl", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet == null) {
            return;
        }
        HashSet<String> ids = new HashSet<String>(16);
        DataSet copyDataSet = dataSet.copy();
        while (copyDataSet.hasNext()) {
            Row row = copyDataSet.next();
            ids.add(row.getString("fid"));
        }
        QFilter qFilter = new QFilter("easdb", "=", (Object)easDbId);
        qFilter.and(new QFilter("dataCenter", "=", (Object)dataCenter));
        qFilter.and(new QFilter("easmodelid", "in", ids));
        DynamicObjectCollection records = QueryServiceHelper.query((String)"eb_easupgrade_record", (String)"number", (QFilter[])qFilter.toArray());
        List existNumbers = records.stream().map(e -> e.getString("number")).collect(Collectors.toList());
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String number = row.getString("fnumber");
            if (existNumbers.contains(number)) continue;
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"eb_easupgrade_record");
            dy.set("easmodelid", (Object)row.getString("fid"));
            dy.set("refcube", (Object)row.getString("frefcube"));
            dy.set("number", (Object)number);
            dy.set("name", (Object)EASUpgradeUtils.getLocaleStr(row, "fname"));
            dy.set("easdb", (Object)easDbId);
            dy.set("datacenter", (Object)dataCenter);
            dy.set("modeltype", (Object)row.getInteger("fschemetype"));
            dy.set("starttime", row.get("fdatefrom"));
            dy.set("endtime", row.get("fdateto"));
            dy.set("memupstatus", (Object)UpgradeStatus.NO.getVal());
            dy.set("dataupstatus", (Object)UpgradeStatus.NO.getVal());
            newList.add(dy);
        }
        if (newList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newList.toArray(new DynamicObject[0]));
        }
    }

    public void checkVersion(Long easDbId) {
        BaseDataSyncImpl sync = new BaseDataSyncImpl();
        sync.startSync(easDbId, "T_SYS_DATACENTER");
        EASUpgradeParam easUpgradeParam = new EASUpgradeParam();
        easUpgradeParam.setUpgradeSourceId(easDbId);
        IEASUpgradeContext easUpgradeContext = EASUpgradeContext.of(easUpgradeParam);
        IRunChecker checker = EASSysVersionChecker.get(easUpgradeParam, easUpgradeContext);
        List<IEASUpgradeResult> check = checker.check();
        if (!EASUpgradeResult.isSuccess(check)) {
            throw new KDBizException(EASUpgradeResult.getErrorsInfo(check));
        }
    }

    public DynamicObjectCollection getEasDataSources(long easDbId) {
        QFilter qFilter = new QFilter("connection_type", "=", (Object)"eas");
        if (easDbId != 0L) {
            qFilter.and("id", "=", (Object)easDbId);
        }
        return QueryServiceHelper.query((String)"isc_data_source", (String)"id", (QFilter[])qFilter.toArray(), (String)"createtime desc");
    }

    public void upEasModelMemberUpgrade(Long upgradeModelId, UpgradeStatus upgradeStatus, Long modelId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)upgradeModelId, (String)"eb_easupgrade_record");
        if (upgradeStatus != null) {
            dynamicObject.set("memupstatus", (Object)upgradeStatus.getVal());
        }
        if (modelId != null) {
            dynamicObject.set("model", (Object)modelId);
        }
        if (upgradeStatus == UpgradeStatus.SUCCEED || upgradeStatus == UpgradeStatus.FAILED) {
            dynamicObject.set("endupgradetime", (Object)TimeServiceHelper.now());
        } else {
            dynamicObject.set("endupgradetime", null);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void startEasModelMemberUpgrade(Long upgradeModelId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)upgradeModelId, (String)"eb_easupgrade_record");
        dynamicObject.set("memupstatus", (Object)UpgradeStatus.ING.getVal());
        dynamicObject.set("dataupstatus", (Object)UpgradeStatus.NO.getVal());
        dynamicObject.set("upgradetime", (Object)TimeServiceHelper.now());
        dynamicObject.set("upgradeer", (Object)UserUtils.getUserId());
        dynamicObject.set("endupgradetime", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void startEasModelDataUpgrade(Long upgradeModelId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)upgradeModelId, (String)"eb_easupgrade_record");
        dynamicObject.set("dataupstatus", (Object)UpgradeStatus.ING.getVal());
        dynamicObject.set("upgradetime", (Object)TimeServiceHelper.now());
        dynamicObject.set("upgradeer", (Object)UserUtils.getUserId());
        dynamicObject.set("endupgradetime", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void upEasModelDataUpgradeStatus(Long upgradeModelId, UpgradeStatus upgradeStatus) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)upgradeModelId, (String)"eb_easupgrade_record");
        dynamicObject.set("dataupstatus", (Object)upgradeStatus.getVal());
        if (upgradeStatus == UpgradeStatus.SUCCEED || upgradeStatus == UpgradeStatus.FAILED) {
            dynamicObject.set("endupgradetime", (Object)TimeServiceHelper.now());
        } else {
            dynamicObject.set("endupgradetime", null);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void upEasModelStatus(DynamicObject[] dynamicObjects, UpgradeStatus upgradeStatus, int type) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (type == 1) {
                dynamicObject.set("memupstatus", (Object)upgradeStatus.getVal());
                continue;
            }
            if (type == 2) {
                dynamicObject.set("dataupstatus", (Object)upgradeStatus.getVal());
                continue;
            }
            dynamicObject.set("memupstatus", (Object)upgradeStatus.getVal());
            dynamicObject.set("dataupstatus", (Object)upgradeStatus.getVal());
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private static class InnerClass {
        private static EasUpgradeService instance = new EasUpgradeService();

        private InnerClass() {
        }
    }
}

