/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.business.easupgrade.face.IChecker;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.DynamicTree;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.dao.NewMember;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEASUpgrade
implements IRunUpgrade,
IChecker {
    protected static final Log log = LogFactory.getLog(AbstractEASUpgrade.class);
    private final IEASUpgradeParam param;
    private final IEASUpgradeContext context;
    private final List<IEASUpgradeResult> results = Collections.synchronizedList(new ArrayList());
    private CountDownLatch cdl = null;
    private final LogStats stats = new LogStats("budget-upgrade-log:");
    private Map<String, NewMember> memberNumMap = null;
    private Map<String, NewMember> memberIdMap = null;
    private final Map<String, String> memberParentMap = Maps.newLinkedHashMapWithExpectedSize((int)2000);

    protected IEASUpgradeParam getParam() {
        return this.param;
    }

    protected IEASUpgradeContext getContext() {
        return this.context;
    }

    protected List<IEASUpgradeResult> getResult() {
        return this.results;
    }

    @Override
    public void setCountDownLatch(CountDownLatch cdl) {
        this.cdl = cdl;
    }

    @Override
    public CountDownLatch getCountDownLatch() {
        return this.cdl;
    }

    protected LogStats getStats() {
        return this.stats;
    }

    protected AbstractEASUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        this.param = param;
        this.context = context;
    }

    protected abstract String getUpgradeInfo();

    public Object call() {
        return this.upgrade();
    }

    @Override
    public List<IEASUpgradeResult> upgrade() {
        this.getStats().addInfo("begin-upgrade." + this.getUpgradeInfo());
        try {
            this.$upgrade();
        }
        catch (Exception ex) {
            log.error("eas-upgrade-error:", (Throwable)ex);
            EASUpgradeUtils.dealException(this.getUpgradeInfo(), ex, this.getResult());
        }
        finally {
            if (this.getCountDownLatch() != null) {
                this.getCountDownLatch().countDown();
            }
            this.getStats().addInfo("end-upgrade.");
            log.info(this.getStats().toString());
        }
        return this.getResult();
    }

    protected abstract void $upgrade();

    protected Map<String, NewMember> getMemberNumMap() {
        if (this.memberNumMap == null) {
            this.memberNumMap = Maps.newLinkedHashMap();
        }
        return this.memberNumMap;
    }

    protected void setMemberNumMap(Map<String, NewMember> memberNumMap) {
        this.memberNumMap = memberNumMap;
    }

    protected Map<String, NewMember> getMemberIdMap() {
        if (this.memberIdMap == null) {
            this.memberIdMap = Maps.newLinkedHashMap();
        }
        return this.memberIdMap;
    }

    protected void setMemberIdMap(Map<String, NewMember> memberIdMap) {
        this.memberIdMap = memberIdMap;
    }

    protected Map<String, String> getMemberParentMap() {
        return this.memberParentMap;
    }

    protected DynamicObject transMember(@NotNull String entityNumber, @NotNull Row row, @NotNull Dimension dimension, @NotNull Map<String, DynamicObject> idsMap) {
        DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        this.defaultObjectValue(member, row, dimension);
        idsMap.put(row.getString(this.getDefaultIdField()), member);
        if (this.hasParent()) {
            String _id = row.getString(this.getDefaultIdField());
            String _parentId = row.getString(this.getDefaultParentIdField());
            this.getMemberParentMap().put(_id, _parentId);
        }
        return member;
    }

    protected String getDefaultIdField() {
        return "fid";
    }

    protected String getDefaultParentIdField() {
        return "fparentid";
    }

    protected boolean hasParent() {
        return true;
    }

    protected DynamicObject createDefaultView(DynamicObject dimension) {
        DynamicObject view = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview");
        view.set("id", (Object)DBServiceHelper.genGlobalLongId());
        view.set("number", (Object)(dimension.getString("number") + "001"));
        view.set("name", (Object)ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u57fa\u51c6\u89c6\u56fe", (String)"AddDimemsionPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getString("name")}));
        view.set("longnumber", (Object)("!" + view.getString("number")));
        view.set("model", dimension.get("model"));
        view.set("dimension", (Object)dimension.getLong("id"));
        view.set("creater", (Object)this.getContext().getRunData().getUserId());
        view.set("createdate", (Object)this.getContext().getRunData().getTime());
        view.set("modifier", (Object)this.getContext().getRunData().getUserId());
        view.set("modifydate", (Object)this.getContext().getRunData().getTime());
        view.set("parent", (Object)0L);
        view.set("baseview", (Object)0L);
        view.set("usage", (Object)Character.valueOf('0'));
        view.set("source", (Object)Character.valueOf('1'));
        view.set("isleaf", (Object)Character.valueOf('1'));
        view.set("level", (Object)Character.valueOf('1'));
        return view;
    }

    protected DynamicObject createAnalyseView(@NotNull Dimension orgDim, EASMember cusView, Long baseViewId) {
        DynamicObject view = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview");
        view.set("id", (Object)DBServiceHelper.genGlobalLongId());
        String startDate = ConvertUtils.toDateString((Date)cusView.getStartDate());
        String viewNumber = EASUpgradeUtils.getNumber(cusView.getNumber());
        if (viewNumber != null && viewNumber.length() > 39) {
            viewNumber = viewNumber.substring(0, 39);
        }
        viewNumber = viewNumber + '-' + startDate;
        view.set("number", (Object)viewNumber);
        view.set("name", (Object)cusView.getName());
        view.set("model", (Object)orgDim.getModel().getId());
        view.set("dimension", (Object)orgDim.getId());
        view.set("creater", (Object)this.getContext().getRunData().getUserId());
        view.set("createdate", (Object)this.getContext().getRunData().getTime());
        view.set("modifier", (Object)this.getContext().getRunData().getUserId());
        view.set("modifydate", (Object)this.getContext().getRunData().getTime());
        view.set("parent", (Object)baseViewId);
        view.set("baseview", (Object)baseViewId);
        view.set("usage", (Object)Character.valueOf('1'));
        view.set("source", (Object)Character.valueOf('0'));
        view.set("isleaf", (Object)Character.valueOf('1'));
        view.set("level", (Object)Character.valueOf('1'));
        return view;
    }

    protected void defaultObjectValue(DynamicObject member, Row row, Dimension dimension) {
        if (member == null) {
            return;
        }
        member.set("number", (Object)row.getString("fnumber"));
        member.set("name", (Object)EASUpgradeUtils.getLocaleStr(row, "fname"));
        member.set("description", (Object)EASUpgradeUtils.getLocaleStr(row, "fdescription"));
        member.set("simplename", (Object)row.getString("fsimplename"));
        member.set("status", (Object)Character.valueOf('C'));
        member.set("creator", (Object)this.getContext().getRunData().getUserId());
        member.set("modifier", (Object)this.getContext().getRunData().getUserId());
        member.set("createtime", (Object)this.getContext().getRunData().getTime());
        member.set("modifytime", (Object)this.getContext().getRunData().getTime());
        int aggType = row.getInteger("fpolalgorithm");
        switch (aggType) {
            case 2: {
                member.set("aggoprt", (Object)AggOprtEnum.SUBSTRACT.getSign());
                break;
            }
            case 3: {
                member.set("aggoprt", (Object)AggOprtEnum.SKIP.getSign());
                break;
            }
            default: {
                member.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
            }
        }
        member.set("storagetype", (Object)StorageTypeEnum.STORAGE.getIndex());
        member.set("model", (Object)dimension.getModel().getId());
        member.set("dimension", (Object)dimension.getId());
        member.set("isleaf", (Object)Character.valueOf('1'));
        member.set("enable", (Object)Character.valueOf('1'));
        member.set("disable", (Object)Character.valueOf('0'));
        member.set("membersource", (Object)MemberSourceEnum.SYSTEM_IMPORT.getIndex());
    }

    protected DynamicObject createDefaultMember(@NotNull DynamicObject dimension) {
        DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)dimension.getString("membermodel"));
        member.set("id", (Object)DBServiceHelper.genGlobalLongId());
        member.set("creator", (Object)this.getContext().getRunData().getUserId());
        member.set("createtime", (Object)this.getContext().getRunData().getTime());
        member.set("modifier", (Object)this.getContext().getRunData().getUserId());
        member.set("modifytime", (Object)this.getContext().getRunData().getTime());
        member.set("model", dimension.get("model"));
        member.set("dimension", (Object)dimension.getLong("id"));
        member.set("status", (Object)Character.valueOf('C'));
        member.set("storagetype", (Object)StorageTypeEnum.STORAGE.getIndex());
        member.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
        member.set("isleaf", (Object)Character.valueOf('1'));
        member.set("level", (Object)Character.valueOf('1'));
        member.set("dseq", (Object)Character.valueOf('1'));
        member.set("enable", (Object)Character.valueOf('1'));
        member.set("disable", (Object)Character.valueOf('0'));
        member.set("datatype", (Object)Character.valueOf('0'));
        member.set("membersource", (Object)MemberSourceEnum.PRESET.getIndex());
        return member;
    }

    protected void dealMembers(@NotNull EASDim easDim, @NotNull Dimension dimension, @NotNull Map<String, DynamicObject> members, boolean buildRootMember) {
        NewMember newMember;
        String msg;
        DynamicObject member;
        String oldId;
        if (members.isEmpty()) {
            return;
        }
        this.setMemberIdMap(Maps.newLinkedHashMap());
        this.setMemberNumMap(Maps.newLinkedHashMap());
        boolean hasBaseMember = true;
        if ("eb_viewmember".equals(members.values().iterator().next().getDynamicObjectType().getName())) {
            hasBaseMember = false;
        }
        int index = 0;
        Member rootMember = null;
        LinkedHashSet checkerNumbers = Sets.newLinkedHashSet();
        LinkedHashMap upCheckNumbers = Maps.newLinkedHashMap();
        LinkedHashSet replaceNumbers = Sets.newLinkedHashSet();
        List allMembers = dimension.getAllMembers();
        Collection viewMembers = dimension.getViewMember();
        checkerNumbers.addAll(allMembers.stream().filter(Objects::nonNull).map(BaseCache::getNumber).collect(Collectors.toSet()));
        checkerNumbers.addAll(viewMembers.stream().filter(Objects::nonNull).map(BaseCache::getNumber).collect(Collectors.toSet()));
        upCheckNumbers.putAll(allMembers.stream().filter(Objects::nonNull).collect(Collectors.toMap(m -> m.getNumber().toUpperCase(), BaseCache::getNumber)));
        upCheckNumbers.putAll(viewMembers.stream().filter(Objects::nonNull).collect(Collectors.toMap(m -> m.getNumber().toUpperCase(), BaseCache::getNumber)));
        if (hasBaseMember) {
            rootMember = dimension.getStructOfMember(dimension.getNumber());
        }
        LinkedHashSet errorMemberIds = Sets.newLinkedHashSet();
        String memberTable = "t_eb_structofdefined";
        SysDimensionEnum sysDimensionEnum = SysDimensionEnum.getEnumByNumber((String)dimension.getNumber());
        if (sysDimensionEnum != null) {
            memberTable = sysDimensionEnum.getMemberTreetable();
        }
        long[] ids = DBServiceHelper.genLongIds((String)memberTable, (int)members.size());
        for (Map.Entry<String, DynamicObject> entry : members.entrySet()) {
            String newNumber;
            String oldNumber;
            boolean verifyNumber;
            oldId = entry.getKey();
            member = entry.getValue();
            long newId = ids[index++];
            member.set("id", (Object)newId);
            if (hasBaseMember) {
                member.set("masterid", (Object)newId);
            }
            if (verifyNumber = this.isVerifyNumber(member)) {
                Member _tmpMember;
                String upNumber;
                String replaceNumber;
                oldNumber = this.getOldNumber(member);
                String currNumber = member.getString("number");
                newNumber = EASUpgradeUtils.getNumber(currNumber);
                if (!NumberCheckUtils.checkNumber((String)newNumber)) {
                    replaceNumber = "EAS-" + this.getContext().getRunData().getRandomVal();
                    replaceNumbers.add(currNumber + '-' + replaceNumber);
                    newNumber = replaceNumber;
                }
                if (upCheckNumbers.containsKey(upNumber = newNumber.toUpperCase())) {
                    String oldUpNumber = (String)upCheckNumbers.get(upNumber);
                    replaceNumber = newNumber;
                    if (replaceNumber.length() > 50) {
                        replaceNumber = replaceNumber.substring(0, 44);
                    }
                    replaceNumber = replaceNumber + '-' + this.getContext().getRunData().getRandomVal();
                    msg = ResManager.loadResFormat((String)"%1 \u7ef4\u5ea6\u4e0b\u5b58\u5728\u5ffd\u7565\u5927\u5c0f\u5199\u91cd\u590d\u7f16\u7801\uff08%2 - %3\uff09\u7684\u6210\u5458\uff0c\u7f16\u7801\u8f6c\u6362\u6210(%4)\u3002", (String)"AbstractEASUpgrade_4", (String)"epm-eb-business", (Object[])new Object[]{dimension.getName(), newNumber, oldUpNumber, replaceNumber});
                    this.getResult().add(this.afterResult(EASUpgradeResult.warring(this.getUpgradeInfo(), msg, null, easDim.getNumber(), dimension.getId(), dimension.getNumber())));
                    newNumber = replaceNumber;
                } else {
                    upCheckNumbers.put(upNumber, newNumber);
                }
                if (!checkerNumbers.add(newNumber)) {
                    msg = ResManager.loadResFormat((String)"%1 \u7ef4\u5ea6\u4e0b\u5b58\u5728\u91cd\u590d\u7f16\u7801\uff08%2\uff09\u7684\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractEASUpgrade_1", (String)"epm-eb-business", (Object[])new Object[]{dimension.getName(), newNumber});
                    this.getResult().add(this.afterResult(EASUpgradeResult.error(this.getUpgradeInfo(), msg, null, easDim.getNumber(), dimension.getId(), dimension.getNumber())));
                    errorMemberIds.add(oldId);
                    continue;
                }
                member.set("number", (Object)newNumber);
                if (!hasBaseMember && (_tmpMember = dimension.getStructOfMember(newNumber)) != null) {
                    member.set("memberid", (Object)_tmpMember.getId());
                }
            } else {
                newNumber = oldNumber = this.getOldNumber(member);
            }
            newMember = this.buildNewMember(newId, newNumber, member.getString("name"), oldId, oldNumber);
            this.getMemberIdMap().put(oldId, newMember);
            NewMember oldMember = this.getMemberNumMap().get(oldNumber);
            if (oldMember == null) {
                this.getMemberNumMap().put(oldNumber, newMember);
                continue;
            }
            oldMember.merge(newMember);
        }
        if (!replaceNumbers.isEmpty()) {
            String replaceStr = StringUtils.join((Collection)replaceNumbers, (char)',');
            msg = ResManager.loadResFormat((String)"\uff08%1\uff09\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u6a2a\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\u3002", (String)"AbstractEASUpgrade_3", (String)"epm-eb-business", (Object[])new Object[]{replaceStr});
            this.getResult().add(this.afterResult(EASUpgradeResult.warring(this.getUpgradeInfo(), msg, easDim.getId(), easDim.getNumber(), dimension.getId(), dimension.getNumber())));
        }
        if (!errorMemberIds.isEmpty()) {
            errorMemberIds.forEach(members::remove);
        }
        HashMap<Long, DynamicTree> treeMap = new HashMap<Long, DynamicTree>(members.size() + 10);
        if (buildRootMember && rootMember != null) {
            DynamicObject _root = BusinessDataServiceHelper.newDynamicObject((String)dimension.getMemberModel());
            _root.set("id", (Object)rootMember.getId());
            _root.set("level", (Object)1);
            _root.set("number", (Object)rootMember.getNumber());
            _root.set("longnumber", (Object)rootMember.getLongNumber());
            treeMap.put(rootMember.getId(), new DynamicTree(_root));
        }
        for (Map.Entry entry : members.entrySet()) {
            oldId = (String)entry.getKey();
            member = (DynamicObject)entry.getValue();
            String parentId = this.getMemberParentMap().get(oldId);
            if (StringUtils.equals((String)parentId, (String)oldId)) {
                if (rootMember != null) {
                    member.set("parent", (Object)rootMember.getId());
                }
            } else if (StringUtils.isNotEmpty((String)parentId)) {
                newMember = this.getMemberIdMap().get(parentId);
                if (newMember != null) {
                    long newPId = newMember.getId();
                    if (IDUtils.isNull((long)newPId)) {
                        msg = ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u6210\u5458\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u4e0a\u7ea7\u6210\u5458(parentId:%2)\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractEASUpgrade_2", (String)"epm-eb-business", (Object[])new Object[]{member.getString("number"), parentId});
                        this.getResult().add(this.afterResult(EASUpgradeResult.error(this.getUpgradeInfo(), msg, null, null, dimension.getId(), dimension.getNumber())));
                    }
                    member.set("parent", (Object)newPId);
                } else if (rootMember != null) {
                    member.set("parent", (Object)rootMember.getId());
                }
            } else if (rootMember != null) {
                member.set("parent", (Object)rootMember.getId());
            }
            treeMap.put(member.getLong("id"), new DynamicTree(member));
        }
        this.beforeBuildTree(treeMap);
        DynamicTree root = this.buildTree(treeMap);
        if (root != null) {
            root.buildData(this.getBeginSeqIndex(dimension));
        }
        this.addMemberMapping(dimension, this.getMemberIdMap(), this.getMemberNumMap());
    }

    protected IEASUpgradeResult afterResult(IEASUpgradeResult result) {
        return result;
    }

    protected void addMemberMapping(Dimension dimension, Map<String, NewMember> memberIdMap, Map<String, NewMember> memberNumMap) {
        this.getContext().getRunData().addMemberMapping(dimension.getNumber(), memberIdMap, memberNumMap);
    }

    protected void dealMembers(@NotNull EASDim easDim, @NotNull Dimension dimension, @NotNull Map<String, DynamicObject> members) {
        this.dealMembers(easDim, dimension, members, true);
    }

    protected NewMember buildNewMember(Long newId, String newNumber, String newName, String oldId, String oldNumber) {
        return new NewMember(newId, newNumber, newName, oldId, oldNumber);
    }

    protected boolean isVerifyNumber(@NotNull DynamicObject member) {
        return true;
    }

    protected String getOldNumber(@NotNull DynamicObject member) {
        return member.getString("number");
    }

    protected void beforeBuildTree(Map<Long, DynamicTree> members) {
    }

    protected int getBeginSeqIndex(@NotNull Dimension dimension) {
        int beginSeq = 0;
        SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)dimension.getNumber());
        if (SysDimensionEnum.DataType == dimensionEnum || SysDimensionEnum.Version == dimensionEnum || SysDimensionEnum.Currency == dimensionEnum || SysDimensionEnum.Metric == dimensionEnum) {
            beginSeq = 20;
        } else if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
            beginSeq = 1;
        }
        return beginSeq;
    }

    protected DynamicTree buildTree(Map<Long, DynamicTree> members) {
        if (members.isEmpty()) {
            return null;
        }
        DynamicTree root = null;
        for (DynamicTree _member : members.values()) {
            Long parentId = _member.member.getLong("parent");
            if (IDUtils.isNotNull((Long)parentId)) {
                this.buildParent(parentId, _member, members);
                continue;
            }
            root = _member;
        }
        return root;
    }

    private void buildParent(@NotNull Long parentId, @NotNull DynamicTree member, Map<Long, DynamicTree> members) {
        DynamicTree parent = members.get(parentId);
        if (parent != null) {
            parent.addChild(member);
        }
    }

    protected void saveMembers(DynamicObject[] members) {
        if (members == null || members.length == 0) {
            this.getStats().addInfo("members is null, not save.");
            return;
        }
        DynamicObjectUtils.save((DynamicObject[])members);
        this.getStats().addInfo("end members save. size = " + members.length);
    }

    protected boolean isSuccess() {
        return EASUpgradeResult.isSuccess(this.getResult());
    }
}

