/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import org.jetbrains.annotations.NotNull;

public class EASAccountUpgrade
extends AbstractEASUpgrade {
    private Long datasetId = null;

    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASAccountUpgrade(param, context);
    }

    protected EASAccountUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-account";
    }

    protected void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    protected Long getDatasetId() {
        return this.datasetId;
    }

    @Override
    protected void $upgrade() {
        block35: {
            String[] checkTables = new String[]{"T_MBG_BGACCOUNT", "T_MBG_BGACCOUNTVIEW"};
            if (!this.existTables(this.getParam(), this.getResult(), "BG_Account", SysDimensionEnum.Account.getNumber(), this.getUpgradeInfo(), checkTables)) {
                return;
            }
            IEASSchema easSchema = this.getContext().getEASSchema();
            EASDim accountDim = easSchema.getEASDim("BG_Account");
            EASMember accountView = null;
            Dimension dimension = this.getContext().getRunData().getModelCache().getDimension(SysDimensionEnum.Account.getNumber());
            Member rootMember = dimension.getMember(null, dimension.getNumber());
            List<EASMember> easMembers = EASDimUpgradeUtils.getDimRefMember(this.getParam(), easSchema.getSchemaId(), "BG_Account");
            for (EASMember easMember : easMembers) {
                accountDim.members.add(easMember);
                accountView = easMember;
            }
            if (accountView == null) {
                String msg = ResManager.loadKDString((String)"EAS\u79d1\u76ee\u7ef4\u5ea6\u6ca1\u6709\u5173\u8054\u7684\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASAccountChecker_0", (String)"epm-eb-business", (Object[])new Object[0]);
                this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg, null, "BG_Account", dimension.getId(), dimension.getNumber()));
            } else {
                LinkedHashMap idsMap = Maps.newLinkedHashMap();
                String entityNumber = SysDimensionEnum.Account.getMemberTreemodel();
                this.setDatasetId(this.getContext().getRunData().getDefaultDataset().getLong("id"));
                String syncAccount = this.getParam().getSyncTableName("T_MBG_BGACCOUNT");
                SqlBuilder sql = new SqlBuilder();
                sql.append("select fid, fnumber, flongnumber, fname_l1, fname_l2, fname_l3, fpolalgorithm, fbgdecreditalgorithm, fisenabled, fdisableddate,fparentid, fdescription_l1, fdescription_l2, fdescription_l3, fsimplename from ", new Object[0]).append(syncAccount, new Object[0]).append(" where fbgaccountviewid = ?", new Object[]{accountView.memberId});
                try (DataSet ds = DB.queryDataSet((String)"queryEASAccount", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                    if (ds != null) {
                        for (Row row : ds) {
                            this.transMember(entityNumber, row, dimension, idsMap);
                        }
                    }
                }
                this.dealMembers(accountDim, dimension, idsMap);
                if (this.isSuccess()) {
                    var13_13 = null;
                    try (TXHandle tx = TX.required();){
                        try {
                            this.saveMembers(idsMap.values().toArray(new DynamicObject[0]));
                            if (!idsMap.isEmpty()) {
                                DB.execute((DBRoute)BgBaseConstant.epm, (String)"update t_eb_structofent set fisleaf = 0 where fid = ?", (Object[])new Object[]{rootMember.getId()});
                            }
                            this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), ResManager.loadKDString((String)"\u79d1\u76ee\u6210\u5458\u5347\u7ea7\u5b8c\u6210\u3002", (String)"EASAccountUpgrade_3", (String)"epm-eb-business", (Object[])new Object[0]), null, accountDim.getNumber(), dimension.getId(), dimension.getNumber()));
                            break block35;
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            throw new KDBizException(e.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        var13_13 = throwable;
                        throw throwable;
                    }
                }
                this.getStats().addInfo("members upgrade exist error.");
            }
        }
    }

    @Override
    protected DynamicObject transMember(@NotNull String entityNumber, @NotNull Row row, @NotNull Dimension dimension, @NotNull Map<String, DynamicObject> idsMap) {
        DynamicObject account = super.transMember(entityNumber, row, dimension, idsMap);
        account.set("dataset", (Object)this.getDatasetId());
        account.set("disable", (Object)Character.valueOf(row.getInteger("fisenabled") == 0 ? (char)'1' : '0'));
        account.set("disabledate", (Object)row.getDate("fdisableddate"));
        account.set("accounttype", (Object)"50");
        account.set("datatype", (Object)Character.valueOf('0'));
        int drcrdirect = row.getInteger("fbgdecreditalgorithm");
        if (drcrdirect == 10) {
            account.set("drcrdirect", (Object)Character.valueOf('5'));
        } else if (drcrdirect == 20) {
            account.set("drcrdirect", (Object)Character.valueOf('6'));
        } else {
            account.set("drcrdirect", (Object)Character.valueOf('0'));
        }
        return account;
    }
}

