/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.model.serviceHelper.DataSetServiceHelper;
import org.jetbrains.annotations.NotNull;

public class EASAfterMemberUpgrade
extends AbstractEASUpgrade {
    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASAfterMemberUpgrade(param, context);
    }

    protected EASAfterMemberUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-close";
    }

    @Override
    protected void $upgrade() {
        IModelCacheHelper modelCacheHelper = this.getContext().getRunData().getModelCache();
        Long modelId = modelCacheHelper.getModelobj().getId();
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"id,number", (QFilter[])builder.toArray(), (String)"dseq");
        DynamicObject busModelObj = this.getContext().getRunData().getDefaultBusModel();
        DynamicObjectCollection entries = busModelObj.getDynamicObjectCollection("viewentry");
        Set dimsIds = entries.stream().map(entry -> entry.getLong("dimension_id")).collect(Collectors.toSet());
        for (Object dim : dims) {
            Long dimId = dim.getLong("id");
            String dimNumber = dim.getString("number");
            SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)dimNumber);
            if (dimensionEnum != null || dimsIds.contains(dimId)) continue;
            DynamicObject object = entries.addNew();
            object.set("id", (Object)DBServiceHelper.genGlobalLongId());
            object.set("dimension", (Object)dimId);
            object.set("view", (Object)modelCacheHelper.getDefaultViewIdOnDim(dimNumber));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busModelObj});
        DynamicObject datasetObj = this.getContext().getRunData().getDefaultDataset();
        entries = datasetObj.getDynamicObjectCollection("entryentity");
        dimsIds = entries.stream().map(entry -> entry.getLong("datasetdim_id")).collect(Collectors.toSet());
        for (DynamicObject dim : dims) {
            Long dimId = dim.getLong("id");
            String dimNumber = dim.getString("number");
            SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)dimNumber);
            if (dimensionEnum != null || dimsIds.contains(dimId)) continue;
            DynamicObject object = entries.addNew();
            object.set("id", (Object)DBServiceHelper.genGlobalLongId());
            object.set("datasetdim", (Object)dimId);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datasetObj});
        CubeUtils.updateCubeVersion((Long)modelId);
        modelCacheHelper = this.getContext().getRunData().getModelCacheByReBuilder();
        Dataset dataset = Dataset.of((DynamicObject)DataSetServiceHelper.loadDefault(modelId));
        ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((Model)modelCacheHelper.getModelobj());
        if (ShrekCubeServiceHelper.existCube((Model)modelCacheHelper.getModelobj(), (Dataset)dataset)) {
            ShrekCubeServiceHelper.updateCube((Model)modelCacheHelper.getModelobj(), (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)config);
        } else {
            ShrekCubeServiceHelper.createCube((Model)modelCacheHelper.getModelobj(), (Dataset)dataset, (IModelCacheHelper)modelCacheHelper, (ShrekConfig)config);
        }
    }
}

