/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunData;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.dao.NewMember;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EASCslUpgrade
extends AbstractEASUpgrade {
    private static final String[] checkTables = new String[]{"T_ORG_TREE", "T_ORG_STRUCTURE", "T_ORG_BASEUNIT"};
    private DynamicObject orgView = null;
    private String currUnionId = null;
    private Set<String> mergeOrgIds = new LinkedHashSet<String>();

    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASCslUpgrade(param, context);
    }

    protected EASCslUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-consolidation";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void $upgrade() {
        if (!this.existTables(this.getParam(), this.getResult(), "BG_Consolidation", SysDimensionEnum.Entity.getNumber(), this.getUpgradeInfo(), checkTables)) {
            return;
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        IModelCacheHelper modelCacheHelper = this.getContext().getRunData().getModelCache();
        List<EASMember> easMembers = EASDimUpgradeUtils.getDimRefMember(this.getParam(), easSchema.getSchemaId(), "BG_Organization", new Object[]{3});
        if (!easMembers.isEmpty()) {
            Long defaultViewId = modelCacheHelper.getDefaultViewIdOnDim(SysDimensionEnum.Entity.getNumber());
            for (EASMember cslView : easMembers) {
                try {
                    modelCacheHelper = this.getContext().getRunData().getModelCacheByReBuilder();
                    this.dealCslView(cslView, modelCacheHelper, defaultViewId);
                }
                catch (Exception ex) {
                    log.error("upgrade-custom-dim-error:", (Throwable)ex);
                    this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), ex, null, "BG_Consolidation", null, SysDimensionEnum.Entity.getNumber()));
                }
                finally {
                    CubeUtils.updateDimensionVersion((Long)modelCacheHelper.getModelobj().getId(), (Long)modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber()).getId());
                }
            }
        }
    }

    protected void setCurrUnionId(String currUnionId) {
        this.currUnionId = currUnionId;
    }

    protected String getCurrUnionId() {
        return this.currUnionId;
    }

    protected void dealCslView(EASMember cslView, IModelCacheHelper modelCacheHelper, Long baseViewId) {
        SqlBuilder sql;
        String syncCslUnitTable;
        String syncCslTable;
        Member rootMember;
        Dimension orgDim;
        LinkedHashMap idsMap;
        block43: {
            idsMap = Maps.newLinkedHashMap();
            orgDim = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
            rootMember = orgDim.getStructOfMember(SysDimensionEnum.Entity.getNumber());
            String syncTreeTable = this.getParam().getSyncTableName("T_ORG_TREE");
            syncCslTable = this.getParam().getSyncTableName("T_ORG_STRUCTURE");
            syncCslUnitTable = this.getParam().getSyncTableName("T_ORG_BASEUNIT");
            sql = new SqlBuilder();
            sql.append("select fid, fnumber, fname_l1, fname_l2, fname_l3, fstartdate from " + syncTreeTable + " where fid = ?", new Object[]{cslView.memberId});
            try (DataSet ds = DB.queryDataSet((String)"queryEASCsl", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    this.setCurrUnionId(cslView.memberId);
                    cslView.setNumber(row.getString("fnumber"));
                    String viewNameKey = "(" + ConvertUtils.toDateString((Date)row.getDate("fstartdate")) + ")";
                    cslView.setName(EASUpgradeUtils.getLocaleStr(row, "fname", viewNameKey));
                    cslView.setStartDate(row.getDate("fstartdate"));
                    break block43;
                }
                String msg = ResManager.loadResFormat((String)"\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5408\u5e76\u8303\u56f4(%1)\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASCslUpgrade_0", (String)"epm-eb-business", (Object[])new Object[]{cslView.memberId});
                this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg, null, "BG_Consolidation", orgDim.getId(), orgDim.getNumber()));
                return;
            }
        }
        sql = new SqlBuilder();
        sql.append("select t.fid, u.fnumber, t.fparentid, t.fisleaf, u.fname_l1, u.fname_l2, u.fname_l3, t.funitid from " + syncCslTable + " t ", new Object[0]).append(" join " + syncCslUnitTable + " u on t.funitid = u.fid ", new Object[0]).append(" where t.ftreeid = ?", new Object[]{cslView.memberId});
        this.orgView = this.createAnalyseView(orgDim, cslView, baseViewId);
        DynamicObject entity = this.createDefaultMember(BusinessDataServiceHelper.newDynamicObject((String)"eb_viewmember"), orgDim, this.orgView);
        entity.set("id", (Object)DBServiceHelper.genGlobalLongId());
        entity.set("number", (Object)rootMember.getNumber());
        entity.set("longnumber", (Object)rootMember.getLongNumber());
        entity.set("level", (Object)1);
        entity.set("memberid", (Object)rootMember.getId());
        entity.set("membersource", (Object)Character.valueOf('0'));
        idsMap.put(entity.getString("id"), entity);
        try (DataSet ds = DB.queryDataSet((String)"queryEASCsl", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    this.transMember("eb_viewmember", row, orgDim, this.orgView, entity, idsMap);
                }
            }
        }
        EASDim cslDim = new EASDim();
        cslDim.setNumber("BG_Consolidation");
        this.dealMembers(cslDim, orgDim, idsMap, false);
        DynamicObject[] virtualMembers = this.buildVirtualMember(cslView, orgDim, rootMember, idsMap);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.orgView});
                this.saveMembers(virtualMembers);
                this.saveMembers(idsMap.values().toArray(new DynamicObject[0]));
                String msg = ResManager.loadResFormat((String)"\u5408\u5e76\u8303\u56f4(%1)\u5347\u7ea7\u7ec4\u7ec7\u7ef4\u5ea6\u89c6\u56fe(%2)\u6210\u529f\u3002", (String)"EASCslUpgrade_1", (String)"epm-eb-business", (Object[])new Object[]{cslView.getNumber(), this.orgView.getString("number")});
                this.getResult().add(this.afterResult(EASUpgradeResult.run(this.getUpgradeInfo(), msg, null, "BG_Consolidation", orgDim.getId(), orgDim.getNumber())));
            }
            catch (Throwable ex) {
                String msg = ResManager.loadResFormat((String)"\u5408\u5e76\u8303\u56f4(%1)\u5347\u7ea7\u7ec4\u7ec7\u7ef4\u5ea6\u89c6\u56fe(%2)\u5931\u8d25\u3002", (String)"EASCslUpgrade_2", (String)"epm-eb-business", (Object[])new Object[]{cslView.getNumber(), this.orgView.getString("number")});
                this.getResult().add(this.afterResult(EASUpgradeResult.error(this.getUpgradeInfo(), msg, null, "BG_Consolidation", orgDim.getId(), orgDim.getNumber())));
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    protected DynamicObject transMember(@NotNull String entityNumber, @NotNull Row row, @NotNull Dimension dimension, @NotNull DynamicObject view, @NotNull DynamicObject rootMember, @NotNull Map<String, DynamicObject> idsMap) {
        DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        this.defaultObjectValue(member, row, dimension, view);
        boolean checker = this.getContext().getRunData().getBaseOrgUnits().containsKey(row.getString("funitid"));
        if (member.getBoolean("isleaf")) {
            if (checker) {
                String newMemberNumber = this.getContext().getRunData().getNumberByMapping(SysDimensionEnum.Entity.getNumber(), row.getString("fnumber"));
                Member baseMember = dimension.getStructOfMember(newMemberNumber);
                if (baseMember != null) {
                    if (!baseMember.getNumber().equals(member.getString("number"))) {
                        member.set("number", (Object)baseMember.getNumber());
                    }
                    member.set("memberid", (Object)baseMember.getId());
                } else {
                    String msg = ResManager.loadResFormat((String)"\u7ec4\u7ec7\u5355\u5143\u7f16\u7801(%1)\u5728\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASCslUpgrade_4", (String)"epm-eb-business", (Object[])new Object[]{row.getString("fnumber")});
                    this.getResult().add(this.afterResult(EASUpgradeResult.error(this.getUpgradeInfo(), msg, null, "BG_Consolidation", dimension.getId(), dimension.getNumber())));
                }
            }
        } else {
            this.getMergeOrgIds().add(row.getString(this.getDefaultIdField()));
        }
        IRunData runData = this.getContext().getRunData();
        runData.getUnionIds().put(row.getString("fid"), row.getString("funitid"));
        runData.getBaseUnionIds().put(row.getString("funitid"), row.getString("fid"));
        if (checker || !member.getBoolean("isleaf")) {
            idsMap.put(row.getString(this.getDefaultIdField()), member);
            if (this.hasParent()) {
                String _id = row.getString(this.getDefaultIdField());
                String _parentId = row.getString(this.getDefaultParentIdField());
                if (StringUtils.isEmpty((String)_parentId)) {
                    _parentId = rootMember.getString("id");
                }
                this.getMemberParentMap().put(_id, _parentId);
            }
        } else {
            String msg = ResManager.loadResFormat((String)"\u7ec4\u7ec7\u5355\u5143\u5728\u9884\u7b97\u7ec4\u7ec7\u6811\u4e2d\u4e0d\u5b58\u5728\uff08%1 - %2 - %3\uff09", (String)"EASCslUpgrade_3", (String)"epm-eb-business", (Object[])new Object[]{row.getString("fnumber"), member.getString("name"), row.getString("funitid")});
            this.getResult().add(this.afterResult(EASUpgradeResult.warring(this.getUpgradeInfo(), msg, null, "BG_Consolidation", dimension.getId(), dimension.getNumber())));
        }
        return member;
    }

    protected Set<String> getMergeOrgIds() {
        return this.mergeOrgIds;
    }

    @Override
    protected boolean isVerifyNumber(@NotNull DynamicObject member) {
        return IDUtils.isNull((long)member.getLong("memberid"));
    }

    @Override
    protected IEASUpgradeResult afterResult(IEASUpgradeResult result) {
        IEASUpgradeResult _result = super.afterResult(result);
        if (this.orgView != null) {
            _result.setUnionId(this.getCurrUnionId());
            _result.setViewId(this.orgView.getLong("id"));
            _result.setViewNumber(this.orgView.getString("number"));
            _result.setViewName(this.orgView.getString("name"));
        }
        return _result;
    }

    @Override
    protected void addMemberMapping(Dimension dimension, Map<String, NewMember> memberIdMap, Map<String, NewMember> memberNumMap) {
        this.getContext().getRunData().addMemberMapping(this.orgView.getString("number"), memberIdMap, memberNumMap);
    }

    @Override
    protected NewMember buildNewMember(Long newId, String newNumber, String newName, String oldId, String oldNumber) {
        String unionId = this.getContext().getRunData().getUnionIds().get(oldId);
        NewMember member = StringUtils.isNotEmpty((String)unionId) ? super.buildNewMember(newId, newNumber, newName, unionId, oldNumber) : super.buildNewMember(newId, newNumber, newName, oldId, oldNumber);
        return member;
    }

    protected DynamicObject[] buildVirtualMember(@NotNull EASMember cslView, @NotNull Dimension orgDim, @NotNull Member rootMember, @NotNull Map<String, DynamicObject> idsMap) {
        if (idsMap.isEmpty()) {
            return null;
        }
        IRunData runData = this.getContext().getRunData();
        LinkedList virtualMembers = Lists.newLinkedList();
        LinkedHashMap tmpMap = Maps.newLinkedHashMap();
        List allMembers = orgDim.getAllMembers();
        Set<String> existNumbers = allMembers.stream().filter(Objects::nonNull).map(BaseCache::getNumber).collect(Collectors.toSet());
        Set<String> upExistNumbers = allMembers.stream().filter(Objects::nonNull).map(m -> m.getNumber().toUpperCase()).collect(Collectors.toSet());
        int seqIndex = rootMember.getChildren().size() + 1;
        for (Map.Entry<String, DynamicObject> entry : idsMap.entrySet()) {
            String oldNumber;
            String viewId = entry.getKey();
            DynamicObject viewMember = entry.getValue();
            Long memberId = viewMember.getLong("memberid");
            if (IDUtils.isNull((Long)memberId) && this.getMergeOrgIds().contains(viewId)) {
                DynamicObject virtualMember = this.defaultVirtualValue(cslView, orgDim, rootMember, viewMember);
                String replaceNumber = oldNumber = virtualMember.getString("number");
                while (this.verifyNumber(virtualMember, existNumbers, upExistNumbers)) {
                    replaceNumber = "EAS-" + runData.getRandomVal();
                    virtualMember.set("number", (Object)replaceNumber);
                }
                existNumbers.add(replaceNumber);
                upExistNumbers.add(replaceNumber.toUpperCase());
                virtualMember.set("dseq", (Object)seqIndex++);
                virtualMembers.add(virtualMember);
                viewMember.set("number", (Object)virtualMember.getString("number"));
                viewMember.set("memberid", (Object)virtualMember.getLong("id"));
            }
            if (!this.getMergeOrgIds().contains(viewId) || "Entity".equals(viewMember.getString("number"))) continue;
            DynamicObject cosmic = BusinessDataServiceHelper.newDynamicObject((String)"eb_viewmember");
            cosmic.set("id", (Object)DBServiceHelper.genGlobalLongId());
            DynamicObject view = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview");
            view.set("id", (Object)viewMember.getLong("view"));
            this.defaultObjectValue(cosmic, null, orgDim, view);
            oldNumber = viewMember.getString("number");
            oldNumber = oldNumber.length() > 50 ? oldNumber.substring(0, 43) + "._inv" : oldNumber + "._inv";
            cosmic.set("name", (Object)viewMember.getString("name"));
            cosmic.set("number", (Object)oldNumber);
            cosmic.set("longnumber", (Object)(viewMember.getString("longnumber") + '!' + oldNumber));
            cosmic.set("parent", (Object)viewMember.getLong("id"));
            cosmic.set("level", (Object)(viewMember.getInt("level") + 1));
            viewMember.set("isleaf", (Object)Character.valueOf('0'));
            tmpMap.put(cosmic.getString("id"), cosmic);
            DynamicObject cosmicMember = BusinessDataServiceHelper.newDynamicObject((String)SysDimensionEnum.Entity.getMemberTreemodel());
            cosmicMember.set("id", (Object)DBServiceHelper.genGlobalLongId());
            cosmicMember.set("masterid", (Object)cosmicMember.getLong("id"));
            cosmicMember.set("number", (Object)oldNumber);
            cosmicMember.set("name", (Object)cosmic.getString("name"));
            cosmicMember.set("longnumber", (Object)("Entity!" + oldNumber));
            cosmicMember.set("parent", (Object)rootMember.getId());
            cosmicMember.set("level", (Object)2);
            cosmicMember.set("isleaf", (Object)Character.valueOf('1'));
            cosmicMember.set("currency", (Object)runData.getDefaultCurrency());
            cosmicMember.set("status", (Object)Character.valueOf('C'));
            cosmicMember.set("creator", (Object)runData.getUserId());
            cosmicMember.set("modifier", (Object)runData.getUserId());
            cosmicMember.set("createtime", (Object)runData.getTime());
            cosmicMember.set("modifytime", (Object)runData.getTime());
            cosmicMember.set("dseq", (Object)seqIndex++);
            cosmicMember.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
            cosmicMember.set("storagetype", (Object)StorageTypeEnum.STORAGE.getIndex());
            cosmicMember.set("model", (Object)orgDim.getModel().getId());
            cosmicMember.set("dimension", (Object)orgDim.getId());
            cosmicMember.set("isleaf", (Object)Character.valueOf('1'));
            cosmicMember.set("enable", (Object)"0");
            cosmicMember.set("disable", (Object)"1");
            cosmicMember.set("membersource", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
            cosmicMember.set("mergernode", (Object)Character.valueOf('0'));
            cosmicMember.set("isinnerorg", (Object)Character.valueOf('0'));
            cosmicMember.set("isouterorg", (Object)Character.valueOf('0'));
            cosmicMember.set("isexchangerate", (Object)Character.valueOf('0'));
            virtualMembers.add(cosmicMember);
            cosmic.set("memberid", (Object)cosmicMember.getLong("id"));
        }
        if (!tmpMap.isEmpty()) {
            idsMap.putAll(tmpMap);
        }
        return virtualMembers.toArray(new DynamicObject[virtualMembers.size()]);
    }

    protected boolean verifyNumber(DynamicObject member, Set<String> existNumbers, Set<String> upExistNumbers) {
        boolean verify;
        String memberNumber = member.getString("number");
        boolean bl = verify = existNumbers.contains(memberNumber) || upExistNumbers.contains(memberNumber.toUpperCase());
        if (!verify) {
            verify = !NumberCheckUtils.checkNumber((String)memberNumber);
        }
        return verify;
    }

    protected DynamicObject createDefaultMember(@NotNull DynamicObject member, @NotNull Dimension dimension, @NotNull DynamicObject view) {
        member.set("status", (Object)Character.valueOf('C'));
        member.set("modifier", (Object)this.getContext().getRunData().getUserId());
        member.set("modifydate", (Object)this.getContext().getRunData().getTime());
        member.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
        member.set("model", (Object)dimension.getModel().getId());
        member.set("dimension", (Object)dimension.getId());
        member.set("view", (Object)view.getLong("id"));
        member.set("isinnerorg", (Object)Character.valueOf('0'));
        member.set("isouterorg", (Object)Character.valueOf('0'));
        member.set("enable", (Object)Character.valueOf('1'));
        member.set("disable", (Object)Character.valueOf('0'));
        return member;
    }

    protected void defaultObjectValue(DynamicObject member, Row row, Dimension dimension, DynamicObject view) {
        if (member == null) {
            return;
        }
        member = this.createDefaultMember(member, dimension, view);
        if (row != null) {
            member.set("number", (Object)row.getString("fnumber"));
            member.set("name", (Object)EASUpgradeUtils.getLocaleStr(row, "fname"));
        }
        if (row == null || row.getBoolean("fisleaf").booleanValue()) {
            member.set("membersource", (Object)Character.valueOf('0'));
            member.set("isleaf", (Object)Character.valueOf('1'));
            member.set("mergernode", (Object)Character.valueOf('0'));
        } else {
            member.set("membersource", (Object)Character.valueOf('1'));
            member.set("isleaf", (Object)Character.valueOf('0'));
            member.set("mergernode", (Object)Character.valueOf('1'));
        }
    }

    protected DynamicObject defaultVirtualValue(@NotNull EASMember cslView, @NotNull Dimension dimension, @NotNull Member rootMember, @NotNull DynamicObject viewMember) {
        DynamicObject virtual = BusinessDataServiceHelper.newDynamicObject((String)dimension.getMemberModel());
        virtual.set("id", (Object)DBServiceHelper.genGlobalLongId());
        virtual.set("number", (Object)(cslView.number + '_' + viewMember.getString("number")));
        virtual.set("name", (Object)viewMember.getString("name"));
        virtual.set("longnumber", (Object)(rootMember.getLongNumber() + '!' + virtual.getString("number")));
        virtual.set("parent", (Object)rootMember.getId());
        virtual.set("masterid", (Object)virtual.getLong("id"));
        virtual.set("creator", (Object)this.getContext().getRunData().getUserId());
        virtual.set("createtime", (Object)this.getContext().getRunData().getTime());
        virtual.set("modifier", (Object)this.getContext().getRunData().getUserId());
        virtual.set("modifytime", (Object)this.getContext().getRunData().getTime());
        virtual.set("status", (Object)Character.valueOf('C'));
        virtual.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
        virtual.set("storagetype", (Object)StorageTypeEnum.STORAGE.getIndex());
        virtual.set("model", (Object)dimension.getModel().getId());
        virtual.set("dimension", (Object)dimension.getId());
        virtual.set("isleaf", (Object)Character.valueOf('0'));
        virtual.set("level", (Object)2);
        virtual.set("enable", (Object)Character.valueOf('1'));
        virtual.set("disable", (Object)Character.valueOf('0'));
        virtual.set("membersource", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex());
        virtual.set("currency", (Object)this.getContext().getRunData().getDefaultCurrency());
        virtual.set("mergernode", (Object)Character.valueOf('0'));
        virtual.set("isinnerorg", (Object)Character.valueOf('0'));
        virtual.set("isouterorg", (Object)Character.valueOf('0'));
        virtual.set("isexchangerate", (Object)Character.valueOf('0'));
        virtual.set("executor", (Object)0L);
        virtual.set("owner", (Object)0L);
        return virtual;
    }
}

