/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import org.jetbrains.annotations.NotNull;

public class EASCurrencyUpgrade
extends AbstractEASUpgrade {
    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASCurrencyUpgrade(param, context);
    }

    protected EASCurrencyUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-currency";
    }

    @Override
    protected void $upgrade() {
        String[] checkTables = new String[]{"T_BD_CURRENCY"};
        if (!this.existTables(this.getParam(), this.getResult(), "BG_Currency", SysDimensionEnum.Currency.getNumber(), this.getUpgradeInfo(), checkTables)) {
            return;
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        EASDim currencyDim = easSchema.getEASDim("BG_Currency");
        Dimension dimension = this.getContext().getRunData().getModelCache().getDimension(SysDimensionEnum.Currency.getNumber());
        List<EASMember> easMembers = EASDimUpgradeUtils.getDimRefMember(this.getParam(), easSchema.getSchemaId(), "BG_Currency");
        currencyDim.members.addAll(easMembers);
        if (currencyDim.members.isEmpty()) {
            String msg = ResManager.loadKDString((String)"EAS\u5e01\u79cd\u7ef4\u5ea6\u6ca1\u6709\u5173\u8054\u7684\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASCurrencyChecker_0", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg));
        } else {
            LinkedHashMap idsMap = Maps.newLinkedHashMap();
            String entityNumber = SysDimensionEnum.Currency.getMemberTreemodel();
            String syncCurrencyTable = this.getParam().getSyncTableName("T_BD_CURRENCY");
            List currencyIds = currencyDim.members.stream().map(version -> version.memberId).collect(Collectors.toList());
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid, fnumber, fname_l1, fname_l2, fname_l3, fdescription_l1, fdescription_l2, fdescription_l3, fsimplename, 1 as fpolalgorithm from " + syncCurrencyTable + " where ", new Object[0]).appendIn("fid", currencyIds);
            try (DataSet ds = DB.queryDataSet((String)"queryEASCur", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        this.transMember(entityNumber, row, dimension, idsMap);
                    }
                }
            }
            this.dealMembers(currencyDim, dimension, idsMap);
            if (this.isSuccess()) {
                this.saveMembers(idsMap.values().toArray(new DynamicObject[0]));
                this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), ResManager.loadKDString((String)"\u5e01\u79cd\u6210\u5458\u5347\u7ea7\u5b8c\u6210\u3002", (String)"EASCurrencyUpgrade_0", (String)"epm-eb-business", (Object[])new Object[0]), null, currencyDim.getNumber(), dimension.getId(), dimension.getNumber()));
            } else {
                this.getStats().addInfo("members upgrade exist error.");
            }
        }
    }

    @Override
    protected DynamicObject transMember(@NotNull String entityNumber, @NotNull Row row, @NotNull Dimension dimension, @NotNull Map<String, DynamicObject> idsMap) {
        DynamicObject currency = super.transMember(entityNumber, row, dimension, idsMap);
        currency.set("aggoprt", (Object)AggOprtEnum.SKIP.getSign());
        return currency;
    }

    @Override
    protected boolean hasParent() {
        return false;
    }
}

