/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.dao.NewMember;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import org.jetbrains.annotations.NotNull;

public class EASCusMemberUpgrade
extends AbstractEASUpgrade {
    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASCusMemberUpgrade(param, context);
    }

    protected EASCusMemberUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-cus";
    }

    @Override
    protected void $upgrade() {
        String[] checkTables = new String[]{"T_MBG_MBGMEMBER", "T_MBG_MBGVIEW"};
        if (!this.existTables(this.getParam(), this.getResult(), null, null, this.getUpgradeInfo(), checkTables)) {
            return;
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        IModelCacheHelper modelCacheHelper = this.getContext().getRunData().getModelCache();
        String syncCusTable = this.getParam().getSyncTableName("T_MBG_MBGMEMBER");
        List<EASMember> cusViews = EASDimUpgradeUtils.getCusDimRefMember(this.getParam(), easSchema.getSchemaId());
        for (EASMember cusView : cusViews) {
            try {
                this.dealCustomDimension(syncCusTable, cusView, modelCacheHelper);
            }
            catch (Exception ex) {
                log.error("upgrade-custom-dim-error:", (Throwable)ex);
                this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), ex));
            }
        }
    }

    protected void dealCustomDimension(String syncCusTable, EASMember cusView, IModelCacheHelper modelCacheHelper) {
        LinkedHashMap idsMap = Maps.newLinkedHashMap();
        if (this.getContext().getRunData().getNewDimNumber(cusView.number) == null) {
            String msg = ResManager.loadResFormat((String)"\u83b7\u53d6\u7ef4\u5ea6\u201c%1\u201d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASCusMemberUpgrade_2", (String)"epm-eb-business", (Object[])new Object[]{cusView.number});
            this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg));
            return;
        }
        Dimension dimension = modelCacheHelper.getDimension(this.getContext().getRunData().getNewDimNumber(cusView.number));
        if (dimension == null) {
            String msg = ResManager.loadResFormat((String)"\u6ca1\u6709\u627e\u5230\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u5347\u7ea7\u540e\u7684\u5bf9\u5e94\u7ef4\u5ea6\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASCusMemberUpgrade_1", (String)"epm-eb-business", (Object[])new Object[]{cusView.number});
            this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg));
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fissystemdefault,fisleaf, fid, fnumber, fparentid, fname_l1, fname_l2, fname_l3, fsimplename, fdescription_l1, fdescription_l2, fdescription_l3, faggregation as fpolalgorithm, fisenabled, fdisableddate from ", new Object[0]);
        sql.append(syncCusTable, new Object[0]).append(" where fviewid = ?", new Object[]{cusView.memberId});
        String noneMemberId = "";
        String rootMemberId = "";
        String noneMemberNumber = "";
        String rootMemberNumber = "";
        try (DataSet ds = DB.queryDataSet((String)"queryEASCus", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    String fissystemdefault = row.getString("fissystemdefault");
                    if ("1".equals(fissystemdefault)) {
                        String fisleaf = row.getString("fisleaf");
                        if ("1".equals(fisleaf)) {
                            noneMemberId = row.getString("fid");
                            noneMemberNumber = row.getString("fnumber");
                            continue;
                        }
                        rootMemberId = row.getString("fid");
                        rootMemberNumber = row.getString("fnumber");
                        continue;
                    }
                    this.transMember("epm_userdefinedmembertree", row, dimension, idsMap);
                }
            }
        }
        EASDim cusEasDim = new EASDim();
        cusEasDim.setId(cusView.getMemberId());
        cusEasDim.setNumber(cusView.getNumber());
        this.dealMembers(cusEasDim, dimension, idsMap);
        if (this.isSuccess()) {
            this.saveMembers(idsMap.values().toArray(new DynamicObject[0]));
            this.addDefaultRootMap(dimension, rootMemberId, rootMemberNumber);
            this.addDefaultMap(dimension, noneMemberId, noneMemberNumber);
            this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6210\u5458\u5347\u7ea7\u5b8c\u6210\u3002", (String)"EASCusMemberUpgrade_0", (String)"epm-eb-business", (Object[])new Object[]{dimension.getName()}), null, cusView.getNumber(), dimension.getId(), dimension.getNumber()));
        } else {
            this.getStats().addInfo(dimension.getNumber() + " members upgrade exist error.");
        }
    }

    private void addDefaultMap(Dimension dimension, String noneMemberId, String noneMemberNumber) {
        Map<String, NewMember> memberNumMap = this.getMemberNumMap();
        Map<String, NewMember> memberIdMap = this.getMemberIdMap();
        Member member = dimension.getStructOfMember(dimension.getNoneNumber());
        NewMember newMember = new NewMember(member.getId(), member.getNumber(), member.getName(), noneMemberId, noneMemberNumber);
        memberIdMap.put(noneMemberId, newMember);
        memberNumMap.put(noneMemberNumber, newMember);
        this.getContext().getRunData().addMemberMapping(dimension.getNumber(), this.getMemberIdMap(), this.getMemberNumMap());
    }

    private void addDefaultRootMap(Dimension dimension, String rootMemberId, String rootMemberNumber) {
        Map<String, NewMember> memberNumMap = this.getMemberNumMap();
        Map<String, NewMember> memberIdMap = this.getMemberIdMap();
        Member member = dimension.getStructOfMember(dimension.getNumber());
        NewMember newMember = new NewMember(member.getId(), member.getNumber(), member.getName(), rootMemberId, rootMemberNumber);
        memberIdMap.put(rootMemberId, newMember);
        memberNumMap.put(rootMemberNumber, newMember);
        this.getContext().getRunData().addMemberMapping(dimension.getNumber(), this.getMemberIdMap(), this.getMemberNumMap());
    }

    @Override
    protected DynamicObject transMember(@NotNull String entityNumber, @NotNull Row row, @NotNull Dimension dimension, @NotNull Map<String, DynamicObject> idsMap) {
        DynamicObject cusMember = super.transMember(entityNumber, row, dimension, idsMap);
        cusMember.set("datatype", (Object)Character.valueOf('0'));
        cusMember.set("disable", (Object)Character.valueOf(row.getInteger("fisenabled") == 0 ? (char)'1' : '0'));
        cusMember.set("disabledate", (Object)row.getDate("fdisableddate"));
        return cusMember;
    }
}

