/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.upgrade.EasUpgradeLogService;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import org.jetbrains.annotations.NotNull;

public class EASDataClearUpgrade
extends AbstractEASUpgrade {
    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASDataClearUpgrade(param, context);
    }

    protected EASDataClearUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-clear";
    }

    @Override
    protected void $upgrade() {
        long modelId;
        QFilter filter;
        DynamicObject model;
        if (this.getParam().isUpgradeData()) {
            return;
        }
        DynamicObject modelLog = EasUpgradeLogService.getInstance().get(this.getParam().getUpgradeModelId());
        if (modelLog != null && (model = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)"id, name, number, shownumber, reportType, version, datasource, creator, level", (QFilter[])(filter = new QFilter("id", "=", (Object)(modelId = modelLog.getLong("model.id")))).toArray())) != null) {
            boolean modelManage = MemberPermHelper.ifUserHasRootPermByModel((long)UserUtils.getUserId(), (String)String.valueOf(modelId));
            if (!modelManage) {
                return;
            }
            filter = new QFilter("model", "=", (Object)modelId);
            if (!QueryServiceHelper.exists((String)"eb_templateentity", (QFilter[])filter.toArray())) {
                try {
                    List datasets = DatasetServiceHelper.getAllDatasets((Long)modelId);
                    ShrekCubeServiceHelper.clearData((Model)Model.of((DynamicObject)model), (List)datasets);
                }
                catch (Exception ex) {
                    log.warn("clear-cubeData-error:", (Throwable)ex);
                    this.getResult().add(EASUpgradeResult.warring(this.getUpgradeInfo(), ResManager.loadResFormat((String)"\u4f53\u7cfb\u6570\u636e\u6e05\u9664\u5931\u8d25(%1)\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASDataClearUpgrade_0", (String)"epm-eb-business", (Object[])new Object[]{ex.getMessage()})));
                }
                OperateOption op = OperateOption.create();
                String appId = this.getParam().getApplication() == ApplicationTypeEnum.BG ? ApplicationTypeEnum.BG.getIndex() : ApplicationTypeEnum.BGMD.getIndex();
                op.setVariableValue("appnumber", appId);
                try {
                    OperationServiceHelper.executeOperate((String)"modeldel", (String)"epm_model", (Object[])new Object[]{modelId}, (OperateOption)op);
                }
                catch (Throwable ex) {
                    log.warn("model-delete-warring:", ex);
                }
            }
        }
    }
}

