/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.easupgrade.constant.EasUpgradeConstants;
import kd.epm.eb.business.easupgrade.enums.Status;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunData;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.dao.EasDataUpgradeDetail;
import kd.epm.eb.business.easupgrade.impl.dao.EasDataUpgradeLog;
import kd.epm.eb.business.easupgrade.impl.dao.NewMember;
import kd.epm.eb.business.easupgrade.impl.dao.OffsetCell;
import kd.epm.eb.business.easupgrade.impl.dao.PeriodMember;
import kd.epm.eb.business.easupgrade.impl.upgrade.EasDataUpgradeLogService;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.sync.BaseDataSyncImpl;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BGCells;
import kd.epm.eb.common.olapdao.BgmdOlapWriter;
import kd.epm.eb.common.olapdao.BgmdShrekDao;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.model.serviceHelper.DataSetServiceHelper;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.request.SaveRequest;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EASDataUpgrade
extends AbstractEASUpgrade {
    public static final EasDataUpgradeLogService easDataUpgradeLogService = EasDataUpgradeLogService.getInstance();

    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASDataUpgrade(param, context);
    }

    protected EASDataUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-data";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void $upgrade() {
        try {
            boolean checker = EASUpgradeResult.isSuccess(this.getResult());
            if (!checker) {
                this.addDataUpgradeLog(false);
                return;
            }
            this.initModelCache();
            IEASUpgradeParam param = this.getParam();
            BaseDataSyncImpl sync = new BaseDataSyncImpl();
            IEASSchema easSchema = param.getEASSchema();
            String refCube = easSchema.getRefCube();
            Long upgradeSourceId = param.getUpgradeSourceId();
            this.addDataUpgradeLog(true);
            try {
                if (param.isSyncData()) {
                    sync.startSync(upgradeSourceId, refCube);
                }
            }
            catch (Exception e) {
                if (param.getSyncTableName(refCube) == null) {
                    throw new KDBizException(e.getMessage());
                }
                log.info(e.getMessage());
            }
            List<EASMember> easMembers = EASDimUpgradeUtils.getDimRefMember(this.getParam(), easSchema.getSchemaId(), "BG_Organization", new Object[]{3});
            easSchema.setHasConsolidationDim(!easMembers.isEmpty());
            if (easSchema.isHasConsolidationDim()) {
                String offsetCube = easSchema.getOffsetRefCube();
                try {
                    if (param.isSyncData()) {
                        sync.startSync(upgradeSourceId, offsetCube);
                    }
                }
                catch (Exception e) {
                    if (param.getSyncTableName(offsetCube) == null) {
                        throw new KDBizException(e.getMessage());
                    }
                    log.info(e.getMessage());
                }
            }
            param.setTableMap();
            this.initDimMap();
            this.initMemberMap();
            this.initPeriodMap();
            this.initScenrioIdTypeMap();
            this.upgradeData();
            this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), "success"));
            EasDataUpgradeLog dataUpLog = this.getContext().getRunData().getEasDataUpgradeLog();
            dataUpLog.setStatus(Status.SUCCEED.getVal());
            easDataUpgradeLogService.update(dataUpLog);
        }
        catch (Exception ex) {
            this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), CommonServiceHelper.getStackTraceStr((Throwable)ex)));
            this.addDataUpgradeLog(false);
            log.error("eas-data-upgrade-error:", (Throwable)ex);
        }
        finally {
            if (this.getCountDownLatch() != null) {
                this.getCountDownLatch().countDown();
            }
            this.getStats().addInfo("end-data-upgrade.");
            log.info(this.getStats().toString());
        }
    }

    private void addDataUpgradeLog(boolean success) {
        IRunData runData = this.getContext().getRunData();
        EasDataUpgradeLog dataUpLog = runData.getEasDataUpgradeLog();
        dataUpLog.setUpgradeModelId(this.getParam().getUpgradeModelId());
        dataUpLog.setStatus(success ? Status.SYNC.getVal() : Status.FAILED.getVal());
        StringBuilder info = new StringBuilder();
        List<IEASUpgradeResult> results = this.getResult();
        for (IEASUpgradeResult result : results) {
            info.append(result.getAllInfo());
        }
        dataUpLog.setInfo(info.toString());
        easDataUpgradeLogService.add(dataUpLog);
    }

    private void upgradeData() {
        IRunData runData = this.getContext().getRunData();
        IEASUpgradeParam param = this.getParam();
        IEASSchema easSchema = param.getEASSchema();
        IModelCacheHelper modelCache = runData.getModelCache();
        Long modelId = modelCache.getModelobj().getId();
        DynamicObject dataset = DataSetServiceHelper.loadDefault(modelId);
        long dataSetId = dataset.getLong("id");
        List dimensionList = modelCache.getDimensionList(Long.valueOf(dataSetId));
        ArrayList<String> dimNumberList = new ArrayList<String>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            String dimensionNumber = dimension.getNumber();
            dimNumberList.add(dimensionNumber);
        }
        HashSet<String> fields = new HashSet<String>(EasUpgradeConstants.EAS_EB_DIM_MAP.keySet());
        Map<String, String> dimNumMap = runData.getDimNumMap();
        for (Map.Entry entry : dimNumMap.entrySet()) {
            String newDim = (String)entry.getValue();
            if (!dimNumberList.contains(newDim)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u9ed8\u8ba4\u6570\u636e\u96c6\u7f3a\u5c11\u7ef4\u5ea6%1\uff0c\u65e0\u6cd5\u5347\u7ea7\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5220\u9664\u3002", (String)"EASDataUpgrade_2", (String)"epm-eb-business", (Object[])new Object[]{newDim}));
            }
            String oldDim = (String)entry.getKey();
            EASDim easDim = easSchema.getEASDim(oldDim);
            if (easDim == null || "BG_Consolidation".equals(oldDim)) continue;
            fields.add(easDim.fieldMapped);
        }
        String defalutAuditTrail = this.getDefalutAuditTrail(modelCache);
        this.setTotal(easSchema);
        long l = 0L;
        long failCount = 0L;
        String sql = this.queryDataSql(param.getSyncTableName(easSchema.getRefCube()), fields);
        try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            if (dataSet != null) {
                int size = 100000;
                ArrayList<BGCell> datas = new ArrayList<BGCell>(size);
                while (dataSet.hasNext()) {
                    Row data = dataSet.next();
                    List<BGCell> bgCells = this.toCell(data, defalutAuditTrail, dimensionList);
                    if (!bgCells.isEmpty()) {
                        ++l;
                        datas.addAll(bgCells);
                    } else {
                        ++failCount;
                    }
                    if (datas.size() < size) continue;
                    long finalSuccessCount = l;
                    long finalFailCount = failCount;
                    ArrayList<BGCell> copyDatas = new ArrayList<BGCell>(datas);
                    EpmThreadPools.CommPools.execute(() -> this.saveToOlap(copyDatas, modelId, dataSetId, finalSuccessCount, finalFailCount));
                    datas.clear();
                }
                this.saveToOlap(datas, modelId, dataSetId, l, failCount);
            }
        }
        if (easSchema.isHasConsolidationDim()) {
            EASDim consolidationDim = this.getParam().getEASSchema().getEASDim("BG_Consolidation");
            fields.add(consolidationDim.fieldMapped);
            fields.add("funionid");
            String offsetSql = this.queryOffsetDataSql(param.getSyncTableName(easSchema.getOffsetRefCube()), fields);
            try (DataSet offsetDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)offsetSql);){
                if (offsetDataSet != null) {
                    HashMap<String, OffsetCell> membelCellMap = new HashMap<String, OffsetCell>(16);
                    while (offsetDataSet.hasNext()) {
                        Row data = offsetDataSet.next();
                        List<BGCell> bgCells = this.toCell(data, defalutAuditTrail, dimensionList, true, membelCellMap);
                        if (!bgCells.isEmpty()) {
                            ++l;
                            continue;
                        }
                        ++failCount;
                    }
                    ArrayList<BGCell> datas = new ArrayList<BGCell>(membelCellMap.size());
                    for (OffsetCell offsetCell : membelCellMap.values()) {
                        datas.add(offsetCell.getCell());
                    }
                    this.saveToOlap(datas, modelId, dataSetId, l, failCount);
                }
            }
        }
    }

    private void setTotal(IEASSchema easSchema) {
        IEASUpgradeParam param = this.getParam();
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)("select count(fid) count from " + param.getSyncTableName(easSchema.getRefCube())));
        long total = 0L;
        if (dataSet != null && dataSet.hasNext()) {
            total += dataSet.next().getLong("count").longValue();
        }
        if (easSchema.isHasConsolidationDim()) {
            EASDim consolidationDim = this.getParam().getEASSchema().getEASDim("BG_Consolidation");
            String field = consolidationDim.fieldMapped;
            DataSet offsetDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)("select count(fid) count from " + param.getSyncTableName(easSchema.getOffsetRefCube()) + " where " + field + " in ('Csl:CSL-05', 'Csl:CSL-06')"));
            if (offsetDataSet != null) {
                total += offsetDataSet.next().getLong("count").longValue();
            }
        }
        EasDataUpgradeLog easDataUpgradeLog = this.getContext().getRunData().getEasDataUpgradeLog();
        easDataUpgradeLog.setTotalCount(total);
        easDataUpgradeLog.setWaitCount(total);
        easDataUpgradeLog.setStatus(Status.UPGRADE.getVal());
        easDataUpgradeLogService.update(easDataUpgradeLog);
    }

    private void saveUpgradeDataLog() {
        IRunData runData = this.getContext().getRunData();
        easDataUpgradeLogService.addDetailsLogs(runData.getEasDataUpgradeDetails());
        runData.clearEasDataUpgradeDetails();
    }

    private String queryOffsetDataSql(String refCube, Set<String> fields) {
        EASDim consolidationDim = this.getParam().getEASSchema().getEASDim("BG_Consolidation");
        String field = consolidationDim.fieldMapped;
        return this.queryDataSql(refCube, fields) + " where " + field + " in ('Csl:CSL-05', 'Csl:CSL-06') order by " + field + ", fstate";
    }

    private String queryDataSql(String refCube, Set<String> fields) {
        StringBuilder query = new StringBuilder();
        query.append("select fid,fvalue,fstate,");
        for (String field : fields) {
            query.append(field).append(",");
        }
        return query.substring(0, query.length() - 1) + " from " + refCube;
    }

    private String getDefalutAuditTrail(IModelCacheHelper modelCache) {
        Member member = modelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, "EntityInput");
        if (member.isLeaf()) {
            return member.getNumber();
        }
        List detailChildren = modelCache.getDetailChildren(member);
        for (Member detailChild : detailChildren) {
            if (!"10".equals(detailChild.getAuditTrailUse())) continue;
            return detailChild.getNumber();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7ebf\u7d22\u6210\u5458EntityInput\u4e0d\u662f\u660e\u7ec6\u6210\u5458\uff0c\u5176\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458\u90fd\u4e0d\u662f\u7f16\u5236\u7528\u9014\u7684\u6210\u5458\u3002", (String)"EASDataUpgrade_1", (String)"epm-eb-business", (Object[])new Object[0]));
    }

    private void saveToOlap(List<BGCell> cells, Long modelId, Long dataSetId, long successCount, long failCount) {
        EasDataUpgradeLog easDataUpgradeLog = this.getContext().getRunData().getEasDataUpgradeLog();
        easDataUpgradeLog.setSuccessCount(successCount);
        easDataUpgradeLog.setFailCount(failCount);
        easDataUpgradeLog.setWaitCount(easDataUpgradeLog.getTotalCount() - easDataUpgradeLog.getSuccessCount() - easDataUpgradeLog.getFailCount());
        easDataUpgradeLogService.update(easDataUpgradeLog);
        this.saveUpgradeDataLog();
        if (cells.size() > 0) {
            IModelCacheHelper modelCache = this.getContext().getRunData().getModelCache();
            List dimensionList = modelCache.getDimensionList(dataSetId);
            SaveRequest request = new SaveRequest(modelId, dataSetId, cells);
            List writeDims = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            Long busModelByDataSet = modelCache.getBusModelByDataSet(dataSetId);
            try (BgmdOlapWriter writer = BgmdShrekDao.getInstance().save(modelCache, AlgoCalcUtils.getCubeNumber((Long)request.getDatasetId()), writeDims, request.getFixMemberList());){
                for (BGCell cell : cells) {
                    try {
                        writer.addValue(cell, busModelByDataSet);
                    }
                    catch (Exception e) {
                        log.error("EASDataUpgrade - error : " + e.getMessage());
                    }
                }
            }
        }
    }

    private List<BGCell> toCell(Row data, String defalutAuditTrail, List<Dimension> dimensionList) {
        return this.toCell(data, defalutAuditTrail, dimensionList, false, null);
    }

    private List<BGCell> toCell(Row data, String defalutAuditTrail, List<Dimension> dimensionList, boolean isOffset, Map<String, OffsetCell> memberCellMap) {
        ArrayList<BGCell> cells = new ArrayList<BGCell>(10);
        try {
            IRunData runData = this.getContext().getRunData();
            IEASSchema easSchema = this.getContext().getEASSchema();
            ArrayList<String> dimensionNumberList = new ArrayList<String>(dimensionList.size());
            ArrayList<Object> members = new ArrayList<Object>(dimensionList.size());
            members.add(data.getBigDecimal("fvalue"));
            String fieldValue = "";
            Map<String, String> scenrioIdTypeMap = runData.getScenrioIdTypeMap();
            String scenarioType = scenrioIdTypeMap.get(data.getString("fscenario"));
            Map<String, PeriodMember> periodIdMemberMap = runData.getPeriodIdMemberMap();
            Map<String, Map<String, NewMember>> numberMappingMap = runData.getNumberMappingMap();
            HashSet<String> easPeriods = new HashSet<String>(16);
            String budgetPeriodMemberNumber = "";
            String offset = "";
            String direction = "";
            String unionid = "";
            String state = "";
            EASDim consolidationDim = this.getParam().getEASSchema().getEASDim("BG_Consolidation");
            Map<String, String> newDimNumMap = runData.getNewDimNumMap();
            IModelCacheHelper modelCache = runData.getModelCache();
            for (Dimension dimension : dimensionList) {
                String memberNumber;
                String dimensionNumber = dimension.getNumber();
                String oldDim = newDimNumMap.get(dimensionNumber);
                if ("EasPeriod".equals(dimensionNumber)) continue;
                if (isOffset) {
                    offset = data.getString(consolidationDim.fieldMapped);
                    state = data.getString("fstate");
                }
                String field = EasUpgradeConstants.EB_EAS_DIM_MAP.get(dimensionNumber);
                if ("AuditTrail".equals(dimensionNumber)) {
                    memberNumber = defalutAuditTrail;
                } else if ("ChangeType".equals(dimensionNumber)) {
                    memberNumber = "1".equals(scenarioType) ? "DataIntegration" : "CurrentPeriod";
                } else {
                    if (field == null) {
                        field = this.getCustomDimField(easSchema, oldDim);
                    }
                    if (field != null) {
                        String[] strs;
                        fieldValue = data.getString(field);
                        if (StringUtils.isEmpty((String)fieldValue)) {
                            return cells;
                        }
                        if (("Account".equals(dimensionNumber) || !EasUpgradeConstants.EB_EAS_DIM_MAP.containsKey(dimensionNumber)) && (strs = fieldValue.split(":")).length > 1) {
                            fieldValue = strs[1];
                        }
                        if (isOffset && "Entity".equals(dimensionNumber)) {
                            unionid = data.getString("funionid");
                            memberNumber = runData.getNumberByMapping("BG_Consolidation" + unionid, fieldValue);
                            oldDim = "BG_Consolidation";
                        } else if ("BudgetPeriod".equals(dimensionNumber)) {
                            PeriodMember periodMember = periodIdMemberMap.get(fieldValue);
                            if (periodMember == null) {
                                String msg = ResManager.loadResFormat((String)"EAS:%1\u7ef4\u5ea6%2\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"EASDataUpgrade_0", (String)"epm-eb-business", (Object[])new Object[]{"BG_Period", fieldValue});
                                this.addDataUpgradeDetail(msg, data.toString());
                                return cells;
                            }
                            if (!periodMember.isSuccess()) {
                                this.addDataUpgradeDetail(periodMember.getInfo(), data.toString());
                                return cells;
                            }
                            String easPeriodNumber = periodMember.getEasNumber();
                            Map<String, NewMember> newMemberMap = numberMappingMap.get("EasPeriod");
                            if (newMemberMap != null) {
                                NewMember newMember = newMemberMap.get(easPeriodNumber);
                                if (newMember != null) {
                                    Map<String, NewMember> children = newMember.getChildren();
                                    easPeriods.add(newMember.getNumber());
                                    if (children != null) {
                                        easPeriods.addAll(children.keySet());
                                    }
                                } else {
                                    String msg = ResManager.loadResFormat((String)"EAS:%1\u7ef4\u5ea6%2\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"EASDataUpgrade_0", (String)"epm-eb-business", (Object[])new Object[]{"EasPeriod", easPeriodNumber});
                                    this.addDataUpgradeDetail(msg, data.toString());
                                    return cells;
                                }
                            }
                            memberNumber = periodMember.getEbNumber();
                        } else {
                            memberNumber = runData.getNumberByMapping(oldDim, fieldValue);
                        }
                    } else {
                        memberNumber = dimension.getNoneNumber();
                    }
                }
                if (StringUtils.isEmpty((String)memberNumber)) {
                    String msg = ResManager.loadResFormat((String)"EAS:%1\u7ef4\u5ea6%2\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"EASDataUpgrade_0", (String)"epm-eb-business", (Object[])new Object[]{oldDim, fieldValue});
                    this.addDataUpgradeDetail(msg, data.toString());
                    return cells;
                }
                Long viewId = runData.getUnionIdViewIdMap().get(unionid);
                Member member = modelCache.getMember(dimensionNumber, viewId, memberNumber);
                if (member == null) {
                    String msg = ResManager.loadResFormat((String)"\u661f\u701a\uff1a%1\u7ef4\u5ea6%2\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"EASDataUpgrade_5", (String)"epm-eb-business", (Object[])new Object[]{dimensionNumber, memberNumber});
                    this.addDataUpgradeDetail(msg, data.toString());
                    return cells;
                }
                if (!member.isLeaf()) {
                    if (isOffset && !dimension.isPreset()) {
                        memberNumber = dimension.getNoneNumber();
                    } else {
                        Member cosmicMember = this.buildCosmicMember(modelCache, dimensionNumber, member);
                        memberNumber = cosmicMember.getNumber();
                    }
                }
                if ("BudgetPeriod".equals(dimensionNumber) && easPeriods.size() > 0) {
                    budgetPeriodMemberNumber = memberNumber;
                    continue;
                }
                if ("Account".equals(dimensionNumber)) {
                    direction = member.getAccountDirection();
                }
                members.add(memberNumber);
                dimensionNumberList.add(dimensionNumber);
            }
            if (easPeriods.size() > 0) {
                for (String easPeriod : easPeriods) {
                    ArrayList<String> dimensionNumberList1 = new ArrayList<String>(dimensionNumberList);
                    ArrayList<String> members1 = new ArrayList<String>(members);
                    if (!(easPeriod.startsWith("YEAR.") || easPeriod.startsWith("HALF.") || easPeriod.startsWith("QUAR.") || easPeriod.startsWith("MONT."))) {
                        budgetPeriodMemberNumber = budgetPeriodMemberNumber.split("\\.")[0] + ".M01";
                    }
                    members1.add(budgetPeriodMemberNumber);
                    dimensionNumberList1.add("BudgetPeriod");
                    Member member = modelCache.getMember("EasPeriod", null, easPeriod);
                    if (!member.isLeaf()) {
                        Member cosmicMember = this.buildCosmicMember(modelCache, "EasPeriod", member);
                        easPeriod = cosmicMember.getNumber();
                    }
                    members1.add(easPeriod);
                    dimensionNumberList1.add("EasPeriod");
                    cells.add(BGCells.of((Object[])members1.toArray(new Object[0]), dimensionNumberList1));
                }
            } else {
                cells.add(BGCells.of((Object[])members.toArray(new Object[0]), dimensionNumberList));
            }
            if (isOffset) {
                for (BGCell cell : cells) {
                    String memberKey;
                    OffsetCell offsetCellOld;
                    if ("5".equals(direction) && "Csl:CSL-06".equals(offset) || "6".equals(direction) && "Csl:CSL-05".equals(offset)) {
                        BigDecimal value = (BigDecimal)cell.getValue();
                        cell.setValue((Object)value.negate());
                    }
                    if ((offsetCellOld = memberCellMap.get(memberKey = cell.getKey2(dimensionList))) != null && state.equals(offsetCellOld.getState())) {
                        BGCell cellOld = offsetCellOld.getCell();
                        BigDecimal oldValue = (BigDecimal)cellOld.getValue();
                        cellOld.setValue((Object)oldValue.add((BigDecimal)cell.getValue()));
                        continue;
                    }
                    OffsetCell offsetCell = new OffsetCell();
                    offsetCell.setCell(cell);
                    offsetCell.setOffset(offset);
                    memberCellMap.put(memberKey, offsetCell);
                }
            }
        }
        catch (Exception e) {
            this.addDataUpgradeDetail(e.getMessage(), data.toString());
            return cells;
        }
        return cells;
    }

    private String getCustomDimField(IEASSchema easSchema, String easDimNumber) {
        EASDim easDim;
        if (easDimNumber != null && (easDim = easSchema.getEASDim(easDimNumber)) != null) {
            return easDim.fieldMapped;
        }
        return null;
    }

    private Member buildCosmicMember(IModelCacheHelper modelCache, String dimNumber, Member member) {
        Member cosmicMember = modelCache.getMember(dimNumber, null, member.getNumber() + "._inv");
        if (cosmicMember != null) {
            return cosmicMember;
        }
        DynamicObject dataset = DataSetServiceHelper.loadDefault(modelCache.getModelobj().getId());
        long dataSetId = dataset.getLong("id");
        cosmicMember = MemberServiceHelper.addCosmicMember((Member)member, (Long)dataSetId);
        this.getContext().getRunData().updateModelCache();
        return cosmicMember;
    }

    private void addDataUpgradeDetail(String msg, String data) {
        EasDataUpgradeDetail easDataUpgradeDetail = new EasDataUpgradeDetail();
        easDataUpgradeDetail.setDataJson(data);
        easDataUpgradeDetail.setUpgradeModelId(this.getParam().getUpgradeModelId());
        easDataUpgradeDetail.setInfo(msg);
        easDataUpgradeDetail.setStatus(Status.FAILED.getVal());
        easDataUpgradeDetail.setCreatedate(TimeServiceHelper.now());
        IRunData runData = this.getContext().getRunData();
        runData.addEasDataUpgradeDetails(easDataUpgradeDetail);
    }

    private void initModelCache() {
        QFilter qFilter;
        DynamicObject dynamicObject;
        IRunData runData = this.getContext().getRunData();
        IEASUpgradeParam param = this.getParam();
        Long upgradeModelId = param.getUpgradeModelId();
        IModelCacheHelper modelCache = runData.getModelCache();
        if (modelCache == null && (dynamicObject = QueryServiceHelper.queryOne((String)"eb_eas_upgrade_log", (String)"model_id", (QFilter[])(qFilter = new QFilter("upgrademodel", "=", (Object)upgradeModelId)).toArray())) != null) {
            runData.setModelId(dynamicObject.getLong("model_id"));
            runData.getModelCacheByReBuilder();
        }
    }

    private void initDimMap() {
        IRunData runData = this.getContext().getRunData();
        IEASUpgradeParam param = this.getParam();
        Long upgradeModelId = param.getUpgradeModelId();
        Map<String, Long> unionIdViewIdMap = runData.getUnionIdViewIdMap();
        QFilter qFilter = new QFilter("upgrademodel", "=", (Object)upgradeModelId);
        qFilter.and(new QFilter("status", "=", (Object)Status.SUCCEED.getVal()));
        String fields = "dimuplog.easdimid,dimuplog.easdimnumber,dimuplog.dimid,dimuplog.dimnumber,dimuplog.easunionid,dimuplog.viewid";
        DynamicObjectCollection memberMaps = QueryServiceHelper.query((String)"eb_eas_upgrade_log", (String)fields, (QFilter[])qFilter.toArray(), (String)"dimuplog.easdimnumber");
        for (DynamicObject memberMap : memberMaps) {
            String easdimid = memberMap.getString("dimuplog.easdimid");
            String easdimnumber = memberMap.getString("dimuplog.easdimnumber");
            Long dimid = memberMap.getLong("dimuplog.dimid");
            String dimnumber = memberMap.getString("dimuplog.dimnumber");
            runData.addDimMapping(easdimid, easdimnumber, dimid, dimnumber);
            String easunionid = memberMap.getString("dimuplog.easunionid");
            Long viewid = memberMap.getLong("dimuplog.viewid");
            if (!StringUtils.isNotEmpty((String)easunionid) || !IDUtils.isNotNull((Long)viewid)) continue;
            unionIdViewIdMap.put(easunionid, viewid);
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fnumber, fsrcnumber, freffield, fname_l1, fname_l2, fname_l3, fdescription_l1, fdescription_l2, fdescription_l3 from ", new Object[0]);
        sql.append(param.getSyncTableName("T_MBG_MBGDIM"), new Object[0]).append(" where ", new Object[0]);
        sql.appendIn("fnumber", new ArrayList<String>(runData.getDimNumMap().keySet()));
        sql.append(" order by freffield", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"queryEASDims", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    EASDim easDim = EASDim.of(row);
                    easSchema.addEASDim(easDim);
                }
            }
        }
    }

    private void initMemberMap() {
        IRunData runData = this.getContext().getRunData();
        IEASUpgradeParam param = this.getParam();
        Long upgradeModelId = param.getUpgradeModelId();
        Map<String, Map<String, NewMember>> dimIdMappingMap = runData.getIdMappingMap();
        Map<String, Map<String, NewMember>> dimNumberMappingMap = runData.getNumberMappingMap();
        QFilter qFilter = new QFilter("upgrademodel", "=", (Object)upgradeModelId);
        qFilter.and(new QFilter("status", "=", (Object)Status.SUCCEED.getVal()));
        String fields = "easdimnumber,easmemid,easmemnumber,easmemname,memid,memnumber,memname,easunionid";
        DynamicObjectCollection memberMaps = QueryServiceHelper.query((String)"eb_eas_mem_upgrade_log", (String)fields, (QFilter[])qFilter.toArray(), (String)"easdimnumber");
        for (DynamicObject memberMap : memberMaps) {
            String easdimnumber = memberMap.getString("easdimnumber");
            String easmemid = memberMap.getString("easmemid");
            String easmemnumber = memberMap.getString("easmemnumber");
            Long memid = memberMap.getLong("memid");
            String memnumber = memberMap.getString("memnumber");
            String memname = memberMap.getString("memname");
            if ("BG_Consolidation".equals(easdimnumber)) {
                String easunionid = memberMap.getString("easunionid");
                easdimnumber = "BG_Consolidation" + easunionid;
            }
            NewMember newMember = new NewMember(memid, memnumber, memname, easmemid, easmemnumber);
            Map idMappingMap = dimIdMappingMap.computeIfAbsent(easdimnumber, e -> new HashMap(32));
            idMappingMap.put(easmemid, newMember);
            Map numberMappingMap = dimNumberMappingMap.computeIfAbsent(easdimnumber, e -> new HashMap(32));
            if ("EasPeriod".equals(easdimnumber)) {
                NewMember newMember1 = (NewMember)numberMappingMap.get(easmemnumber);
                if (newMember1 == null) {
                    numberMappingMap.put(easmemnumber, newMember);
                    continue;
                }
                newMember1.merge(newMember);
                continue;
            }
            numberMappingMap.put(easmemnumber, newMember);
        }
    }

    private void initPeriodMap() {
        IRunData runData = this.getContext().getRunData();
        IEASUpgradeParam param = this.getParam();
        String syncTable = param.getSyncTableName("T_MBG_BgPeriod");
        String sql = "select fid,fnumber,fperiodtype,fisleaf from " + syncTable;
        HashMap<String, PeriodMember> periodIdMemberMap = new HashMap<String, PeriodMember>(16);
        try (DataSet ds = DB.queryDataSet((String)"EASDataUpgrade", (DBRoute)BgBaseConstant.epm, (String)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    String fid = row.getString("fid");
                    String fnumber = row.getString("fnumber");
                    String fperiodtype = row.getString("fperiodtype");
                    boolean fisleaf = row.getBoolean("fisleaf");
                    PeriodMember periodMember = new PeriodMember(fid, fnumber, fisleaf, fperiodtype);
                    periodIdMemberMap.put(fid, periodMember);
                }
            }
        }
        for (PeriodMember periodMember : periodIdMemberMap.values()) {
            try {
                String periodTypeId;
                periodMember.setSuccess(true);
                String easNumber = periodMember.getEasNumber();
                String[] easNumberSplit = easNumber.split("\\.");
                int length = easNumberSplit.length;
                String ebNumber = "";
                switch (periodTypeId = periodMember.getPeriodTypeId()) {
                    case "1": {
                        if (length != 2) break;
                        String year = easNumberSplit[1].replace("Y", "");
                        if (periodMember.isEasIsLeaf()) {
                            ebNumber = "FY" + year + ".M01";
                            break;
                        }
                        ebNumber = "FY" + year;
                        break;
                    }
                    case "2": {
                        int month;
                        if (length != 3) break;
                        String year = easNumberSplit[1].replace("Y", "");
                        int half = Integer.parseInt(easNumberSplit[2].replace("HY", ""));
                        if (periodMember.isEasIsLeaf()) {
                            month = (half - 1) * 6 + 1;
                            ebNumber = "FY" + year + ".M" + (month < 10 ? "0" + month : "" + month);
                            break;
                        }
                        ebNumber = "FY" + year + ".HF" + half;
                        break;
                    }
                    case "3": {
                        int month;
                        if (length != 3) break;
                        String year = easNumberSplit[1].replace("Y", "");
                        int quar = Integer.parseInt(easNumberSplit[2].replace("Q", ""));
                        if (periodMember.isEasIsLeaf()) {
                            month = (quar - 1) * 3 + 1;
                            ebNumber = "FY" + year + ".M" + (month < 10 ? "0" + month : "" + month);
                            break;
                        }
                        ebNumber = "FY" + year + ".Q" + quar;
                        break;
                    }
                    case "4": {
                        if (length != 3) break;
                        String year = easNumberSplit[1].replace("Y", "");
                        String month = easNumberSplit[2].replace("M", "");
                        ebNumber = "FY" + year + ".M" + month;
                        break;
                    }
                    case "5": 
                    case "6": 
                    case "7": 
                    case "9": {
                        periodMember.setSuccess(false);
                        periodMember.setInfo(ResManager.loadKDString((String)"\u5e74\u5468\u3001\u6708\u5468\u3001\u65ec\u3001\u65e5\u4e0d\u5347\u7ea7\u3002", (String)"EASDataUpgrade_4", (String)"epm-eb-business", (Object[])new Object[0]));
                        break;
                    }
                    default: {
                        if (length < 2) break;
                        String year = easNumberSplit[1].replace("Y", "");
                        ebNumber = "FY" + year + ".M01";
                    }
                }
                periodMember.setEbNumber(ebNumber);
            }
            catch (Exception e) {
                periodMember.setSuccess(false);
                periodMember.setInfo(ResManager.loadResFormat((String)"\u671f\u95f4\u5206\u7c7b\u8f6c\u6362\u51fa\u9519\uff1a%1\u3002", (String)"EASDataUpgrade_3", (String)"epm-eb-business", (Object[])new Object[]{e.getMessage()}));
            }
        }
        runData.setPeriodIdMemberMap(periodIdMemberMap);
    }

    private void initScenrioIdTypeMap() {
        IRunData runData = this.getContext().getRunData();
        IEASUpgradeParam param = this.getParam();
        String syncTable = param.getSyncTableName("T_MBG_BGSCENARIO");
        String sql = "select fscenarioid,ftype from " + syncTable;
        HashMap<String, String> scenrioIdTypeMap = new HashMap<String, String>(16);
        try (DataSet ds = DB.queryDataSet((String)"EASDataUpgrade", (DBRoute)BgBaseConstant.epm, (String)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    String fscenarioid = row.getString("fscenarioid");
                    String ftype = row.getString("ftype");
                    scenrioIdTypeMap.put(fscenarioid, ftype);
                }
            }
        }
        runData.setScenrioIdTypeMap(scenrioIdTypeMap);
    }
}

