/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunData;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASPeriod;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.NumberCheckUtils;
import org.jetbrains.annotations.NotNull;

public class EASDimsUpgrade
extends AbstractEASUpgrade {
    private static final String[] checkTables = new String[]{"T_MBG_MBGDIM", "T_MBG_MBGVIEW", "T_MBG_BGDIMSETTINGS", "T_MBG_BGDIMSETTINGSMEMBER", "T_MBG_BgPeriod", "T_MBG_BgPeriodType", "T_MBG_BgPeriodDisp"};

    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASDimsUpgrade(param, context);
    }

    protected EASDimsUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    public String getUpgradeInfo() {
        return "upgrade-dims";
    }

    @Override
    protected void $upgrade() {
        DynamicObject dimension;
        if (!this.existTables(this.getParam(), this.getResult(), null, null, this.getUpgradeInfo(), checkTables)) {
            return;
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        IRunData runData = this.getContext().getRunData();
        IEASUpgradeParam param = this.getParam();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fnumber, fsrcnumber, freffield, fname_l1, fname_l2, fname_l3, fdescription_l1, fdescription_l2, fdescription_l3 from ", new Object[0]);
        sql.append(param.getSyncTableName("T_MBG_MBGDIM"), new Object[0]);
        sql.append(" order by freffield", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"queryEASDims", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                easSchema.addEASDim(EASDim.defaultEAS("BG_Organization", "BG_Organization"));
                easSchema.addEASDim(EASDim.defaultEAS("BG_Account", "BG_Account"));
                easSchema.addEASDim(EASDim.defaultEAS("BG_Period", "BG_Period"));
                easSchema.addEASDim(EASDim.defaultEAS("BG_Scenario", "BG_Scenario"));
                easSchema.addEASDim(EASDim.defaultEAS("BG_Version", "BG_Version"));
                easSchema.addEASDim(EASDim.defaultEAS("BG_Currency", "BG_Currency"));
                easSchema.addEASDim(EASDim.defaultEAS("BG_Element", "BG_Element"));
                for (Row row : ds) {
                    EASDim easDim = EASDim.of(row);
                    easSchema.addEASDim(easDim);
                }
            }
        }
        String syncDimSetMember = param.getSyncTableName("T_MBG_BGDIMSETTINGSMEMBER");
        String syncDimSet = param.getSyncTableName("T_MBG_BGDIMSETTINGS");
        String syncDimView = param.getSyncTableName("T_MBG_MBGVIEW");
        String syncDim = param.getSyncTableName("T_MBG_MBGDIM");
        sql = new SqlBuilder();
        sql.append("select t.fid, t.fdimnumber, m.fmemberid, v.fstandby from " + syncDimSet + " t join " + syncDimSetMember + " m on t.fid = m.fbgdimsettingsid join " + syncDimView + " v on m.fmemberid = v.fid where t.fbgschemeid = ? and t.fdimnumber in (select fnumber from " + syncDim + ") and v.fstandby = 0", new Object[]{easSchema.getSchemaId()});
        ArrayList dims = Lists.newArrayListWithExpectedSize((int)32);
        ArrayList views = Lists.newArrayListWithExpectedSize((int)32);
        ArrayList members = Lists.newArrayListWithExpectedSize((int)32);
        try (DataSet ds = DB.queryDataSet((String)"queryEASDims", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    if ("BG_Consolidation".equals(row.getString("fdimnumber")) || (dimension = this.createCustomDim(row, dims)) == null) continue;
                    dims.add(dimension);
                    views.add(this.createDefaultView(dimension));
                    members.addAll(this.createDefaultMembers(dimension));
                }
            }
        }
        runData.setHasCustomPeriodDim(this.hasCustomPeriodTypeDim());
        if (!this.isSuccess()) {
            return;
        }
        if (runData.hasCustomPeriodDim()) {
            dimension = this.createCusPeriodDim(dims);
            dims.add(dimension);
            views.add(this.createDefaultView(dimension));
            members.addAll(this.createDefaultMembers(dimension));
        }
        var15_17 = null;
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])dims.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])views.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])members.toArray(new DynamicObject[0]));
            }
            catch (Throwable ex) {
                tx.markRollback();
                this.getResult().add(EASUpgradeResult.error("upgrade-dims", ex));
                throw new KDBizException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            var15_17 = throwable;
            throw throwable;
        }
        if (this.isSuccess()) {
            Long modelId = this.getContext().getRunData().getModelCache().getModelobj().getId();
            CubeUtils.updateCubeVersion((Long)modelId);
            this.getContext().getRunData().getModelCacheByReBuilder();
        }
    }

    private DynamicObject createCustomDim(Row row, List<DynamicObject> dims) {
        if (row == null) {
            return null;
        }
        String oldDimNumber = row.getString("fdimnumber");
        EASDim easDim = this.getContext().getEASSchema().getEASDim(oldDimNumber);
        if (easDim == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"EAS\u65b9\u6848\u5173\u8054\u7684\u7ef4\u5ea6\uff08%1\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASDimsUpgrade_0", (String)"epm-eb-business", (Object[])new Object[]{oldDimNumber}));
        }
        DynamicObject dimension = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
        this.setDimensionDefaultValue(dimension, dims);
        if (SysDimensionEnum.include((String)oldDimNumber) || NumberCheckUtils.checkNumber((String)oldDimNumber) || Character.isDigit(oldDimNumber.charAt(0))) {
            dimension.set("number", (Object)EASUpgradeUtils.getNumber1("EAS", oldDimNumber));
        } else {
            dimension.set("number", (Object)EASUpgradeUtils.getNumber1(null, oldDimNumber));
        }
        dimension.set("shortnumber", (Object)easDim.srcNumber);
        dimension.set("name", (Object)easDim.name);
        dimension.set("description", (Object)easDim.description);
        this.getContext().getRunData().addDimMapping(easDim.id, easDim.number, dimension.getLong("id"), dimension.getString("number"));
        return dimension;
    }

    private boolean hasCustomPeriodTypeDim() {
        IEASUpgradeParam param = this.getParam();
        String syncPeriodType = param.getSyncTableName("T_MBG_BgPeriodType");
        String syncDimSet = param.getSyncTableName("T_MBG_BGDIMSETTINGS");
        String syncDimSetMember = param.getSyncTableName("T_MBG_BGDIMSETTINGSMEMBER");
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t.fid, t.fnumber, t.fname_l1, t.fname_l2, t.fname_l3, t.fiscalyear, t.fstartyear, t.fendyear, t.fstartmonth, t.fyear, t.fhalfyear, t.fquarter, t.fmonth, t.ftenday, t.fyearweek, t.fmothweek, t.fday, t.fselfdefined from " + syncPeriodType + " t join " + syncDimSetMember + " m on t.fid = m.fmemberid join " + syncDimSet + " dim on m.fbgdimsettingsid = dim.fid where dim.fbgschemeid = ?", new Object[]{this.getContext().getEASSchema().getSchemaId()});
        EASPeriod easPeriod = this.getContext().getRunData().getEASPeriod();
        try (DataSet ds = DB.queryDataSet((String)"queryEASDims", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    if (!this.canDealCustomPeriod(row)) continue;
                    EASPeriod.EASPeriodType periodType = new EASPeriod.EASPeriodType();
                    periodType.id = row.getString("fid");
                    periodType.number = row.getString("fnumber");
                    periodType.name = EASUpgradeUtils.getLocaleStr(row, "fname");
                    periodType.beginYear = row.getInteger("fstartyear");
                    periodType.endYear = row.getInteger("fendyear");
                    periodType.year = row.getBoolean("fyear");
                    periodType.halfyear = row.getBoolean("fhalfyear");
                    periodType.quarter = row.getBoolean("fquarter");
                    periodType.month = row.getBoolean("fmonth");
                    periodType.fiscalYear = row.getInteger("fiscalyear") == 1;
                    periodType.custom = row.getBoolean("fselfdefined");
                    easPeriod.getPeriodTypes().put(periodType.id, periodType);
                }
            }
        }
        HashSet<String> periodTypeIds = new HashSet<String>(easPeriod.getPeriodTypes().keySet());
        if (periodTypeIds.isEmpty()) {
            String msg = ResManager.loadKDString((String)"EAS\u65b9\u6848\u5173\u8054\u7684\u671f\u95f4\u5206\u7c7b\u4e0d\u53ef\u5347\u7ea7\uff08\u4e0d\u652f\u6301\u65ec\u3001\u5e74\u5468\u3001\u6708\u5468\u3001\u65e5\u671f\u95f4\uff09\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASDimsUpgrade_1", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResult().add(EASUpgradeResult.warring(this.getUpgradeInfo(), msg));
            return false;
        }
        boolean hasCustomPeriod = false;
        if (easPeriod.getPeriodTypes().isEmpty()) {
            String msg = ResManager.loadKDString((String)"EAS\u65b9\u6848\u5173\u8054\u7684\u671f\u95f4\u5206\u7c7b\u4e0d\u53ef\u5347\u7ea7\uff08\u4e0d\u652f\u6301\u65ec\u3001\u5e74\u5468\u3001\u6708\u5468\u3001\u65e5\u671f\u95f4\uff09\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASDimsUpgrade_1", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResult().add(EASUpgradeResult.warring(this.getUpgradeInfo(), msg));
        } else {
            EASPeriod.EASPeriodType MONT = easPeriod.getPeriodTypes().values().iterator().next();
            if (easPeriod.getPeriodTypes().size() == 1 && "MONT".equals(MONT.number)) {
                String msg = ResManager.loadKDString((String)"EAS\u65b9\u6848\u5173\u8054\u5347\u7ea7\u7684\u671f\u95f4\u5206\u7c7b\u53ea\u6709MONT\u671f\u95f4\u5206\u7c7b\uff0c\u56e0\u6b64\u4e0d\u521b\u5efa\u671f\u95f4\u5206\u7c7b\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u3002", (String)"EASDimsUpgrade_4", (String)"epm-eb-business", (Object[])new Object[0]);
                this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), msg));
            } else {
                hasCustomPeriod = true;
            }
        }
        return hasCustomPeriod;
    }

    private DynamicObject createCusPeriodDim(List<DynamicObject> dims) {
        DynamicObject cutPeriodDim = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
        this.setDimensionDefaultValue(cutPeriodDim, dims);
        cutPeriodDim.set("number", (Object)"EasPeriod");
        cutPeriodDim.set("shortnumber", (Object)"epd");
        cutPeriodDim.set("name", (Object)ResManager.loadKDString((String)"\u671f\u95f4\u5206\u7c7b", (String)"EASDimsUpgrade_2", (String)"epm-eb-business", (Object[])new Object[0]));
        return cutPeriodDim;
    }

    private void setDimensionDefaultValue(DynamicObject dimension, List<DynamicObject> dims) {
        dimension.set("id", (Object)DBServiceHelper.genGlobalLongId());
        dimension.set("creator", (Object)this.getContext().getRunData().getUserId());
        dimension.set("createtime", (Object)this.getContext().getRunData().getTime());
        dimension.set("modifier", (Object)this.getContext().getRunData().getUserId());
        dimension.set("modifytime", (Object)this.getContext().getRunData().getTime());
        dimension.set("model", (Object)this.getContext().getRunData().getModelCache().getModelobj().getId());
        int dimSize = this.getContext().getRunData().getModelCache().getDimensionList().size();
        dimension.set("dseq", (Object)(dimSize + dims.size() + 10));
        dimension.set("issysdimension", (Object)Character.valueOf('0'));
        dimension.set("status", (Object)Character.valueOf('C'));
        dimension.set("enable", (Object)Character.valueOf('1'));
        dimension.set("membermodel", (Object)"epm_userdefinedmembertree");
        dimension.set("membertable", (Object)"t_eb_structofdefined");
        dimension.set("fieldmapped", (Object)("dim" + (dims.size() + 1)));
    }

    private List<DynamicObject> createDefaultMembers(@NotNull DynamicObject dimension) {
        ArrayList<DynamicObject> defaultMembers = new ArrayList<DynamicObject>();
        DynamicObject root = this.createDefaultMember(dimension);
        root.set("name", (Object)dimension.getString("name"));
        root.set("number", (Object)dimension.getString("number"));
        root.set("longnumber", (Object)dimension.getString("number"));
        root.set("isleaf", (Object)Character.valueOf('0'));
        root.set("level", (Object)1);
        root.set("storagetype", (Object)StorageTypeEnum.DYNAMIC.getIndex());
        defaultMembers.add(root);
        DynamicObject none = this.createDefaultMember(dimension);
        none.set("name", (Object)ResManager.loadResFormat((String)"\u4e0d\u533a\u5206%1", (String)"AddDimemsionPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{dimension.getString("name")}));
        none.set("number", (Object)(dimension.get("shortnumber") + "None"));
        none.set("longnumber", (Object)(dimension.getString("number") + '!' + none.get("number")));
        none.set("level", (Object)2);
        none.set("parent", (Object)root.getLong("id"));
        defaultMembers.add(none);
        return defaultMembers;
    }
}

