/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.easupgrade.constant.EasUpgradeConstants;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.dao.NewMember;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.DataTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import org.jetbrains.annotations.NotNull;

public class EASElementUpgrade
extends AbstractEASUpgrade {
    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASElementUpgrade(param, context);
    }

    protected EASElementUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-element";
    }

    @Override
    protected void $upgrade() {
        String[] checkTables = new String[]{"T_MBG_BGELEMENT"};
        if (!this.existTables(this.getParam(), this.getResult(), "BG_Element", SysDimensionEnum.Metric.getNumber(), this.getUpgradeInfo(), checkTables)) {
            return;
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        EASDim elementDim = easSchema.getEASDim("BG_Element");
        Dimension dimension = this.getContext().getRunData().getModelCache().getDimension(SysDimensionEnum.Metric.getNumber());
        List<EASMember> easMembers = EASDimUpgradeUtils.getDimRefMember(this.getParam(), easSchema.getSchemaId(), "BG_Element");
        elementDim.members.addAll(easMembers);
        if (elementDim.members.isEmpty()) {
            String msg = ResManager.loadKDString((String)"EAS\u7248\u8981\u7d20\u7ef4\u5ea6\u6ca1\u6709\u5173\u8054\u7684\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASElementChecker_0", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg));
        } else {
            LinkedHashMap idsMap = Maps.newLinkedHashMap();
            String entityNumber = SysDimensionEnum.Metric.getMemberTreemodel();
            String syncElementTable = this.getParam().getSyncTableName("T_MBG_BGELEMENT");
            List elementIds = elementDim.members.stream().map(version -> version.memberId).collect(Collectors.toList());
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid, fnumber, fname_l1, fname_l2, fname_l3, fparentid, fdescription_l1, fdescription_l2, fdescription_l3, fsimplename, 1 as fpolalgorithm, fdatatype from " + syncElementTable + " where ", new Object[0]).appendIn("fid", elementIds);
            String element01Id = "";
            try (DataSet ds = DB.queryDataSet((String)"queryEASVer", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        String fnumber = row.getString("fnumber");
                        if ("01".equals(fnumber)) {
                            element01Id = row.getString("fid");
                            continue;
                        }
                        this.transMember(entityNumber, row, dimension, idsMap);
                    }
                }
            }
            this.dealMembers(elementDim, dimension, idsMap);
            if (this.isSuccess()) {
                this.saveMembers(idsMap.values().toArray(new DynamicObject[0]));
                this.addDefaultMap(element01Id);
                this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), ResManager.loadKDString((String)"\u5ea6\u91cf\uff08\u8981\u7d20\uff09\u6210\u5458\u5347\u7ea7\u5b8c\u6210\u3002", (String)"EASElementUpgrade_0", (String)"epm-eb-business", (Object[])new Object[0]), null, elementDim.getNumber(), dimension.getId(), dimension.getNumber()));
            } else {
                this.getStats().addInfo("members upgrade exist error.");
            }
        }
    }

    private void addDefaultMap(String element01Id) {
        HashMap<String, NewMember> memberNumMap = new HashMap<String, NewMember>(16);
        HashMap<String, NewMember> memberIdMap = new HashMap<String, NewMember>(16);
        IModelCacheHelper modelCache = this.getContext().getRunData().getModelCache();
        String number = EasUpgradeConstants.DEFAULT_ELEMENT_NUMBER_MAP.get("01");
        Member member = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, number);
        if (member == null) {
            throw new KDBizException(number + " is not exist");
        }
        NewMember newMember = new NewMember(member.getId(), member.getNumber(), member.getName(), element01Id, "01");
        memberIdMap.put(element01Id, newMember);
        memberNumMap.put("01", newMember);
        this.getContext().getRunData().addMemberMapping(SysDimensionEnum.Metric.getNumber(), memberIdMap, memberNumMap);
    }

    @Override
    protected DynamicObject transMember(@NotNull String entityNumber, @NotNull Row row, @NotNull Dimension dimension, @NotNull Map<String, DynamicObject> idsMap) {
        DynamicObject metric = super.transMember(entityNumber, row, dimension, idsMap);
        metric.set("aggoprt", (Object)AggOprtEnum.SKIP.getSign());
        metric.set("use", (Object)"1");
        switch (row.getInteger("fdatatype")) {
            case 0: {
                metric.set("datatype", (Object)DataTypeEnum.CURRENCY.getOIndex());
                metric.set("isagg", (Object)Character.valueOf('1'));
                break;
            }
            case 1: {
                metric.set("datatype", (Object)DataTypeEnum.CURRENCY.getOIndex());
                metric.set("isagg", (Object)Character.valueOf('0'));
                break;
            }
            case 3: {
                metric.set("datatype", (Object)DataTypeEnum.PROPORTION.getOIndex());
                metric.set("isagg", (Object)Character.valueOf('0'));
                break;
            }
            case 4: {
                metric.set("datatype", (Object)DataTypeEnum.DATETP.getOIndex());
                metric.set("isagg", (Object)Character.valueOf('0'));
                break;
            }
            case 5: {
                metric.set("datatype", (Object)DataTypeEnum.TXT.getOIndex());
                metric.set("isagg", (Object)Character.valueOf('0'));
                break;
            }
            default: {
                metric.set("datatype", (Object)DataTypeEnum.UNCURRENCY.getOIndex());
                metric.set("isagg", (Object)Character.valueOf('1'));
            }
        }
        return metric;
    }

    @Override
    protected boolean hasParent() {
        return false;
    }
}

