/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunData;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.dao.NewMember;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EASEntityUpgrade
extends AbstractEASUpgrade {
    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASEntityUpgrade(param, context);
    }

    protected EASEntityUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-entity";
    }

    @Override
    protected void $upgrade() {
        block36: {
            String[] checkTables = new String[]{"T_MBG_BGORGUNIT", "T_MBG_BGORGVIEW"};
            if (!this.existTables(this.getParam(), this.getResult(), "BG_Organization", SysDimensionEnum.Entity.getNumber(), this.getUpgradeInfo(), checkTables)) {
                return;
            }
            IEASSchema easSchema = this.getContext().getEASSchema();
            EASDim orgDim = easSchema.getEASDim("BG_Organization");
            Dimension dimension = this.getContext().getRunData().getModelCache().getDimension(SysDimensionEnum.Entity.getNumber());
            Member rootMember = dimension.getStructOfMember(dimension.getNumber());
            EASMember editView = null;
            List<EASMember> easMembers = EASDimUpgradeUtils.getDimRefMember(this.getParam(), easSchema.getSchemaId(), "BG_Organization", new Object[]{2});
            for (EASMember easMember : easMembers) {
                orgDim.members.add(easMember);
                if (2 != easMember.type) continue;
                editView = easMember;
            }
            if (editView == null && !easMembers.isEmpty()) {
                editView = easMembers.get(0);
            }
            if (editView == null) {
                String msg = ResManager.loadKDString((String)"EAS\u7ec4\u7ec7\u7ef4\u5ea6\u6ca1\u6709\u5173\u8054\u7684\u7f16\u5236\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASEntityChecker_0", (String)"epm-eb-business", (Object[])new Object[0]);
                this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg));
            } else {
                LinkedHashMap idsMap = Maps.newLinkedHashMap();
                String entityNumber = SysDimensionEnum.Entity.getMemberTreemodel();
                String orgTable = this.getParam().getSyncTableName("T_MBG_BGORGUNIT");
                SqlBuilder sql = new SqlBuilder();
                sql.append("select fid, fnumber, flongnumber, fpolalgorithm, fname_l1, fname_l2, fname_l3, fisousealup, fparentid, fdescription_l1, fdescription_l2, fdescription_l3, fsimplename, forgunitid from ", new Object[0]).append(orgTable, new Object[0]).append(" where fviewid = ?", new Object[]{editView.memberId}).append(" and fisvirtual = 0", new Object[0]);
                try (DataSet ds = DB.queryDataSet((String)"queryEASOrg", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                    if (ds != null) {
                        for (Row row : ds) {
                            this.transMember(entityNumber, row, dimension, idsMap);
                        }
                    }
                }
                this.dealMembers(orgDim, dimension, idsMap);
                if (this.isSuccess()) {
                    var13_13 = null;
                    try (TXHandle tx = TX.required();){
                        try {
                            this.saveMembers(idsMap.values().toArray(new DynamicObject[0]));
                            if (!idsMap.isEmpty()) {
                                DB.execute((DBRoute)BgBaseConstant.epm, (String)"update t_eb_structofent set fisleaf = 0 where fid = ?", (Object[])new Object[]{rootMember.getId()});
                            }
                            this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458\u5347\u7ea7\u5b8c\u6210\u3002", (String)"EASEntityUpgrade_0", (String)"epm-eb-business", (Object[])new Object[0]), null, orgDim.getNumber(), dimension.getId(), dimension.getNumber()));
                            break block36;
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            throw new KDBizException(e.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        var13_13 = throwable;
                        throw throwable;
                    }
                }
                this.getStats().addInfo("members upgrade exist error.");
            }
        }
    }

    @Override
    protected DynamicObject transMember(@NotNull String entityNumber, @NotNull Row row, @NotNull Dimension dimension, @NotNull Map<String, DynamicObject> idsMap) {
        DynamicObject orgUnit = super.transMember(entityNumber, row, dimension, idsMap);
        orgUnit.set("disable", (Object)Character.valueOf(row.getInteger("fisousealup") == 1 ? (char)'1' : '0'));
        orgUnit.set("currency", (Object)this.getContext().getRunData().getDefaultCurrency());
        orgUnit.set("mergernode", (Object)Character.valueOf('0'));
        orgUnit.set("isinnerorg", (Object)Character.valueOf('0'));
        orgUnit.set("isouterorg", (Object)Character.valueOf('0'));
        orgUnit.set("isexchangerate", (Object)Character.valueOf('0'));
        orgUnit.set("executor", (Object)0L);
        orgUnit.set("owner", (Object)0L);
        IRunData runData = this.getContext().getRunData();
        runData.getBgOrgUnits().put(row.getString("fid"), row.getString("forgunitid"));
        runData.getBaseOrgUnits().put(row.getString("forgunitid"), row.getString("fid"));
        return orgUnit;
    }

    @Override
    protected NewMember buildNewMember(Long newId, String newNumber, String newName, String oldId, String oldNumber) {
        String costCenterId = this.getContext().getRunData().getBgOrgUnits().get(oldId);
        NewMember member = StringUtils.isNotEmpty((String)costCenterId) ? super.buildNewMember(newId, newNumber, newName, costCenterId, oldNumber) : super.buildNewMember(newId, newNumber, newName, oldId, oldNumber);
        return member;
    }
}

