/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunData;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.dao.EASPeriod;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.business.model.entity.AbstractDimensionMemTree;
import kd.epm.eb.business.model.entity.BudgetPeriodMemTree;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EASPeriodUpgrade
extends AbstractEASUpgrade {
    private static final String[] checkTables = new String[]{"T_MBG_BgPeriod", "T_MBG_BgPeriodType", "T_MBG_BgPeriodDisp"};
    private final Map<String, String> advanceNumberMap = Maps.newLinkedHashMap();

    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASPeriodUpgrade(param, context);
    }

    protected EASPeriodUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-period";
    }

    @Override
    protected void $upgrade() {
        if (!this.existTables(this.getParam(), this.getResult(), "BG_Period", SysDimensionEnum.BudgetPeriod.getNumber(), this.getUpgradeInfo(), checkTables)) {
            return;
        }
        Dimension dimension = this.getContext().getRunData().getModelCache().getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
        IEASSchema easSchema = this.getContext().getEASSchema();
        EASDim periodDim = easSchema.getEASDim("BG_Period");
        List<EASMember> easMembers = EASDimUpgradeUtils.getDimRefMember(this.getParam(), easSchema.getSchemaId(), "BG_Period");
        periodDim.members.addAll(easMembers);
        if (periodDim.members.isEmpty()) {
            String msg = ResManager.loadKDString((String)"EAS\u671f\u95f4\u7ef4\u5ea6\u6ca1\u6709\u5173\u8054\u7684\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASPeriodChecker_0", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg));
            return;
        }
        this.dealStandardPeriod(dimension);
        this.dealCustomPeriod();
    }

    private void dealStandardPeriod(Dimension dimension) {
        CalendarHelper calendarHelper = new CalendarHelper();
        int beginYear = calendarHelper.getCurrentlyYear(this.getContext().getEASSchema().getDateFrom());
        int endYear = calendarHelper.getCurrentlyYear(this.getContext().getEASSchema().getDateTo());
        DynamicObject modelObj = this.getContext().getRunData().getModel();
        DynamicObject dimObj = this.getContext().getRunData().getDimension(dimension.getId());
        Member root = dimension.getMember(null, SysDimensionEnum.BudgetPeriod.getNumber());
        BudgetPeriodMemTree budgetPeriodMemTree = new BudgetPeriodMemTree(modelObj, dimObj);
        budgetPeriodMemTree.setNumber(root.getNumber());
        budgetPeriodMemTree.setLongnumber(root.getLongNumber());
        budgetPeriodMemTree.initYearTree(beginYear, endYear, 1);
        List allPeriods = dimension.getAllMembers(2);
        Set allPeriodNumbers = allPeriods.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        List<AbstractDimensionMemTree> yearTree = budgetPeriodMemTree.getChildren();
        yearTree.removeIf(year -> allPeriodNumbers.contains(year.getNumber()));
        budgetPeriodMemTree.initPeriodTree(1, true, true, true);
        LinkedList members = Lists.newLinkedList();
        for (AbstractDimensionMemTree treeNode : budgetPeriodMemTree.getChildren()) {
            treeNode.setParent(root.getId());
            this.init(treeNode, members);
        }
        this.saveMembers(members.toArray(new DynamicObject[0]));
        this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), ResManager.loadKDString((String)"\u671f\u95f4\u6210\u5458\u5347\u7ea7\u5b8c\u6210\u3002", (String)"EASPeriodUpgrade_0", (String)"epm-eb-business", (Object[])new Object[0]), null, "BG_Period", dimension.getId(), dimension.getNumber()));
    }

    private void init(AbstractDimensionMemTree treeNode, List<DynamicObject> members) {
        members.add(treeNode.initToDyna());
        for (AbstractDimensionMemTree child : treeNode.getChildren()) {
            this.init(child, members);
        }
    }

    private void dealCustomPeriod() {
        IRunData runData = this.getContext().getRunData();
        if (!runData.hasCustomPeriodDim()) {
            return;
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        EASDim periodDim = easSchema.getEASDim("BG_Period");
        EASPeriod easPeriod = runData.getEASPeriod();
        Dimension dimension = runData.getModelCache().getDimension("EasPeriod");
        HashMap periodTypeNumMap = Maps.newHashMapWithExpectedSize((int)easPeriod.getPeriodTypes().size());
        Set<String> periodTypeIds = easPeriod.getPeriodTypes().keySet();
        if (!periodTypeIds.isEmpty()) {
            String syncPeriodType = this.getParam().getSyncTableName("T_MBG_BgPeriodType");
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid, fnumber from " + syncPeriodType + " where ", new Object[0]).appendIn("fid", periodTypeIds.toArray(new Object[0]));
            try (DataSet ds = DB.queryDataSet((String)"queryEASPeriod", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        periodTypeNumMap.put(row.getString("fid"), row.getString("fnumber"));
                    }
                }
            }
        }
        LinkedHashMap membersMap = Maps.newLinkedHashMap();
        for (EASPeriod.EASPeriodType periodType : easPeriod.getPeriodTypes().values()) {
            periodType.number = (String)periodTypeNumMap.get(periodType.id);
            membersMap.putAll(this.dealCustomPeriod(dimension, periodType));
        }
        this.dealMembers(periodDim, dimension, membersMap);
        if (this.isSuccess()) {
            this.saveMembers(membersMap.values().toArray(new DynamicObject[0]));
            this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), ResManager.loadKDString((String)"\u671f\u95f4\u5206\u7c7b\u6210\u5458\u5347\u7ea7\u5b8c\u6210\u3002", (String)"EASPeriodUpgrade_2", (String)"epm-eb-business", (Object[])new Object[0]), null, "EasPeriod", dimension.getId(), dimension.getNumber()));
        } else {
            this.getStats().addInfo("members upgrade exist error.");
        }
    }

    private Map<String, DynamicObject> dealCustomPeriod(Dimension dimension, EASPeriod.EASPeriodType periodType) {
        if (dimension == null || periodType == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap idsMap = Maps.newLinkedHashMap();
        String syncPeriodDisp = this.getParam().getSyncTableName("T_MBG_BgPeriodDisp");
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fnumber, fparentid, fname_l1, fname_l2, fname_l3, fsimplename, fdescription_l1, fdescription_l2, fdescription_l3, 1 as fpolalgorithm from " + syncPeriodDisp + " where ftypeid = ?", new Object[]{periodType.id});
        if (periodType.fiscalYear) {
            sql.append(" and fbegindate >= ? and fenddate <= ?", new Object[]{this.getContext().getEASSchema().getDateFrom(), this.getContext().getEASSchema().getDateTo()});
        } else {
            CalendarHelper calendarHelper = new CalendarHelper();
            int beginYear = calendarHelper.getCurrentlyYear(this.getContext().getEASSchema().getDateFrom());
            int endYear = calendarHelper.getCurrentlyYear(this.getContext().getEASSchema().getDateTo());
            SqlBuilder year = new SqlBuilder();
            year.append("select fnumber, flongnumber from " + syncPeriodDisp + " where ftypeid = ? and fperiodtype = 1", new Object[]{periodType.id});
            LinkedList<String> years = new LinkedList<String>();
            DataSet ds = DB.queryDataSet((String)"queryYear", (DBRoute)BgBaseConstant.epm, (SqlBuilder)year);
            Object object = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        String[] numbers = row.getString("fnumber").split("\\.");
                        if (numbers.length <= 1) continue;
                        String number = numbers[1];
                        try {
                            int currYear = Integer.parseInt(number.replaceAll("Y", ""));
                            if (currYear < beginYear || currYear > endYear) continue;
                            years.add(row.getString("flongnumber"));
                        }
                        catch (Exception ex) {
                            log.error("eas-period-trans-error:" + row.getString("fnumber"));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            if (!years.isEmpty()) {
                sql.append(" and (", new Object[0]);
                boolean isFirst = true;
                for (String _year : years) {
                    if (isFirst) {
                        sql.append("(flongnumber = ? or flongnumber like ?)", new Object[]{_year, _year + '!' + '%'});
                        isFirst = false;
                        continue;
                    }
                    sql.append(" or (flongnumber = ? or flongnumber like ?)", new Object[]{_year, _year + '!' + '%'});
                }
                sql.append(")", new Object[0]);
            }
        }
        DynamicObject easPeriodDim = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
        easPeriodDim.set("id", (Object)dimension.getId());
        easPeriodDim.set("model", (Object)dimension.getModel().getId());
        easPeriodDim.set("membermodel", (Object)dimension.getMemberModel());
        DynamicObject ptMember = this.createDefaultMember(easPeriodDim);
        ptMember.set("id", (Object)DBServiceHelper.genGlobalLongId());
        ptMember.set("number", (Object)periodType.number);
        ptMember.set("name", (Object)periodType.name);
        ptMember.set("aggoprt", (Object)AggOprtEnum.SKIP.getSign());
        idsMap.put(ptMember.getString("id"), ptMember);
        try (DataSet ds = DB.queryDataSet((String)"queryEASPeriod", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    this.transMember("epm_userdefinedmembertree", row, dimension, periodType, ptMember, idsMap);
                }
            }
        }
        return idsMap;
    }

    protected DynamicObject transMember(@NotNull String entityNumber, @NotNull Row row, @NotNull Dimension dimension, @NotNull EASPeriod.EASPeriodType periodType, @NotNull DynamicObject ptMember, @NotNull Map<String, DynamicObject> idsMap) {
        String _parentId;
        DynamicObject member = this.transMember(entityNumber, row, dimension, idsMap);
        member.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
        member.set("storagetype", (Object)StorageTypeEnum.STORAGE.getIndex());
        String memberNumber = member.getString("number");
        if (!memberNumber.startsWith(periodType.number)) {
            String advNumber = periodType.number + '.' + memberNumber;
            member.set("number", (Object)advNumber);
            this.getAdvanceNumberMap().put(advNumber, memberNumber);
            String msg = ResManager.loadResFormat((String)"\u671f\u95f4\u5206\u7c7b\u4e0b\u671f\u95f4\u7f16\u7801\u6210\u5458\u6ca1\u6709\u524d\u7f00\uff08%1 - %2\uff09", (String)"EASPeriodUpgrade_1", (String)"epm-eb-business", (Object[])new Object[]{memberNumber, advNumber});
            IEASUpgradeResult result = EASUpgradeResult.warring(this.getUpgradeInfo(), msg, null, "EasPeriod", dimension.getId(), dimension.getNumber());
            result.setMemberNumber(advNumber);
            this.getResult().add(result);
        }
        if (StringUtils.isEmpty((String)(_parentId = row.getString(this.getDefaultParentIdField())))) {
            String _id = row.getString(this.getDefaultIdField());
            this.getMemberParentMap().put(_id, ptMember.getString("id"));
        }
        return member;
    }

    protected Map<String, String> getAdvanceNumberMap() {
        return this.advanceNumberMap;
    }

    @Override
    protected String getOldNumber(@NotNull DynamicObject member) {
        String _oldNumber = this.getAdvanceNumberMap().get(member.getString("number"));
        if (_oldNumber != null) {
            return _oldNumber;
        }
        return super.getOldNumber(member);
    }
}

