/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.business.easupgrade.constant.EasUpgradeConstants;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunData;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASBase;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASProperty;
import kd.epm.eb.business.easupgrade.impl.dao.EASPropertyValue;
import kd.epm.eb.business.easupgrade.impl.dao.NewMember;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeCheckUtils;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EASPropertyUpgrade
extends AbstractEASUpgrade {
    private static final String[] checkTables = new String[]{"T_MBG_BGPROPERTYSORT", "T_MBG_BGPROPERTY", "T_MBG_PROPERTYREFSOURCE"};

    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASPropertyUpgrade(param, context);
    }

    protected EASPropertyUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-property";
    }

    @Override
    protected void $upgrade() {
        if (!this.existTables(this.getParam(), this.getResult(), null, null, this.getUpgradeInfo(), checkTables)) {
            return;
        }
        IModelCacheHelper modelCacheHelper = this.getContext().getRunData().getModelCacheByReBuilder();
        List dimensions = modelCacheHelper.getDimensionList();
        for (Dimension dimension : dimensions) {
            EASDim easDim;
            String oldDimNumber = EasUpgradeConstants.EB_DIMNUMBERMAP.get(dimension.getNumber());
            if (oldDimNumber == null) {
                oldDimNumber = this.getContext().getRunData().getOldDimNumber(dimension.getNumber());
            }
            if ((easDim = this.getContext().getEASSchema().getEASDim(oldDimNumber)) == null || !SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) && !"epm_userdefinedmembertree".equals(dimension.getMemberModel())) continue;
            List<EASProperty> properties = EASUpgradeCheckUtils.queryProperty(this.getParam(), easDim);
            try {
                this.dealDimProperty(easDim, properties, dimension);
            }
            catch (Exception ex) {
                log.error("eas-upgrade-error:", (Throwable)ex);
                String msg = ResManager.loadResFormat((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027\u53ca\u5c5e\u6027\u503c\u540c\u6b65\u5931\u8d25(%1)\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASPropertyUpgrade_0", (String)"epm-eb-business", (Object[])new Object[]{ex.getMessage()});
                this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg, easDim.getId(), easDim.getNumber(), dimension.getId(), dimension.getNumber()));
                this.getResult().add(EASUpgradeResult.error("upgrade", ex, easDim.getId(), easDim.getNumber(), dimension.getId(), dimension.getNumber()));
            }
        }
    }

    protected void dealDimProperty(EASDim easDim, List<EASProperty> properties, Dimension dimension) {
        String msg;
        DynamicObject _property;
        if (easDim == null || properties == null || properties.isEmpty() || dimension == null) {
            return;
        }
        IRunData runData = this.getContext().getRunData();
        Map<String, NewMember> memberMap = runData.getIdMappingMap().get(dimension.getNumber());
        if (memberMap == null) {
            return;
        }
        HashMap propertiesMap = Maps.newHashMapWithExpectedSize((int)32);
        LinkedList propertyValues = Lists.newLinkedList();
        LinkedList refParams = Lists.newLinkedList();
        int seqIndex = 1;
        for (EASProperty property : properties) {
            _property = BusinessDataServiceHelper.newDynamicObject((String)"eb_customproperty");
            _property.set("id", (Object)DBServiceHelper.genGlobalLongId());
            _property.set("number", (Object)EASUpgradeUtils.getNumber1("EAS", property.getNumber()));
            _property.set("name", (Object)property.getName());
            _property.set("dseq", (Object)seqIndex++);
            _property.set("source", (Object)Character.valueOf('1'));
            _property.set("model", (Object)dimension.getModel().getId());
            _property.set("dimension", (Object)dimension.getId());
            propertiesMap.put(property.getId(), _property);
        }
        LinkedHashMap propertyValueIds = Maps.newLinkedHashMap();
        Map<String, List<EASPropertyValue>> propertyValueMap = EASUpgradeCheckUtils.queryPropertyValue(this.getParam(), properties);
        for (Map.Entry<String, List<EASPropertyValue>> entry : propertyValueMap.entrySet()) {
            _property = (DynamicObject)propertiesMap.get(entry.getKey());
            if (_property != null) {
                seqIndex = 1;
                for (EASPropertyValue _propertyValue : entry.getValue()) {
                    DynamicObject propertyValue = BusinessDataServiceHelper.newDynamicObject((String)"eb_custompropertyvalue");
                    propertyValue.set("id", (Object)DBServiceHelper.genGlobalLongId());
                    propertyValue.set("number", (Object)EASUpgradeUtils.getNumber1("EAS", _propertyValue.getNumber()));
                    propertyValue.set("name", (Object)_propertyValue.getName());
                    propertyValue.set("dseq", (Object)seqIndex++);
                    propertyValue.set("property", (Object)_property.getLong("id"));
                    propertyValues.add(propertyValue);
                    propertyValueIds.put(_propertyValue.getId(), propertyValue.getLong("id"));
                }
                continue;
            }
            Set propertyValNums = entry.getValue().stream().map(EASBase::getNumber).collect(Collectors.toSet());
            msg = ResManager.loadResFormat((String)"%1 \u7ef4\u5ea6\u4e0b\u5b58\u5728\u65e0\u6548\u5173\u8054\u7684\u5c5e\u6027\u503c (%2)\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASPropertyUpgrade_1", (String)"epm-eb-business", (Object[])new Object[]{StringUtils.join(propertyValNums, (char)',')});
            this.getResult().add(EASUpgradeResult.warring(this.getUpgradeInfo(), msg, easDim.getId(), easDim.getNumber(), dimension.getId(), dimension.getNumber()));
        }
        Map<String, Set<String>> propertyRefMap = EASUpgradeCheckUtils.queryPropertyRef(this.getParam(), propertyValueIds.keySet());
        if (!propertyRefMap.isEmpty()) {
            for (Map.Entry<String, Set<String>> entry : propertyRefMap.entrySet()) {
                String oldPropValueId = entry.getKey();
                for (String oldMemberId : entry.getValue()) {
                    Long propValueId = (Long)propertyValueIds.get(oldPropValueId);
                    NewMember member = memberMap.get(oldMemberId);
                    if (member == null) continue;
                    Object[] sqlParams = new Object[]{member.getId(), null, 1, propValueId};
                    refParams.add(sqlParams);
                }
            }
            if (!refParams.isEmpty()) {
                int index = 0;
                long[] ids = DBServiceHelper.genLongIds((String)"t_eb_memberpropertyvalue", (int)refParams.size());
                for (Object[] _sqlParam : refParams) {
                    _sqlParam[1] = ids[index++];
                }
            }
        }
        TXHandle tx = TX.required();
        Object object = null;
        try {
            try {
                DynamicObjectUtils.save((DynamicObject[])propertiesMap.values().toArray(new DynamicObject[0]));
                DynamicObjectUtils.save((DynamicObject[])propertyValues.toArray(new DynamicObject[0]));
                if (!refParams.isEmpty()) {
                    String sql = "insert into t_eb_memberpropertyvalue (fid, fentryid, fseq, fpropertyvalueid) values (?,?,?,?)";
                    DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, (List)refParams);
                }
                msg = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027\u5347\u7ea7\u6210\u529f\u3002", (String)"EASPropertyUpgrade_2", (String)"epm-eb-business", (Object[])new Object[0]);
                this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), msg, easDim.getId(), easDim.getNumber(), dimension.getId(), dimension.getNumber()));
            }
            catch (Throwable ex) {
                this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), ex, easDim.getId(), easDim.getNumber(), dimension.getId(), dimension.getNumber()));
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

