/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.easupgrade.constant.EasUpgradeConstants;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.dao.NewMember;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import org.jetbrains.annotations.NotNull;

public class EASScenarioUpgrade
extends AbstractEASUpgrade {
    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASScenarioUpgrade(param, context);
    }

    protected EASScenarioUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-scenario";
    }

    @Override
    protected void $upgrade() {
        String[] checkTables = new String[]{"T_MBG_BGSCENARIO"};
        if (!this.existTables(this.getParam(), this.getResult(), "BG_Scenario", SysDimensionEnum.DataType.getNumber(), this.getUpgradeInfo(), checkTables)) {
            return;
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        EASDim scenarioDim = easSchema.getEASDim("BG_Scenario");
        Dimension dimension = this.getContext().getRunData().getModelCache().getDimension(SysDimensionEnum.DataType.getNumber());
        List<EASMember> easMembers = EASDimUpgradeUtils.getDimRefMember(this.getParam(), easSchema.getSchemaId(), "BG_Scenario");
        scenarioDim.members.addAll(easMembers);
        if (scenarioDim.members.isEmpty()) {
            String msg = ResManager.loadKDString((String)"EAS\u60c5\u666f\u7ef4\u5ea6\u6ca1\u6709\u5173\u8054\u7684\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASScenarioChecker_0", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg, null, "BG_Scenario", dimension.getId(), SysDimensionEnum.DataType.getNumber()));
        } else {
            LinkedHashMap idsMap = Maps.newLinkedHashMap();
            String entityNumber = SysDimensionEnum.DataType.getMemberTreemodel();
            String syncScenarioTable = this.getParam().getSyncTableName("T_MBG_BGSCENARIO");
            List scenarioIds = scenarioDim.members.stream().map(scen -> scen.memberId).collect(Collectors.toList());
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid, fnumber, fname_l1, fname_l2, fname_l3, fparentid, fdescription_l1, fdescription_l2, fdescription_l3, fsimplename, 1 as fpolalgorithm, ftype, fscenarioid from " + syncScenarioTable + " where ", new Object[0]).appendIn("fid", scenarioIds).append(" and fnumber not in ('BgData','ActData')", new Object[0]);
            try (DataSet ds = DB.queryDataSet((String)"queryEASScen", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        this.transMember(entityNumber, row, dimension, idsMap);
                    }
                }
            }
            this.dealMembers(scenarioDim, dimension, idsMap);
            if (this.isSuccess()) {
                this.saveMembers(idsMap.values().toArray(new DynamicObject[0]));
                this.addDefaultMap();
                this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), ResManager.loadKDString((String)"\u60c5\u666f\uff08\u6570\u636e\u7c7b\u578b\uff09\u6210\u5458\u5347\u7ea7\u5b8c\u6210\u3002", (String)"EASScenarioUpgrade_0", (String)"epm-eb-business", (Object[])new Object[0]), null, scenarioDim.getNumber(), dimension.getId(), dimension.getNumber()));
            } else {
                this.getStats().addInfo("members upgrade exist error.");
            }
        }
    }

    private void addDefaultMap() {
        Map<String, NewMember> memberNumMap = this.getMemberNumMap();
        Map<String, NewMember> memberIdMap = this.getMemberIdMap();
        IModelCacheHelper modelCache = this.getContext().getRunData().getModelCache();
        for (Map.Entry<String, String> entry : EasUpgradeConstants.DEFAULT_SCENARIO_ID_EBNUMBER_MAP.entrySet()) {
            Member member = modelCache.getMember(EasUpgradeConstants.DIMNUMBERMAP.get("BG_Scenario").getNumber(), null, entry.getValue());
            if (member == null) {
                throw new KDBizException(entry.getValue() + "is not exist");
            }
            String oldNumber = EasUpgradeConstants.DEFAULT_SCENARIO_ID_NUMBER_MAP.get(entry.getKey());
            NewMember newMember = new NewMember(member.getId(), member.getNumber(), member.getName(), entry.getKey(), oldNumber);
            memberIdMap.put(entry.getKey(), newMember);
            memberNumMap.put(oldNumber, newMember);
        }
        this.getContext().getRunData().addMemberMapping(SysDimensionEnum.DataType.getNumber(), this.getMemberIdMap(), this.getMemberNumMap());
    }

    @Override
    protected DynamicObject transMember(@NotNull String entityNumber, @NotNull Row row, @NotNull Dimension dimension, @NotNull Map<String, DynamicObject> idsMap) {
        DynamicObject scenario = super.transMember(entityNumber, row, dimension, idsMap);
        scenario.set("aggoprt", (Object)AggOprtEnum.SKIP.getSign());
        return scenario;
    }

    @Override
    protected String getDefaultIdField() {
        return "fscenarioid";
    }

    @Override
    protected boolean hasParent() {
        return false;
    }
}

