/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import java.text.DecimalFormat;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.business.model.preDimensionHelper.PreDimensionUtil;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.model.interfaces.IDimensionComponent;
import kd.epm.eb.model.serviceHelper.InitModelServiceHelper;
import kd.epm.epbs.business.bd.model.ModelSyncHelper;
import org.jetbrains.annotations.NotNull;

public class EASSchemaUpgrade
extends AbstractEASUpgrade {
    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASSchemaUpgrade(param, context);
    }

    protected EASSchemaUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-schema";
    }

    @Override
    protected void $upgrade() {
        String[] checkTables = new String[]{"T_MBG_BGSCHEME"};
        if (!this.existTables(this.getParam(), this.getResult(), null, null, this.getUpgradeInfo(), checkTables)) {
            return;
        }
        IEASSchema easSchema = null;
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fnumber, fname_l1, fname_l2, fname_l3, fdescription_l1, fdescription_l2, fdescription_l3, fcreatetime, flastupdatetime, fdatefrom, fdateto, frefcube from ", new Object[0]).append(this.getParam().getSyncTableName("T_MBG_BGSCHEME"), new Object[0]).append(" where fid = ?", new Object[]{this.getParam().getEASSchema().getSchemaId()});
        try (DataSet ds = DB.queryDataSet((String)"queryEASSchema", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                easSchema = this.getContext().getEASSchema();
                easSchema.setSchemaId(row.getString("fid"));
                easSchema.setNumber(EASUpgradeUtils.getNumber("EAS", row.getString("fnumber")));
                easSchema.setRefCube(row.getString("frefcube"));
                easSchema.setCreateTime(row.getDate("fcreatetime"));
                easSchema.setLastUpdateTime(row.getDate("flastupdatetime"));
                easSchema.setName(EASUpgradeUtils.getLocaleStr(row, "fname"));
                easSchema.setDescription(EASUpgradeUtils.getLocaleStr(row, "fdescription"));
                easSchema.setDateFrom(row.getDate("fdatefrom"));
                CalendarHelper calendarHelper = new CalendarHelper();
                calendarHelper.setTime(row.getDate("fdateto"));
                calendarHelper.processSetMaxTime();
                easSchema.setDateTo(calendarHelper.getTime());
            }
        }
        if (easSchema == null) {
            String msg = ResManager.loadKDString((String)"EAS\u9884\u7b97\u65b9\u6848(%1)\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASSchemaUpgrade_0", (String)"epm-eb-business", (Object[])new Object[]{this.getParam().getEASSchema().getName()});
            this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg));
        } else {
            this.verifyModelNumber(easSchema);
            DynamicObject model = this.buildModel(easSchema);
            InitModelServiceHelper.preSetModelPerm(model);
            this.getContext().getRunData().setModelId(model.getLong("id"));
            PreDimensionUtil pre = new PreDimensionUtil(model, ApplicationTypeEnum.BGMD);
            List<IDimensionComponent> dimTrees = pre.resolveDimemTrees();
            pre.afterModelSaveBGMD(dimTrees, false);
            String msg = ResManager.loadResFormat((String)"\u4f53\u7cfb(%1 - %2)\u5347\u7ea7\u5b8c\u6210\u3002", (String)"EASSchemaUpgrade_1", (String)"epm-eb-business", (Object[])new Object[]{model.getString("number"), model.getString("name")});
            this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), msg));
        }
    }

    private DynamicObject buildModel(IEASSchema easSchema) {
        DynamicObject model = BusinessDataServiceHelper.newDynamicObject((String)"epm_model");
        Long modelId = DBServiceHelper.genGlobalLongId();
        model.set("id", (Object)modelId);
        model.set("masterid", (Object)modelId);
        model.set("shownumber", (Object)easSchema.getNumber());
        model.set("number", (Object)easSchema.getNumber());
        model.set("name", (Object)easSchema.getName());
        model.set("description", (Object)ResManager.loadResFormat((String)"EAS\u9884\u7b97\u6a21\u578b(%1)\u5347\u7ea7\u4f53\u7cfb\u3002 %2", (String)"EASSchemaUpgrade_2", (String)"epm-eb-business", (Object[])new Object[]{model.getString("name"), easSchema.getDescription()}));
        model.set("createtime", (Object)easSchema.getCreateTime());
        model.set("modifytime", (Object)easSchema.getLastUpdateTime());
        model.set("datasource", (Object)this.getParam().getEpmDataSourceId());
        model.set("reporttype", (Object)(this.getParam().getApplication() == ApplicationTypeEnum.BG ? ApplicationTypeEnum.BG.getIndex() : ApplicationTypeEnum.BGMD.getIndex()));
        model.set("creator", (Object)this.getContext().getRunData().getUserId());
        model.set("modifier", (Object)this.getContext().getRunData().getUserId());
        model.set("enable", (Object)1);
        CalendarHelper helper = new CalendarHelper();
        int beginYear = helper.getCurrentlyYear(easSchema.getDateFrom());
        int endYear = easSchema.getDateTo() != null ? helper.getCurrentlyYear(easSchema.getDateTo()) - beginYear + 1 : 5;
        model.set("startfy", (Object)(beginYear -= 1996));
        model.set("presetyear", (Object)endYear);
        model.set("sysperiod", (Object)2);
        model.set("isdetailtomonth", (Object)1);
        model.set("modeltype", (Object)1);
        model.set("status", (Object)Character.valueOf('C'));
        model.set("beginyearofmonth", (Object)"1");
        model.set("beginperiod", (Object)"1");
        String beginPeriodText = "1".equals(model.getString("beginyearofmonth")) ? ResManager.loadResFormat((String)"\u5f53\u5e74%1\u6708", (String)"BgmdModelSaveOp_1", (String)"epm-eb-business", (Object[])new Object[]{model.getString("beginperiod")}) : ResManager.loadResFormat((String)"\u4e0a\u5e74%1\u6708", (String)"BgmdModelSaveOp_2", (String)"epm-eb-business", (Object[])new Object[]{model.getString("beginperiod")});
        model.set("beginperiodtext", (Object)beginPeriodText);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model});
        ModelSyncHelper.saveEpbsModel((Long)modelId, (String)model.getString("reporttype"));
        return model;
    }

    private void verifyModelNumber(@NotNull IEASSchema easSchema) {
        int count = 0;
        boolean checker = true;
        DecimalFormat format = new DecimalFormat("00");
        String oldNumber = easSchema.getNumber();
        if (oldNumber.length() > 47) {
            oldNumber = oldNumber.substring(0, 47);
        }
        while (checker && count++ < 99) {
            checker = this.hasModel(easSchema.getNumber());
            if (!checker) continue;
            easSchema.setNumber(oldNumber + '-' + format.format(count));
        }
    }

    private boolean hasModel(String modelNumber) {
        String sql = "select fid from t_eb_model where fshownumber = ?";
        try (DataSet ds = DB.queryDataSet((String)"queryModelNum", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{modelNumber});){
            if (ds != null && ds.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

