/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.upgrade.items;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.easupgrade.constant.EasUpgradeConstants;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IRunUpgrade;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.dao.NewMember;
import kd.epm.eb.business.easupgrade.impl.upgrade.items.AbstractEASUpgrade;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import org.jetbrains.annotations.NotNull;

public class EASVersionUpgrade
extends AbstractEASUpgrade {
    public static IRunUpgrade get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASVersionUpgrade(param, context);
    }

    protected EASVersionUpgrade(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getUpgradeInfo() {
        return "upgrade-version";
    }

    @Override
    protected void $upgrade() {
        String[] checkTables = new String[]{"T_MBG_BGVERSION"};
        if (!this.existTables(this.getParam(), this.getResult(), "BG_Version", SysDimensionEnum.Version.getNumber(), this.getUpgradeInfo(), checkTables)) {
            return;
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        EASDim versionDim = easSchema.getEASDim("BG_Version");
        Dimension dimension = this.getContext().getRunData().getModelCache().getDimension(SysDimensionEnum.Version.getNumber());
        List<EASMember> easMembers = EASDimUpgradeUtils.getDimRefMember(this.getParam(), easSchema.getSchemaId(), "BG_Version");
        versionDim.members.addAll(easMembers);
        if (versionDim.members.isEmpty()) {
            String msg = ResManager.loadKDString((String)"EAS\u7248\u672c\u7ef4\u5ea6\u6ca1\u6709\u5173\u8054\u7684\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASVersionChecker_0", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResult().add(EASUpgradeResult.error(this.getUpgradeInfo(), msg));
        } else {
            LinkedHashMap idsMap = Maps.newLinkedHashMap();
            String entityNumber = SysDimensionEnum.Version.getMemberTreemodel();
            String syncVersionTable = this.getParam().getSyncTableName("T_MBG_BGVERSION");
            List versionIds = versionDim.members.stream().map(version -> version.memberId).collect(Collectors.toList());
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid, fnumber, fname_l1, fname_l2, fname_l3, fparentid, fdescription_l1, fdescription_l2, fdescription_l3, fsimplename, 1 as fpolalgorithm, fversionid from " + syncVersionTable + " where ", new Object[0]).appendIn("fid", versionIds);
            String veId = "";
            try (DataSet ds = DB.queryDataSet((String)"queryEASVer", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                if (ds != null) {
                    for (Row row : ds) {
                        String fnumber = row.getString("fnumber");
                        if ("Ve".equals(fnumber)) {
                            veId = row.getString("fversionid");
                            continue;
                        }
                        this.transMember(entityNumber, row, dimension, idsMap);
                    }
                }
            }
            this.dealMembers(versionDim, dimension, idsMap);
            if (this.isSuccess()) {
                this.saveMembers(idsMap.values().toArray(new DynamicObject[0]));
                this.addDefaultMap(veId);
                this.getResult().add(EASUpgradeResult.run(this.getUpgradeInfo(), ResManager.loadKDString((String)"\u7248\u672c\u6210\u5458\u5347\u7ea7\u5b8c\u6210\u3002", (String)"EASVersionUpgrade_0", (String)"epm-eb-business", (Object[])new Object[0]), null, versionDim.getNumber(), dimension.getId(), dimension.getNumber()));
            } else {
                this.getStats().addInfo("members upgrade exist error.");
            }
        }
    }

    private void addDefaultMap(String veId) {
        HashMap<String, NewMember> memberNumMap = new HashMap<String, NewMember>(16);
        HashMap<String, NewMember> memberIdMap = new HashMap<String, NewMember>(16);
        IModelCacheHelper modelCache = this.getContext().getRunData().getModelCache();
        String number = EasUpgradeConstants.DEFAULT_VERSION_NUMBER_MAP.get("Ve");
        Member member = modelCache.getMember(SysDimensionEnum.Version.getNumber(), null, number);
        if (member == null) {
            throw new KDBizException(number + " is not exist");
        }
        NewMember newMember = new NewMember(member.getId(), member.getNumber(), member.getName(), veId, "Ve");
        memberIdMap.put(veId, newMember);
        memberNumMap.put("Ve", newMember);
        this.getContext().getRunData().addMemberMapping(SysDimensionEnum.Version.getNumber(), memberIdMap, memberNumMap);
    }

    @Override
    protected DynamicObject transMember(@NotNull String entityNumber, @NotNull Row row, @NotNull Dimension dimension, @NotNull Map<String, DynamicObject> idsMap) {
        DynamicObject version = super.transMember(entityNumber, row, dimension, idsMap);
        version.set("aggoprt", (Object)AggOprtEnum.SKIP.getSign());
        return version;
    }

    @Override
    protected String getDefaultIdField() {
        return "fversionid";
    }

    @Override
    protected boolean hasParent() {
        return false;
    }
}

