/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.sync;

import java.sql.Timestamp;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.easupgrade.sync.ISync;
import kd.epm.eb.business.easupgrade.utils.EASTableSyncLogUtil;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.lang3.StringUtils;

public class AbstractSync
implements ISync {
    @Override
    public void start(Long srcDsId, String table) {
        this.sync(srcDsId, table, false);
    }

    @Override
    public void startSync(Long srcDsId, String table) {
        this.sync(srcDsId, table, true);
    }

    private void sync(Long srcDsId, String table, boolean sync) {
        long logId = EASTableSyncLogUtil.writeLog(srcDsId, table);
        try {
            Map result;
            DynamicObject src = this.createSrcDsObject(srcDsId, table);
            DynamicObject srcDataSource = BusinessDataServiceHelper.loadSingle((Object)srcDsId, (String)"isc_data_source");
            long dblinkId = srcDataSource.getLong("dblink_id");
            DynamicObject dblink = BusinessDataServiceHelper.loadSingle((Object)dblinkId, (String)"isc_database_link");
            String dataCenter = dblink.getString("data_center");
            String tableName = this.creatTargetTable(srcDsId, dataCenter, src, table);
            QFilter qFilter = new QFilter("dblink.database_type", "=", (Object)"self");
            DynamicObject iscDs = BusinessDataServiceHelper.loadSingle((String)"isc_data_source", (String)"number", (QFilter[])qFilter.toArray());
            Long tarId = (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncMetaData", (Object[])new Object[]{iscDs.getString("number"), "TABLE", tableName + "@epm"});
            DynamicObject tar = BusinessDataServiceHelper.loadSingle((Object)tarId, (String)"isc_metadata_schema");
            DynamicObject dataCopy = this.createDataCopy(src, tar, table + srcDsId);
            DynamicObject trigger = this.createTrigger(dataCopy);
            long triggerId = trigger.getLong("id");
            String triggerNumber = trigger.getString("number");
            if (sync) {
                result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncExecute", (Object[])new Object[]{triggerNumber, null});
                EASTableSyncLogUtil.upLog((Long)logId, result, tableName);
            } else {
                EASTableSyncLogUtil.upLog((Long)logId, triggerId, tableName);
                result = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"execute", (Object[])new Object[]{triggerNumber, null});
            }
            if (!((Boolean)result.get("success")).booleanValue()) {
                throw new KDBizException((String)result.get("msg"));
            }
        }
        catch (Exception e) {
            EASTableSyncLogUtil.updateFailLog(logId, e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u6210\u670d\u52a1\u4e91\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff0c\u8be6\u60c5\u65e5\u5fd7\u8bf7\u5230\u96c6\u6210\u7ba1\u7406-\u8fde\u63a5\u914d\u7f6e\u4e2d\u67e5\u770b\u3002", (String)"EASDataUpgrade_6", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public DynamicObject createSrcDsObject(DynamicObject srcDs, String table) {
        try {
            Long srcId = (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncMetaData", (Object[])new Object[]{srcDs.getString("number"), "TABLE", table});
            return BusinessDataServiceHelper.loadSingle((Object)srcId, (String)"isc_metadata_schema");
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public DynamicObject createSrcDsObject(Long srcDsId, String table) {
        DynamicObject srcDs = BusinessDataServiceHelper.loadSingle((Object)srcDsId, (String)"isc_data_source");
        return this.createSrcDsObject(srcDs, table);
    }

    private void addEasTable(Long dataSourceId, String dataCenter, String srctable, String tartable) {
        DynamicObject easTable = BusinessDataServiceHelper.newDynamicObject((String)"eb_eas_table");
        easTable.set("easdbsource", (Object)dataSourceId);
        easTable.set("easdbcenter", (Object)dataCenter);
        easTable.set("srctable", (Object)srctable);
        easTable.set("tartable", (Object)tartable);
        easTable.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{easTable});
    }

    private String creatTargetTable(Long dataSourceId, String dataCenter, DynamicObject src, String tableName) {
        String tarTable;
        QFilter qFilter = new QFilter("easdbsource", "=", (Object)dataSourceId);
        qFilter.and(new QFilter("easdbcenter", "=", (Object)dataCenter));
        qFilter.and(new QFilter("srctable", "=", (Object)tableName));
        DynamicObject easTable = QueryServiceHelper.queryOne((String)"eb_eas_table", (String)"tartable", (QFilter[])qFilter.toArray());
        DBRoute epm = DBRoute.of((String)"epm");
        if (easTable == null) {
            DynamicObjectCollection properties = src.getDynamicObjectCollection("prop_entryentity");
            if (properties == null || properties.size() < 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\u5c5e\u6027\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5176\u5b83\u96c6\u6210\u5bf9\u8c61", (String)"DataIntegrationService_3", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            long id = GlobalIdUtil.genGlobalLongId();
            tarTable = "T_EB_EAS_" + id;
            String pk = "";
            StringBuilder sb = new StringBuilder();
            sb.append(" create table ").append(tarTable).append(" (");
            for (DynamicObject prop : properties) {
                String propName = prop.getString("prop_name");
                String propLabel = prop.getString("prop_label");
                String dataType = prop.getString("data_type");
                boolean isPrimaryKey = prop.getBoolean("is_primary_key");
                if (isPrimaryKey) {
                    pk = " constraint pk_" + tarTable + " primary key(" + propName + ") ";
                }
                sb.append(" ").append(propName).append(" ").append(this.transformFileType(dataType));
                sb.append(" ,");
            }
            String ddl = sb.toString();
            ddl = StringUtils.isNotBlank((CharSequence)pk) ? ddl + pk : StringUtils.substring((String)ddl, (int)0, (int)ddl.lastIndexOf(","));
            ddl = ddl + ")";
            DB.execute((DBRoute)epm, (String)ddl);
            this.addEasTable(dataSourceId, dataCenter, tableName, tarTable);
        } else {
            tarTable = easTable.getString("tartable");
            boolean hasTable = SqlBatchUtils.hasTable((String)tarTable);
            if (!hasTable) {
                DeleteServiceHelper.delete((String)"eb_eas_table", (QFilter[])qFilter.toArray());
                this.creatTargetTable(dataSourceId, dataCenter, src, tableName);
            }
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)("truncate table " + tarTable));
        }
        return tarTable;
    }

    private String transformFileType(String dataType) {
        if (StringUtils.containsIgnoreCase((CharSequence)dataType, (CharSequence)"decimal(19,0)")) {
            dataType = "bigint";
        } else if (StringUtils.containsIgnoreCase((CharSequence)dataType, (CharSequence)"decimal(10,0)")) {
            dataType = "int";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"date")) {
            dataType = "datetime";
        }
        return dataType;
    }

    private DynamicObject createDataCopy(DynamicObject src, DynamicObject tar, String schemeNumber) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("number", "=", (Object)schemeNumber);
        DeleteServiceHelper.delete((String)"isc_data_copy", (QFilter[])qfBuilder.toArrays());
        Long id = GlobalIdUtil.genGlobalLongId();
        DynamicObject dc = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_copy");
        dc.set("id", (Object)id);
        dc.set("source_schema", (Object)src);
        dc.set("data_source", src.get("group"));
        dc.set("target_schema", (Object)tar);
        dc.set("data_target", tar.get("group"));
        dc.set("mode", (Object)"BreakOnError");
        dc.set("number", (Object)schemeNumber);
        dc.set("name", (Object)ResManager.loadResFormat((String)"\u82cd\u7a79\u9884\u7b97-%1", (String)"DataIntegrationService_1", (String)"epm-eb-business", (Object[])new Object[]{id}));
        dc.set("proxy_user", (Object)"#{creator}");
        dc.set("creator", (Object)UserUtils.getUserId());
        dc.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        MainEntityType mainEntity = (MainEntityType)dc.getDataEntityType();
        EntityType entryType = (EntityType)mainEntity.getAllEntities().get("mapping_entries");
        DynamicObjectCollection items = dc.getDynamicObjectCollection("mapping_entries");
        DynamicObjectCollection properties = src.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject prop : properties) {
            DynamicObject item = new DynamicObject((DynamicObjectType)entryType);
            item.set("mapping_tar_column", (Object)prop.getString("prop_name"));
            boolean isPrimaryKey = prop.getBoolean("is_primary_key");
            item.set("candidate_key", (Object)isPrimaryKey);
            item.set("mapping_src_column", (Object)prop.getString("prop_name"));
            items.add((Object)item);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dc});
        return dc;
    }

    private DynamicObject createTrigger(DynamicObject dataCopy) {
        String schemeNumber = dataCopy.getString("number");
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("number", "=", (Object)schemeNumber);
        DeleteServiceHelper.delete((String)"isc_data_copy_trigger", (QFilter[])qfBuilder.toArrays());
        Long id = GlobalIdUtil.genGlobalLongId();
        DynamicObject tr = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_copy_trigger");
        tr.set("id", (Object)id);
        tr.set("trigger_type", (Object)"manual");
        tr.set("data_copy", (Object)dataCopy);
        tr.set("number", (Object)schemeNumber);
        tr.set("name", (Object)ResManager.loadResFormat((String)"\u82cd\u7a79\u9884\u7b97-%1", (String)"DataIntegrationService_1", (String)"epm-eb-business", (Object[])new Object[]{id}));
        tr.set("trace_all", (Object)Boolean.FALSE);
        tr.set("enable", (Object)1);
        tr.set("creator", (Object)UserUtils.getUserId());
        tr.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        tr.set("status", (Object)"C");
        MainEntityType mainEntity = (MainEntityType)tr.getDataEntityType();
        EntityType entryType = (EntityType)mainEntity.getAllEntities().get("event_handlers");
        DynamicObjectCollection items = tr.getDynamicObjectCollection("event_handlers");
        DynamicObject item = new DynamicObject((DynamicObjectType)entryType);
        item.set("datacopy_event", (Object)"OnTaskSuccess");
        item.set("target_consumer", (Object)"TargetSystem");
        item.set("event_handler", (Object)"msvc://epm.eb.SyncCallBackService.call");
        items.add((Object)item);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tr});
        return tr;
    }
}

