/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.analyzeReport.execute.ConditionExecutor;
import kd.epm.eb.business.analyzeReport.factory.ConditionExecutorFactory;
import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.BaseFormLockType;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMapBaseInfo;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMemberPojo;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQuery;
import kd.epm.eb.business.dataintegration.entity.ExecuteCondition;
import kd.epm.eb.business.dataintegration.entity.GLMapCondition;
import kd.epm.eb.business.dataintegration.entity.GlBizFieldType;
import kd.epm.eb.business.dataintegration.entity.GlPeriod;
import kd.epm.eb.business.dataintegration.entity.IntegrationDimMapGroup;
import kd.epm.eb.business.dataintegration.entity.IntegrationExecStatus;
import kd.epm.eb.business.dataintegration.entity.IntegrationRange;
import kd.epm.eb.business.dataintegration.entity.MemberMapPPO;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationContext;
import kd.epm.eb.business.dataintegration.entity.syssetting.BcmSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.EasSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.EbSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.GlSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.business.dataintegration.executor.DimMapConditionExecutor;
import kd.epm.eb.business.dataintegration.executor.DimMapEqualsConditionExecutor;
import kd.epm.eb.business.dataintegration.executor.DimMapInConditionExecutor;
import kd.epm.eb.business.dataintegration.executor.DimMapNullConditionExecutor;
import kd.epm.eb.business.easupgrade.constant.EasUpgradeConstants;
import kd.epm.eb.business.easupgrade.sync.BaseDataSyncImpl;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.business.easupgrade.utils.IntegrationLogHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dataintegration.CompareSign;
import kd.epm.eb.common.dataintegration.DataIntegrationGetValType;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.orm.EbIntegrationLog;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.pojo.DynamicAlertPojo;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.Counter;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.DynamicAlertUtils;
import org.apache.commons.lang3.StringUtils;

public class EASDataIntegrationUtil {
    public static List<String> getDimsources(DynamicObjectCollection dimmapCol) {
        return EASDataIntegrationUtil.getDimSources(dimmapCol, obj -> obj.getString("dimsource"));
    }

    public static <T> List<String> getDimSources(Iterable<T> sourceData, Function<T, String> fieldStrSupplier) {
        ArrayList<String> fieldList = new ArrayList<String>(10);
        if (sourceData != null) {
            for (T data : sourceData) {
                String[] fieldArr;
                String fieldStr = fieldStrSupplier.apply(data);
                if (fieldStr == null) continue;
                for (String field : fieldArr = StringUtils.split((String)fieldStr, (String)",")) {
                    if (!StringUtils.isNotEmpty((CharSequence)field)) continue;
                    fieldList.add(field);
                }
            }
        }
        return fieldList;
    }

    public static Map<String, Map<String, String>> getIdNumberMapFromEas(List<String> dimsources, long easdbid) {
        HashMap<String, Map<String, String>> tableIdNumberMap = new HashMap<String, Map<String, String>>(dimsources.size());
        for (String dimsource : dimsources) {
            if (!EasUpgradeConstants.EAS_DIM_TABLE_MAP.containsKey(dimsource)) continue;
            String table = EASDimUpgradeUtils.getSyncTable(easdbid, EasUpgradeConstants.EAS_DIM_TABLE_MAP.get(dimsource));
            if (!SqlBatchUtils.hasTable((String)table)) {
                BaseDataSyncImpl sync = new BaseDataSyncImpl();
                sync.startSync(easdbid, table);
            }
            if (SqlBatchUtils.hasTable((String)table)) {
                String queryDimSql;
                DataSet dataSet;
                String fid = "fid";
                if ("fversion".equals(dimsource)) {
                    fid = "fversionid";
                } else if ("fscenario".equals(dimsource)) {
                    fid = "fscenarioid";
                }
                if ((dataSet = EASDataIntegrationUtil.getDataSet(queryDimSql = "select " + fid + ",fnumber from " + table)) == null) continue;
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Map idNumberMap = tableIdNumberMap.computeIfAbsent(dimsource, e -> new HashMap(16));
                    idNumberMap.put(row.getString(fid), row.getString("fnumber"));
                }
                continue;
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u8868\u68c0\u67e5 - %1 \u6570\u636e\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASTableChecker_1", (String)"epm-eb-business", (Object[])new Object[]{table}));
        }
        return tableIdNumberMap;
    }

    private static DataSet getDataSet(String sql) {
        return DB.queryDataSet((String)"epm_dataintergation_eas", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
    }

    public static Map<String, String> getNumberIdMapFromEas(String dimsource, List<String> numbers, long easdbid) {
        HashMap<String, String> numberIdMap = new HashMap<String, String>(16);
        String table = EASDimUpgradeUtils.getSyncTable(easdbid, EasUpgradeConstants.EAS_DIM_TABLE_MAP.get(dimsource));
        if (numbers.size() > 0) {
            if (!SqlBatchUtils.hasTable((String)table)) {
                BaseDataSyncImpl sync = new BaseDataSyncImpl();
                sync.startSync(easdbid, table);
            }
            if (SqlBatchUtils.hasTable((String)table)) {
                String fid = "fid";
                if ("fversion".equals(dimsource)) {
                    fid = "fversionid";
                } else if ("fscenario".equals(dimsource)) {
                    fid = "fscenarioid";
                }
                String queryDimSql = "select " + fid + ",fnumber from " + table + " where fnumber in (";
                StringBuilder stringBuilder = new StringBuilder(queryDimSql);
                for (String number : numbers) {
                    stringBuilder.append("'").append(number).append("'").append(",");
                }
                queryDimSql = stringBuilder.substring(0, stringBuilder.length() - 1) + ")";
                DataSet dataSet = DB.queryDataSet((String)"epm_dataintergation_getNumberIdMapFromEas", (DBRoute)DBRoute.of((String)"epm"), (String)queryDimSql);
                if (dataSet != null) {
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        numberIdMap.put(row.getString("fnumber"), row.getString(fid));
                    }
                }
            } else {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u8868\u68c0\u67e5 - %1 \u6570\u636e\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASTableChecker_1", (String)"epm-eb-business", (Object[])new Object[]{table}));
            }
        }
        return numberIdMap;
    }

    public static void convertEasData(List<Map<String, String>> datas, List<String> dimsources, Map<String, Map<String, String>> idNumberMapFromEas) {
        for (Map<String, String> data : datas) {
            for (String dimsource : dimsources) {
                String number;
                Map<String, String> idNumberMap;
                String dimKey = "f" + dimsource;
                String memberValue = data.get(dimKey);
                if (EASDimUpgradeUtils.isCustomDim(dimsource)) {
                    String[] strs = memberValue.split(":");
                    if (strs.length <= 1) continue;
                    data.put(dimKey, strs[1]);
                    continue;
                }
                if (!EasUpgradeConstants.EAS_DIM_TABLE_MAP.containsKey(dimsource) || (idNumberMap = idNumberMapFromEas.get(dimsource)) == null || !StringUtils.isNotEmpty((CharSequence)(number = idNumberMap.get(memberValue)))) continue;
                data.put(dimKey, number);
            }
        }
    }

    private static Map<String, String> getCustomDimSrcNumberMap(Map<String, List<String>> filterParamMap, long easdbid) {
        HashMap<String, String> refMap = new HashMap<String, String>(16);
        String table = EASDimUpgradeUtils.getSyncTable(easdbid, "T_MBG_MBGDIM");
        ArrayList<String> customDims = new ArrayList<String>(10);
        for (Map.Entry<String, List<String>> entry : filterParamMap.entrySet()) {
            String field = entry.getKey();
            if ("f2".equals(field) || !EASDimUpgradeUtils.isCustomDim(field)) continue;
            customDims.add(field.toUpperCase());
        }
        if (customDims.size() > 0) {
            if (!SqlBatchUtils.hasTable((String)table)) {
                BaseDataSyncImpl sync = new BaseDataSyncImpl();
                sync.startSync(easdbid, table);
            }
            if (SqlBatchUtils.hasTable((String)table)) {
                String queryDimSql = "select fsrcnumber,freffield from " + table + " where freffield in (";
                StringBuilder stringBuilder = new StringBuilder(queryDimSql);
                for (String dim : customDims) {
                    stringBuilder.append("'").append(dim).append("'").append(",");
                }
                queryDimSql = stringBuilder.substring(0, stringBuilder.length() - 1) + ")";
                DataSet dataSet = DB.queryDataSet((String)"epm_dataintergation_getNumberIdMapFromEas", (DBRoute)DBRoute.of((String)"epm"), (String)queryDimSql);
                if (dataSet != null) {
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        refMap.put(row.getString("freffield"), row.getString("fsrcnumber"));
                    }
                }
            } else {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u8868\u68c0\u67e5 - %1 \u6570\u636e\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASTableChecker_1", (String)"epm-eb-business", (Object[])new Object[]{table}));
            }
        }
        return refMap;
    }

    public static void convertFilterParamMap(Map<String, List<String>> filterParamMap, long easdbid) {
        if (IDUtils.isNull((long)easdbid)) {
            return;
        }
        Map<String, String> refMap = EASDataIntegrationUtil.getCustomDimSrcNumberMap(filterParamMap, easdbid);
        for (Map.Entry<String, List<String>> entry : filterParamMap.entrySet()) {
            String field = entry.getKey();
            List<String> values = entry.getValue();
            ArrayList<String> convertValues = new ArrayList<String>(values.size());
            if ("f2".equals(field)) {
                for (String value : values) {
                    convertValues.add("Acc:" + value);
                }
            } else if (EASDimUpgradeUtils.isCustomDim(field)) {
                for (String value : values) {
                    String srcNumber = refMap.get(field.toUpperCase());
                    if (StringUtils.isNotEmpty((CharSequence)srcNumber)) {
                        convertValues.add(srcNumber + ":" + value);
                        continue;
                    }
                    convertValues.add(value);
                }
            } else if (EasUpgradeConstants.EAS_DIM_TABLE_MAP.containsKey(field)) {
                Map<String, String> numberIdMap = EASDataIntegrationUtil.getNumberIdMapFromEas(field, values, easdbid);
                for (String value : values) {
                    String id = numberIdMap.get(value);
                    if (StringUtils.isNotEmpty((CharSequence)id)) {
                        convertValues.add(id);
                        continue;
                    }
                    convertValues.add(value);
                }
            }
            entry.setValue(convertValues);
        }
    }

    public static Long getDefaultMapCat(Long modelId) {
        Date now = TimeServiceHelper.now();
        Long userId = UserUtils.getUserId();
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId).and(new QFilter("number", "=", (Object)"defaultCat"));
        DynamicObject mapCat = QueryServiceHelper.queryOne((String)"eb_integration_mapcat", (String)"id", (QFilter[])qFilter.toArray());
        if (mapCat == null) {
            mapCat = BusinessDataServiceHelper.newDynamicObject((String)"eb_integration_mapcat");
            mapCat.set("modelid", (Object)modelId);
            mapCat.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            mapCat.set("number", (Object)"defaultCat");
            mapCat.set("name", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u7c7b", (String)"EASDataIntegrationUtil_1", (String)"epm-eb-business", (Object[])new Object[0]));
            mapCat.set("creator", (Object)userId);
            mapCat.set("modifier", (Object)userId);
            mapCat.set("createtime", (Object)now);
            mapCat.set("modifytime", (Object)now);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mapCat});
        }
        return mapCat.getLong("id");
    }

    public static Long getDefaultMemberMapIfEAS(IModelCacheHelper modelCache, String dimNumber, Long defaultMapCat) {
        Long modelId = modelCache.getModelobj().getId();
        Date now = TimeServiceHelper.now();
        Long userId = UserUtils.getUserId();
        String integrationMapNumber = dimNumber + "_default";
        QFilter qFilter1 = new QFilter("modelid", "=", (Object)modelId).and(new QFilter("number", "=", (Object)integrationMapNumber));
        DynamicObject integrationMap = QueryServiceHelper.queryOne((String)"eb_integration_map", (String)"id", (QFilter[])qFilter1.toArray());
        if (integrationMap == null) {
            integrationMap = BusinessDataServiceHelper.newDynamicObject((String)"eb_integration_map");
            integrationMap.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            integrationMap.set("number", (Object)integrationMapNumber);
            integrationMap.set("name", (Object)(SysDimensionEnum.getEnumByNumber((String)dimNumber).getChineseName() + "_default"));
            integrationMap.set("type", (Object)"input");
            integrationMap.set("modelid", (Object)modelId);
            QFilter qFilter2 = new QFilter("model", "=", (Object)modelId);
            qFilter2.and(new QFilter("number", "=", (Object)dimNumber));
            DynamicObject dimension = BusinessDataServiceHelper.loadSingle((String)"epm_dimension", (String)"id", (QFilter[])qFilter2.toArray());
            integrationMap.set("tdim", (Object)dimension);
            integrationMap.set("creator", (Object)userId);
            integrationMap.set("modifier", (Object)userId);
            integrationMap.set("createtime", (Object)now);
            integrationMap.set("modifytime", (Object)now);
            integrationMap.set("mapcat", (Object)defaultMapCat);
            DynamicObjectCollection entrys = integrationMap.getDynamicObjectCollection("entryentity");
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                EASDataIntegrationUtil.addIntegrationMapEntry(entrys, "01", "Money", modelCache, dimNumber);
            } else if (SysDimensionEnum.Currency.getNumber().equals(dimNumber)) {
                EASDataIntegrationUtil.addIntegrationMapEntry(entrys, "BB01", "CYN", modelCache, dimNumber);
            } else if (SysDimensionEnum.DataType.getNumber().equals(dimNumber)) {
                EASDataIntegrationUtil.addIntegrationMapEntry(entrys, "BgData", "Budget", modelCache, dimNumber);
                EASDataIntegrationUtil.addIntegrationMapEntry(entrys, "ActData", "Actual", modelCache, dimNumber);
            } else if (SysDimensionEnum.Version.getNumber().equals(dimNumber)) {
                EASDataIntegrationUtil.addIntegrationMapEntry(entrys, "Ve", "ACTUAL", modelCache, dimNumber);
            }
            if (entrys.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{integrationMap});
            }
        }
        return integrationMap.getLong("id");
    }

    private static void addIntegrationMapEntry(DynamicObjectCollection entrys, String srcNumber, String tarNumber, IModelCacheHelper modelCache, String dimNumber) {
        DynamicObject entry = new DynamicObject(entrys.getDynamicObjectType());
        Member member = modelCache.getMember(dimNumber, null, tarNumber);
        if (member == null || !member.isLeaf()) {
            return;
        }
        entry.set("sourcename", (Object)member.getName());
        entry.set("sourcenumber", (Object)srcNumber);
        entry.set("targetname", (Object)member.getName());
        entry.set("targetnumber", (Object)tarNumber);
        entry.set("state", (Object)Boolean.TRUE);
        entrys.add((Object)entry);
    }

    public static List<ComboItem> buildCombListOfSourceObj(DynamicObject newSourceObj, Long easDbId) {
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(16);
        if (newSourceObj != null) {
            newSourceObj = BusinessDataServiceHelper.loadSingle((Object)newSourceObj.getLong("id"), (String)"isc_metadata_schema");
            DynamicObjectCollection props = newSourceObj.getDynamicObjectCollection("prop_entryentity");
            Map<String, String> easFieldLabelMap = EASDataIntegrationUtil.getEASFieldLabelMap(props, easDbId);
            for (DynamicObject prop : props) {
                String name = prop.getString("prop_label");
                String number = prop.getString("prop_name");
                String labelName = easFieldLabelMap.get(number);
                if (labelName != null) {
                    name = name + " " + easFieldLabelMap.getOrDefault(number, name);
                }
                ComboItem item = new ComboItem(new LocaleString(name), number);
                itemList.add(item);
            }
        }
        return itemList;
    }

    public static Map<String, String> getEASFieldLabelMap(DynamicObjectCollection props, Long easdbId) {
        Map<String, String> easFieldLabelMap = new HashMap<String, String>(props.size());
        if (IDUtils.isNotNull((Long)easdbId)) {
            ArrayList<String> fields = new ArrayList<String>(10);
            for (DynamicObject prop : props) {
                String number = prop.getString("prop_name");
                fields.add(number);
            }
            easFieldLabelMap = EASDataIntegrationUtil.getEASFieldLabelMap(easdbId, fields);
        }
        return easFieldLabelMap;
    }

    public static Map<String, String> getEASFieldLabelMap(Long easdbid, List<String> fields) {
        HashMap<String, String> refMap = new HashMap<String, String>(16);
        String table = EASDimUpgradeUtils.getSyncTable(easdbid, "T_MBG_MBGDIM");
        if (fields.size() > 0) {
            if (!SqlBatchUtils.hasTable((String)table)) {
                BaseDataSyncImpl sync = new BaseDataSyncImpl();
                sync.startSync(easdbid, table);
            }
            if (SqlBatchUtils.hasTable((String)table)) {
                String queryDimSql = "select fname_l1, fname_l2, fname_l3,freffield from " + table + " where freffield in (";
                StringBuilder stringBuilder = new StringBuilder(queryDimSql);
                boolean hasCustomDim = false;
                for (String field : fields) {
                    if (!"f2".equals(field) && EASDimUpgradeUtils.isCustomDim(field)) {
                        stringBuilder.append("'").append(field.toUpperCase()).append("'").append(",");
                        hasCustomDim = true;
                        continue;
                    }
                    SysDimensionEnum sysDimensionEnum = EasUpgradeConstants.EAS_EB_DIM_MAP.get(field);
                    if (sysDimensionEnum == null) continue;
                    refMap.put(field, sysDimensionEnum.getChineseName());
                }
                if (hasCustomDim) {
                    queryDimSql = stringBuilder.substring(0, stringBuilder.length() - 1) + ")";
                    DataSet dataSet = DB.queryDataSet((String)"epm_dataintergation_getNumberIdMapFromEas", (DBRoute)DBRoute.of((String)"epm"), (String)queryDimSql);
                    if (dataSet != null) {
                        while (dataSet.hasNext()) {
                            Row row = dataSet.next();
                            refMap.put(row.getString("freffield").toLowerCase(), EASUpgradeUtils.getLocaleStr(row, "fname").getLocaleValue());
                        }
                    }
                }
            } else {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u8868\u68c0\u67e5 - %1 \u6570\u636e\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASTableChecker_1", (String)"epm-eb-business", (Object[])new Object[]{table}));
            }
        }
        return refMap;
    }

    public static void openMemberMapBaseForm(IFormView formView, IFormPlugin formPlugin, DataIntegrationDimMapBaseInfo mapInfo, String focusNodeId, Long modelId, BaseFormLockType lockType) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_datacollmembmap_base");
        formShowParameter.setShowTitle(Boolean.TRUE.booleanValue());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("ModelId", (Object)modelId);
        formShowParameter.setCustomParam("lockType", (Object)lockType.getVal());
        formShowParameter.setCustomParam("eb_integration_mapcat", (Object)focusNodeId);
        if (mapInfo != null) {
            formShowParameter.setCustomParam("MapCatBaseInfo", (Object)ObjectSerialUtil.toByteSerialized((Object)mapInfo));
        }
        formShowParameter.setCloseCallBack(new CloseCallBack(formPlugin, "dimenMap"));
        formView.showForm(formShowParameter);
    }

    public static DataIntegrationDimMapBaseInfo getOrSelMapInfo(boolean isSelect, IFormView formView) {
        DataIntegrationDimMapBaseInfo mapBaseInfo = null;
        IDataModel dataModel = formView.getModel();
        if (isSelect) {
            mapBaseInfo = new DataIntegrationDimMapBaseInfo();
            mapBaseInfo.setIntegrationType(DataIntegrationType.getTypeByVal((String)((String)dataModel.getValue("type"))));
            mapBaseInfo.setSchemeType(IntegrationSchemeType.getTypeByVal((String)((String)dataModel.getValue("schemetype"))));
            mapBaseInfo.setName((OrmLocaleValue)dataModel.getValue("name"));
            mapBaseInfo.setNumber((String)dataModel.getValue("number"));
        } else {
            String paramStr = (String)formView.getFormShowParameter().getCustomParam("MapCatBaseInfo");
            if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
                mapBaseInfo = (DataIntegrationDimMapBaseInfo)ObjectSerialUtil.deSerializedBytes((String)paramStr);
            }
        }
        return mapBaseInfo;
    }

    public static SysSettingInfo desSysSetting(String settingStr, IntegrationSchemeType schemeType) {
        SysSettingInfo settingInfo = null;
        if (StringUtils.isNotEmpty((CharSequence)settingStr)) {
            switch (schemeType) {
                case CUSTOM: {
                    settingInfo = (SysSettingInfo)SerializationUtils.fromJsonString((String)settingStr, EasSysSetting.class);
                    break;
                }
                case EB: {
                    settingInfo = (SysSettingInfo)SerializationUtils.fromJsonString((String)settingStr, EbSysSetting.class);
                    break;
                }
                case GL: {
                    settingInfo = (SysSettingInfo)SerializationUtils.fromJsonString((String)settingStr, GlSysSetting.class);
                    break;
                }
                case BCM: {
                    settingInfo = (SysSettingInfo)SerializationUtils.fromJsonString((String)settingStr, BcmSysSetting.class);
                    break;
                }
                default: {
                    settingInfo = (SysSettingInfo)SerializationUtils.fromJsonString((String)settingStr, SysSettingInfo.class);
                    break;
                }
            }
        } else if (schemeType == IntegrationSchemeType.CUSTOM) {
            settingInfo = new EasSysSetting();
        }
        return settingInfo;
    }

    public static String serSysSetting4Like(SysSettingInfo settingInfo, boolean noIgnoreFields) {
        String str;
        String string = str = noIgnoreFields ? EASDataIntegrationUtil.serSysSetting(settingInfo, new String[0]) : EASDataIntegrationUtil.serSysSetting(settingInfo, "useMulBizField", "useRefField");
        if (str != null && str.charAt(str.length() - 1) == '}') {
            char[] chars = str.toCharArray();
            chars[chars.length - 1] = 37;
            str = new String(chars);
        }
        return str;
    }

    public static String serSysSetting(SysSettingInfo settingInfo, String ... ignoreFields) {
        if (settingInfo == null) {
            return "";
        }
        Method[] methods = settingInfo.getClass().getMethods();
        Field[] fields = settingInfo.getClass().getDeclaredFields();
        Field[] parentFields = settingInfo.getClass().getSuperclass().getDeclaredFields();
        ArrayList<Field> allFields = new ArrayList<Field>(fields.length);
        allFields.addAll(Arrays.asList(fields));
        allFields.addAll(Arrays.asList(parentFields));
        LinkedHashMap<String, Object> valMap = new LinkedHashMap<String, Object>(16);
        HashMap<String, Method> fieldGetMethod = new HashMap<String, Method>(16);
        for (Method method : methods) {
            String methodName = method.getName();
            String fieldName = null;
            if (methodName.startsWith("get")) {
                fieldName = methodName.substring(3);
            } else if (methodName.startsWith("is")) {
                fieldName = methodName.substring(2);
            }
            if (fieldName == null || fieldName.equals("Class")) continue;
            fieldGetMethod.put(fieldName.toLowerCase(), method);
        }
        if (ignoreFields != null) {
            for (String fieldKey : ignoreFields) {
                fieldGetMethod.remove(fieldKey.toLowerCase());
            }
        }
        try {
            for (Field field : allFields) {
                Object val;
                Method method = (Method)fieldGetMethod.get(field.getName().toLowerCase());
                if (method == null || (val = method.invoke((Object)settingInfo, new Object[0])) == null) continue;
                valMap.put(field.getName(), val);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return SerializationUtils.toJsonString(valMap);
    }

    public static Pair<String, Boolean> getFieldGroupInfoByScheme(IntegrationSchemeType schemeType) {
        String groupName;
        boolean setNameEditBox = true;
        switch (schemeType) {
            case CUSTOM: {
                groupName = ResManager.loadKDString((String)"\u4e1a\u52a1\u5b57\u6bb5", (String)"EASDataIntegrationUtil_2", (String)"epm-eb-business", (Object[])new Object[0]);
                setNameEditBox = false;
                break;
            }
            case EB: {
                groupName = ResManager.loadKDString((String)"\u9884\u7b97\u7ef4\u5ea6\u6210\u5458", (String)"EASDataIntegrationUtil_3", (String)"epm-eb-business", (Object[])new Object[0]);
                break;
            }
            case GL: {
                groupName = ResManager.loadKDString((String)"\u4e1a\u52a1\u6210\u5458", (String)"EASDataIntegrationUtil_4", (String)"epm-eb-business", (Object[])new Object[0]);
                break;
            }
            case BCM: {
                groupName = ResManager.loadKDString((String)"\u5408\u5e76\u62a5\u8868\u7ef4\u5ea6\u6210\u5458", (String)"EASDataIntegrationUtil_5", (String)"epm-eb-business", (Object[])new Object[0]);
                break;
            }
            default: {
                groupName = "";
            }
        }
        return new Pair((Object)groupName, (Object)setNameEditBox);
    }

    public static boolean showRangeCol(DataIntegrationType type, IntegrationSchemeType schemeType) {
        return type == DataIntegrationType.INPUT && schemeType == IntegrationSchemeType.GL;
    }

    public static boolean showBizFieldCol(SysSettingInfo sysSettingInfo) {
        return sysSettingInfo instanceof EasSysSetting && ((EasSysSetting)sysSettingInfo).isUseMulBizField();
    }

    /*
     * WARNING - void declaration
     */
    public static List<List<Long>> getConditionIdsBySchemesGroup(List<Set<Long>> schemeIds) {
        void var7_8;
        HashSet allSchemeIds = new HashSet();
        schemeIds.forEach(allSchemeIds::addAll);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"eb_integration_query", (String)"id,integrationids", (QFilter[])new QFilter("integrationids.fbasedataid_id", "in", allSchemeIds).toArray());
        HashMap<Long, Set> conditionSchemeMap = new HashMap<Long, Set>(16);
        DynamicObject[] dynamicObjectArray = objects;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var7_8 < n) {
            DynamicObject obj = dynamicObjectArray[var7_8];
            Long conditionId = obj.getLong("id");
            DynamicObjectCollection integrationObjs = obj.getDynamicObjectCollection("integrationids");
            Set integrationIdSet = integrationObjs.stream().map(ob -> ob.getLong("fbasedataid_id")).collect(Collectors.toSet());
            conditionSchemeMap.put(conditionId, integrationIdSet);
            ++var7_8;
        }
        ArrayList<List<Long>> result = new ArrayList<List<Long>>(16);
        for (Collection collection : schemeIds) {
            ArrayList cIds = new ArrayList(16);
            conditionSchemeMap.forEach((cId, sIds) -> {
                if (groupSIds.size() == sIds.size() && sIds.containsAll(groupSIds)) {
                    cIds.add(cId);
                }
            });
            result.add(cIds);
        }
        return result;
    }

    public static List<Long> getSchemeIdsByCondition(Long conditionId) {
        return EASDataIntegrationUtil.getSchemeIdsByCondition(Collections.singletonList(conditionId)).getOrDefault(conditionId, new ArrayList(16));
    }

    public static Map<Long, List<Long>> getSchemeIdsByCondition(Collection<Long> conditionIds) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(conditionIds.size());
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"eb_integration_query", (String)"id,integrationids.fbasedataid_id as integrationid", (QFilter[])new QFilter("id", "in", conditionIds).toArray());
        for (DynamicObject obj : objects) {
            Long conditionId = obj.getLong("id");
            Long integrationId = obj.getLong("integrationid");
            result.computeIfAbsent(conditionId, key -> new ArrayList(16)).add(integrationId);
        }
        return result;
    }

    public static List<Long> getConditionIdsBySchemes(Collection<Long> schemeIds) {
        HashSet<Long> ids = schemeIds instanceof Set ? (HashSet<Long>)schemeIds : new HashSet<Long>(schemeIds);
        return EASDataIntegrationUtil.getConditionIdsBySchemesGroup(Collections.singletonList(ids)).get(0);
    }

    public static Map<String, List<Member>> parserMemberFilter(ExecuteCondition condition) {
        Long modelId = condition.getModelId();
        List<DataIntegrationQuery> dataIntegrationQueryList = condition.getFilters();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, List<Member>> dimMemberParamMap = new HashMap<String, List<Member>>(16);
        Map<String, List<Member>> replaceMembers = condition.getReplaceMembers();
        for (DataIntegrationQuery dataIntegrationQuery : dataIntegrationQueryList) {
            String dimNumber = dataIntegrationQuery.getDimNumber();
            if (replaceMembers.containsKey(dimNumber)) continue;
            List<Member> memberList = EASDataIntegrationUtil.parserMemberFilter(modelCache, dataIntegrationQuery, dataIntegrationQuery.getViewId());
            if (memberList.isEmpty()) {
                throw new KDBizException(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u4e0d\u542b\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\u8303\u56f4\u3002", (String)"DataIntegrationDataService_15", (String)"epm-eb-business", (Object[])new Object[]{dimNumber}));
            }
            dimMemberParamMap.put(dimNumber, memberList);
        }
        dimMemberParamMap.putAll(replaceMembers);
        return dimMemberParamMap;
    }

    public static List<Member> parserMemberFilter(IModelCacheHelper modelCache, DataIntegrationQuery dataIntegrationQuery, Long viewId) {
        ArrayList<Member> memberList = new ArrayList<Member>(10);
        if (dataIntegrationQuery != null) {
            String dimNumber = dataIntegrationQuery.getDimNumber();
            List<DataIntegrationMemberPojo> dataIntegrationMemberPojoList = dataIntegrationQuery.getDataIntegrationMemberPojoList();
            for (DataIntegrationMemberPojo memberObj : dataIntegrationMemberPojoList) {
                memberList.addAll(modelCache.getMember(dimNumber, viewId, memberObj.getMemberNumberString(), Integer.parseInt(memberObj.getScopeString())));
            }
        }
        return memberList;
    }

    public static int getExecProgress(Long actionId) {
        int progress;
        List<EbIntegrationLog> logPjs = IntegrationLogHelper.getLogPjByAction(actionId);
        if (logPjs == null || logPjs.isEmpty()) {
            progress = 100;
        } else {
            int endCount = logPjs.size();
            for (EbIntegrationLog log : logPjs) {
                if (!IntegrationExecStatus.WAIT.getVal().equals(log.getStatusStr()) && !IntegrationExecStatus.ING.getVal().equals(log.getStatusStr())) continue;
                --endCount;
            }
            progress = endCount * 100 / logPjs.size();
        }
        return progress;
    }

    public static Map<Long, MemberMapPPO> loadRefMemberMap(AbstractDataIntegration dataIntegration) {
        if (dataIntegration != null) {
            HashSet<Long> memberMapIds = new HashSet<Long>(16);
            List<IntegrationDimMapGroup> dimMapGroups = dataIntegration.getDimMapGroups();
            dimMapGroups.forEach(group -> group.getMemberMaps().forEach(map -> {
                if (IDUtils.isNotEmptyLong((Long)map.getDimmembmapid()).booleanValue()) {
                    memberMapIds.add(map.getDimmembmapid());
                }
            }));
            return EASDataIntegrationUtil.getMemberMapObj(memberMapIds);
        }
        return new HashMap<Long, MemberMapPPO>(16);
    }

    public static Map<Long, MemberMapPPO> getMemberMapObj(Set<Long> mapIds) {
        DynamicObject[] mapObjs;
        HashMap<Long, MemberMapPPO> result = new HashMap<Long, MemberMapPPO>();
        if (CollectionUtils.isNotEmpty(mapIds) && (mapObjs = BusinessDataServiceHelper.load((Object[])mapIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_integration_map"))) != null) {
            for (DynamicObject obj : mapObjs) {
                Long id = obj.getLong("id");
                result.put(id, MemberMapPPO.of(obj));
            }
        }
        return result;
    }

    public static List<GlPeriod> loadGlPeriodObj(Collection<Long> periodIds) {
        ArrayList<GlPeriod> result = new ArrayList<GlPeriod>(periodIds.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"loadGlPeriodObj", (String)GlBizFieldType.PERIOD.getFieldFormKey(), (String)"id,number,enddate", (QFilter[])new QFilter("id", "in", periodIds).toArray(), null);){
            for (Row row : dataSet) {
                result.add(new GlPeriod(row.getLong("id"), row.getString("number"), row.getDate("enddate")));
            }
        }
        return result;
    }

    public static Map<Long, String> queryGlDataIdNumberMap(GlBizFieldType fieldType, Object glObj, Long costView, boolean loadOrgFromCache) {
        HashMap<Long, String> idNumberMap;
        if (fieldType == GlBizFieldType.ORG && loadOrgFromCache) {
            idNumberMap = (Map)ThreadCache.get((Object)("gl_org_idNum_" + costView), () -> EASDataIntegrationUtil.queryGlDataIdNumberMap(fieldType, glObj, costView, false));
        } else {
            idNumberMap = new HashMap(16);
            Pair<String, QFilter> glBaseDataAndFilters = EASDataIntegrationUtil.getGlBaseDataAndFilters(fieldType, glObj, costView);
            String formKey = (String)glBaseDataAndFilters.p1;
            if (formKey != null) {
                QFilter[] qFilterArray;
                QFilter qFilter = (QFilter)glBaseDataAndFilters.p2;
                BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)formKey);
                String numberP = dataEntityType.getNumberProperty();
                String selFields = formKey.equals("bos_org_structure") ? "org.number as " + numberP + ", org.id as id" : numberP + ",id";
                if (qFilter == null) {
                    qFilterArray = null;
                } else {
                    QFilter[] qFilterArray2 = new QFilter[1];
                    qFilterArray = qFilterArray2;
                    qFilterArray2[0] = qFilter;
                }
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getGlBasedataRows", (String)formKey, (String)selFields, (QFilter[])qFilterArray, null);){
                    for (Row row : dataSet) {
                        idNumberMap.put(row.getLong("id"), row.getString(numberP));
                    }
                }
            }
        }
        return idNumberMap;
    }

    public static Map<String, List<String>> queryGlAllChildNumber(Set<String> parentNumbers, Set<Long> sourceIds, GlBizFieldType fieldType, Long glObj, Long costView) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(16);
        if (CollectionUtils.isNotEmpty(parentNumbers)) {
            Pair<String, QFilter> glBaseDataAndFilters = EASDataIntegrationUtil.getGlBaseDataAndFilters(fieldType, glObj, costView);
            String formKey = (String)glBaseDataAndFilters.p1;
            if (formKey != null) {
                QFilter qFilter = (QFilter)glBaseDataAndFilters.p2;
                if (fieldType == GlBizFieldType.ACCOUNT) {
                    EASDataIntegrationUtil.queryGlAcctChildNumMap(result, sourceIds, qFilter);
                } else {
                    BasedataEntityType dataEntityType;
                    if (formKey.equals("bos_org")) {
                        formKey = "bos_org_structure";
                        qFilter = new QFilter("view", "=", (Object)15);
                    }
                    if ((dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)formKey)) != null) {
                        String numberP = dataEntityType.getNumberProperty();
                        DynamicProperty longNumberP = dataEntityType.getProperty("longnumber");
                        DynamicProperty parentP = dataEntityType.getProperty("parent");
                        if (parentP == null) {
                            parentP = dataEntityType.getProperty("parentid");
                        }
                        if ("bos_org_structure".equals(formKey)) {
                            numberP = "org.number";
                        }
                        if (longNumberP != null && !longNumberP.isDbIgnore()) {
                            QFilter[] qFilterArray;
                            String longNumKey = longNumberP.getName();
                            String string = numberP + "," + longNumKey;
                            if (qFilter == null) {
                                qFilterArray = null;
                            } else {
                                QFilter[] qFilterArray2 = new QFilter[1];
                                qFilterArray = qFilterArray2;
                                qFilterArray2[0] = qFilter;
                            }
                            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getGlBasedataRows", (String)formKey, (String)string, (QFilter[])qFilterArray, null);){
                                Character splitKey = null;
                                BiFunction<String, String, Boolean> pNumConsumer = (number, pNumber) -> {
                                    if (parentNumbers.contains(pNumber)) {
                                        result.computeIfAbsent((String)pNumber, key -> new LinkedList()).add(number);
                                        return true;
                                    }
                                    return false;
                                };
                                for (Row row : dataSet) {
                                    String number2 = row.getString(numberP);
                                    String longNumber = row.getString(longNumKey);
                                    splitKey = EASDataIntegrationUtil.parserParentNums(number2, longNumber, splitKey, pNumConsumer);
                                }
                            }
                        }
                        if (parentP != null && StringUtils.isNotEmpty((CharSequence)parentP.getAlias())) {
                            QFilter[] qFilterArray;
                            String parentKey = parentP.getName();
                            HashMap<Long, Pair> idPidMap = new HashMap<Long, Pair>();
                            String string = "id," + numberP + "," + parentKey;
                            if (qFilter == null) {
                                qFilterArray = null;
                            } else {
                                QFilter[] qFilterArray3 = new QFilter[1];
                                qFilterArray = qFilterArray3;
                                qFilterArray3[0] = qFilter;
                            }
                            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getGlBasedataRows", (String)formKey, (String)string, (QFilter[])qFilterArray, null);){
                                for (Row row : dataSet) {
                                    String number3 = row.getString(numberP);
                                    Long id2 = row.getLong("id");
                                    Long pId = row.getLong(parentKey);
                                    idPidMap.put(id2, new Pair((Object)pId, (Object)number3));
                                }
                            }
                            idPidMap.forEach((id, numbPidMap) -> {
                                String number = (String)numbPidMap.p2;
                                Pair pMap = (Pair)idPidMap.get(numbPidMap.p1);
                                for (int deep = 0; deep < 20 && pMap != null; ++deep) {
                                    if (parentNumbers.contains(pMap.p2)) {
                                        result.computeIfAbsent((String)pMap.p2, key -> new LinkedList()).add(number);
                                    }
                                    pMap = (Pair)idPidMap.get(pMap.p1);
                                }
                            });
                        }
                    }
                }
            }
        }
        return result;
    }

    private static void queryGlAcctChildNumMap(Map<String, List<String>> result, Set<Long> parentIds, QFilter qFilter) {
        Long id;
        QFilter[] qFilterArray;
        String formKey = GlBizFieldType.ACCOUNT.getFieldFormKey();
        HashMap<Long, Long> accountInfoMap = new HashMap<Long, Long>();
        if (qFilter == null) {
            qFilterArray = null;
        } else {
            QFilter[] qFilterArray2 = new QFilter[1];
            qFilterArray = qFilterArray2;
            qFilterArray2[0] = qFilter;
        }
        DynamicObjectCollection objects = QueryServiceHelper.query((String)formKey, (String)"id,parent", qFilterArray);
        for (DynamicObject obj : objects) {
            id = obj.getLong("id");
            Long pId = obj.getLong("parent");
            accountInfoMap.put(id, pId);
        }
        HashMap<Long, List> resultIds = new HashMap<Long, List>(16);
        accountInfoMap.forEach((_id, _pId) -> {
            for (int deep = 0; deep < 20 && _pId != null; ++deep) {
                if (parentIds.contains(_pId)) {
                    resultIds.computeIfAbsent((Long)_pId, key -> new LinkedList()).add(_id);
                }
                _pId = (Long)accountInfoMap.get(_pId);
            }
        });
        if (resultIds.size() > 0) {
            HashMap<Long, String> allChildIdNumMap = new HashMap<Long, String>(16);
            resultIds.forEach((parentId, ids) -> {
                allChildIdNumMap.put((Long)parentId, (String)null);
                ids.forEach(childId -> {
                    String cfr_ignored_0 = allChildIdNumMap.put((Long)childId, (String)null);
                });
            });
            objects = QueryServiceHelper.query((String)formKey, (String)"id,number,createorg.number as orgnumber", (QFilter[])new QFilter("id", "in", allChildIdNumMap.keySet()).toArray());
            for (DynamicObject obj : objects) {
                id = obj.getLong("id");
                allChildIdNumMap.put(id, obj.getString("number") + "," + obj.getString("orgnumber"));
            }
            resultIds.forEach((parentId, ids) -> {
                String parentAOStr = (String)allChildIdNumMap.get(parentId);
                ArrayList childAOStr = new ArrayList(ids.size());
                ids.forEach(childId -> childAOStr.add(allChildIdNumMap.get(childId)));
                result.put(parentAOStr, childAOStr);
            });
        }
    }

    private static Character parserParentNums(String number, String longNumber, Character splitKey, BiFunction<String, String, Boolean> pNumConsumer) {
        if (StringUtils.isNotEmpty((CharSequence)number) && StringUtils.isNotEmpty((CharSequence)longNumber) && number.length() < longNumber.length()) {
            int lastIndex = longNumber.length() - number.length() - 1;
            if (splitKey == null) {
                splitKey = Character.valueOf(longNumber.charAt(lastIndex));
            }
            char sKey = splitKey.charValue();
            StringBuilder sb = new StringBuilder();
            for (int index = lastIndex - 1; index >= 0; --index) {
                char word = longNumber.charAt(index);
                if (word == sKey) {
                    boolean isReturn = pNumConsumer.apply(number, sb.reverse().toString());
                    sb.setLength(0);
                    if (!isReturn) continue;
                    break;
                }
                sb.append(word);
            }
            if (sb.length() > 0) {
                pNumConsumer.apply(number, sb.reverse().toString());
            }
        }
        return splitKey;
    }

    public static Pair<String, QFilter> getGlBaseDataAndFilters(GlBizFieldType fieldType, Object glObj, Long costView) {
        Pair<String, QFilter> glBaseDataAndFilters;
        if (fieldType == GlBizFieldType.DIMENSION || fieldType == null) {
            QFilter filter = glObj instanceof String ? new QFilter("number", "=", glObj) : new QFilter("id", "=", glObj);
            DynamicObject asstactType = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"valuetype,assistanttype,valuesource.id,filtercondition_tag", (QFilter[])new QFilter[]{filter});
            glBaseDataAndFilters = EASDataIntegrationUtil.getGlBaseDataAndFilters(asstactType);
        } else {
            QFilter qFilter = null;
            String formKey = fieldType.getFieldFormKey();
            switch (fieldType) {
                case ORG: {
                    qFilter = new QFilter("view", "=", (Object)costView);
                    break;
                }
                case ACCOUNT: {
                    qFilter = new QFilter("accounttable", "=", glObj);
                    break;
                }
                case PERIOD: {
                    qFilter = new QFilter("periodtype", "=", glObj);
                }
            }
            glBaseDataAndFilters = new Pair<String, QFilter>((Object)formKey, qFilter);
        }
        return glBaseDataAndFilters;
    }

    public static Pair<String, QFilter> getGlBaseDataAndFilters(DynamicObject asstactType) {
        String formKey = null;
        QFilter filter = null;
        if (asstactType != null) {
            String entityName;
            String dimValueType = asstactType.getString("valuetype");
            if ("2".equals(dimValueType)) {
                long groupId = asstactType.getLong("assistanttype");
                filter = new QFilter("group", "=", (Object)groupId);
                formKey = "bos_assistantdata_detail";
            } else if ("1".equals(dimValueType) && StringUtils.isNotEmpty((CharSequence)(entityName = asstactType.getString("valuesource.id")))) {
                String conditionStr;
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
                DynamicProperty statusProp = entityType.getProperty("status");
                if (statusProp != null) {
                    filter = new QFilter("status", "=", (Object)"C");
                }
                if (StringUtils.isNotEmpty((CharSequence)(conditionStr = asstactType.getString("filtercondition_tag")))) {
                    FlexBDValueCondition valueCondition = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)conditionStr, FlexBDValueCondition.class);
                    FilterBuilder filterBuilder = new FilterBuilder(entityType, valueCondition.getFilterCondition(), true);
                    filterBuilder.buildFilter(true);
                    if (filterBuilder.getQFilters() != null) {
                        if (filter == null) {
                            filter = new QFilter("1", "=", (Object)"1");
                        }
                        for (QFilter qf : filterBuilder.getQFilters()) {
                            filter = filter.and(qf);
                        }
                    }
                }
                formKey = entityName;
            }
        }
        return new Pair(formKey, filter);
    }

    public static List<QFilter> getBcmDimFilters(Long modelId, Long dimId, Long viewId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("dimension", "=", (Object)dimId));
        if (IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) {
            qFilters.add(new QFilter("cslscheme", "=", (Object)viewId));
        }
        return qFilters;
    }

    public static Map<String, List<Member>> parserMemberFilter(AbstractDataIntegration dataIntegration, IModelCacheHelper modelCacheHelper, IntegrationContext globalContext) {
        HashMap<String, List<Member>> memberFilters = new HashMap<String, List<Member>>();
        if (dataIntegration != null) {
            boolean filterPerm = globalContext.getExecuteCondition().isFilterMemberPerm();
            Long bizModelId = dataIntegration.getBizModelId();
            Long modelId = modelCacheHelper.getModelobj().getId();
            Map<String, List<Member>> globalMemberFilters = globalContext.getMemberFilters();
            List<IntegrationRange> integrationRanges = dataIntegration.getIntegrationRanges();
            DimMembPermType permType = globalContext.getExecuteCondition().isOut() ? DimMembPermType.READ : DimMembPermType.WRITE;
            Map viewIds = modelCacheHelper.getViewsByDataSet(dataIntegration.getDatasetid());
            ArrayList<String> emptyDims = new ArrayList<String>(16);
            for (IntegrationRange range : integrationRanges) {
                Set permMembIds;
                Member member2;
                List<Object> members = null;
                Long datasetId = dataIntegration.getDatasetid();
                String dimNumber = range.getDimNumber();
                Long viewId = (Long)viewIds.get(range.getDimNumber());
                if (range.getGetValType() == DataIntegrationGetValType.CONDITION) {
                    members = globalMemberFilters.get(dimNumber);
                    if (members != null && members.size() > 0 && (member2 = members.get(0)) instanceof ViewMember) {
                        viewId = ((ViewMember)member2).getViewId();
                    }
                    if (members != null && SysDimensionEnum.Account.getNumber().equals(range.getDimNumber())) {
                        members = members.stream().filter(member -> datasetId.equals(member.getDatasetId())).collect(Collectors.toList());
                    }
                } else {
                    members = new ArrayList<Member>(16);
                    member2 = range.getRangeMembers().iterator();
                    while (member2.hasNext()) {
                        MemberCondition condition = member2.next();
                        viewId = IDUtils.toLong((Object)condition.getViewId());
                        List memberList = modelCacheHelper.getMember(range.getDimNumber(), viewId, condition.getNumber(), Integer.parseInt(condition.getRange()));
                        members.addAll(memberList);
                    }
                }
                if (filterPerm && (permMembIds = DimMembPermHelper.getPermMembIds((String)dimNumber, (Long)modelId, (Long)bizModelId, (Long)viewId, (DimMembPermType)permType, (boolean)true)) != null) {
                    if (members == null) {
                        members = new ArrayList(permMembIds.size());
                        for (Long memberId : permMembIds) {
                            Member member3 = modelCacheHelper.getMember(dimNumber, viewId, memberId);
                            if (member3 == null) continue;
                            members.add(member3);
                        }
                    } else {
                        members = members.stream().filter(member -> permMembIds.contains(member.getId())).collect(Collectors.toList());
                    }
                }
                if (members == null) continue;
                if (members.isEmpty()) {
                    emptyDims.add(dimNumber);
                }
                memberFilters.put(range.getDimNumber(), members);
            }
            if (emptyDims.size() > 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u4e0d\u542b\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u8fc7\u6ee4\u6761\u4ef6\u8303\u56f4\u3002", (String)"DataIntegrationDataService_15", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)",", emptyDims)}));
            }
        }
        return memberFilters;
    }

    public static Map<String, Map<String, Pair<String, String>>> parserMemberMap(DynamicObject memberMapObj, DataIntegrationType type, IntegrationSchemeType scheme, SysSettingInfo sourceSetting) {
        DynamicObjectCollection memberMapRows = memberMapObj.getDynamicObjectCollection("entryentity");
        HashMap<String, Map<String, Pair<String, String>>> allMemberMap = new HashMap<String, Map<String, Pair<String, String>>>(16);
        if (EASDataIntegrationUtil.showRangeCol(type, scheme)) {
            HashSet<String> sourcesVal = new HashSet<String>(memberMapRows.size());
            HashSet<Long> sourceIds = new HashSet<Long>(16);
            String rangeVal_only = String.valueOf(RangeEnum.ONLY.getIndex());
            for (DynamicObject row : memberMapRows) {
                if (!row.getBoolean("state") || rangeVal_only.equals(row.getString("scope"))) continue;
                String sourceNumber = row.getString("sourcenumber");
                sourcesVal.add(sourceNumber);
                sourceIds.add(row.getLong("sourceid"));
            }
            HashMap<String, ThreeTuple<String, String, Integer>> _mMap = new HashMap<String, ThreeTuple<String, String, Integer>>(16);
            HashMap<String, List<String>> allChildMap = null;
            if (scheme == IntegrationSchemeType.GL && sourceSetting instanceof GlSysSetting) {
                GlSysSetting glSysSetting = (GlSysSetting)sourceSetting;
                allChildMap = EASDataIntegrationUtil.queryGlAllChildNumber(sourcesVal, sourceIds, GlBizFieldType.getTypeByFieldKey(glSysSetting.getBizField()), glSysSetting.getGlObj(), glSysSetting.getCostView());
            }
            if (allChildMap == null) {
                allChildMap = new HashMap(16);
            }
            for (DynamicObject row : memberMapRows) {
                List allChildNumbers;
                Integer range;
                if (!row.getBoolean("state")) continue;
                String sourceValNum = row.getString("sourcenumber");
                String refValNum = row.getString("assistnumber");
                String targetValNum = row.getString("targetnumber");
                String refObjNumber = row.getString("acctorgnumber");
                String refObjNumber1 = row.getString("refacctorgnumber");
                if (StringUtils.isNotEmpty((CharSequence)refObjNumber)) {
                    sourceValNum = sourceValNum + "," + refObjNumber;
                }
                if (StringUtils.isNotEmpty((CharSequence)refObjNumber1)) {
                    refValNum = refValNum + "," + refObjNumber1;
                }
                if ((range = Integer.valueOf(row.getInt("scope"))).intValue() == RangeEnum.ONLY.getIndex() || range.intValue() == RangeEnum.ALL.getIndex()) {
                    if (sourceSetting.isUseRefField()) {
                        EASDataIntegrationUtil.putMemberMapByLevel(_mMap, sourceValNum + "\u3002.&.\u3002" + refValNum, targetValNum, sourceValNum, range, allChildMap);
                    } else {
                        EASDataIntegrationUtil.putMemberMapByLevel(_mMap, sourceValNum, targetValNum, sourceValNum, range, allChildMap);
                    }
                }
                if (range.intValue() == RangeEnum.ONLY.getIndex() || (allChildNumbers = (List)allChildMap.get(sourceValNum)) == null) continue;
                for (String childNum : allChildNumbers) {
                    if (sourceSetting.isUseRefField()) {
                        EASDataIntegrationUtil.putMemberMapByLevel(_mMap, childNum + "\u3002.&.\u3002" + refValNum, targetValNum, sourceValNum, range, allChildMap);
                        continue;
                    }
                    EASDataIntegrationUtil.putMemberMapByLevel(_mMap, childNum, targetValNum, sourceValNum, range, allChildMap);
                }
            }
            HashMap mMap = new HashMap(16);
            if (_mMap.size() > 0) {
                _mMap.forEach((sourceKey, val) -> mMap.put(sourceKey, new Pair(val.item1, null)));
            }
            allMemberMap.put("", mMap);
        } else {
            for (DynamicObject row : memberMapRows) {
                if (!row.getBoolean("state")) continue;
                String sourceField = row.getString("bizfieldcol");
                Map mMap = allMemberMap.computeIfAbsent(sourceField, key -> new HashMap(16));
                String sourceVal = row.getString("sourcenumber");
                String refVal = row.getString("assistnumber");
                String targetVal = row.getString("targetnumber");
                String targetName = row.getString("targetname");
                if (sourceSetting.isUseRefField()) {
                    mMap.put(sourceVal + "\u3002.&.\u3002" + refVal, new Pair((Object)targetVal, (Object)targetName));
                    continue;
                }
                mMap.put(sourceVal, new Pair((Object)targetVal, (Object)targetName));
            }
        }
        return allMemberMap;
    }

    private static void putMemberMapByLevel(Map<String, ThreeTuple<String, String, Integer>> memberMap, String sourceVal, String targetVal, String pNumber, Integer priority, Map<String, List<String>> allChildMap) {
        ThreeTuple<String, String, Integer> tValAndPnumb = memberMap.get(sourceVal);
        if (tValAndPnumb == null) {
            memberMap.put(sourceVal, (ThreeTuple<String, String, Integer>)new ThreeTuple((Object)targetVal, (Object)pNumber, (Object)priority));
        } else {
            int size2;
            String prePNumber = (String)tValAndPnumb.item2;
            Integer prePriority = (Integer)tValAndPnumb.item3;
            List<String> prePChild = allChildMap.get(prePNumber);
            List<String> pChild = allChildMap.get(pNumber);
            int size1 = prePChild == null ? 0 : prePChild.size();
            int n = size2 = pChild == null ? 0 : pChild.size();
            if (size1 == size2 && priority < prePriority || size2 < size1) {
                memberMap.put(sourceVal, (ThreeTuple<String, String, Integer>)new ThreeTuple((Object)targetVal, (Object)pNumber, (Object)priority));
            }
        }
    }

    public static String getGlValOnRow(Map<String, Object> rowData, String fieldKey, Map<String, String> fieldKeyMap) {
        String fieldVal = null;
        if (rowData != null) {
            String glFieldKey = fieldKeyMap.get(fieldKey);
            if (glFieldKey != null) {
                fieldVal = (String)rowData.get(glFieldKey);
            } else {
                Object assgrpMap = rowData.get("assgrp");
                if (assgrpMap instanceof Map) {
                    fieldVal = (String)((Map)assgrpMap).get(fieldKey);
                }
            }
        }
        return fieldVal;
    }

    public static ConditionExecutor parserCondition(List<GLMapCondition> conditions, Map<Long, String> accountOrgInfo) {
        ConditionExecutor conditionExecutor = null;
        if (conditions != null && conditions.size() > 0) {
            conditionExecutor = ConditionExecutorFactory.getExecutor(conditions, condition -> {
                GLMapCondition mapCondition = (GLMapCondition)condition;
                DimMapConditionExecutor executor = null;
                String fieldKey = mapCondition.getField();
                boolean isAccount = mapCondition.getFieldType() == GlBizFieldType.ACCOUNT;
                Set<String> filedValNumberSet = mapCondition.getMemValues().stream().map(obj -> isAccount ? (String)accountOrgInfo.get(obj.getId()) : obj.getNumber()).collect(Collectors.toSet());
                CompareSign compareSign = mapCondition.getCompareSign();
                switch (compareSign) {
                    case in: 
                    case not_in: {
                        executor = new DimMapInConditionExecutor(fieldKey, filedValNumberSet);
                        break;
                    }
                    case equals: 
                    case not_equals: {
                        executor = new DimMapEqualsConditionExecutor(fieldKey, filedValNumberSet);
                        break;
                    }
                    case is_null: 
                    case is_notnull: {
                        executor = new DimMapNullConditionExecutor(fieldKey, filedValNumberSet);
                    }
                }
                if (executor != null) {
                    executor.setRollback(compareSign == CompareSign.not_in || compareSign == CompareSign.not_equals || compareSign == CompareSign.is_notnull);
                }
                return executor;
            });
        }
        return conditionExecutor;
    }

    public static QFilter getGlDimMemberMapFilter(DataIntegrationType integrationType, GlBizFieldType fieldType, Long glObjId, Long costViewId, Long ebModelId, Long dataSetId, Long ebDimId, List<Long> dimViewId) {
        GlSysSetting sysSetting = new GlSysSetting();
        sysSetting.setCostView(costViewId);
        sysSetting.setGlObj(glObjId);
        sysSetting.setBizField(fieldType.getFieldKey());
        return EASDataIntegrationUtil.getDimMemberMapFilter(integrationType, IntegrationSchemeType.GL, sysSetting, ebModelId, dataSetId, ebDimId, dimViewId == null ? null : dimViewId);
    }

    public static QFilter getEbDimMemberMapFilter(Long ebModelId, Long dataSetId, Long ebDimId, List<Long> dimViewId) {
        return EASDataIntegrationUtil.getDimMemberMapFilter(DataIntegrationType.OUTPUT, IntegrationSchemeType.EB, null, ebModelId, dataSetId, ebDimId, dimViewId == null ? null : dimViewId);
    }

    public static QFilter getBcmDimMemberMapFilter(DataIntegrationType integrationType, Long bcmModelId, Long bcmDimId, Long bcmDimViewId, Long ebModelId, Long dataSetId, Long ebDimId, List<Long> viewIds) {
        BcmSysSetting sysSetting = new BcmSysSetting();
        sysSetting.setModel(bcmModelId);
        sysSetting.setDim(bcmDimId);
        sysSetting.setView(bcmDimViewId);
        return EASDataIntegrationUtil.getDimMemberMapFilter(integrationType, IntegrationSchemeType.BCM, sysSetting, ebModelId, dataSetId, ebDimId, viewIds);
    }

    public static QFilter getEasDimMemberMapFilter(DataIntegrationType integrationType, Long sourceObjId, Long ebModelId, Long dataSetId, Long ebDimId, List<Long> dimViewId, String ... bizFieldKey) {
        EasSysSetting sysSetting = new EasSysSetting();
        sysSetting.setObj(sourceObjId);
        sysSetting.setFilterFields(bizFieldKey);
        return EASDataIntegrationUtil.getDimMemberMapFilter(integrationType, IntegrationSchemeType.CUSTOM, sysSetting, ebModelId, dataSetId, ebDimId, dimViewId);
    }

    public static QFilter getDimMemberMapFilter(DataIntegrationType integrationType, IntegrationSchemeType schemeType, SysSettingInfo settingInfo, Long ebModelId, Long dataSetId, Long ebDimId, List<Long> viewIds) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)ebModelId);
        Dimension dimension = modelCacheHelper.getDimension(ebDimId);
        EbSysSetting ebSysSetting = new EbSysSetting();
        ebSysSetting.setDim(ebDimId);
        if (CollectionUtils.isEmpty(viewIds) && !SysDimensionEnum.AuditTrail.getNumber().equals(dimension.getNumber())) {
            viewIds = new ArrayList<Long>(16);
            List datasetViewS = modelCacheHelper.getViewGroupViewsByDataSetAndDimNumber(dataSetId, dimension.getNumber());
            if (CollectionUtils.isNotEmpty((Collection)datasetViewS)) {
                viewIds.addAll(datasetViewS);
            }
        }
        if (viewIds != null && modelCacheHelper.getModelobj().isModelByNewEB() && !SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
            viewIds.clear();
        }
        if (dimension.getNumber().equals(SysDimensionEnum.Account.getNumber())) {
            ebSysSetting.setDataset(dataSetId);
        }
        QFilter qFilter = new QFilter("modelid", "=", (Object)ebModelId);
        if (viewIds == null || viewIds.isEmpty()) {
            ebSysSetting.setView(null);
            EASDataIntegrationUtil.addSysFilter(qFilter, integrationType, schemeType, settingInfo, ebSysSetting);
        } else {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(viewIds.size());
            for (Long viewId : viewIds) {
                QFilter temp = new QFilter("modelid", "=", (Object)ebModelId);
                ebSysSetting.setView(viewId);
                EASDataIntegrationUtil.addSysFilter(temp, integrationType, schemeType, settingInfo, ebSysSetting);
                qFilters.add(temp);
            }
            QFilter qFilter1 = null;
            for (QFilter filter : qFilters) {
                if (qFilter1 == null) {
                    qFilter1 = filter;
                    continue;
                }
                qFilter1.or(filter);
            }
            qFilter.and(qFilter1);
        }
        return qFilter;
    }

    private static void addSysFilter(QFilter temp, DataIntegrationType integrationType, IntegrationSchemeType schemeType, SysSettingInfo settingInfo, SysSettingInfo ebSysSetting) {
        if (integrationType == DataIntegrationType.OUTPUT && schemeType == IntegrationSchemeType.EB) {
            temp.and("sourcesysinfo", "like", (Object)EASDataIntegrationUtil.serSysSetting4Like(ebSysSetting, false));
        } else {
            temp.and("targetsysinfo", "like", (Object)EASDataIntegrationUtil.serSysSetting4Like(ebSysSetting, false));
            if (settingInfo instanceof EasSysSetting) {
                EasSysSetting easSysSetting = (EasSysSetting)settingInfo;
                EasSysSetting _easSysSetting = (EasSysSetting)easSysSetting.clone();
                _easSysSetting.setFilterFields(null);
                QFilter filter = new QFilter("sourcesysinfo", "like", (Object)EASDataIntegrationUtil.serSysSetting4Like(_easSysSetting, false));
                filter.and("entryentity.bizfieldcol", "in", (Object)easSysSetting.getFilterFields());
                _easSysSetting.setObj(null);
                _easSysSetting.setBizField(null);
                filter.or("sourcesysinfo", "like", (Object)EASDataIntegrationUtil.serSysSetting4Like(_easSysSetting, true));
                filter.or("sourcesysinfo", "=", (Object)" ");
                temp.and(filter);
            } else if (settingInfo != null) {
                temp.and("sourcesysinfo", "like", (Object)EASDataIntegrationUtil.serSysSetting4Like(settingInfo, false));
            }
        }
    }

    public static String parserRange2Show(List<DataIntegrationQuery> queryList, IModelCacheHelper modelCacheHelper, boolean isOut, boolean checkPerm, Long bizModelId) {
        StringBuilder sb = new StringBuilder();
        DimMembPermType checkPermType = null;
        if (checkPerm) {
            checkPermType = isOut ? DimMembPermType.READ : DimMembPermType.WRITE;
        }
        Long modelId = modelCacheHelper.getModelobj().getId();
        for (DataIntegrationQuery query : queryList) {
            String dimNumber = query.getDimNumber();
            Dimension dimension = modelCacheHelper.getDimension(dimNumber);
            if (dimension == null) {
                sb.append(dimNumber).append('\uff1a');
                sb.append(SerializationUtils.toJsonString(query.getDataIntegrationMemberPojoList()));
            } else {
                Set permMemberIds = checkPermType == null ? null : DimMembPermHelper.getPermMemberIds((String)dimNumber, (Long)modelId, (Long)bizModelId, (Long)query.getViewId(), (DimMembPermType)checkPermType, (boolean)true);
                sb.append(dimension.getName()).append('\uff1a');
                if (query.getDataIntegrationMemberPojoList().size() > 0) {
                    Long viewId = query.getViewId();
                    if (permMemberIds == null) {
                        for (DataIntegrationMemberPojo memberPojo : query.getDataIntegrationMemberPojoList()) {
                            Member member = modelCacheHelper.getMember(dimNumber, viewId, memberPojo.getMemberNumberString());
                            sb.append(memberPojo.getMemberNumberString()).append('_');
                            if (member != null) {
                                sb.append(member.getName());
                            }
                            RangeEnum rangeEnum = RangeEnum.getRangeByVal((String)memberPojo.getScopeString());
                            sb.append('(').append(rangeEnum == null ? memberPojo.getScopeString() : rangeEnum.getName()).append(')');
                            sb.append(',');
                        }
                    } else {
                        Map<Long, RangeEnum> allLegalMembers = EASDataIntegrationUtil.selRangeMemberByPerm(query, modelCacheHelper, permMemberIds);
                        allLegalMembers.forEach((memberId, range) -> {
                            Member member = modelCacheHelper.getMember(dimNumber, viewId, memberId);
                            if (member != null) {
                                sb.append(member.getNumber()).append('_');
                                sb.append(member.getName());
                            } else {
                                sb.append(memberId);
                            }
                            sb.append('(').append(range.getName()).append(')');
                            sb.append(',');
                        });
                    }
                    sb.setLength(sb.length() - 1);
                }
            }
            sb.append('\uff1b');
        }
        return sb.toString();
    }

    public static List<DataIntegrationQuery> changeRangeByPerm(List<DataIntegrationQuery> queryList, IModelCacheHelper modelCacheHelper, boolean isOut, Long bizModelId) {
        DimMembPermType checkPermType = isOut ? DimMembPermType.READ : DimMembPermType.WRITE;
        ArrayList<DataIntegrationQuery> _queryList = new ArrayList<DataIntegrationQuery>(queryList.size());
        Long modelId = modelCacheHelper.getModelobj().getId();
        for (DataIntegrationQuery memberRange : queryList) {
            Long viewId;
            String dimNumber = memberRange.getDimNumber();
            Set permMembIds = DimMembPermHelper.getPermMembIds((String)dimNumber, (Long)modelId, (Long)bizModelId, (Long)(viewId = memberRange.getViewId()), (DimMembPermType)checkPermType, (boolean)true);
            if (permMembIds == null) {
                _queryList.add(memberRange);
                continue;
            }
            Map<Long, RangeEnum> allLegalMembers = EASDataIntegrationUtil.selRangeMemberByPerm(memberRange, modelCacheHelper, permMembIds);
            DataIntegrationQuery newMemberRange = new DataIntegrationQuery();
            newMemberRange.setDimNumber(dimNumber);
            newMemberRange.setViewId(viewId);
            ArrayList<DataIntegrationMemberPojo> memberPojoList = new ArrayList<DataIntegrationMemberPojo>(allLegalMembers.size());
            allLegalMembers.forEach((memberId, range) -> {
                DataIntegrationMemberPojo memberRangeObj = new DataIntegrationMemberPojo();
                Member member = modelCacheHelper.getMember(dimNumber, viewId, memberId);
                if (member != null) {
                    memberRangeObj.setScopeString(range.getIndStr());
                    memberRangeObj.setMemberNumberString(member.getNumber());
                    memberRangeObj.setMemberIdLong((Long)memberId);
                    memberRangeObj.setDimensionNumberString(dimNumber);
                    memberPojoList.add(memberRangeObj);
                }
            });
            newMemberRange.setDataIntegrationMemberPojoList(memberPojoList);
            _queryList.add(newMemberRange);
        }
        return _queryList;
    }

    private static Map<Long, RangeEnum> selRangeMemberByPerm(DataIntegrationQuery integrationQuery, IModelCacheHelper modelCacheHelper, Set<Long> permMembIds) {
        HashMap<Long, RangeEnum> legalChildes = new HashMap<Long, RangeEnum>(16);
        HashMap<Long, RangeEnum> allLegalMembers = new HashMap<Long, RangeEnum>(16);
        String dimNumber = integrationQuery.getDimNumber();
        Long viewId = integrationQuery.getViewId();
        for (DataIntegrationMemberPojo memberPojo : integrationQuery.getDataIntegrationMemberPojoList()) {
            Member member = modelCacheHelper.getMember(dimNumber, viewId, memberPojo.getMemberNumberString());
            RangeEnum rangeEnum = RangeEnum.getRangeByVal((String)memberPojo.getScopeString());
            EASDataIntegrationUtil.checkLegality(member, permMembIds, legalChildes, rangeEnum, true);
            EASDataIntegrationUtil.mergeRangeRecord(allLegalMembers, legalChildes, modelCacheHelper, dimNumber, viewId);
            legalChildes.clear();
        }
        return allLegalMembers;
    }

    private static void mergeRangeRecord(Map<Long, RangeEnum> allLegalMembers, Map<Long, RangeEnum> legalChildes, IModelCacheHelper modelCacheHelper, String dimNumber, Long viewId) {
        if (legalChildes.size() > 0) {
            Iterator<Map.Entry<Long, RangeEnum>> entryIterator = legalChildes.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry<Long, RangeEnum> memberInfo = entryIterator.next();
                Long memberId = memberInfo.getKey();
                RangeEnum sourceRange = allLegalMembers.get(memberId);
                RangeEnum targetRange = memberInfo.getValue();
                RangeEnum newRange = null;
                if (sourceRange == null) {
                    newRange = targetRange;
                } else {
                    switch (targetRange) {
                        case ALL: {
                            newRange = targetRange;
                            break;
                        }
                        case ALL_EXCLUDE: {
                            if (sourceRange != RangeEnum.ONLY && sourceRange != RangeEnum.ALL) break;
                            newRange = RangeEnum.ALL;
                            break;
                        }
                        case ALL_DETAIL: 
                        case ALL_NOTDETAIL: {
                            if (sourceRange == RangeEnum.ONLY) {
                                EASDataIntegrationUtil.split2SingleRange(memberId, targetRange, allLegalMembers, modelCacheHelper, dimNumber, viewId);
                                newRange = sourceRange;
                                break;
                            }
                            if (sourceRange != RangeEnum.ALL_EXCLUDE && sourceRange != RangeEnum.ALL) break;
                            newRange = sourceRange;
                            break;
                        }
                        case ONLY: {
                            if (sourceRange == RangeEnum.ALL_DETAIL || sourceRange == RangeEnum.ALL_DETAIL_INCLUDE) {
                                allLegalMembers.remove(memberId);
                                EASDataIntegrationUtil.split2SingleRange(memberId, sourceRange, allLegalMembers, modelCacheHelper, dimNumber, viewId);
                                break;
                            }
                            if (sourceRange != RangeEnum.ALL_EXCLUDE && sourceRange != RangeEnum.ALL) break;
                            newRange = sourceRange;
                        }
                    }
                }
                if (newRange == null) {
                    newRange = targetRange;
                }
                allLegalMembers.put(memberId, newRange);
                entryIterator.remove();
            }
        }
    }

    private static void split2SingleRange(Long memberId, RangeEnum rangeEnum, Map<Long, RangeEnum> allMemberRange, IModelCacheHelper modelCacheHelper, String dimNumber, Long viewId) {
        List memberList = modelCacheHelper.getMember(dimNumber, viewId, memberId, rangeEnum.getIndex());
        if (memberList.size() > 0) {
            HashMap<Long, RangeEnum> singleRange = new HashMap<Long, RangeEnum>(memberList.size());
            memberList.forEach(member -> singleRange.put(member.getId(), RangeEnum.ONLY));
            singleRange.remove(memberId);
            EASDataIntegrationUtil.mergeRangeRecord(allMemberRange, singleRange, modelCacheHelper, dimNumber, viewId);
        }
    }

    private static boolean checkLegality(Member member, Set<Long> permMemberIds, Map<Long, RangeEnum> legalChildes, RangeEnum rangeEnum, boolean isFirst) {
        boolean hasPerm = false;
        boolean hasChildIllegal = false;
        HashMap<Long, RangeEnum> legalChild = new HashMap<Long, RangeEnum>(16);
        if (member != null) {
            List children;
            hasPerm = permMemberIds.contains(member.getId());
            if (rangeEnum == RangeEnum.ALL_DETAIL || rangeEnum == RangeEnum.ALL_NOTDETAIL) {
                Counter hasChildIllegalCount = new Counter();
                boolean needLeaf = rangeEnum == RangeEnum.ALL_DETAIL;
                member.iterateNoRoot(child -> {
                    if ((child.isLeaf() && needLeaf || !child.isLeaf() && !needLeaf) && !EASDataIntegrationUtil.checkLegality(child, permMemberIds, legalChild, RangeEnum.ONLY, false)) {
                        hasChildIllegalCount.addOne();
                    }
                });
                hasChildIllegal = hasChildIllegalCount.getSize() != 0;
            } else if ((rangeEnum == RangeEnum.ALL || rangeEnum == RangeEnum.ALL_EXCLUDE) && (children = member.getChildren()) != null) {
                for (Member child2 : children) {
                    if (EASDataIntegrationUtil.checkLegality(child2, permMemberIds, legalChild, RangeEnum.ALL, false)) continue;
                    hasChildIllegal = true;
                }
            }
        }
        boolean result = false;
        if (!hasChildIllegal && hasPerm) {
            legalChild.clear();
            result = true;
            if (member.isLeaf() && !isFirst) {
                legalChild.put(member.getId(), RangeEnum.ONLY);
            } else {
                legalChild.put(member.getId(), rangeEnum);
            }
        } else if (hasPerm && (RangeEnum.ALL == rangeEnum || RangeEnum.ONLY == rangeEnum)) {
            legalChild.put(member.getId(), RangeEnum.ONLY);
        }
        legalChildes.putAll(legalChild);
        return result;
    }

    public static void showExecuteRangeInfo(String scopeString, IFormView formView) {
        if (StringUtils.isBlank((CharSequence)scopeString)) {
            return;
        }
        String finalScopeString = Arrays.stream(scopeString.split("\uff1b")).map(item -> {
            int indexOfInt = item.indexOf("\uff1a");
            String dimensionNameString = item.substring(0, indexOfInt + 1);
            String memberScopeString = item.substring(indexOfInt + 1);
            return dimensionNameString + "\n" + memberScopeString;
        }).collect(Collectors.joining("\n\n", "\n", ""));
        DynamicAlertPojo dynamicAlertPojo = new DynamicAlertPojo();
        dynamicAlertPojo.setTitleString(ResManager.loadKDString((String)"\u6267\u884c\u8303\u56f4", (String)"DataIntegrationLogListPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        dynamicAlertPojo.setOperationTypeString("read_more");
        dynamicAlertPojo.setMessageString(finalScopeString);
        DynamicAlertUtils.openDynamicAlert((IFormView)formView, (DynamicAlertPojo)dynamicAlertPojo);
    }

    public static void setF7PermParam(RangeF7Param f7Param, Long modelId, boolean isInput) {
        if (CommonUtils.integraitonFilterswitch((Long)modelId)) {
            if (isInput) {
                f7Param.setPermType(DimMembPermType.WRITE);
            } else {
                f7Param.setPermType(DimMembPermType.READ);
            }
            f7Param.setNeedPermCheck(true);
        } else {
            f7Param.setNeedPermCheck(false);
        }
    }

    public static void setF7PermParam(MemberF7Parameter f7Param, Long modelId, boolean isInput) {
        if (CommonUtils.integraitonFilterswitch((Long)modelId)) {
            if (isInput) {
                f7Param.setPermType(DimMembPermType.WRITE);
            } else {
                f7Param.setPermType(DimMembPermType.READ);
            }
            f7Param.setVerifyPermission(true);
        } else {
            f7Param.setVerifyPermission(false);
        }
    }
}

