/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class EASDimUpgradeUtils {
    public static String getSyncTable(@NotNull IEASUpgradeParam param, @NotNull String tableName, boolean showException) {
        String tarName = param.getTableMap().get(tableName);
        if (tarName != null) {
            return tarName;
        }
        if (showException) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u8868%1\u4e0d\u5b58\u5728", (String)"", (String)"epm-eb-business", (Object[])new Object[]{tableName}));
        }
        return null;
    }

    public static String getSyncTable(@NotNull Long dataSourceId, @NotNull String tableName) {
        return EASDimUpgradeUtils.getSyncTable(dataSourceId, EASUpgradeUtils.getDataCenter(dataSourceId), tableName);
    }

    public static String getSyncTable(@NotNull Long dataSourceId, String dataCenter, @NotNull String tableName) {
        QFilter qFilter = new QFilter("easdbsource", "=", (Object)dataSourceId);
        qFilter.and(new QFilter("easdbcenter", "=", (Object)dataCenter));
        qFilter.and(new QFilter("srctable", "=", (Object)tableName));
        DynamicObject easTable = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_eas_table", (String)"tartable", (QFilter[])qFilter.toArray());
        if (easTable != null) {
            return easTable.getString("tartable");
        }
        throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u8868%1\u4e0d\u5b58\u5728", (String)"EASDimUpgradeUtils_1", (String)"epm-eb-business", (Object[])new Object[]{tableName}));
    }

    public static List<EASMember> getDimRefMember(@NotNull IEASUpgradeParam param, @NotNull String easSchemaId, @NotNull String dimNumber, Object[] memberTypes) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t.fid, t.fdimnumber, m.fmemberid, m.ftype from " + param.getSyncTableName("T_MBG_BGDIMSETTINGS") + " t join " + param.getSyncTableName("T_MBG_BGDIMSETTINGSMEMBER") + " m on t.fid = m.fbgdimsettingsid where t.fbgschemeid = ? and t.fdimnumber = ?", new Object[]{easSchemaId, dimNumber});
        if (memberTypes != null && memberTypes.length > 0) {
            sql.append(" and ", new Object[0]).appendIn("ftype", memberTypes);
        }
        ArrayList easMembers = Lists.newArrayListWithCapacity((int)32);
        try (DataSet ds = DB.queryDataSet((String)"queryEASDims", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    easMembers.add(EASMember.of(row));
                }
            }
        }
        return easMembers;
    }

    public static List<EASMember> getDimRefMember(@NotNull IEASUpgradeParam param, @NotNull String easSchemaId, @NotNull String dimNumber) {
        return EASDimUpgradeUtils.getDimRefMember(param, easSchemaId, dimNumber, null);
    }

    public static List<EASMember> getCusDimRefMember(@NotNull IEASUpgradeParam param, @NotNull String easSchemaId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t.fid, t.fdimnumber, m.fmemberid, m.ftype from " + param.getSyncTableName("T_MBG_BGDIMSETTINGS") + " t join " + param.getSyncTableName("T_MBG_BGDIMSETTINGSMEMBER") + " m on t.fid = m.fbgdimsettingsid where t.fbgschemeid = ? and t.fdimnumber not in (?,?,?,?,?,?,?,?)", new Object[]{easSchemaId, "BG_Organization", "BG_Account", "BG_Period", "BG_Currency", "BG_Scenario", "BG_Consolidation", "BG_Element", "BG_Version"});
        ArrayList easMembers = Lists.newArrayListWithCapacity((int)32);
        try (DataSet ds = DB.queryDataSet((String)"queryEASDims", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    easMembers.add(EASMember.of(row));
                }
            }
        }
        return easMembers;
    }

    public static boolean isCustomDim(String field) {
        if (field == null) {
            return false;
        }
        if (field.startsWith("f") || field.startsWith("F")) {
            return NumberUtils.isNumber((String)field.substring(1));
        }
        return false;
    }
}

