/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.impl.dao.EASBase;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASProperty;
import kd.epm.eb.business.easupgrade.impl.dao.EASPropertyValue;
import kd.epm.eb.common.constant.BgBaseConstant;
import org.jetbrains.annotations.NotNull;

public class EASUpgradeCheckUtils {
    public static List<String> queryNoExistParent(@NotNull IEASUpgradeParam param, @NotNull String tableName, @NotNull String viewIdField, @NotNull String viewId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fnumber from ", new Object[0]).append(param.getSyncTableName(tableName), new Object[0]);
        sql.append(" where " + viewIdField + " = ? and fparentid not in (select fid from ", new Object[0]).append(param.getSyncTableName(tableName), new Object[0]);
        sql.append(" where " + viewIdField + " = ?)", new Object[]{viewId, viewId});
        sql.append(" and fparentid is not null and fparentid <> ' '", new Object[0]);
        return EASUpgradeCheckUtils.queryNoExistParent(sql);
    }

    public static List<String> queryNoExistParent(@NotNull IEASUpgradeParam param, @NotNull String tableName, @NotNull String viewIdField, @NotNull List<String> viewIds) {
        if (viewIds.isEmpty()) {
            return Collections.emptyList();
        }
        Object[] _viewIds = viewIds.toArray(new Object[0]);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fnumber from ", new Object[0]).append(param.getSyncTableName(tableName), new Object[0]).append(" where ", new Object[0]);
        sql.appendIn(viewIdField, _viewIds);
        sql.append(" and fparentid not in (select fid from ", new Object[0]).append(param.getSyncTableName(tableName), new Object[0]).append(" where ", new Object[0]);
        sql.appendIn(viewIdField, _viewIds).append(") and fparentid is not null and fparentid <> ' '", new Object[0]);
        return EASUpgradeCheckUtils.queryNoExistParent(sql);
    }

    private static List<String> queryNoExistParent(@NotNull SqlBuilder sql) {
        LinkedList checkNumbers = Lists.newLinkedList();
        try (DataSet ds = DB.queryDataSet((String)"queryEASData", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    checkNumbers.add(row.getString("fnumber"));
                }
            }
        }
        return checkNumbers;
    }

    public static List<String> queryParentIsSelf(@NotNull IEASUpgradeParam param, @NotNull String tableName, @NotNull String viewIdField, @NotNull List<String> viewIds) {
        String syncTable = param.getSyncTableName(tableName);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fnumber from " + syncTable, new Object[0]).append("where", new Object[0]).appendIn(viewIdField, viewIds.toArray()).append(" and fid = fparentid", new Object[0]);
        LinkedList checkNumbers = Lists.newLinkedList();
        try (DataSet ds = DB.queryDataSet((String)"queryEASData", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    checkNumbers.add(row.getString("fnumber"));
                }
            }
        }
        return checkNumbers;
    }

    public static List<EASProperty> queryProperty(@NotNull IEASUpgradeParam param, EASDim easDim) {
        String syncPropTable = param.getSyncTableName("T_MBG_BGPROPERTYSORT");
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid,fnumber,fname_l1,fname_l2,fname_l3,fdescription_l1,fdescription_l2,fdescription_l3 from " + syncPropTable + " where ", new Object[0]);
        if ("BG_Organization".equals(easDim.getNumber())) {
            sql.append("fsourcetype = ?", new Object[]{"33F82845"});
        } else if ("BG_Account".equals(easDim.getNumber())) {
            sql.append("fsourcetype = ?", new Object[]{"E68E9293"});
        } else {
            sql.append("fsourcetype = ?", new Object[]{"D177852B"});
            sql.append(" and fmbgdimid = ?", new Object[]{easDim.getId()});
        }
        sql.append(" order by fnumber", new Object[0]);
        ArrayList<EASProperty> properties = new ArrayList<EASProperty>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryProperty", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    properties.add(EASProperty.of(row));
                }
            }
        }
        return properties;
    }

    public static Map<String, List<EASPropertyValue>> queryPropertyValue(@NotNull IEASUpgradeParam param, List<EASProperty> properties) {
        if (properties == null || properties.isEmpty()) {
            return Collections.emptyMap();
        }
        String syncPropValueTable = param.getSyncTableName("T_MBG_BGPROPERTY");
        Set<String> propertyIds = properties.stream().map(EASBase::getId).collect(Collectors.toSet());
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid,fnumber,fname_l1,fname_l2,fname_l3,fdescription_l1,fdescription_l2,fdescription_l3,fbgpropertysortid from " + syncPropValueTable + " where ", new Object[0]);
        sql.appendIn("fbgpropertysortid", (Object[])propertyIds.toArray(new String[propertyIds.size()]));
        sql.append(" order by fbgpropertysortid, flongnumber", new Object[0]);
        HashMap propertyValueMap = Maps.newHashMapWithExpectedSize((int)properties.size());
        try (DataSet ds = DB.queryDataSet((String)"queryProperty", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    List propertyValues = propertyValueMap.computeIfAbsent(row.getString("fbgpropertysortid"), f -> Lists.newLinkedList());
                    propertyValues.add(EASPropertyValue.of(row));
                }
            }
        }
        return propertyValueMap;
    }

    public static Map<String, Set<String>> queryPropertyRef(@NotNull IEASUpgradeParam param, Set<String> propertyValueIds) {
        if (propertyValueIds == null || propertyValueIds.isEmpty()) {
            return Collections.emptyMap();
        }
        String syncPropRefTable = param.getSyncTableName("T_MBG_PROPERTYREFSOURCE");
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fpropertyid, fsourceid from " + syncPropRefTable + " where ", new Object[0]);
        sql.appendIn("fpropertyid", (Object[])propertyValueIds.toArray(new String[propertyValueIds.size()]));
        HashMap propertyRefMap = Maps.newHashMapWithExpectedSize((int)propertyValueIds.size());
        try (DataSet ds = DB.queryDataSet((String)"queryProperty", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    Set sourceIds = propertyRefMap.computeIfAbsent(row.getString("fpropertyid"), f -> Sets.newHashSet());
                    sourceIds.add(row.getString("fsourceid"));
                }
            }
        }
        return propertyRefMap;
    }
}

