/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.utils;

import java.util.Collection;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EASUpgradeUtils {
    public static final char[] COMPLIANCE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_', '.'};
    public static final char[] COMPLIANCE1 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static void dealException(@NotNull String category, @NotNull Exception ex, @NotNull List<IEASUpgradeResult> results) {
        results.add(EASUpgradeResult.error(category, CommonServiceHelper.getStackTraceStr((Throwable)ex)));
    }

    public static void dealException(@NotNull String category, @NotNull Exception ex, @NotNull IEASUpgradeResult result) {
        result.addErrorInfo(category, ex);
    }

    public static String getName(String easName) {
        return EASUpgradeUtils.getString(easName, 50, false);
    }

    public static ILocaleString getLocaleStr(Row row, String field) {
        LocaleString value = new LocaleString();
        value.setLocaleValue_en(EASUpgradeUtils.getName(row.getString(field + "_l1")));
        value.setLocaleValue_zh_CN(EASUpgradeUtils.getName(row.getString(field + "_l2")));
        value.setLocaleValue_zh_TW(EASUpgradeUtils.getName(row.getString(field + "_l3")));
        return value;
    }

    public static ILocaleString getLocaleStr(Row row, String field, String afterPrefix) {
        if (StringUtils.isEmpty((String)afterPrefix)) {
            return EASUpgradeUtils.getLocaleStr(row, field);
        }
        int prefixLength = afterPrefix.length();
        LocaleString value = new LocaleString();
        value.setLocaleValue_en(EASUpgradeUtils.getString(row.getString(field + "_l1"), 50 - prefixLength, false) + afterPrefix);
        value.setLocaleValue_zh_CN(EASUpgradeUtils.getString(row.getString(field + "_l2"), 50 - prefixLength, false) + afterPrefix);
        value.setLocaleValue_zh_TW(EASUpgradeUtils.getString(row.getString(field + "_l3"), 50 - prefixLength, false) + afterPrefix);
        return value;
    }

    public static String getNumber(String easNumber) {
        return EASUpgradeUtils.getNumber(null, easNumber);
    }

    public static String getNumber(String prefix, String easNumber) {
        if (StringUtils.isNotEmpty((String)prefix)) {
            String _easNumber = prefix + (easNumber != null ? easNumber : "");
            return EASUpgradeUtils.getString(_easNumber, 50, true);
        }
        return EASUpgradeUtils.getString(easNumber, 50, true);
    }

    public static String getNumber1(String prefix, String easNumber) {
        if (StringUtils.isNotEmpty((String)prefix)) {
            String _easNumber = prefix + (easNumber != null ? easNumber : "");
            return EASUpgradeUtils.getString1(_easNumber, 50, true);
        }
        return EASUpgradeUtils.getString1(easNumber, 50, true);
    }

    public static String getDescription(String easNumber) {
        return EASUpgradeUtils.getString(easNumber, 255, false);
    }

    private static String getString(String str, int length, boolean hasCompliance) {
        String _str;
        String string = _str = str != null ? str.trim() : "";
        if (hasCompliance) {
            _str = _str.replaceAll(" ", "");
            _str = EASUpgradeUtils.compliance(_str, COMPLIANCE);
        }
        if (_str.length() > length) {
            return _str.substring(0, length);
        }
        return _str;
    }

    private static String getString1(String str, int length, boolean hasCompliance) {
        String _str;
        String string = _str = str != null ? str.trim().replaceAll(" ", "") : "";
        if (hasCompliance) {
            _str = EASUpgradeUtils.compliance1(_str);
        }
        if (_str.length() > length) {
            return _str.substring(0, length);
        }
        return _str;
    }

    public static String compliance(String str, char[] COMPLIANCE) {
        char[] data = new char[str.length()];
        int in = str.length();
        for (int i = 0; i < in; ++i) {
            char _char = str.charAt(i);
            boolean check = false;
            for (char c : COMPLIANCE) {
                if (_char != c) continue;
                check = true;
                break;
            }
            if (!check) {
                _char = '-';
            }
            data[i] = _char;
        }
        String _str = String.valueOf(data);
        if ("other".equalsIgnoreCase(_str) || "all".equalsIgnoreCase(_str) || "none".equalsIgnoreCase(_str) || "null".equalsIgnoreCase(_str)) {
            _str = "EAS" + _str;
        }
        return _str;
    }

    public static String compliance1(String str) {
        String _str = EASUpgradeUtils.compliance(str, COMPLIANCE1).replaceAll("-", "");
        if (Character.isDigit(_str.charAt(0))) {
            _str = "EAS" + _str;
        }
        return _str;
    }

    public static String getDataCenter(Long easDbId) {
        DynamicObject srcDataSource = BusinessDataServiceHelper.loadSingle((Object)easDbId, (String)"isc_data_source");
        long dblinkId = srcDataSource.getLong("dblink_id");
        DynamicObject dblink = BusinessDataServiceHelper.loadSingle((Object)dblinkId, (String)"isc_database_link");
        if (dblink != null) {
            return dblink.getString("data_center");
        }
        return "";
    }

    public static String getSqlInStr(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        for (String str : collection) {
            sb.append("'").append(str).append("'").append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

