/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.utils;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.dataintegration.entity.IntegrationExecStatus;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.orm.EbIntegrationLog;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.OrmBuilder;

public class IntegrationLogHelper {
    public static EbIntegrationLog getFirstLogPj(Long integrationSchemeId, IntegrationExecStatus status, String ... fields) {
        List logList = OrmBuilder.clazz(EbIntegrationLog.class).field(fields).fieldOne("fcreatedatefield").whereEqual("fintegrationid", (Object)integrationSchemeId).whereEqual("fstatus", (Object)status.getVal()).toRowList();
        EbIntegrationLog ebIntegrationLog = null;
        Long createTime = Long.MAX_VALUE;
        for (EbIntegrationLog log : logList) {
            if (log.getCreatedatefieldLong().compareTo(createTime) >= 0) continue;
            ebIntegrationLog = log;
            createTime = log.getCreatedatefieldLong();
        }
        return ebIntegrationLog;
    }

    public static boolean allInsDone(Long actionId) {
        boolean result = true;
        List<EbIntegrationLog> logPjByAction = IntegrationLogHelper.getLogPjByAction(actionId);
        for (EbIntegrationLog log : logPjByAction) {
            if (!IntegrationExecStatus.WAIT.getVal().equals(log.getStatusStr()) && !IntegrationExecStatus.ING.getVal().equals(log.getStatusStr())) continue;
            result = false;
            break;
        }
        return result;
    }

    public static List<EbIntegrationLog> getLogPjByAction(Long actionId) {
        ArrayList result = OrmBuilder.clazz(EbIntegrationLog.class).field(new String[]{"fstatus", "fintegrationid"}).whereEqual("factionid", (Object)actionId).toRowList();
        if (result == null) {
            result = new ArrayList(1);
        }
        return result;
    }

    public static void updateLogInfo(Long logId, String[] fields, Object[] values) {
        OrmBuilder.clazz(EbIntegrationLog.class).setColumnString(fields).param(values).whereEqual("fid", (Object)logId).update();
    }

    public static void markLogStatus(Long mainLogId, String logStr, IntegrationExecStatus execStatus) {
        if (logStr != null && logStr.length() > 100) {
            logStr = logStr.substring(0, 100);
        } else if (logStr == null) {
            logStr = "";
        }
        IntegrationLogHelper.updateLogInfo(mainLogId, new String[]{"fstatus", "flogstr", "fmodifydatefield"}, new Object[]{execStatus.getVal(), logStr, TimeServiceHelper.now()});
    }

    public static void markLogStatus(Long mainLogId, IntegrationExecStatus execStatus) {
        IntegrationLogHelper.markLogStatus(mainLogId, null, execStatus);
    }

    public static void delDetailLogByIntegration(Long integrationId) {
        if (IDUtils.isNotNull((Long)integrationId)) {
            String sql = "delete from t_eb_integration_logdet where fintegrationid = " + integrationId;
            DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)sql, null);
        }
    }
}

