/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.context;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.eb.business.ebupgrades.constants.DelRefKeyEnum;
import kd.epm.eb.business.ebupgrades.context.OldDataContext;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.pojo.BasedataPojo;

public class ModelContext {
    private Model modelCache;
    private BasedataPojo defaultBusModel;
    private BasedataPojo defaultDataset;
    private final Map<String, OldDataContext> oldDataContextMap = new HashMap<String, OldDataContext>(16);
    private final Map<String, Map<String, Object>> delDataMap = new HashMap<String, Map<String, Object>>(16);

    public Model getModelCache() {
        return this.modelCache;
    }

    public void setModelCache(Model modelCache) {
        this.modelCache = modelCache;
    }

    public BasedataPojo getDefaultBusModel() {
        return this.defaultBusModel;
    }

    public void setDefaultBusModel(BasedataPojo defaultBusModel) {
        this.defaultBusModel = defaultBusModel;
    }

    public BasedataPojo getDefaultDataset() {
        return this.defaultDataset;
    }

    public void setDefaultDataset(BasedataPojo defaultDataset) {
        this.defaultDataset = defaultDataset;
    }

    public OldDataContext getOldDataContext(String table) {
        return this.oldDataContextMap.get(table);
    }

    public void putOldDataContext(OldDataContext oldDataContext) {
        String table = oldDataContext.getTable();
        this.oldDataContextMap.put(table, oldDataContext);
    }

    public Map<String, Map<String, Object>> getDelDataMap() {
        return this.delDataMap;
    }

    public void addDelDataMap(DelRefKeyEnum delRefKey, Map<String, Object> dataMap) {
        this.delDataMap.put(delRefKey.getVal(), dataMap);
    }

    @SafeVarargs
    public final <T> Object getRefDelDataObject(DelRefKeyEnum delRefKey, T ... keys) {
        String refKey;
        Map<String, Object> delData = this.delDataMap.get(delRefKey.getVal());
        if (delData.size() == 0 || keys.length <= 0) {
            return null;
        }
        if (keys.length == 1) {
            refKey = String.valueOf(keys[0]);
        } else {
            List<T> idList = Arrays.asList(keys);
            refKey = idList.stream().map(String::valueOf).collect(Collectors.joining("!"));
        }
        return delData.get(refKey);
    }
}

