/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.interfaces;

import java.util.HashSet;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.ebupgrades.constants.TaskStatus;
import kd.epm.eb.business.ebupgrades.context.GroupContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;

public abstract class AbstractUpgradesTask {
    private StringBuffer logInfo = new StringBuffer();
    private UpgradesContext globalContext;
    private GroupContext groupContext;
    private TaskStatus status;
    private Set<Long> sussedModelIds = new HashSet<Long>(16);
    private String taskKey;
    private static final Log abstractUpgradesTaskLog = LogFactory.getLog(AbstractUpgradesTask.class);

    public AbstractUpgradesTask() {
        this.status = TaskStatus.NULL;
    }

    public final void setGlobalContext(UpgradesContext globalContext) {
        this.globalContext = globalContext;
    }

    public UpgradesContext getGlobalContext() {
        return this.globalContext;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void updateStatus(TaskStatus status) {
        this.status = status;
    }

    public void markModelOk(Long modelId) {
        this.sussedModelIds.add(modelId);
    }

    public Set<Long> getSussedModelIds() {
        return this.sussedModelIds;
    }

    public void setTaskKey(String taskKey) {
        this.taskKey = taskKey;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public abstract void backData();

    public abstract void execute();

    public abstract void rollBack();

    public abstract void release();

    public abstract void loadData();

    public final void doRelease() {
        try {
            this.release();
        }
        catch (Throwable throwable) {
            abstractUpgradesTaskLog.error("doRelease", throwable);
        }
    }

    public final GroupContext getGroupContext() {
        return this.groupContext;
    }

    public final void setGroupContext(GroupContext groupContext) {
        this.groupContext = groupContext;
    }

    public final void addLogInfo(String info) {
        int freeLength = 2000 - this.logInfo.length();
        if (freeLength > 0) {
            if (info.length() > freeLength) {
                info = info.substring(0, freeLength);
            }
            this.logInfo.append(info);
        }
    }

    public final void clearLogInfo() {
        this.logInfo.setLength(0);
    }

    public final String getLogInfo() {
        return this.logInfo.toString();
    }
}

