/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.business.ebupgrades.context.GroupContext;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.business.ebupgrades.pojo.AdjustBillRecord;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.CollectionUtils;

public class AdjustBillUpgradeTask
extends AbstractUpgradesTask {
    private static final Log log = LogFactory.getLog(AdjustBillUpgradeTask.class);
    private static final String PARAM_KEY = "adjust_bill";
    private static final String T_EB_ADJUST_BILL = "t_eb_adjustbill";
    private static final String T_EB_ADJUST_DETAIL = "t_eb_adjdetail";
    private static final String T_EB_ADJUSTBILL_BP = "t_eb_adjustbill_bp";
    private static final String T_EB_ADJUST_PROJECT = "t_eb_adjustproject";

    @Override
    public void backData() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        log.info("[AdjustBillUpgradeTask#backData] start getAdjustBillMap");
        Map<Long, AdjustBillRecord> adjustBillMap = this.getAdjustBillMap(context);
        log.info("[AdjustBillUpgradeTask#backData] end getAdjustBillMap, size={}", (Object)adjustBillMap.size());
        if (adjustBillMap.isEmpty()) {
            return;
        }
        GroupContext groupContext = this.getGroupContext();
        groupContext.addParam(PARAM_KEY, adjustBillMap);
        log.info("[AdjustBillUpgradeTask#backData] start backup t_eb_adjustbill");
        UpgradesTaskUtil.getInstance().backupsDataByIds(T_EB_ADJUST_BILL, toUpModelIds, "fmodel");
        log.info("[AdjustBillUpgradeTask#backData] end backup t_eb_adjustbill");
        log.info("[AdjustBillUpgradeTask#backData] start backup t_eb_adjdetail");
        UpgradesTaskUtil.getInstance().backupsDataByIds(T_EB_ADJUST_DETAIL, adjustBillMap.keySet());
        log.info("[AdjustBillUpgradeTask#backData] end backup t_eb_adjdetail");
        log.info("[AdjustBillUpgradeTask#backData] start backup t_eb_adjustproject");
        UpgradesTaskUtil.getInstance().backupsDataByIds(T_EB_ADJUST_PROJECT, toUpModelIds, "fmodel");
        log.info("[AdjustBillUpgradeTask#backData] start backup t_eb_adjustproject");
    }

    @Override
    public void execute() {
        GroupContext groupContext = this.getGroupContext();
        Map adjustBillMap = (Map)groupContext.getParam(PARAM_KEY);
        if (adjustBillMap == null || adjustBillMap.isEmpty()) {
            return;
        }
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(toUpModelIds.size());
        ArrayList<Object[]> sqlProjectParams = new ArrayList<Object[]>(toUpModelIds.size());
        for (Map.Entry entry : adjustBillMap.entrySet()) {
            AdjustBillRecord adjustBill = (AdjustBillRecord)entry.getValue();
            sqlParams.add(new Object[]{adjustBill.getBizModelId(), adjustBill.getModelId()});
            sqlProjectParams.add(new Object[]{adjustBill.getMetricId(), adjustBill.getBizModelId(), adjustBill.getModelId()});
        }
        log.info("[AdjustBillUpgradeTask#execute] start update t_eb_adjustbill");
        String updateSql = "update t_eb_adjustbill set fyear=0, fbizmodelid=? where fmodel=?";
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)updateSql, sqlParams);
        log.info("[AdjustBillUpgradeTask#execute] end update t_eb_adjustbill");
        log.info("[AdjustBillUpgradeTask#execute] start update t_eb_adjustproject");
        String updateProjectSql = "update t_eb_adjustproject set fmetricid=?, fbizmodelid=? where fmodel=?";
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)updateProjectSql, sqlProjectParams);
        log.info("[AdjustBillUpgradeTask#execute] end update t_eb_adjustproject");
        ArrayList<Object[]> sqlDetailParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> sqlPeriodParams = new ArrayList<Object[]>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fentryid, fperiod from ", new Object[0]).append(T_EB_ADJUST_DETAIL, new Object[0]).append(" where ", new Object[0]);
        sql.appendIn("fid", adjustBillMap.keySet().toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryBillDetail", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            HashSet<String> idAndBaseDataIds = new HashSet<String>(16);
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long fid = row.getLong("fid");
                Long entryId = row.getLong("fentryid");
                AdjustBillRecord adjustBill = (AdjustBillRecord)adjustBillMap.get(fid);
                Long yearId = adjustBill.getYearId();
                ModelContext modelContext = context.getModelInfo(adjustBill.getModelId());
                String yearNumber = "";
                List<DynamicObject> oldYears = modelContext.getOldDataContext(SysDimensionEnum.Year.getMemberTreemodel()).getOldData();
                for (DynamicObject year : oldYears) {
                    Long id = year.getLong("id");
                    if (!id.equals(yearId)) continue;
                    yearNumber = year.getString("number");
                    break;
                }
                Long periodId = row.getLong("fperiod");
                String periodNumber = "";
                List<DynamicObject> oldPeriods = modelContext.getOldDataContext(SysDimensionEnum.Period.getMemberTreemodel()).getOldData();
                for (DynamicObject period : oldPeriods) {
                    Long id = period.getLong("id");
                    if (!id.equals(periodId)) continue;
                    periodNumber = period.getString("number");
                    break;
                }
                StringBuilder budgetPeriods = new StringBuilder(yearNumber);
                budgetPeriods.append(".").append(periodNumber.substring(periodNumber.indexOf("_") + 1));
                Dimension budgetPeriodDimension = modelContext.getModelCache().getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
                Member budgetPeriodMember = budgetPeriodDimension.getMember(Long.valueOf(0L), budgetPeriods.toString());
                long budgetPeriodId = 0L;
                if (budgetPeriodMember != null) {
                    budgetPeriodId = budgetPeriodMember.getId();
                }
                Long metricId = adjustBill.getMetricId();
                sqlDetailParams.add(new Object[]{metricId, budgetPeriodId, entryId});
                if (!idAndBaseDataIds.add(fid + "_" + budgetPeriodId)) continue;
                sqlPeriodParams.add(new Object[]{fid, DBServiceHelper.genGlobalLongId(), budgetPeriodId});
            }
        }
        log.info("[AdjustBillUpgradeTask#execute] start update t_eb_adjdetail");
        String updateDetailSql = "update t_eb_adjdetail set fperiod=0, fmetric=?, fbudgetperiod=? where fentryid=?";
        if (CollectionUtils.isNotEmpty(sqlDetailParams)) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)updateDetailSql, sqlDetailParams);
        }
        log.info("[AdjustBillUpgradeTask#execute] end update t_eb_adjdetail");
        log.info("[AdjustBillUpgradeTask#execute] start insert t_eb_adjustbill_bp");
        String insertPeriodSql = "insert into t_eb_adjustbill_bp(fid,fpkid,fbasedataid) values (?,?,?)";
        if (CollectionUtils.isNotEmpty(sqlPeriodParams)) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)insertPeriodSql, sqlPeriodParams);
        }
        log.info("[AdjustBillUpgradeTask#execute] end insert t_eb_adjustbill_bp");
        try (TXHandle tx = TX.requiresNew((String)"sys_attachmemt: adjust");){
            try {
                ArrayList<Object[]> attachmentParams = new ArrayList<Object[]>(16);
                String entity = "eb_adjustbill_nbg";
                for (Long aLong : adjustBillMap.keySet()) {
                    Object[] objects = new Object[]{entity, aLong + ""};
                    attachmentParams.add(objects);
                }
                DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)"update t_bas_attachment set fbilltype =? where finterid in (?)", attachmentParams);
            }
            catch (Throwable ex) {
                tx.markRollback();
                throw ex;
            }
        }
    }

    @Override
    public void rollBack() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        Map<Long, AdjustBillRecord> adjustBillMap = this.getAdjustBillMap(context);
        if (adjustBillMap == null || adjustBillMap.isEmpty()) {
            return;
        }
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        log.info("[AdjustBillUpgradeTask#rollBack] start rollback t_eb_adjustbill");
        QFilter qFilter = new QFilter("fid", "in", adjustBillMap.keySet());
        instance.delDataWithoutRef(T_EB_ADJUST_BILL, qFilter.toString());
        instance.reCoverFromBak(T_EB_ADJUST_BILL, adjustBillMap.keySet());
        log.info("[AdjustBillUpgradeTask#rollBack] end rollback t_eb_adjustbill");
        log.info("[AdjustBillUpgradeTask#rollBack] start rollback t_eb_adjdetail");
        instance.delDataWithoutRef(T_EB_ADJUST_DETAIL, qFilter.toString());
        instance.reCoverFromBak(T_EB_ADJUST_DETAIL, adjustBillMap.keySet());
        log.info("[AdjustBillUpgradeTask#rollBack] end rollback t_eb_adjdetail");
        log.info("[AdjustBillUpgradeTask#rollBack] start rollback t_eb_adjustbill_bp");
        instance.delDataWithoutRef(T_EB_ADJUSTBILL_BP, qFilter.toString());
        log.info("[AdjustBillUpgradeTask#rollBack] end rollback t_eb_adjustbill_bp");
        QFilter projectFilter = new QFilter("fmodel", "in", toUpModelIds);
        instance.delDataWithoutRef(T_EB_ADJUST_PROJECT, projectFilter.toString());
        instance.reCoverFromBak(T_EB_ADJUST_PROJECT, toUpModelIds, "fmodel");
        try (TXHandle tx = TX.requiresNew((String)"sys_attachmemt: adjustRollBack");){
            try {
                ArrayList<Object[]> attachmentParams = new ArrayList<Object[]>(16);
                String entity = "eb_adjustbill";
                for (Long aLong : adjustBillMap.keySet()) {
                    Object[] objects = new Object[]{entity, aLong + ""};
                    attachmentParams.add(objects);
                }
                DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)"update t_bas_attachment set fbilltype =? where finterid in (?)", attachmentParams);
            }
            catch (Throwable ex) {
                tx.markRollback();
                throw ex;
            }
        }
    }

    @Override
    public void release() {
    }

    @Override
    public void loadData() {
    }

    private Map<Long, AdjustBillRecord> getAdjustBillMap(UpgradesContext context) {
        List<Long> toUpModelIds = context.getToUpModelIds();
        HashMap<Long, AdjustBillRecord> adjustBillMap = new HashMap<Long, AdjustBillRecord>(toUpModelIds.size());
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fyear, fmodel from ", new Object[0]).append(T_EB_ADJUST_BILL, new Object[0]).append(" where ", new Object[0]);
        sql.appendIn("fmodel", toUpModelIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryAdjustBill", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long fid = row.getLong("fid");
                Long yearId = row.getLong("fyear");
                Long modelId = row.getLong("fmodel");
                Long bizModelId = 0L;
                Long metricId = 0L;
                ModelContext modelContext = context.getModelInfo(modelId);
                if (modelContext != null) {
                    BasedataPojo bizModel = modelContext.getDefaultBusModel();
                    bizModelId = bizModel.getId();
                    Dimension metricDimension = modelContext.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber());
                    metricId = metricDimension.getMember(Long.valueOf(0L), "Money").getId();
                }
                AdjustBillRecord adjustBill = new AdjustBillRecord();
                adjustBill.setFid(fid);
                adjustBill.setModelId(modelId);
                adjustBill.setBizModelId(bizModelId);
                adjustBill.setYearId(yearId);
                adjustBill.setMetricId(metricId);
                adjustBillMap.put(fid, adjustBill);
            }
        }
        return adjustBillMap;
    }
}

