/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.ebupgrades.constants.DelRefKeyEnum;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.context.OldDataContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.business.ebupgrades.utils.DataLockUpgradesUtil;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.BasedataPojo;
import org.apache.commons.collections4.CollectionUtils;

public class DataLockUpgradesTask
extends AbstractUpgradesTask {
    private static final String OldMeta = "eb_datalock";
    private static final String NewMeta = "bgmd_datalock";
    private static final String Old_Table = "t_eb_datalock";
    private static final String New_Table = "t_bgmd_datalock";
    private static final Log log = LogFactory.getLog(DataLockUpgradesTask.class);

    @Override
    public void backData() {
        List<Long> toUpModelIds = this.getGlobalContext().getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        instance.backupsDataByIds(Old_Table, toUpModelIds, "fmodelid");
    }

    @Override
    public void execute() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        DynamicObjectCollection oldDataLockObjects = QueryServiceHelper.query((String)OldMeta, (String)"model.id,year.id,currency.id,currency.number,version.id,version.number,entity.number,periodbinary", (QFilter[])new QFilter("model", "in", toUpModelIds).toArray());
        this.addLogInfo("DataLockUpgradesTask.oldDataLockObjects.size:" + oldDataLockObjects.size());
        if (CollectionUtils.isEmpty((Collection)oldDataLockObjects)) {
            return;
        }
        List<DynamicObject> newDataLockObjects = this.packageNewDataLockObjects(oldDataLockObjects, context, toUpModelIds);
        this.addLogInfo("DataLockUpgradesTask.newDataLockObjects.size:" + newDataLockObjects.size());
        if (newDataLockObjects.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newDataLockObjects.toArray(new DynamicObject[0]));
        }
        this.delOldDataLockData();
    }

    @Override
    public void rollBack() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        String filterParam = new QFilter("fmodelid", "in", toUpModelIds).toString();
        this.delNewDataLockObjects(toUpModelIds);
        instance.reCoverFromBak(Old_Table, filterParam);
        instance.clearDataEntityCache(NewMeta);
    }

    @Override
    public void release() {
    }

    @Override
    public void loadData() {
    }

    private void delNewDataLockObjects(List<Long> toUpModelIds) {
        DeleteServiceHelper.delete((String)NewMeta, (QFilter[])new QFilter("model", "in", toUpModelIds).toArray());
    }

    private List<DynamicObject> packageNewDataLockObjects(DynamicObjectCollection oldDataLockObjects, UpgradesContext context, List<Long> toUpModelIds) {
        ArrayList<DynamicObject> newDataLockObjects = new ArrayList<DynamicObject>(10);
        DataLockUpgradesUtil instance = DataLockUpgradesUtil.getInstance();
        ArrayList allDataTypeMembers = new ArrayList(10);
        ArrayList allAutMembers = new ArrayList(10);
        HashMap oldPeriodData = new HashMap(16);
        toUpModelIds.forEach(modelId -> {
            ModelContext modelContext = context.getModelInfo((Long)modelId);
            Model modelCache = modelContext.getModelCache();
            Dimension dataTypeDim = modelCache.getDimension(SysDimensionEnum.DataType.getNumber());
            List dataTypeLeafMembers = dataTypeDim.getLeafMembers();
            allDataTypeMembers.addAll(dataTypeLeafMembers);
            Dimension autDim = modelCache.getDimension(SysDimensionEnum.AuditTrail.getNumber());
            List autLeafMembers = autDim.getLeafMembers();
            allAutMembers.addAll(autLeafMembers);
            List<DynamicObject> sortOldPeriodData = instance.getSortOldPeriodData(modelContext);
            oldPeriodData.put(modelId, sortOldPeriodData);
        });
        this.addLogInfo("DataLockUpgradesTask.oldPeriodData:" + SerializationUtils.toJsonString(oldPeriodData.keySet()));
        for (DynamicObject oldDataLockObject : oldDataLockObjects) {
            Long modelId2 = oldDataLockObject.getLong("model.id");
            Long yearId = oldDataLockObject.getLong("year.id");
            Long versionId = oldDataLockObject.getLong("version.id");
            String entityNumber = oldDataLockObject.getString("entity.number");
            Integer periodInteger = oldDataLockObject.getInt("periodbinary");
            ModelContext modelContext = context.getModelInfo(modelId2);
            DynamicObject dataLockObject = BusinessDataServiceHelper.newDynamicObject((String)NewMeta);
            dataLockObject.set("model_id", (Object)modelId2);
            BasedataPojo defaultBusModel = modelContext.getDefaultBusModel();
            Long bizModelId = defaultBusModel.getId();
            dataLockObject.set("businessmodel_id", (Object)bizModelId);
            Object periodMember = modelContext.getRefDelDataObject(DelRefKeyEnum.BUDGET_PERIOD, yearId);
            if (periodMember == null) {
                this.addLogInfo("DataLockUpgradesTask.getYearNumber err !:" + yearId);
                throw new KDBizException("getYearNumber err !");
            }
            if (periodMember instanceof Member) {
                dataLockObject.set("year_id", (Object)((Member)periodMember).getId());
            }
            dataLockObject.set("version_id", (Object)versionId);
            dataLockObject.set("entity", (Object)entityNumber);
            dataLockObject.set("periodinteger", (Object)instance.getNewPeriodInteger(periodInteger, (List)oldPeriodData.get(modelId2)));
            for (Member dataType : allDataTypeMembers) {
                for (Member auditTrail : allAutMembers) {
                    DynamicObject _dataLock = (DynamicObject)OrmUtils.clone((IDataEntityBase)dataLockObject, (boolean)true, (boolean)true);
                    newDataLockObjects.add(_dataLock);
                    _dataLock.set("datatype_id", (Object)dataType.getId());
                    _dataLock.set("audittrail_id", (Object)auditTrail.getId());
                }
            }
        }
        return newDataLockObjects;
    }

    private void delOldDataLockData() {
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        OldDataContext oldDataContext = new OldDataContext();
        oldDataContext.setTable(OldMeta);
        oldDataContext.setSelectFields(this.getOldMetaSelectFields());
        QFilter qf = new QFilter("model", "in", toUpModelIds);
        Map<Long, List<DynamicObject>> toDelDataMap = instance.queryAndFillDataContextByOrm(oldDataContext, qf);
        this.addLogInfo("DataLockUpgradesTask.toDelDataMap:" + SerializationUtils.toJsonString(toDelDataMap.keySet()));
        toUpModelIds.forEach(e -> {
            ModelContext modelInfo = context.getModelInfo((Long)e);
            OldDataContext oldDataContext_copy = instance.copyOldDataContext(oldDataContext);
            oldDataContext_copy.setOldData((List)toDelDataMap.get(e));
            modelInfo.putOldDataContext(oldDataContext_copy);
        });
        String filterParam = new QFilter("fmodelid", "in", toUpModelIds).toString();
        instance.delDataWithoutRef(Old_Table, filterParam);
        instance.clearDataEntityCache(OldMeta);
    }

    private List<String> getOldMetaSelectFields() {
        ArrayList<String> selectFields = new ArrayList<String>(10);
        selectFields.add("year");
        selectFields.add("currency");
        selectFields.add("version");
        selectFields.add("entity");
        selectFields.add("periodbinary");
        return selectFields;
    }
}

