/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.ApplicationScenarioEnum;
import kd.epm.eb.common.enums.BizModelEnum;
import kd.epm.eb.common.enums.DimensionViewEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.ChangeTypeFormulaEnum;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;

public class DefaultBaseDataUpgradesTask
extends AbstractUpgradesTask {
    private static final List<String> changeTypeNumbers = Arrays.asList("CurrentPeriod", "EndingBalance", "EBChanges", "Occupation", "Execute");
    private static final String ApplicationScenario = "t_eb_applicationscenario";
    private static final String View = "t_eb_dimensionview";
    private static final String BizModel = "t_eb_businessmodel";
    private static final String DataSetCatalog = "t_eb_datasetcatalog";
    private static final String DataSet = "t_eb_dataset";

    @Override
    public void backData() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        qFilter.and("fnumber", "in", changeTypeNumbers);
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        String table = SysDimensionEnum.ChangeType.getMemberTreetable();
        instance.backupsData(table, qFilter.toString());
    }

    @Override
    public void execute() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        Map<Long, List<Long>> ids = this.createDefaultApplicationScenario(toUpModelIds);
        Map<Long, Map<Long, Long>> viewMap = this.createDefaultView(context);
        this.changeTypePresetData(toUpModelIds, viewMap);
        this.createDefaultBizModel(toUpModelIds, ids, viewMap);
        this.createDefaultDataSets(toUpModelIds);
        toUpModelIds.forEach(e -> {
            ModelCacheContext.removeModel((Long)e);
            CubeUtils.updateCubeVersion((Long)e);
        });
    }

    private Map<Long, List<Long>> createDefaultApplicationScenario(List<Long> toUpModelIds) {
        List list = ApplicationScenarioEnum.getAll();
        list.remove(ApplicationScenarioEnum.ROLLBUDGET);
        ArrayList<DynamicObject> save = new ArrayList<DynamicObject>(16);
        HashMap<Long, List<Long>> idMap = new HashMap<Long, List<Long>>(16);
        for (Long toUpModelId : toUpModelIds) {
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (ApplicationScenarioEnum applicationScenarioEnum : list) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_applicationscenario");
                long id = GlobalIdUtil.genGlobalLongId();
                dynamicObject.set("id", (Object)id);
                dynamicObject.set("number", (Object)applicationScenarioEnum.getNumber());
                dynamicObject.set("name", (Object)LanguageUtils.getLocaleValue((String)applicationScenarioEnum.getName(), (String)applicationScenarioEnum.getNameKey().getResourceID(), (String)"epm-eb-common"));
                dynamicObject.set("model", (Object)toUpModelId);
                dynamicObject.set("creator", (Object)UserUtils.getUserId());
                dynamicObject.set("createtime", (Object)TimeServiceHelper.now());
                dynamicObject.set("modifier", (Object)UserUtils.getUserId());
                dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
                dynamicObject.set("issyspreset", (Object)applicationScenarioEnum.getIsSysPreset());
                dynamicObject.set("description", (Object)"");
                save.add(dynamicObject);
                ids.add(id);
            }
            idMap.put(toUpModelId, ids);
        }
        SaveServiceHelper.save((DynamicObject[])save.toArray(new DynamicObject[0]));
        return idMap;
    }

    private Map<Long, Map<Long, Long>> createDefaultView(UpgradesContext context) {
        HashMap<Long, Map<Long, Long>> idModelMap = new HashMap<Long, Map<Long, Long>>(16);
        ArrayList<DynamicObject> save = new ArrayList<DynamicObject>(16);
        List<Long> toUpModelIds = context.getToUpModelIds();
        for (Long toUpModelId : toUpModelIds) {
            ModelContext modelInfo = context.getModelInfo(toUpModelId);
            HashMap<String, String> definedNameMap = new HashMap<String, String>(16);
            Map<String, Long> dimMap = this.getDimensionIdMap(modelInfo.getModelCache(), definedNameMap);
            if (dimMap.size() == 0) continue;
            HashMap<Long, Long> idMap = new HashMap<Long, Long>(16);
            for (Map.Entry<String, Long> dimEntry : dimMap.entrySet()) {
                String number = dimEntry.getKey();
                Long dimId = dimEntry.getValue();
                DimensionViewEnum dimensionViewEnum = DimensionViewEnum.getByDimNumber((String)number);
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview");
                long id = GlobalIdUtil.genGlobalLongId();
                dynamicObject.set("id", (Object)id);
                dynamicObject.set("number", (Object)number);
                dynamicObject.set("name", dimensionViewEnum != null ? LanguageUtils.getLocaleValue((String)dimensionViewEnum.getName(), (String)dimensionViewEnum.getNameKey().getResourceID(), (String)"epm-eb-common") : definedNameMap.get(number));
                dynamicObject.set("model", (Object)toUpModelId);
                dynamicObject.set("dimension", (Object)dimId);
                dynamicObject.set("level", (Object)1);
                dynamicObject.set("dseq", (Object)1);
                dynamicObject.set("longnumber", (Object)("!" + number));
                dynamicObject.set("isleaf", (Object)true);
                dynamicObject.set("source", (Object)1);
                dynamicObject.set("parent", (Object)0L);
                dynamicObject.set("usage", (Object)"0");
                dynamicObject.set("baseview", (Object)0L);
                dynamicObject.set("creater", (Object)UserUtils.getUserId());
                dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
                dynamicObject.set("modifier", (Object)UserUtils.getUserId());
                dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
                dynamicObject.set("description", (Object)"");
                idMap.put(dimId, id);
                save.add(dynamicObject);
            }
            idModelMap.put(toUpModelId, idMap);
        }
        SaveServiceHelper.save((DynamicObject[])save.toArray(new DynamicObject[0]));
        return idModelMap;
    }

    private void changeTypePresetData(List<Long> toUpModelIds, Map<Long, Map<Long, Long>> viewMap) {
        QFBuilder qfBuilder = new QFBuilder("model", "in", toUpModelIds);
        qfBuilder.add("number", "in", changeTypeNumbers);
        DynamicObject[] members = BusinessDataServiceHelper.load((String)"epm_changetypemembertree", (String)"id,number,isPeriodDistribution,model.id,dimension.id,view,entryentity_formul,entryentity_formul.formulview,entryentity_formul.formula,entryentity_formul.formulaname", (QFilter[])qfBuilder.toArray());
        HashMap<Long, Long> curViewMap = new HashMap<Long, Long>(16);
        for (DynamicObject member : members) {
            List formulaData;
            Long modelId = member.getLong("model.id");
            Long dimensionId = members[0].getLong("dimension.id");
            Long viewId = this.getViewId(viewMap, curViewMap, modelId, dimensionId);
            String number = member.getString("number");
            if ("CurrentPeriod".equals(number)) {
                member.set("isPeriodDistribution", (Object)true);
            }
            if ((formulaData = ChangeTypeFormulaEnum.getFormulaData((String)number)) != null) {
                DynamicObjectCollection entryentity_formul = member.getDynamicObjectCollection("entryentity_formul");
                DynamicObject object = entryentity_formul.addNew();
                object.set("formulview", (Object)viewId);
                object.set("formula", formulaData.get(0));
                object.set("formulaname", formulaData.get(1));
                continue;
            }
            member.set("view", (Object)viewId);
        }
        SaveServiceHelper.save((DynamicObject[])members);
    }

    private void createDefaultBizModel(List<Long> toUpModelIds, Map<Long, List<Long>> idsMap, Map<Long, Map<Long, Long>> viewMap) {
        if (idsMap == null || idsMap.size() == 0) {
            return;
        }
        UpgradesContext globalContext = this.getGlobalContext();
        long[] pkIds = DB.genGlobalLongIds((int)toUpModelIds.size());
        ArrayList<DynamicObject> toSave = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < toUpModelIds.size(); ++i) {
            Long toUpModelId = toUpModelIds.get(i);
            List<Long> ids = idsMap.get(toUpModelId);
            ModelContext modelInfo = globalContext.getModelInfo(toUpModelId);
            BizModelEnum bizModelEnum = BizModelEnum.AUNNALBUDGET;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_businessmodel");
            dynamicObject.set("id", (Object)pkIds[i]);
            dynamicObject.set("number", (Object)bizModelEnum.getNumber());
            dynamicObject.set("name", (Object)LanguageUtils.getLocaleValue((String)bizModelEnum.getName(), (String)bizModelEnum.getNameKey().getResourceID(), (String)"epm-eb-common"));
            dynamicObject.set("model", (Object)toUpModelId);
            dynamicObject.set("creater", (Object)UserUtils.getUserId());
            dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
            dynamicObject.set("modifier", (Object)UserUtils.getUserId());
            dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
            dynamicObject.set("issyspreset", (Object)bizModelEnum.getIsSysPreset());
            DynamicObjectCollection appscenarios = dynamicObject.getDynamicObjectCollection("scenarioentry");
            Map<Long, Long> viewIdMap = viewMap.get(toUpModelId);
            for (Long id : ids) {
                DynamicObject row = appscenarios.addNew();
                DynamicObject appscenario = BusinessDataServiceHelper.newDynamicObject((String)"eb_applicationscenario");
                appscenario.set("id", (Object)id);
                row.set("appscenario", (Object)appscenario);
            }
            DynamicObjectCollection viewEntry = dynamicObject.getDynamicObjectCollection("viewentry");
            List dimensions = modelInfo.getModelCache().getDimension();
            for (Dimension dim : dimensions) {
                Long id = dim.getId();
                DynamicObject row = viewEntry.addNew();
                DynamicObject dimension = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
                dimension.set("id", (Object)id);
                row.set("dimension", (Object)dimension);
                if (!viewIdMap.containsKey(id)) continue;
                DynamicObject view = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview");
                view.set("id", (Object)viewIdMap.get(id));
                row.set("view", (Object)view);
            }
            toSave.add(dynamicObject);
            modelInfo.setDefaultBusModel(this.getBaseDataPojo(dynamicObject));
        }
        SaveServiceHelper.save((DynamicObject[])toSave.toArray(new DynamicObject[0]));
    }

    private void createDefaultDataSets(List<Long> toUpModelIds) {
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(16);
        ArrayList<DynamicObject> saveCatalog = new ArrayList<DynamicObject>(16);
        long[] pkIds = DB.genGlobalLongIds((int)(toUpModelIds.size() * 2));
        for (int i = 0; i < toUpModelIds.size(); ++i) {
            Long toUpModelId = toUpModelIds.get(i);
            Long rootId = pkIds[i * 2];
            String name = ResManager.loadKDString((String)"\u6570\u636e\u96c6", (String)"DefaultBaseDataUpgradesTask_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            saveCatalog.add(this.createDefaultNode(toUpModelId, rootId, "datasetroot", name, 0L));
            Long defaultCatalog = pkIds[i * 2 + 1];
            name = ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u7c7b", (String)"DefaultBaseDataUpgradesTask_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            saveCatalog.add(this.createDefaultNode(toUpModelId, defaultCatalog, "default", name, rootId));
            idMap.put(toUpModelId, defaultCatalog);
        }
        SaveServiceHelper.save((DynamicObject[])saveCatalog.toArray(new DynamicObject[0]));
        this.createDefaultDataSet(toUpModelIds, idMap);
    }

    private DynamicObject createDefaultNode(Long toUpModelId, Long nodeId, String number, String name, Long parent) {
        DynamicObject newGroup = BusinessDataServiceHelper.newDynamicObject((String)"eb_datasetcatalog");
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        newGroup.set("model", (Object)toUpModelId);
        newGroup.set("id", (Object)nodeId);
        newGroup.set("number", (Object)number);
        newGroup.set("name", (Object)name);
        newGroup.set("creator", (Object)userId);
        newGroup.set("createtime", (Object)now);
        newGroup.set("modifier", (Object)userId);
        newGroup.set("modifytime", (Object)now);
        newGroup.set("parent", (Object)parent);
        if ("datasetroot".equals(number)) {
            newGroup.set("longname", (Object)"");
        } else {
            newGroup.set("longname", (Object)("." + parent.toString()));
        }
        return newGroup;
    }

    private void createDefaultDataSet(List<Long> toUpModelIds, Map<Long, Long> idMap) {
        ArrayList<DynamicObject> saveDataSets = new ArrayList<DynamicObject>(16);
        UpgradesContext globalContext = this.getGlobalContext();
        String name = ResManager.loadKDString((String)"\u9ed8\u8ba4\u6570\u636e\u96c6", (String)"DefaultBaseDataUpgradesTask_2", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        long[] pkIds = DB.genGlobalLongIds((int)toUpModelIds.size());
        for (int i = 0; i < toUpModelIds.size(); ++i) {
            Long toUpModelId = toUpModelIds.get(i);
            ModelContext modelInfo = globalContext.getModelInfo(toUpModelId);
            BasedataPojo defaultDataset = modelInfo.getDefaultDataset();
            Long catalog = idMap.get(toUpModelId);
            DynamicObject dataSet = BusinessDataServiceHelper.newDynamicObject((String)"eb_dataset");
            Long userId = UserUtils.getUserId();
            Date now = TimeServiceHelper.now();
            dataSet.set("model", (Object)toUpModelId);
            long pkId = defaultDataset == null ? pkIds[i] : defaultDataset.getId();
            dataSet.set("id", (Object)pkId);
            dataSet.set("number", (Object)"default");
            dataSet.set("name", (Object)name);
            dataSet.set("creator", (Object)userId);
            dataSet.set("createdate", (Object)now);
            dataSet.set("modifier", (Object)userId);
            dataSet.set("modifydate", (Object)now);
            dataSet.set("catalog", (Object)catalog);
            DynamicObjectCollection defaultDim = dataSet.getDynamicObjectCollection("entryentity");
            List dimensions = modelInfo.getModelCache().getDimension();
            for (Dimension dim : dimensions) {
                String dimNumber = dim.getNumber();
                if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) continue;
                DynamicObject d = defaultDim.addNew();
                d.set("datasetdim", (Object)dim.getId());
            }
            dataSet.set("entryentity", (Object)defaultDim);
            BasedataPojo defaultBusModel = modelInfo.getDefaultBusModel();
            if (defaultBusModel != null) {
                dataSet.set("businessmodel", (Object)defaultBusModel.getId());
            }
            modelInfo.setDefaultDataset(this.getBaseDataPojo(dataSet));
            saveDataSets.add(dataSet);
        }
        SaveServiceHelper.save((DynamicObject[])saveDataSets.toArray(new DynamicObject[0]));
    }

    private BasedataPojo getBaseDataPojo(DynamicObject dynamicObject) {
        return new BasedataPojo(Long.valueOf(dynamicObject.getLong("id")), dynamicObject.getString("name"), dynamicObject.getString("number"));
    }

    private Long getViewId(Map<Long, Map<Long, Long>> viewMap, Map<Long, Long> curViewMap, Long modelId, Long dimensionId) {
        Long viewId = curViewMap.get(modelId);
        if (viewId == null) {
            Map<Long, Long> dimViewMap = viewMap.get(modelId);
            viewId = dimViewMap.get(dimensionId);
            curViewMap.put(modelId, viewId);
        }
        return viewId;
    }

    private Map<String, Long> getDimensionIdMap(Model model, Map<String, String> definedNameMap) {
        HashMap<String, Long> dimensionIdMap = new HashMap<String, Long>(16);
        List dimensions = model.getDimension();
        for (Dimension dimension : dimensions) {
            String number = dimension.getNumber();
            SysDimensionEnum sysDimension = SysDimensionEnum.getEnumByNumber((String)number);
            if (sysDimension == null) {
                dimensionIdMap.put(number, dimension.getId());
                definedNameMap.put(number, dimension.getName());
                continue;
            }
            DimensionViewEnum dimensionViewEnum = DimensionViewEnum.getByDimNumber((String)number);
            if (dimensionViewEnum == null) continue;
            dimensionIdMap.put(number, dimension.getId());
        }
        return dimensionIdMap;
    }

    @Override
    public void rollBack() {
        UpgradesContext globalContext = this.getGlobalContext();
        List<Long> toUpModelIds = globalContext.getToUpModelIds();
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        String filterParam = qFilter.toString();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        instance.delDataWithRefTable(ApplicationScenario, filterParam);
        instance.clearDataEntityCache("eb_applicationscenario");
        instance.delDataWithoutRef(View, filterParam);
        instance.clearDataEntityCache("eb_dimensionview");
        instance.delDataWithRefTable(BizModel, filterParam);
        instance.clearDataEntityCache("eb_businessmodel");
        QFilter qf = new QFilter("fmodel", "in", toUpModelIds);
        instance.delDataWithRefTable(DataSet, qf.toString());
        instance.clearDataEntityCache("eb_dataset");
        instance.delDataWithRefTable(DataSetCatalog, filterParam);
        instance.clearDataEntityCache("eb_datasetcatalog");
        qFilter.and("fnumber", "in", changeTypeNumbers);
        instance.rollDataFromBak(SysDimensionEnum.ChangeType.getMemberTreetable(), qFilter.toString());
        instance.clearDataEntityCache(SysDimensionEnum.ChangeType.getMemberTreemodel());
    }

    @Override
    public void release() {
    }

    @Override
    public void loadData() {
        UpgradesContext globalContext = this.getGlobalContext();
        List<Long> toUpModelIds = globalContext.getToUpModelIds();
        HashMap<Long, DynamicObject> modelBizMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> modelDataSetMap = new HashMap<Long, DynamicObject>(16);
        QFilter qFilter = new QFilter("model", "in", toUpModelIds);
        this.queryBaseDataMap("eb_businessmodel", qFilter, modelBizMap);
        this.queryBaseDataMap("eb_dataset", qFilter, modelDataSetMap);
        for (Long toUpModelId : toUpModelIds) {
            ModelContext modelInfo = globalContext.getModelInfo(toUpModelId);
            modelInfo.setDefaultBusModel(this.getBaseDataPojo((DynamicObject)modelBizMap.get(toUpModelId)));
            modelInfo.setDefaultDataset(this.getBaseDataPojo((DynamicObject)modelDataSetMap.get(toUpModelId)));
        }
    }

    private void queryBaseDataMap(String treeModel, QFilter qFilter, Map<Long, DynamicObject> modelMap) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)treeModel, (String)"id, number, name, model", (QFilter[])new QFilter[]{qFilter});
        query.forEach(e -> {
            Long modelId = e.getLong("model");
            modelMap.put(modelId, (DynamicObject)e);
        });
    }
}

