/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.ebupgrades.constants.DelRefKeyEnum;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.context.OldDataContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;

public class DimDataShareUpgradesTask
extends AbstractUpgradesTask {
    private static final String OldMeta = "eb_sharedimensiondata";
    private static final String NewMeta = "eb_sharedimension_nbg";
    private static final String Old_Main_Table = "t_eb_sharedimensiondata";
    private static final String Old_Sub_Table = "t_eb_sharedimdataentry";

    @Override
    public void backData() {
        List<Long> toUpModelIds = this.getGlobalContext().getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        instance.backupsDataByIds(Old_Main_Table, toUpModelIds, "fmodel");
        List<Long> relIds = this.getSubRelIds(toUpModelIds);
        if (relIds.size() > 0) {
            instance.backupsDataByIds(Old_Sub_Table, relIds, "fid");
        }
    }

    private List<Long> getSubRelIds(List<Long> toUpModelIds) {
        ArrayList<Long> relIds = new ArrayList<Long>(10);
        DynamicObjectCollection query = QueryServiceHelper.query((String)OldMeta, (String)"id", (QFilter[])new QFilter("model", "in", toUpModelIds).toArray());
        if (CollectionUtils.isEmpty((Collection)query)) {
            return relIds;
        }
        for (DynamicObject object : query) {
            relIds.add(object.getLong("id"));
        }
        return relIds;
    }

    @Override
    public void execute() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        DynamicObject[] oldDataShareObjects = BusinessDataServiceHelper.load((String)OldMeta, (String)this.getOldDataShareSelectField(), (QFilter[])new QFilter("model", "in", toUpModelIds).toArray());
        if (oldDataShareObjects == null || oldDataShareObjects.length == 0) {
            return;
        }
        List<DynamicObject> newDataShareObjects = this.packageNewDataShareObjects(oldDataShareObjects, context);
        if (newDataShareObjects.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newDataShareObjects.toArray(new DynamicObject[0]));
        }
        this.delOldData();
    }

    private void delOldData() {
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        OldDataContext oldDataContext = new OldDataContext();
        oldDataContext.setTable(OldMeta);
        Object[] split = this.getOldDataShareSelectField().split(",");
        ArrayList selectField = Lists.newArrayList((Object[])split);
        selectField.remove("model");
        oldDataContext.setSelectFields(selectField);
        QFilter qf = new QFilter("model", "in", toUpModelIds);
        Map<Long, List<DynamicObject>> toDelDataMap = instance.queryAndFillDataContextByOrm(oldDataContext, qf);
        toUpModelIds.forEach(e -> {
            ModelContext modelInfo = context.getModelInfo((Long)e);
            OldDataContext oldDataContext_copy = instance.copyOldDataContext(oldDataContext);
            oldDataContext_copy.setOldData((List)toDelDataMap.get(e));
            modelInfo.putOldDataContext(oldDataContext_copy);
        });
        DeleteServiceHelper.delete((String)OldMeta, (QFilter[])new QFilter("model", "in", toUpModelIds).toArray());
        instance.clearDataEntityCache(OldMeta);
    }

    private List<DynamicObject> packageNewDataShareObjects(DynamicObject[] oldDataShareObjects, UpgradesContext context) {
        ArrayList<DynamicObject> newDataShareObjects = new ArrayList<DynamicObject>(10);
        for (DynamicObject oldDataShareObject : oldDataShareObjects) {
            long modelId = oldDataShareObject.getLong("model.id");
            ModelContext modelInfo = context.getModelInfo(modelId);
            if (modelInfo == null) continue;
            OldDataContext oldContext = modelInfo.getOldDataContext("epm_dimension");
            if (oldContext == null || CollectionUtils.isEmpty(oldContext.getOldData())) {
                throw new KDBizException("get old dimension data error !");
            }
            Long busModelId = modelInfo.getDefaultBusModel().getId();
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)NewMeta);
            object.set("model_id", (Object)modelId);
            object.set("enable", (Object)(oldDataShareObject.getBoolean("status") ? "1" : "0"));
            object.set("number", (Object)oldDataShareObject.getString("number"));
            object.set("name", (Object)oldDataShareObject.getString("name"));
            object.set("bill_id", (Object)oldDataShareObject.getString("bill.id"));
            object.set("field", (Object)oldDataShareObject.getString("field"));
            object.set("fieldnumber", (Object)oldDataShareObject.getString("fieldnumber"));
            object.set("cloud_id", (Object)oldDataShareObject.getString("cloud.id"));
            object.set("app_id", (Object)oldDataShareObject.getString("app.id"));
            object.set("creator", (Object)UserUtils.getUserId());
            object.set("createtime", (Object)TimeServiceHelper.now());
            object.set("bizmodel_id", (Object)busModelId);
            object.set("filternonedata", (Object)0);
            String dimNumber = this.setNewDimId(modelInfo, object, oldDataShareObject, oldContext.getOldData());
            if (dimNumber.equals(SysDimensionEnum.Scenario.getNumber()) || dimNumber.equals(SysDimensionEnum.Process.getNumber())) continue;
            List<Map<String, Object>> newDimRangeData = this.dealDimRangeJsonData(oldDataShareObject, modelInfo, dimNumber);
            object.set("dimensionrangejson", (Object)SerializationUtils.toJsonString(newDimRangeData));
            DynamicObjectCollection newEntryEntity = object.getDynamicObjectCollection("dimentity");
            if (CollectionUtils.isNotEmpty(newDimRangeData)) {
                for (Map<String, Object> map : newDimRangeData) {
                    DynamicObject newSubEntry = newEntryEntity.addNew();
                    newSubEntry.set("memberid", (Object)IDUtils.toLong((Object)map.get("id")));
                    newSubEntry.set("membernumber", map.get("number"));
                    newSubEntry.set("membername", map.get("name"));
                    newSubEntry.set("memberrange", (Object)"10");
                    newSubEntry.set("memberviewid", (Object)IDUtils.toLong((Object)map.get("view")));
                }
            }
            newDataShareObjects.add(object);
        }
        return newDataShareObjects;
    }

    private List<Map<String, Object>> dealDimRangeJsonData(DynamicObject oldDataShareObject, ModelContext modelInfo, String dimNumber) {
        ArrayList<Map<String, Object>> newDimRangeData = new ArrayList<Map<String, Object>>(10);
        String dimRangeJsonData = oldDataShareObject.getString("dimensionrangejson_tag");
        List dimDatas = (List)SerializationUtils.fromJsonString((String)dimRangeJsonData, List.class);
        for (Map dimRange : dimDatas) {
            String id = String.valueOf(dimRange.get("id"));
            String number = (String)dimRange.get("number");
            String name = (String)dimRange.get("name");
            String parent = String.valueOf(dimRange.get("parent"));
            String scope = String.valueOf(dimRange.get("scope"));
            if (SysDimensionEnum.Period.getNumber().equals(dimNumber)) {
                this.dealPeriodDimRangeData(modelInfo, newDimRangeData, number, parent, scope);
                continue;
            }
            if (SysDimensionEnum.Year.getNumber().equals(dimNumber)) {
                Object member = modelInfo.getRefDelDataObject(DelRefKeyEnum.BUDGET_PERIOD, id);
                if (member == null) {
                    this.addLogInfo("DimDataShareUpgradesTask.dealDimRangeJsonData getBudgetPeriodMember error!" + id);
                    throw new KDBizException("getBudgetPeriodMember error !");
                }
                id = ((Member)member).getId().toString();
            }
            this.addNewDimRangeData(newDimRangeData, id, number, name, parent, scope);
        }
        return newDimRangeData;
    }

    private void dealPeriodDimRangeData(ModelContext modelInfo, List<Map<String, Object>> newDimRangeData, String number, String parent, String scope) {
        Model modelCache = modelInfo.getModelCache();
        Dimension dimension = modelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
        List yearMembers = dimension.getAllMembersOnSameLevel(2);
        for (Member yearMember : yearMembers) {
            String newPeriodMemNumber = yearMember.getNumber() + "." + number.split("_")[1];
            Member newPeriodMember = dimension.getMember(Long.valueOf(0L), newPeriodMemNumber);
            if (newPeriodMember == null) {
                this.addLogInfo("DimDataShareUpgradesTask.dealDimRangeJsonData getNewPeriodMember error! newPeriodMemNumber:" + newPeriodMemNumber + "  yearMember:" + SerializationUtils.toJsonString((Object)yearMember));
                throw new KDBizException("getNewPeriodMember error !");
            }
            String id = newPeriodMember.getId().toString();
            this.addNewDimRangeData(newDimRangeData, id, newPeriodMember.getNumber(), newPeriodMember.getName(), parent, scope);
        }
    }

    private void addNewDimRangeData(List<Map<String, Object>> newDimRangeData, String id, String number, String name, String parent, String scope) {
        String viewId = this.getViewId(id);
        HashMap<String, String> data = new HashMap<String, String>(16);
        newDimRangeData.add(data);
        data.put("id", id);
        data.put("name", name);
        data.put("number", number);
        data.put("parent", parent);
        data.put("scope", scope);
        data.put("view", viewId);
    }

    private String getViewId(String id) {
        String viewId = "0";
        QFilter filter = new QFilter("id", "=", (Object)IDUtils.toLong((Object)id));
        DynamicObject viewMember = BusinessDataServiceHelper.loadSingle((String)"eb_viewmember", (String)"id,view,memberid", (QFilter[])filter.toArray());
        if (viewMember != null) {
            viewId = viewMember.getDynamicObject("view").getString("id");
        }
        return viewId;
    }

    private String setNewDimId(ModelContext modelInfo, DynamicObject newDataShareObject, DynamicObject oldDataShareObject, List<DynamicObject> oldDimData) {
        long dimension = oldDataShareObject.getLong("dimension_id");
        long oldPeriodDimId = this.getOldPeriodDimId(oldDimData);
        Long oldYearDimId = this.getOldYearDimId(oldDimData);
        Long oldProcessDimId = this.getOldProcessDimId(oldDimData);
        Long oldScenarioDimId = this.getOldScenarioDimId(oldDimData);
        Dimension budgetPeriodDim = modelInfo.getModelCache().getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
        if (dimension == oldYearDimId) {
            newDataShareObject.set("dimension_id", (Object)budgetPeriodDim.getId());
            return "Year";
        }
        if (dimension == oldPeriodDimId) {
            newDataShareObject.set("dimension_id", (Object)budgetPeriodDim.getId());
            return "Period";
        }
        if (dimension == oldScenarioDimId) {
            return SysDimensionEnum.Scenario.getNumber();
        }
        if (dimension == oldProcessDimId) {
            return SysDimensionEnum.Process.getNumber();
        }
        newDataShareObject.set("dimension_id", (Object)dimension);
        return oldDataShareObject.getString("dimension.number");
    }

    private Long getOldPeriodDimId(List<DynamicObject> oldDimData) {
        for (DynamicObject oldDatum : oldDimData) {
            if (!"Period".equals(oldDatum.getString("number"))) continue;
            return oldDatum.getLong("id");
        }
        return 0L;
    }

    private Long getOldYearDimId(List<DynamicObject> oldDimData) {
        for (DynamicObject oldDatum : oldDimData) {
            if (!"Year".equals(oldDatum.getString("number"))) continue;
            return oldDatum.getLong("id");
        }
        return 0L;
    }

    private Long getOldScenarioDimId(List<DynamicObject> oldDimData) {
        for (DynamicObject oldDatum : oldDimData) {
            if (!SysDimensionEnum.Scenario.getNumber().equals(oldDatum.getString("number"))) continue;
            return oldDatum.getLong("id");
        }
        return 0L;
    }

    private Long getOldProcessDimId(List<DynamicObject> oldDimData) {
        for (DynamicObject oldDatum : oldDimData) {
            if (!SysDimensionEnum.Process.getNumber().equals(oldDatum.getString("number"))) continue;
            return oldDatum.getLong("id");
        }
        return 0L;
    }

    @Override
    public void rollBack() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        String filterParam = new QFilter("fmodel", "in", toUpModelIds).toString();
        DeleteServiceHelper.delete((String)NewMeta, (QFilter[])new QFilter("model", "in", toUpModelIds).toArray());
        instance.reCoverFromBak(Old_Main_Table, filterParam);
        List<Long> relIds = this.getSubRelIds(toUpModelIds);
        if (relIds.size() > 0) {
            instance.reCoverFromBak(Old_Sub_Table, relIds, "fid");
        }
        instance.clearDataEntityCache(NewMeta);
    }

    @Override
    public void release() {
    }

    @Override
    public void loadData() {
    }

    private String getOldDataShareSelectField() {
        return "model,number,bill,field,fieldnumber,status,cloud,app,dimensionrangejson_tag,dimension";
    }
}

