/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks.DimMemberUpgradesTask;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.tasks.AbstractChildUpgradesTask;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.BasedataPojo;

public class AccountUpgradesTask
extends AbstractChildUpgradesTask {
    @Override
    public void backData() {
        List<Long> toUpModelIds = this.getGlobalContext().getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        instance.backupsDataByIds(SysDimensionEnum.Account.getMemberTreetable(), toUpModelIds, "fmodelid");
    }

    @Override
    public void execute() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        QFilter qFilter = new QFilter("model", "in", toUpModelIds);
        Map<Long, List<DynamicObject>> accounts = instance.getMemberMap(SysDimensionEnum.Account.getMemberTreemodel(), qFilter);
        qFilter.and("number", "=", (Object)"Money");
        Map<Long, List<DynamicObject>> metrics = instance.getMemberMap(SysDimensionEnum.Metric.getMemberTreemodel(), qFilter);
        ArrayList<DynamicObject> saveAccounts = new ArrayList<DynamicObject>(16);
        long[] dataSetIds = DB.genGlobalLongIds((int)accounts.size());
        int index = 0;
        String accountNumber = SysDimensionEnum.Account.getNumber();
        for (Map.Entry<Long, List<DynamicObject>> accountEntry : accounts.entrySet()) {
            Long modelId = accountEntry.getKey();
            List<DynamicObject> accountList = accountEntry.getValue();
            long dataSetId = dataSetIds[index++];
            for (DynamicObject account : accountList) {
                DynamicObjectCollection metricEntryEntity = account.getDynamicObjectCollection("entryentity");
                DynamicObject metricEntry = metricEntryEntity.addNew();
                List<DynamicObject> moneyMetrics = metrics.get(modelId);
                if (moneyMetrics == null) continue;
                DynamicObject moneyMetric = moneyMetrics.get(0);
                metricEntry.set("metric", (Object)moneyMetric);
                metricEntry.set("istopoly", (Object)moneyMetric.getBoolean("isagg"));
                metricEntry.set("databytime", (Object)"0");
                metricEntry.set("skip", (Object)"0");
                metricEntry.set("metricdescription", (Object)"");
                metricEntry.set("change", (Object)"1");
                if (accountNumber.equals(account.getString("number"))) continue;
                account.set("dataset", (Object)dataSetId);
                saveAccounts.add(account);
            }
            ModelContext modelInfo = context.getModelInfo(modelId);
            modelInfo.setDefaultDataset(new BasedataPojo(Long.valueOf(dataSetId), "", ""));
        }
        SaveServiceHelper.save((DynamicObject[])saveAccounts.toArray(new DynamicObject[0]));
    }

    @Override
    public void rollBack() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        ArrayList<Map<String, String>> refTableProperties = new ArrayList<Map<String, String>>(16);
        refTableProperties.add(instance.getRefTablePropertyMap("t_eb_accountmetric", "fid", "fid"));
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        String filterParam = qFilter.toString();
        String memberTreeTable = SysDimensionEnum.Account.getMemberTreetable();
        instance.rollDataFromBak(memberTreeTable, instance.getDefaultBakTable(memberTreeTable), "epm", filterParam, filterParam, refTableProperties, true);
        instance.clearDataEntityCache(SysDimensionEnum.Account.getMemberTreemodel());
    }

    @Override
    public void release() {
    }

    @Override
    public void loadData() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        try (DataSet ds = DB.queryDataSet((String)"queryAccount", (DBRoute)DBRoute.of((String)"epm"), (String)String.format("select fmodelid, fdataset from %s where %s", SysDimensionEnum.Account.getMemberTreetable(), qFilter.toString()));){
            Row row = null;
            while (ds.hasNext()) {
                row = ds.next();
                Long modelId = row.getLong("fmodelid");
                ModelContext modelInfo = context.getModelInfo(modelId);
                BasedataPojo defaultDataset = modelInfo.getDefaultDataset();
                if (defaultDataset != null) continue;
                Long dataSetId = row.getLong("fdataset");
                modelInfo.setDefaultDataset(new BasedataPojo(dataSetId, "", ""));
            }
        }
    }
}

