/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks.DimMemberUpgradesTask;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.ebupgrades.context.GroupContext;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.context.OldDataContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.tasks.AbstractChildUpgradesTask;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.business.model.entity.AbstractDimensionMemTree;
import kd.epm.eb.business.model.entity.BudgetPeriodMemTree;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class BudgetPeriodUpgradesTask
extends AbstractChildUpgradesTask {
    @Override
    public void backData() {
        List<Long> toUpModelIds = this.getGlobalContext().getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        instance.backupsDataByIds(SysDimensionEnum.Year.getMemberTreetable(), toUpModelIds, "fmodelid");
        instance.backupsDataByIds(SysDimensionEnum.Period.getMemberTreetable(), toUpModelIds, "fmodelid");
    }

    @Override
    public void execute() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        this.buildAddedBPTree(toUpModelIds);
        this.delDimMembers(toUpModelIds, SysDimensionEnum.Year);
        this.delDimMembers(toUpModelIds, SysDimensionEnum.Period);
    }

    private void buildAddedBPTree(List<Long> toUpModelIds) {
        QFilter qFilter = new QFilter("model", "in", toUpModelIds);
        qFilter.and("membersource", "=", (Object)"0");
        DynamicObjectCollection years = QueryServiceHelper.query((String)SysDimensionEnum.Year.getMemberTreemodel(), (String)"name, number, model", (QFilter[])new QFilter[]{qFilter});
        if (years.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> saveBudgetPeriods = new ArrayList<DynamicObject>(10);
        Map<Long, List<DynamicObject>> toAddYearMap = this.ConvertToModelMap(years);
        GroupContext groupContext = this.getGroupContext();
        Map<Long, DynamicObject> roots = this.getRoots(toUpModelIds);
        for (Long toUpModelId : toUpModelIds) {
            DynamicObject model = (DynamicObject)groupContext.getParam("model_" + toUpModelId);
            DynamicObject dimension = (DynamicObject)groupContext.getParam("bPeriod_" + toUpModelId);
            DynamicObject root = roots.get(toUpModelId);
            BudgetPeriodMemTree budgetPeriodMemTree = new BudgetPeriodMemTree(model, dimension);
            budgetPeriodMemTree.setNumber(root.getString("number"));
            budgetPeriodMemTree.setLongnumber(root.getString("longnumber"));
            List<DynamicObject> toAddYears = toAddYearMap.get(toUpModelId);
            if (toAddYears == null) continue;
            for (DynamicObject toAddYear : toAddYears) {
                String number = toAddYear.getString("number");
                if (!number.startsWith("FY")) continue;
                int startYear = Integer.parseInt(number.replace("FY", ""));
                budgetPeriodMemTree.initYearTree(startYear, startYear + 1, 1);
                AbstractDimensionMemTree memTree = this.getCurTreeNode(number, budgetPeriodMemTree);
                if (memTree == null) continue;
                memTree.setName(toAddYear.getString("name"));
            }
            budgetPeriodMemTree.initPeriodTree(1, true, true, true);
            for (AbstractDimensionMemTree treenode : budgetPeriodMemTree.getChildren()) {
                treenode.setParent(root.getLong("id"));
                this.init(treenode, saveBudgetPeriods);
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveBudgetPeriods.toArray(new DynamicObject[0]));
    }

    private Map<Long, List<DynamicObject>> ConvertToModelMap(DynamicObjectCollection years) {
        HashMap<Long, List<DynamicObject>> modelMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject year : years) {
            Long modelId = year.getLong("model");
            List yearList = modelMap.computeIfAbsent(modelId, k -> new ArrayList(16));
            yearList.add(year);
        }
        return modelMap;
    }

    private AbstractDimensionMemTree getCurTreeNode(String number, BudgetPeriodMemTree budgetPeriodMemTree) {
        AbstractDimensionMemTree node = null;
        List<AbstractDimensionMemTree> children = budgetPeriodMemTree.getChildren();
        for (AbstractDimensionMemTree child : children) {
            if (!number.equals(child.getNumber())) continue;
            node = child;
            break;
        }
        return node;
    }

    private void init(AbstractDimensionMemTree treenode, List<DynamicObject> saveBudgetPeriods) {
        saveBudgetPeriods.add(treenode.initToDyna());
        for (AbstractDimensionMemTree child : treenode.getChildren()) {
            this.init(child, saveBudgetPeriods);
        }
    }

    private void delDimMembers(List<Long> toUpModelIds, SysDimensionEnum sysDimension) {
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        QFilter qf = new QFilter("model", "in", toUpModelIds);
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        String filterParam = qFilter.toString();
        OldDataContext oldDataContext = new OldDataContext();
        oldDataContext.setTable(sysDimension.getMemberTreemodel());
        oldDataContext.addSelectField("isleaf");
        Map<Long, List<DynamicObject>> toDelDataMap = instance.queryAndFillDataContextByOrm(oldDataContext, qf);
        UpgradesContext context = this.getGlobalContext();
        toUpModelIds.forEach(e -> {
            ModelContext modelInfo = context.getModelInfo((Long)e);
            OldDataContext oldDataContext_copy = instance.copyOldDataContext(oldDataContext);
            oldDataContext_copy.setOldData((List)toDelDataMap.get(e));
            modelInfo.putOldDataContext(oldDataContext_copy);
        });
        instance.delDataWithoutRef(sysDimension.getMemberTreetable(), filterParam);
        instance.clearDataEntityCache(sysDimension.getMemberTreemodel());
    }

    private Map<Long, DynamicObject> getRoots(List<Long> toUpModelIds) {
        HashMap<Long, DynamicObject> rootMap = new HashMap<Long, DynamicObject>(16);
        QFilter qFilter = new QFilter("model", "in", toUpModelIds);
        qFilter.and("number", "=", (Object)SysDimensionEnum.BudgetPeriod.getNumber());
        DynamicObjectCollection roots = QueryServiceHelper.query((String)SysDimensionEnum.BudgetPeriod.getMemberTreemodel(), (String)"id, number, longnumber, model", (QFilter[])qFilter.toArray());
        for (DynamicObject root : roots) {
            Long modelId = root.getLong("model");
            rootMap.put(modelId, root);
        }
        return rootMap;
    }

    @Override
    public void rollBack() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        String filterParam = qFilter.toString();
        instance.delDataWithRefTable(SysDimensionEnum.BudgetPeriod.getMemberTreetable(), filterParam);
        instance.delDataWithoutRef(SysDimensionEnum.Year.getMemberTreetable(), filterParam);
        instance.delDataWithoutRef(SysDimensionEnum.Period.getMemberTreetable(), filterParam);
        instance.reCoverFromBak(SysDimensionEnum.Year.getMemberTreetable(), filterParam);
        instance.reCoverFromBak(SysDimensionEnum.Period.getMemberTreetable(), filterParam);
        instance.clearDataEntityCache(SysDimensionEnum.BudgetPeriod.getMemberTreemodel());
    }

    @Override
    public void release() {
    }

    @Override
    public void loadData() {
        UpgradesContext context = this.getGlobalContext();
        this.reloadOldData(context, SysDimensionEnum.Year);
        this.reloadOldData(context, SysDimensionEnum.Period);
    }

    private void reloadOldData(UpgradesContext context, SysDimensionEnum sysDimension) {
        List<Long> toUpModelIds = context.getToUpModelIds();
        QFilter qf = new QFilter("fmodelid", "in", toUpModelIds);
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        OldDataContext oldDataContext = new OldDataContext();
        oldDataContext.setTable(sysDimension.getMemberTreemodel());
        oldDataContext.setRealTable(sysDimension.getMemberTreetable());
        oldDataContext.addSelectField("isleaf");
        Map<Long, List<DynamicObject>> toDelDataMap = instance.queryAndFillDataContextBySql(oldDataContext, qf.toString());
        toUpModelIds.forEach(e -> {
            ModelContext modelInfo = context.getModelInfo((Long)e);
            OldDataContext oldDataContext_copy = instance.copyOldDataContext(oldDataContext);
            oldDataContext_copy.setOldData((List)toDelDataMap.get(e));
            modelInfo.putOldDataContext(oldDataContext_copy);
        });
    }
}

