/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks.DimMemberUpgradesTask;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.tasks.AbstractChildUpgradesTask;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.EbShrekOlapServiceHelper;

public class ChangeTypeUpgradesTask
extends AbstractChildUpgradesTask {
    @Override
    public void backData() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        qFilter.and("fnumber", "in", Arrays.asList("ActualChanges", "DataIntegration"));
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        instance.backupsData(SysDimensionEnum.ChangeType.getMemberTreetable(), qFilter.toString());
    }

    @Override
    public void execute() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        QFilter qFilter = new QFilter("model", "in", toUpModelIds);
        qFilter.and("number", "in", Arrays.asList("ActualChanges", "DataIntegration"));
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, SysDimensionEnum.ChangeType.getMemberTreemodel(), null);
        DynamicObject[] changeTypes = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)SysDimensionEnum.ChangeType.getMemberTreemodel()));
        if (changeTypes.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b\u6210\u5458\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"ChangeTypeUpgradesTask_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map<Long, Map<String, DynamicObject>> changeTypeMap = this.convertToModelMap(changeTypes);
        ArrayList<DynamicObject> saveChangeTypes = new ArrayList<DynamicObject>(16);
        for (Map.Entry<Long, Map<String, DynamicObject>> changeTypeEntry : changeTypeMap.entrySet()) {
            Long modelId = changeTypeEntry.getKey();
            Map<String, DynamicObject> changeTypeNumberMap = changeTypeEntry.getValue();
            ModelContext modelInfo = context.getModelInfo(modelId);
            DynamicObject dataIntegration = changeTypeNumberMap.get("DataIntegration");
            DynamicObject actualChanges = changeTypeNumberMap.get("ActualChanges");
            if (EbShrekOlapServiceHelper.existCubeData((Model)modelInfo.getModelCache(), (String)SysDimensionEnum.ChangeType.getNumber(), new HashSet<String>(Collections.singleton("DataIntegration"))) && EbShrekOlapServiceHelper.existCubeData((Model)modelInfo.getModelCache(), (String)SysDimensionEnum.ChangeType.getNumber(), new HashSet<String>(Collections.singleton("ActualChanges")))) {
                DynamicObject dataIntegration_1 = BusinessDataServiceHelper.newDynamicObject((String)SysDimensionEnum.ChangeType.getMemberTreemodel());
                DynamicObjectUtils.copy((DynamicObject)dataIntegration, (DynamicObject)dataIntegration_1);
                dataIntegration_1.set("number", (Object)"DataIntegration_1");
                dataIntegration_1.set("name", (Object)(dataIntegration.getString("name") + "_1"));
                dataIntegration_1.set("longnumber", (Object)(dataIntegration.getString("longnumber") + "_1"));
                saveChangeTypes.add(dataIntegration_1);
            }
            this.putMemberToChild(dataIntegration, actualChanges);
            saveChangeTypes.add(dataIntegration);
            saveChangeTypes.add(actualChanges);
        }
        SaveServiceHelper.save((DynamicObject[])saveChangeTypes.toArray(new DynamicObject[0]));
    }

    private Map<Long, Map<String, DynamicObject>> convertToModelMap(DynamicObject[] changeTypes) {
        HashMap<Long, Map<String, DynamicObject>> modelMap = new HashMap<Long, Map<String, DynamicObject>>(16);
        for (DynamicObject changeType : changeTypes) {
            Long modelId = changeType.getLong("model.id");
            Map changeTypeMap = modelMap.computeIfAbsent(modelId, k -> new HashMap(16));
            String number = changeType.getString("number");
            changeTypeMap.put(number, changeType);
        }
        return modelMap;
    }

    private void putMemberToChild(DynamicObject child, DynamicObject parent) {
        child.set("level", (Object)(parent.getInt("level") + 1));
        child.set("dseq", (Object)1);
        child.set("longnumber", (Object)(parent.getString("longnumber") + "!" + child.getString("number")));
        child.set("parent", (Object)parent.getLong("id"));
        parent.set("isleaf", (Object)false);
    }

    @Override
    public void rollBack() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        QFilter qf1 = new QFilter("fnumber", "in", Arrays.asList("ActualChanges", "DataIntegration", "DataIntegration_1"));
        QFilter qf2 = new QFilter("fnumber", "in", Arrays.asList("ActualChanges", "DataIntegration"));
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        String filterParam = qf1.and(qFilter).toString();
        String checkFilterParam = qf2.and(qFilter).toString();
        instance.rollDataFromBak(SysDimensionEnum.ChangeType.getMemberTreetable(), filterParam, checkFilterParam, false);
        instance.clearDataEntityCache(SysDimensionEnum.ChangeType.getMemberTreemodel());
    }

    @Override
    public void release() {
    }

    @Override
    public void loadData() {
    }
}

