/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks.DimMemberUpgradesTask;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.ebupgrades.context.GroupContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.tasks.AbstractChildUpgradesTask;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.business.model.entity.AbstractDimensionMemTree;
import kd.epm.eb.business.model.preDimensionHelper.PreDimensionUtil;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.model.interfaces.IDimensionComponent;
import kd.epm.eb.model.interfaces.IInitSpecialTree;

public class MetricUpgradesTask
extends AbstractChildUpgradesTask {
    @Override
    public void backData() {
    }

    @Override
    public void execute() {
        UpgradesContext context = this.getGlobalContext();
        GroupContext groupContext = this.getGroupContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        DynamicObject[] models = BusinessDataServiceHelper.load((Object[])toUpModelIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"epm_model"));
        HashMap saveMembers = new HashMap(16);
        for (DynamicObject model : models) {
            model.set("sysperiod", (Object)"2");
            long modelId = model.getLong("id");
            PreDimensionUtil util = new PreDimensionUtil(model, ApplicationTypeEnum.BGMD, false);
            List<IDimensionComponent> dimensionComponents = util.resolveDimemTrees();
            dimensionComponents.forEach(e -> {
                ((IInitSpecialTree)((Object)e)).initSpecialTrees();
                String dimensionNumber = e.getDimensionNumber();
                DynamicObject dimension = null;
                dimension = SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionNumber) ? (DynamicObject)groupContext.getParam("bPeriod_" + modelId) : (DynamicObject)groupContext.getParam("metric_" + modelId);
                List members = saveMembers.computeIfAbsent(dimensionNumber, k -> new ArrayList(16));
                this.iteratorTrees((AbstractDimensionMemTree)e, dimension, members, new ArrayList<String>(16));
            });
        }
        for (List members : saveMembers.values()) {
            SaveServiceHelper.save((DynamicObject[])members.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public void rollBack() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        instance.delDataWithRefTable(SysDimensionEnum.Metric.getMemberTreetable(), qFilter.toString());
        instance.clearDataEntityCache(SysDimensionEnum.Metric.getMemberTreemodel());
    }

    @Override
    public void release() {
    }

    @Override
    public void loadData() {
    }

    private void iteratorTrees(AbstractDimensionMemTree tree, DynamicObject dimension, List<DynamicObject> members, List<String> numbers) {
        this.saveData(tree, dimension, members, numbers);
        for (AbstractDimensionMemTree atree : tree.getChildren()) {
            this.iteratorTrees(atree, dimension, members, numbers);
        }
    }

    private void saveData(AbstractDimensionMemTree tree, DynamicObject dimension, List<DynamicObject> members, List<String> numbers) {
        if (numbers.contains(tree.getNumber())) {
            return;
        }
        DynamicObject dot = tree.initToDyna();
        dot.set("dimension", (Object)dimension);
        numbers.add(tree.getNumber());
        members.add(dot);
    }
}

