/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.ebupgrades.constants.DelRefKeyEnum;
import kd.epm.eb.business.ebupgrades.context.GroupContext;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.context.OldDataContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.business.ebupgrades.tasks.AbstractChildUpgradesTask;
import kd.epm.eb.business.ebupgrades.tasks.DimMemberUpgradesTask.AccountUpgradesTask;
import kd.epm.eb.business.ebupgrades.tasks.DimMemberUpgradesTask.BudgetPeriodUpgradesTask;
import kd.epm.eb.business.ebupgrades.tasks.DimMemberUpgradesTask.ChangeTypeUpgradesTask;
import kd.epm.eb.business.ebupgrades.tasks.DimMemberUpgradesTask.MetricUpgradesTask;
import kd.epm.eb.business.ebupgrades.tasks.DimMemberUpgradesTask.ProcessUpgradesTask;
import kd.epm.eb.business.ebupgrades.tasks.DimMemberUpgradesTask.ScenarioUpgradesTask;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class DimensionUpgradesTask
extends AbstractUpgradesTask {
    private static final List<String> memberTaskKeys = Arrays.asList(SysDimensionEnum.Metric.getNumber(), SysDimensionEnum.Account.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Process.getNumber());
    private static final List<String> toDelDimNumber = Arrays.asList(SysDimensionEnum.Scenario.getNumber(), SysDimensionEnum.Process.getNumber(), SysDimensionEnum.Year.getNumber(), SysDimensionEnum.Period.getNumber());
    private static final String DIMENSION = "t_eb_dimension";

    @Override
    public void backData() {
        UpgradesContext context = this.getGlobalContext();
        for (String memberTaskKey : memberTaskKeys) {
            AbstractChildUpgradesTask task = this.getMemberTask(context, memberTaskKey);
            if (task == null) continue;
            task.backData();
        }
        List<Long> toUpModelIds = context.getToUpModelIds();
        this.backNeedDelDimensions(toUpModelIds);
        this.backDefinedDimensions(toUpModelIds);
    }

    @Override
    public void execute() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        this.addDimension(toUpModelIds);
        for (String memberTaskKey : memberTaskKeys) {
            AbstractChildUpgradesTask task = this.getMemberTask(context, memberTaskKey);
            if (task == null) continue;
            task.execute();
        }
        List<Object> idList = this.delDimensions(toUpModelIds);
        idList.addAll(this.modifyDefinedDimensions(toUpModelIds));
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        instance.clearDataEntityCache("epm_dimension", idList.toArray());
        instance.clearDataEntityCache("epm_dimension");
        this.afterExecute();
    }

    private void afterExecute() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        toUpModelIds.forEach(e -> {
            ModelContext modelInfo = context.getModelInfo((Long)e);
            Model modelCache = modelInfo.getModelCache();
            modelCache.buildDimensions(null);
            modelCache.buildShareMembers();
            this.fillBudgetPeriodMap(modelInfo);
            this.fillChangeTypeMap(modelInfo);
            this.markModelOk((Long)e);
        });
    }

    private void fillBudgetPeriodMap(ModelContext modelInfo) {
        HashMap<String, Object> bPeriodMap = new HashMap<String, Object>(16);
        Model modelCache = modelInfo.getModelCache();
        Dimension dimension = modelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
        OldDataContext yearOldDataContext = modelInfo.getOldDataContext(SysDimensionEnum.Year.getMemberTreemodel());
        OldDataContext periodOldDataContext = modelInfo.getOldDataContext(SysDimensionEnum.Period.getMemberTreemodel());
        List<DynamicObject> yearOldData = yearOldDataContext.getOldData();
        List<DynamicObject> periodOldData = periodOldDataContext.getOldData();
        for (DynamicObject yearOldDatum : yearOldData) {
            String fyNumber = yearOldDatum.getString("number");
            if (!fyNumber.startsWith("FY")) continue;
            for (DynamicObject periodOldDatum : periodOldData) {
                String bPeriodNumber;
                String periodNumber = periodOldDatum.getString("number");
                if (!periodNumber.startsWith("M_") && !periodNumber.startsWith("Q_") && !periodNumber.startsWith("HF_")) continue;
                String replaceNumber = periodNumber.replace("M_", "");
                replaceNumber = replaceNumber.replace("Q_", "");
                replaceNumber = replaceNumber.replace("HF_", "");
                boolean containSelf = false;
                if (replaceNumber.equals("YearTotal")) {
                    bPeriodNumber = fyNumber;
                    containSelf = true;
                } else {
                    bPeriodNumber = fyNumber + "." + replaceNumber;
                }
                Member member = dimension.getMember(null, bPeriodNumber);
                this.addToBPeriodMap(bPeriodMap, yearOldDatum, periodOldDatum, member, containSelf);
            }
        }
        modelInfo.addDelDataMap(DelRefKeyEnum.BUDGET_PERIOD, bPeriodMap);
    }

    private void fillChangeTypeMap(ModelContext modelInfo) {
        HashMap<String, Object> changeTypeMap = new HashMap<String, Object>(16);
        Model modelCache = modelInfo.getModelCache();
        Dimension dimension = modelCache.getDimension(SysDimensionEnum.ChangeType.getNumber());
        Member dataIntegration_1 = dimension.getMember(dimension.getDefaultViewId(), "DataIntegration_1");
        Member dataIntegration = dimension.getMember(dimension.getDefaultViewId(), "DataIntegration");
        if (dataIntegration_1 == null || dataIntegration == null) {
            return;
        }
        Long id = dataIntegration.getId();
        String number = dataIntegration.getNumber();
        changeTypeMap.put(String.valueOf(id), dataIntegration_1);
        changeTypeMap.put(number, dataIntegration_1);
        modelInfo.addDelDataMap(DelRefKeyEnum.CHANGE_TYPE, changeTypeMap);
    }

    private void addToBPeriodMap(Map<String, Object> bPeriodMap, DynamicObject yearOldDatum, DynamicObject periodOldDatum, Member member, boolean containSelfYear) {
        String fyNumber = yearOldDatum.getString("number");
        long fyId = yearOldDatum.getLong("id");
        String periodNumber = periodOldDatum.getString("number");
        long periodId = periodOldDatum.getLong("id");
        bPeriodMap.put(fyNumber + "!" + periodNumber, member);
        bPeriodMap.put(fyId + "!" + periodId, member);
        if (containSelfYear) {
            bPeriodMap.put(fyNumber, member);
            bPeriodMap.put(String.valueOf(fyId), member);
        }
    }

    @Override
    public void rollBack() {
        UpgradesContext context = this.getGlobalContext();
        for (String memberTaskKey : memberTaskKeys) {
            AbstractChildUpgradesTask task = this.getMemberTask(context, memberTaskKey);
            if (task == null) continue;
            task.rollBack();
        }
        List<Long> toUpModelIds = context.getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        instance.delDataWithRefTable(DIMENSION, this.getToDelQFilter(toUpModelIds));
        String filterParam = this.getToDelFilterParam(toUpModelIds);
        instance.delDataWithoutRef(DIMENSION, filterParam);
        instance.reCoverFromBak(DIMENSION, filterParam);
        filterParam = this.getDefinedFilterParam(toUpModelIds);
        instance.delDataWithoutRef(DIMENSION, filterParam);
        instance.reCoverFromBak(DIMENSION, filterParam);
        instance.clearDataEntityCache("epm_dimension");
    }

    private void backNeedDelDimensions(List<Long> toUpModelIds) {
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        instance.backupsData(DIMENSION, this.getToDelFilterParam(toUpModelIds));
    }

    private void backDefinedDimensions(List<Long> toUpModelIds) {
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        instance.backupsData(DIMENSION, this.getDefinedFilterParam(toUpModelIds));
    }

    private void addDimension(List<Long> toUpModelIds) {
        DynamicObject[] dimensions;
        GroupContext groupContext = this.getGroupContext();
        ArrayList<DynamicObject> toAddDimensions = new ArrayList<DynamicObject>(16);
        QFilter qFilter = new QFilter("model", "in", toUpModelIds);
        qFilter.and("number", "=", (Object)SysDimensionEnum.Period.getNumber());
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, "epm_dimension", null);
        for (DynamicObject period : dimensions = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"epm_dimension"))) {
            DynamicObject bPeriod = this.createDimension(period, SysDimensionEnum.BudgetPeriod);
            toAddDimensions.add(bPeriod);
            long modelId = period.getLong("model.id");
            groupContext.addParam("bPeriod_" + modelId, bPeriod);
            DynamicObject metric = this.createDimension(period, SysDimensionEnum.Metric);
            toAddDimensions.add(metric);
            groupContext.addParam("metric_" + modelId, metric);
        }
        SaveServiceHelper.save((DynamicObject[])toAddDimensions.toArray(new DynamicObject[0]));
    }

    private DynamicObject createDimension(DynamicObject baseDimension, SysDimensionEnum sysDimension) {
        DynamicObject dimension = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
        DynamicObjectUtils.copy((DynamicObject)baseDimension, (DynamicObject)dimension);
        dimension.set("number", (Object)sysDimension.getNumber());
        dimension.set("name", (Object)sysDimension.getChineseName());
        dimension.set("shortnumber", (Object)sysDimension.getShortNumber());
        dimension.set("dseq", (Object)sysDimension.getDseq());
        dimension.set("membermodel", (Object)sysDimension.getMemberTreemodel());
        dimension.set("membertable", (Object)sysDimension.getMemberTreetable());
        return dimension;
    }

    private List<Object> delDimensions(List<Long> toUpModelIds) {
        QFilter qFilter = new QFilter("model", "in", toUpModelIds);
        qFilter.and("number", "in", toDelDimNumber);
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, "epm_dimension", null);
        OldDataContext oldDataContext = new OldDataContext();
        oldDataContext.setTable("epm_dimension");
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        UpgradesContext context = this.getGlobalContext();
        Map<Long, List<DynamicObject>> toDelDataMap = instance.queryAndFillDataContextByOrm(oldDataContext, qFilter);
        toUpModelIds.forEach(e -> {
            ModelContext modelInfo = context.getModelInfo((Long)e);
            OldDataContext oldDataContext_copy = instance.copyOldDataContext(oldDataContext);
            oldDataContext_copy.setOldData((List)toDelDataMap.get(e));
            modelInfo.putOldDataContext(oldDataContext_copy);
        });
        QFilter qf = new QFilter("fid", "in", idList);
        instance.delDataWithoutRef(DIMENSION, qf.toString());
        return idList;
    }

    private List<Object> modifyDefinedDimensions(List<Long> toUpModelIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fdseq from t_eb_dimension where ", new Object[0]);
        sql.appendIn("fmodelid", toUpModelIds.toArray());
        sql.append(" and fissysdimension = ?", new Object[]{"0"});
        String updateSql = "update t_eb_dimension set fdseq = ? where fid = ?";
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        ArrayList<Object> pkIds = new ArrayList<Object>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryDefinedDimensions", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sql);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long id = row.getLong("fid");
                int seq = row.getInteger("fdseq") + 1;
                updateParams.add(new Object[]{seq, id});
                pkIds.add(id);
            }
        }
        if (updateParams.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, updateParams);
        }
        return pkIds;
    }

    private String getToDelQFilter(List<Long> toUpModelIds) {
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        List<String> toDelDimNumbers = Arrays.asList(SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Metric.getNumber());
        qFilter.and("fnumber", "in", toDelDimNumbers);
        return qFilter.toString();
    }

    private String getToDelFilterParam(List<Long> toUpModelIds) {
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        qFilter.and("fnumber", "in", toDelDimNumber);
        return qFilter.toString();
    }

    private String getDefinedFilterParam(List<Long> toUpModelIds) {
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        qFilter.and("fissysdimension", "=", (Object)"0");
        return qFilter.toString();
    }

    private AbstractChildUpgradesTask getMemberTask(UpgradesContext context, String memberTaskKey) {
        AbstractChildUpgradesTask task = null;
        SysDimensionEnum sysDimension = SysDimensionEnum.getEnumByNumber((String)memberTaskKey);
        if (sysDimension == null) {
            return null;
        }
        switch (sysDimension) {
            case Account: {
                task = new AccountUpgradesTask();
                break;
            }
            case BudgetPeriod: {
                task = new BudgetPeriodUpgradesTask();
                break;
            }
            case ChangeType: {
                task = new ChangeTypeUpgradesTask();
                break;
            }
            case Metric: {
                task = new MetricUpgradesTask();
                break;
            }
            case Scenario: {
                task = new ScenarioUpgradesTask();
                break;
            }
            case Process: {
                task = new ProcessUpgradesTask();
                break;
            }
        }
        if (task != null) {
            task.setGlobalContext(context);
            task.setGroupContext(this.getGroupContext());
        }
        return task;
    }

    @Override
    public void release() {
    }

    @Override
    public void loadData() {
        UpgradesContext context = this.getGlobalContext();
        for (String memberTaskKey : memberTaskKeys) {
            AbstractChildUpgradesTask task = this.getMemberTask(context, memberTaskKey);
            if (task == null) continue;
            task.loadData();
        }
        List<Long> toUpModelIds = context.getToUpModelIds();
        OldDataContext oldDataContext = new OldDataContext();
        oldDataContext.setTable("epm_dimension");
        oldDataContext.setRealTable(DIMENSION);
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        QFilter qFilter = new QFilter("fmodelid", "in", toUpModelIds);
        qFilter.and("fnumber", "in", toDelDimNumber);
        Map<Long, List<DynamicObject>> toDelDataMap = instance.queryAndFillDataContextBySql(oldDataContext, qFilter.toString());
        toUpModelIds.forEach(e -> {
            ModelContext modelInfo = context.getModelInfo((Long)e);
            Model modelCache = modelInfo.getModelCache();
            modelCache.buildDimensions(null);
            modelCache.buildShareMembers();
            OldDataContext oldDataContext_copy = instance.copyOldDataContext(oldDataContext);
            oldDataContext_copy.setOldData((List)toDelDataMap.get(e));
            modelInfo.putOldDataContext(oldDataContext_copy);
            this.fillBudgetPeriodMap(modelInfo);
            this.fillChangeTypeMap(modelInfo);
        });
    }
}

