/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.business.ebupgrades.pojo.EntityMetaPerm;
import kd.epm.eb.business.ebupgrades.utils.PermUpgradesUtil;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.EBPermissionUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;

public class FunPermUpgradesTask
extends AbstractUpgradesTask {
    private Map<Long, List<Long>> modelManagers = null;
    private static final String detail_table_bak = "t_perm_userpermdetail_epm_bak";
    private static final String perm_table = "t_perm_userperm";
    private static final String detail_table = "t_perm_userpermdetail";
    private static final List<String> upgradeApps = Arrays.asList(ApplicationTypeEnum.EB.getAppnum(), ApplicationTypeEnum.BGC.getAppnum());

    @Override
    public void backData() {
        UpgradesContext globalContext = this.getGlobalContext();
        List<Long> toUpModelIds = globalContext.getToUpModelIds();
        QFilter qFilter = new QFilter("forgid", "in", toUpModelIds);
        qFilter.and("fdimtype", "=", (Object)"DIM_EPM_MODEL");
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        instance.backupsData(detail_table, detail_table_bak, "sys", instance.getRefFilter(perm_table, qFilter));
    }

    private Map<Long, List<Long>> getModelManagers(List<Long> toUpModelIds) {
        if (this.modelManagers == null) {
            this.modelManagers = PermUpgradesUtil.getInstance().getModelManagers(toUpModelIds);
        }
        return this.modelManagers;
    }

    @Override
    public void execute() {
        DynamicObject[] perms;
        UpgradesContext globalContext = this.getGlobalContext();
        List<Long> toUpModelIds = globalContext.getToUpModelIds();
        Map<Long, List<Long>> modelManagers = this.getModelManagers(toUpModelIds);
        PermUpgradesUtil instance = PermUpgradesUtil.getInstance();
        Map<String, EntityMetaPerm> ebUpgradesPermMap = instance.getEbUpgradesPermMap();
        Map<String, Map<String, List<String>>> allPermItems = this.getAllPermItems();
        Map<String, List<String>> allPermItem_nbg = allPermItems.get("nbg");
        Map<String, List<String>> allPermItem_eb = allPermItems.get(ApplicationTypeEnum.EB.getAppnum());
        Map<String, List<String>> allPermItem_bgc = allPermItems.get(ApplicationTypeEnum.BGC.getAppnum());
        String[] dimTypeInfo = PermCommonUtil.getSuitableDimType((String)"DIM_EPM_MODEL");
        ArrayList<String> dimTypes = new ArrayList<String>(16);
        dimTypes.add(dimTypeInfo[0]);
        dimTypes.add(dimTypeInfo[1]);
        String detailDimType = dimTypeInfo[1];
        QFilter qFilter = new QFilter("org", "in", toUpModelIds);
        qFilter.and("dimtype", "in", dimTypes);
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, "perm_userperm", null);
        for (DynamicObject perm : perms = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"perm_userperm"))) {
            long modelId = perm.getLong("org_id");
            long userId = perm.getLong("user_id");
            List<Long> managers = modelManagers.get(modelId);
            boolean isManager = managers.contains(userId);
            DynamicObjectCollection userPermEntry = perm.getDynamicObjectCollection("entryentity");
            HashMap<String, List<String>> toAddPermItems = new HashMap<String, List<String>>(16);
            Iterator iterator = userPermEntry.iterator();
            while (iterator.hasNext()) {
                String permItem;
                Map<String, String> permItemMap;
                String replaceItem;
                EntityMetaPerm entityMetaPerm;
                DynamicObject userPermDetail = (DynamicObject)iterator.next();
                String entityType = userPermDetail.getString("entitytype.number");
                if (allPermItem_bgc.containsKey(entityType) || !allPermItem_eb.containsKey(entityType)) continue;
                if (!isManager && (entityMetaPerm = ebUpgradesPermMap.get(entityType)) != null && StringUtils.isNotEmpty((String)(replaceItem = (permItemMap = entityMetaPerm.getPermItemMap()).get(permItem = userPermDetail.getString("permitem.id"))))) {
                    String mapEntity = entityMetaPerm.getMapEntity();
                    List items = toAddPermItems.computeIfAbsent(mapEntity, k -> new ArrayList(16));
                    items.add(replaceItem);
                }
                iterator.remove();
            }
            if (isManager) {
                toAddPermItems.putAll(allPermItem_nbg);
            }
            this.addAllPermItems(userPermEntry, toAddPermItems, userId, modelId, detailDimType);
        }
        SaveServiceHelper.save((DynamicObject[])perms);
        PermissionServiceHelper.clearAllCache();
    }

    private Map<String, Map<String, List<String>>> getAllPermItems() {
        HashMap<String, Map<String, List<String>>> allPermItems = new HashMap<String, Map<String, List<String>>>(16);
        Map funcPermItems = EBPermissionUtils.getInstance().getPermItem().getFuncPermItems();
        for (Map.Entry funPermItemEntry : funcPermItems.entrySet()) {
            String appNum = (String)funPermItemEntry.getKey();
            Map permItemMap = (Map)funPermItemEntry.getValue();
            if (!upgradeApps.contains(appNum)) continue;
            ApplicationTypeEnum app = ApplicationTypeEnum.getEnumByNumber((String)appNum);
            if (ApplicationTypeEnum.BGC == app) {
                allPermItems.put(app.getAppnum(), permItemMap);
                continue;
            }
            HashMap<String, List> permItemMap_Eb = new HashMap<String, List>(16);
            HashMap<String, List> permItemMap_Nbg = new HashMap<String, List>(16);
            for (Map.Entry permItemEntry : permItemMap.entrySet()) {
                String entityKey = (String)permItemEntry.getKey();
                List items = (List)permItemEntry.getValue();
                boolean newEbPage = NewEbAppUtil.isNewEbPage((String)entityKey);
                if (newEbPage) {
                    permItemMap_Nbg.put(entityKey, items);
                    continue;
                }
                permItemMap_Eb.put(entityKey, items);
            }
            allPermItems.put(ApplicationTypeEnum.EB.getAppnum(), permItemMap_Eb);
            allPermItems.put("nbg", permItemMap_Nbg);
        }
        return allPermItems;
    }

    private void addAllPermItems(DynamicObjectCollection userPermEntry, Map<String, List<String>> toAddPermItems, Long userId, Long modelId, String detailDimType) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.EB.getAppnum());
        String appId = appInfo.getId();
        for (Map.Entry<String, List<String>> permItemEntry : toAddPermItems.entrySet()) {
            String entityNumber = permItemEntry.getKey();
            List<String> items = permItemEntry.getValue();
            for (String item : items) {
                DynamicObject userPermDetail = userPermEntry.addNew();
                userPermDetail.set("bizapp", (Object)appId);
                userPermDetail.set("controlmode", (Object)"10");
                userPermDetail.set("source", (Object)"1");
                userPermDetail.set("bizroleid", (Object)0L);
                userPermDetail.set("userfield", (Object)userId);
                userPermDetail.set("dim_id", (Object)modelId);
                userPermDetail.set("dim_type", (Object)detailDimType);
                userPermDetail.set("includesub", (Object)"0");
                userPermDetail.set("entitytype", (Object)entityNumber);
                userPermDetail.set("permitem", (Object)item);
            }
        }
    }

    @Override
    public void rollBack() {
        UpgradesContext globalContext = this.getGlobalContext();
        List<Long> toUpModelIds = globalContext.getToUpModelIds();
        QFilter qFilter = new QFilter("forgid", "in", toUpModelIds);
        qFilter.and("fdimtype", "=", (Object)"DIM_EPM_MODEL");
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        String filterParam = instance.getRefFilter(perm_table, qFilter);
        instance.delDataWithoutRef(detail_table, "sys", filterParam);
        instance.reCoverFromBak(detail_table, detail_table_bak, "sys", filterParam);
        instance.clearDataEntityCache("perm_userperm");
        PermissionServiceHelper.clearAllCache();
    }

    @Override
    public void release() {
        this.modelManagers = null;
    }

    @Override
    public void loadData() {
    }
}

