/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.ebupgrades.context.GroupContext;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.CubeUtils;

public class ModelUpgradesTask
extends AbstractUpgradesTask {
    private static final String MODEL = "t_eb_model";

    @Override
    public void backData() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        UpgradesTaskUtil.getInstance().backupsDataByIds(MODEL, toUpModelIds);
    }

    @Override
    public void execute() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        this.updateModelPeriodAndType(toUpModelIds);
        DynamicObject[] models = this.getToUpdateModels();
        this.afterExecute(models);
    }

    private void afterExecute(DynamicObject[] successes) {
        UpgradesContext context = this.getGlobalContext();
        GroupContext groupContext = this.getGroupContext();
        for (DynamicObject success : successes) {
            long id = success.getLong("id");
            ModelContext modelContext = context.getModelInfo(id);
            if (modelContext == null) {
                modelContext = this.createModelContext(success);
                context.putModelContext(id, modelContext);
            }
            groupContext.addParam("model_" + id, success);
            this.markModelOk(id);
        }
        UpgradesTaskUtil.getInstance().clearDataEntityCache("epm_model");
    }

    private ModelContext createModelContext(DynamicObject modelDyn) {
        Model model = Model.of((DynamicObject)modelDyn);
        ModelContext modelContext = new ModelContext();
        modelContext.setModelCache(model);
        return modelContext;
    }

    private DynamicObject[] getToUpdateModels() {
        UpgradesContext context = this.getGlobalContext();
        List<Long> toUpModelIds = context.getToUpModelIds();
        return BusinessDataServiceHelper.load((Object[])toUpModelIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"epm_model"));
    }

    private void updateModelPeriodAndType(List<Long> toUpdateModels) {
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        QFilter qFilter = new QFilter("fid", "in", toUpdateModels);
        HashMap<String, Object> updateMap = new HashMap<String, Object>(16);
        updateMap.put("fisdetailtomonth", true);
        updateMap.put("fisdetailtoqrt", false);
        updateMap.put("fisdetailtohalfyear", false);
        updateMap.put("fmincludeqrt", true);
        updateMap.put("fmincludeyear", true);
        updateMap.put("freporttype", ApplicationTypeEnum.BG.getIndex());
        instance.updateData(MODEL, updateMap, qFilter.toString());
    }

    @Override
    public void rollBack() {
        List<Long> toUpModelIds = this.getGlobalContext().getToUpModelIds();
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        QFilter qFilter = new QFilter("fid", "in", toUpModelIds);
        String filterParam = qFilter.toString();
        instance.rollDataFromBak(MODEL, filterParam);
        UpgradesTaskUtil.getInstance().clearDataEntityCache("epm_model");
        toUpModelIds.forEach(e -> {
            ModelCacheContext.removeModel((Long)e);
            CubeUtils.updateCubeVersion((Long)e);
        });
    }

    @Override
    public void loadData() {
        DynamicObject[] toUpdateModels;
        UpgradesContext globalContext = this.getGlobalContext();
        GroupContext groupContext = this.getGroupContext();
        for (DynamicObject toUpdateModel : toUpdateModels = this.getToUpdateModels()) {
            long modelId = toUpdateModel.getLong("id");
            Model model = Model.of((DynamicObject)toUpdateModel);
            ModelContext modelContext = new ModelContext();
            modelContext.setModelCache(model);
            globalContext.putModelContext(modelId, modelContext);
            groupContext.addParam("model_" + modelId, toUpdateModel);
        }
    }

    @Override
    public void release() {
    }
}

