/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.context.OldDataContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.controller.EbShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekExecuteServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.metadata.KDCell;

public class OlapDataUpgradesTask
extends AbstractUpgradesTask {
    @Override
    public void backData() {
    }

    @Override
    public void execute() {
        UpgradesContext globalContext = this.getGlobalContext();
        List<Long> toUpModelIds = globalContext.getToUpModelIds();
        for (Long modelId : toUpModelIds) {
            ModelContext modelInfo = globalContext.getModelInfo(modelId);
            if (modelInfo == null) {
                throw new KDBizException("model cache is empty:" + modelId);
            }
            Model modelCache = modelInfo.getModelCache();
            if (modelCache == null || modelCache.isModelByEB()) {
                throw new KDBizException("model type error:" + modelId);
            }
            Dataset dataset = Dataset.of((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)modelInfo.getDefaultDataset().getId(), (String)"eb_dataset"));
            ShrekOlapServiceHelper.dropCube((Model)modelCache, Collections.singletonList(dataset));
            ShrekOlapServiceHelper.createCube((Model)modelCache, (Dataset)dataset, (IModelCacheHelper)new ModelCacheHelper(modelCache), (ShrekConfig)ShrekConfigServiceHelper.getBgMDConfig());
            this.updateData(modelInfo, dataset);
        }
    }

    private void updateData(ModelContext modelContext, Dataset newDataset) {
        SelectCommandInfo queryInfo = this.buildCommandInfo(modelContext);
        Model modelCache = modelContext.getModelCache();
        HashMap<String, Integer> dimNumIndex = new HashMap<String, Integer>(queryInfo.getDimensions().size());
        int seq = 0;
        for (String dimNum : queryInfo.getDimensions()) {
            dimNumIndex.put(dimNum, seq++);
        }
        boolean hasNewChangeType = modelCache.getDimension(SysDimensionEnum.ChangeType.getNumber()).getMember(null, "DataIntegration_1") != null;
        Map<String, String> periodMembMap = this.getPeriodMembMap(modelContext);
        Model oldModel = new Model();
        oldModel.setId(modelCache.getId());
        oldModel.setDataSourceId(modelCache.getDataSourceId());
        oldModel.setReportType(ApplicationTypeEnum.EB.getIndex());
        oldModel.setNumber(modelCache.getNumber());
        oldModel.setCubeNumber(modelCache.getCubeNumber());
        LogStats logStats = new LogStats("OlapDataUpgradesTask");
        Dimension entityDim = modelCache.getDimension(SysDimensionEnum.Entity.getNumber());
        List entityMembFilters = null;
        StringBuilder logInfo = new StringBuilder();
        logInfo.append("model:").append(oldModel.getNumber()).append(',');
        logInfo.append("membCount:{");
        for (DimensionFilterItem filterItem : queryInfo.getFilter()) {
            if (filterItem.getName().equals(SysDimensionEnum.Entity.getNumber())) {
                entityMembFilters = filterItem.getValues();
                continue;
            }
            logInfo.append(filterItem.getName()).append(":").append(filterItem.getValues().size()).append(',');
        }
        if (entityMembFilters == null) {
            return;
        }
        int entityMembCount = 0;
        int olapDataCount = 0;
        for (Member entityMemb : entityDim.getAllMembers()) {
            if (!entityMemb.isLeaf()) continue;
            entityMembFilters.set(0, entityMemb.getNumber());
            ++entityMembCount;
            ShrekOlapReader reader = EbShrekOlapServiceHelper.queryReader((Model)oldModel, (SelectCommandInfo)queryInfo, (LogStats)logStats);
            Throwable throwable = null;
            try {
                if (!reader.hasNext()) continue;
                IShrekSave shrekOlapSave = ShrekExecuteServiceHelper.saveData((Model)modelCache, (Dataset)newDataset, (String[])modelCache.getDimensionNums(), (Map)ShrekIdCodeUtils.getDefaultIdCodes(null));
                Throwable throwable2 = null;
                try {
                    do {
                        IKDCell cell;
                        if ((cell = KDCell.of((Object[])reader.next())) == null || cell.getValue() == null) continue;
                        String[] numbers = cell.getMeta().getNumber();
                        String[] newMembStrs = this.getNewMembStrs(numbers, dimNumIndex, modelCache, periodMembMap, hasNewChangeType);
                        shrekOlapSave.add(newMembStrs, cell.getValue().getValue());
                        ++olapDataCount;
                    } while (reader.hasNext());
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (shrekOlapSave == null) continue;
                    if (throwable2 != null) {
                        try {
                            shrekOlapSave.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    shrekOlapSave.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                reader.close();
            }
        }
        logInfo.append(SysDimensionEnum.Entity.getNumber()).append(":").append(entityMembCount).append("},");
        logInfo.append("olapDataCount:").append(olapDataCount).append("|");
        this.addLogInfo(logInfo.toString());
    }

    private Map<String, String> getPeriodMembMap(ModelContext modelContext) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        OldDataContext oldPeriodData = modelContext.getOldDataContext(SysDimensionEnum.Period.getMemberTreemodel());
        for (DynamicObject obj : oldPeriodData.getOldData()) {
            if (!obj.getBoolean("isleaf")) continue;
            String number = obj.getString("number");
            String matchNum = null;
            if (number.endsWith("_HF1")) {
                matchNum = "M_M01";
            } else if (number.endsWith("_HF2")) {
                matchNum = "M_M07";
            } else if (number.endsWith("_Q1")) {
                matchNum = "M_M01";
            } else if (number.endsWith("_Q2")) {
                matchNum = "M_M04";
            } else if (number.endsWith("_Q3")) {
                matchNum = "M_M07";
            } else if (number.endsWith("_Q4")) {
                matchNum = "M_M10";
            }
            if (matchNum == null) continue;
            result.put(number, matchNum);
        }
        return result;
    }

    private SelectCommandInfo buildCommandInfo(ModelContext modelContext) {
        Model modelCache = modelContext.getModelCache();
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        List<String> oldDimNums = modelCache.getDimension().stream().filter(dimension -> !SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber()) && !SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())).map(BaseCache::getNumber).collect(Collectors.toList());
        oldDimNums.add(SysDimensionEnum.Scenario.getNumber());
        oldDimNums.add(SysDimensionEnum.Process.getNumber());
        oldDimNums.add(SysDimensionEnum.Year.getNumber());
        oldDimNums.add(SysDimensionEnum.Period.getNumber());
        queryInfo.setDimensions(oldDimNums);
        this.addDimMembInfo(queryInfo, oldDimNums, modelContext);
        queryInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        return queryInfo;
    }

    private String[] getNewMembStrs(String[] oldMembNums, Map<String, Integer> dimNumIndex, Model newModelCache, Map<String, String> peridMembMap, boolean hasNewChangeType) {
        String peridMemb = oldMembNums[dimNumIndex.get(SysDimensionEnum.Period.getNumber())];
        String yearMemb = oldMembNums[dimNumIndex.get(SysDimensionEnum.Year.getNumber())];
        String changeType = oldMembNums[dimNumIndex.get(SysDimensionEnum.ChangeType.getNumber())];
        String newPeridMemb = peridMembMap.getOrDefault(peridMemb, peridMemb);
        newPeridMemb = newPeridMemb.replace("M_", "");
        String[] nums = new String[newModelCache.getDimension().size()];
        int seq = 0;
        for (Dimension dimension : newModelCache.getDimension()) {
            String dimNum = dimension.getNumber();
            String membNum = null;
            Integer index = dimNumIndex.get(dimNum);
            if (index == null) {
                if (SysDimensionEnum.Metric.getNumber().equals(dimNum)) {
                    membNum = "Money";
                } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNum)) {
                    membNum = yearMemb + "." + newPeridMemb;
                }
            } else {
                membNum = SysDimensionEnum.ChangeType.getNumber().equals(dimNum) ? ("ActualChanges".equals(changeType) ? "DataIntegration" : ("DataIntegration".equals(changeType) && hasNewChangeType ? "DataIntegration_1" : changeType)) : oldMembNums[index];
            }
            nums[seq++] = membNum;
        }
        return nums;
    }

    private void addDimMembInfo(SelectCommandInfo queryInfo, List<String> dimNums, ModelContext modelContext) {
        for (String dimNumber : dimNums) {
            String[] memberArray;
            if (SysDimensionEnum.Scenario.getNumber().equals(dimNumber)) {
                memberArray = new String[]{"NoScenario"};
            } else if (SysDimensionEnum.Process.getNumber().equals(dimNumber)) {
                memberArray = new String[]{"IRpt"};
            } else if (SysDimensionEnum.Year.getNumber().equals(dimNumber) || SysDimensionEnum.Period.getNumber().equals(dimNumber)) {
                SysDimensionEnum dimensionEnum = SysDimensionEnum.Period.getNumber().equals(dimNumber) ? SysDimensionEnum.Period : SysDimensionEnum.Year;
                OldDataContext oldDatas = modelContext.getOldDataContext(dimensionEnum.getMemberTreemodel());
                if (oldDatas == null) {
                    throw new KDBizException(String.format("old %s membs is null:%s", dimensionEnum.getNumber(), modelContext.getModelCache().getNumber()));
                }
                List membObjs = oldDatas.getOldData().stream().filter(obj -> obj.getBoolean("isleaf")).collect(Collectors.toList());
                memberArray = new String[membObjs.size()];
                int seq = 0;
                for (DynamicObject member2 : membObjs) {
                    memberArray[seq] = member2.getString("number");
                    ++seq;
                }
            } else if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                memberArray = new String[]{"test"};
            } else {
                boolean isCT = SysDimensionEnum.ChangeType.getNumber().equals(dimNumber);
                List allMembers = modelContext.getModelCache().getDimension(dimNumber).getAllMembers().stream().filter(member -> {
                    if (isCT) {
                        String membNum = member.getNumber();
                        return "ActualChanges".equals(membNum) || !"DataIntegration_1".equals(membNum) && member.isLeaf();
                    }
                    return member.isLeaf();
                }).collect(Collectors.toList());
                memberArray = new String[allMembers.size()];
                int seq = 0;
                for (Member member3 : allMembers) {
                    memberArray[seq] = member3.getNumber();
                    ++seq;
                }
            }
            queryInfo.addFilter(dimNumber, memberArray);
        }
    }

    @Override
    public void rollBack() {
        DynamicObject[] dataSetObjs;
        List<Long> toUpModelIds = this.getGlobalContext().getToUpModelIds();
        QFBuilder qb = new QFBuilder("number", "=", (Object)"default");
        qb.add("model", "in", toUpModelIds);
        for (DynamicObject obj : dataSetObjs = BusinessDataServiceHelper.load((String)"eb_dataset", (String)"id,number,model.number,model.shownumber,model.reportType,model.datasource", (QFilter[])qb.toArray())) {
            Long datasetId = obj.getLong("id");
            String datasetNum = obj.getString("number");
            DynamicObject modelObj = obj.getDynamicObject("model");
            Model model = Model.of((DynamicObject)modelObj);
            if (model.isModelByEB()) continue;
            ShrekOlapServiceHelper.dropCube((Model)model, Collections.singletonList(new Dataset(datasetId, datasetNum)));
        }
    }

    @Override
    public void release() {
    }

    @Override
    public void loadData() {
    }
}

