/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.business.ebupgrades.pojo.EntityMetaPerm;
import kd.epm.eb.business.ebupgrades.utils.PermUpgradesUtil;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.StringUtils;

public class RolePermUpgradesTask
extends AbstractUpgradesTask {
    private static final String role_detail_table_bak = "t_perm_rolepermdetial_epm_bak";
    private static final String role_perm_table = "t_perm_roleperm";
    private static final String role_detail_table = "t_perm_rolepermdetial";
    private static final String role_table = "perm_roleperm";
    private List<String> epmRoleIds = null;

    @Override
    public void backData() {
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        List<String> epmRoleIds = this.getEpmRoleIds();
        if (epmRoleIds.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("froleid", "in", epmRoleIds);
        String filterParam = instance.getRefFilter(role_perm_table, qFilter);
        instance.backupsData(role_detail_table, role_detail_table_bak, "sys", filterParam);
    }

    private List<String> getEpmRoleIds() {
        if (this.epmRoleIds == null) {
            this.epmRoleIds = PermUpgradesUtil.getInstance().getEpmRoleIds();
        }
        return this.epmRoleIds;
    }

    @Override
    public void execute() {
        QFilter qFilter = new QFilter("roleid", "in", this.getEpmRoleIds());
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, role_table, null);
        DynamicObject[] rolePerms = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)role_table));
        Map<String, EntityMetaPerm> ebUpgradesPermMap = PermUpgradesUtil.getInstance().getEbUpgradesPermMap();
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.EB.getAppnum());
        String appId = appInfo.getId();
        for (DynamicObject rolePerm : rolePerms) {
            String roleId = rolePerm.getString("roleid.id");
            DynamicObjectCollection rolePermDetails = rolePerm.getDynamicObjectCollection("roleperm");
            HashMap<String, List<String>> toAddPermItems = new HashMap<String, List<String>>(16);
            Iterator iterator = rolePermDetails.iterator();
            while (iterator.hasNext()) {
                DynamicObject rolePermDetail = (DynamicObject)iterator.next();
                String appNumber = rolePermDetail.getString("bizapp.id");
                if (!appId.equals(appNumber)) continue;
                String entityNumber = rolePermDetail.getString("entity.number");
                EntityMetaPerm entityMetaPerm = ebUpgradesPermMap.get(entityNumber);
                if (entityMetaPerm != null) {
                    String permItem;
                    String mapEntity = entityMetaPerm.getMapEntity();
                    Map<String, String> permItemMap = entityMetaPerm.getPermItemMap();
                    String replacePerm = permItemMap.get(permItem = rolePermDetail.getString("permitem.id"));
                    if (StringUtils.isNotEmpty((String)replacePerm)) {
                        List permItems = toAddPermItems.computeIfAbsent(mapEntity, k -> new ArrayList(16));
                        permItems.add(replacePerm);
                    }
                }
                iterator.remove();
            }
            this.addAllPermItems(rolePermDetails, toAddPermItems, roleId);
        }
        SaveServiceHelper.save((DynamicObject[])rolePerms);
        PermissionServiceHelper.clearAllCache();
    }

    private void addAllPermItems(DynamicObjectCollection rolePermDetails, Map<String, List<String>> toAddPermItems, String roleId) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.EB.getAppnum());
        String appId = appInfo.getId();
        for (Map.Entry<String, List<String>> permItemEntry : toAddPermItems.entrySet()) {
            String entityNumber = permItemEntry.getKey();
            List<String> items = permItemEntry.getValue();
            for (String item : items) {
                DynamicObject rolePermDetail = rolePermDetails.addNew();
                rolePermDetail.set("bizapp", (Object)appId);
                rolePermDetail.set("entity", (Object)entityNumber);
                rolePermDetail.set("permitem", (Object)item);
                rolePermDetail.set("droleid", (Object)roleId);
            }
        }
    }

    @Override
    public void rollBack() {
        UpgradesTaskUtil instance = UpgradesTaskUtil.getInstance();
        List<String> epmRoleIds = this.getEpmRoleIds();
        if (epmRoleIds.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("froleid", "in", epmRoleIds);
        String filterParam = instance.getRefFilter(role_perm_table, qFilter);
        instance.delDataWithoutRef(role_detail_table, "sys", filterParam);
        instance.reCoverFromBak(role_detail_table, role_detail_table_bak, "sys", filterParam);
        instance.clearDataEntityCache(role_table);
        PermissionServiceHelper.clearAllCache();
    }

    @Override
    public void release() {
        this.epmRoleIds = null;
    }

    @Override
    public void loadData() {
    }
}

