/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.ebupgrades.constants.TaskStatus;
import kd.epm.eb.business.ebupgrades.context.GroupContext;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.business.ebupgrades.pojo.MainRecord;
import kd.epm.eb.business.ebupgrades.utils.UpgradesHelper;

public class TaskGroup
implements Runnable {
    private List<AbstractUpgradesTask> taskList;
    private CountDownLatch downLatch;
    private String groupKey;
    private UpgradesContext upgradesContext;
    private MainRecord mainRecord;
    private static final Log log = LogFactory.getLog(TaskGroup.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        GroupContext groupContext = new GroupContext();
        try {
            for (AbstractUpgradesTask task : this.taskList) {
                if (this.upgradesContext.isHasError()) continue;
                task.setGroupContext(groupContext);
                if (task.getStatus() == TaskStatus.SUCCEED || task.getStatus() == TaskStatus.ROLLING || task.getStatus() == TaskStatus.ROLLFAILED) {
                    task.loadData();
                    continue;
                }
                if (!this.runTask(task)) continue;
                this.upgradesContext.setHasError(true);
                break;
            }
        }
        catch (Exception e) {
            this.upgradesContext.setHasError(true);
            log.error("TaskGroup:" + this.groupKey, (Throwable)e);
        }
        finally {
            if (this.downLatch != null) {
                this.downLatch.countDown();
            }
        }
    }

    private boolean runTask(AbstractUpgradesTask task) {
        TaskStatus status = TaskStatus.SUCCEED;
        long beginTime = System.currentTimeMillis();
        try {
            UpgradesHelper.markTaskStatus(task, this.mainRecord, TaskStatus.UPING, 0L);
            task.backData();
        }
        catch (Exception e) {
            status = TaskStatus.FAILED;
            log.error("runTask_backData:" + task.getTaskKey(), (Throwable)e);
        }
        try (TXHandle tx = TX.required((String)("runTask:" + task.getTaskKey()));){
            try {
                try {
                    if (status != TaskStatus.FAILED) {
                        task.clearLogInfo();
                        task.execute();
                        task.doRelease();
                    }
                }
                catch (Throwable e) {
                    task.doRelease();
                    status = TaskStatus.FAILED;
                    log.error("runTask:" + task.getTaskKey(), e);
                }
                long endTime = System.currentTimeMillis();
                UpgradesHelper.markTaskStatus(task, this.mainRecord, status, endTime - beginTime);
            }
            catch (Throwable e) {
                log.error("markTaskStatus:" + task.getTaskKey(), e);
                status = TaskStatus.FAILED;
            }
            if (status == TaskStatus.FAILED) {
                tx.markRollback();
            }
        }
        return status == TaskStatus.FAILED;
    }

    public boolean rollbackTask() {
        boolean hasError = false;
        for (int taskSeq = this.taskList.size() - 1; taskSeq >= 0; --taskSeq) {
            AbstractUpgradesTask task = this.taskList.get(taskSeq);
            if (task.getStatus() != TaskStatus.SUCCEED && task.getStatus() != TaskStatus.ROLLFAILED && task.getStatus() != TaskStatus.ROLLING) continue;
            try (TXHandle tx = TX.required((String)("rollbackTask:" + task.getTaskKey()));){
                try {
                    hasError = this.rollbackTask(task);
                }
                catch (Throwable e) {
                    log.error("rollbackTask:" + task.getTaskKey(), e);
                    hasError = true;
                }
                if (!hasError) continue;
                tx.markRollback();
                break;
            }
        }
        return hasError;
    }

    private boolean rollbackTask(AbstractUpgradesTask task) {
        boolean hasError = false;
        long beginTime = System.currentTimeMillis();
        TaskStatus taskStatus = TaskStatus.ROLLED;
        try {
            UpgradesHelper.markTaskStatus(task, this.mainRecord, TaskStatus.ROLLING, 0L);
            task.clearLogInfo();
            task.doRelease();
            task.rollBack();
        }
        catch (Throwable e) {
            hasError = true;
            log.error("rollbackTask:" + task.getTaskKey(), e);
            taskStatus = TaskStatus.ROLLFAILED;
        }
        long endTime = System.currentTimeMillis();
        UpgradesHelper.markTaskStatus(task, this.mainRecord, taskStatus, endTime - beginTime);
        return hasError;
    }

    public List<AbstractUpgradesTask> getTaskList() {
        if (this.taskList == null) {
            this.taskList = new ArrayList<AbstractUpgradesTask>(16);
        }
        return this.taskList;
    }

    public void setTaskList(List<AbstractUpgradesTask> taskList) {
        this.taskList = taskList;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public void setDownLatch(CountDownLatch downLatch) {
        this.downLatch = downLatch;
    }

    public void getUpgradesContext(UpgradesContext upgradesContext) {
        this.upgradesContext = upgradesContext;
    }

    public void setUpgradesContext(UpgradesContext upgradesContext) {
        this.upgradesContext = upgradesContext;
    }

    public MainRecord getMainRecord() {
        return this.mainRecord;
    }

    public void setMainRecord(MainRecord mainRecord) {
        this.mainRecord = mainRecord;
    }
}

