/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.tasks.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.ebupgrades.context.GroupContext;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import kd.epm.eb.common.utils.period.BgPeriodUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlUtils;

public class ControlUpgradesTask
extends AbstractUpgradesTask {
    private static final Log log = LogFactory.getLog(ControlUpgradesTask.class);
    private static final String modelTable = "t_eb_controlupgrademodel";
    private static final String memberTable = "t_eb_controlupgrademember";
    private static final String ctrlDimTable = "t_eb_controlupgradctrldim";
    private static final String ctrlDimNameTable = "t_eb_controlupgradecdn";

    @Override
    public void backData() {
        this.checkTable();
        ModelContext modelContext = null;
        ArrayList backModels = Lists.newArrayListWithExpectedSize((int)this.getGlobalContext().getToUpModelIds().size());
        ArrayList backPeriods = Lists.newArrayListWithExpectedSize((int)(this.getGlobalContext().getToUpModelIds().size() * 10));
        QFilter qf = new QFilter("model.id", "in", new HashSet<Long>(this.getGlobalContext().getToUpModelIds()));
        DynamicObject[] bgPeriodArrays = BusinessDataServiceHelper.load((String)"epm_bperiodmembertree", (String)"id, number, model.id", (QFilter[])qf.toArray());
        Map<String, Map<String, DynamicObject>> bgPeriodMap = this.convertToMap(bgPeriodArrays, "model.id", "number");
        Map<String, DynamicObject> subBgPeriodmap = null;
        Map<String, DynamicObject> subEbPeriodMap = null;
        Map<String, DynamicObject> subEbYearMap = null;
        BgPeriodHelper.PeriodType periodType = null;
        String yearNumber = null;
        String ebPeriodNumber = null;
        for (Long modelId : this.getGlobalContext().getToUpModelIds()) {
            log.info("control-upgrade-backdata: modelid = " + modelId);
            modelContext = this.getGlobalContext().getModelInfo(modelId);
            Map<String, Map<String, DynamicObject>> ebPeriodMap = this.convertToMap(modelContext.getOldDataContext("epm_periodmembertree").getOldData().toArray(new DynamicObject[0]), "model.id", "number");
            Map<String, Map<String, DynamicObject>> ebYeardMap = this.convertToMap(modelContext.getOldDataContext("epm_yearmembertree").getOldData().toArray(new DynamicObject[0]), "model.id", "number");
            backModels.add(new Object[]{modelContext.getModelCache().getId(), BizModel.getBgControlRecordTable((Long)modelContext.getDefaultBusModel().getId()), modelId});
            subBgPeriodmap = bgPeriodMap.get(String.valueOf(modelContext.getModelCache().getId()));
            subEbPeriodMap = ebPeriodMap.get(String.valueOf(modelId));
            if (subEbPeriodMap == null) {
                subEbPeriodMap = ebPeriodMap.get(null);
            }
            if ((subEbYearMap = ebYeardMap.get(String.valueOf(modelId))) == null) {
                subEbYearMap = ebYeardMap.get(null);
            }
            if (subBgPeriodmap == null || subEbPeriodMap == null || subEbYearMap == null) {
                log.info("control-upgrade-checknull");
                continue;
            }
            for (DynamicObject bgPeriod : subBgPeriodmap.values()) {
                periodType = BgPeriodHelper.parse((String)bgPeriod.getString("number"));
                if (periodType == null) continue;
                yearNumber = BgPeriodUtils.getPeriodYear((int)periodType.getYear());
                ebPeriodNumber = this.getPeriodNumber(true, periodType);
                if (ebPeriodNumber == null) {
                    log.info("control-upgrade-ebPeriodNumber is null: type = " + periodType.getType() + " year = " + periodType.getYear() + " period = " + periodType.getPeriod());
                    continue;
                }
                yearNumber = BgPeriodUtils.getPeriodYear((int)periodType.getYear());
                if (!subEbYearMap.containsKey(yearNumber)) {
                    log.info("control-upgrade-checknull: yearNumber = " + yearNumber);
                    continue;
                }
                if (!subEbPeriodMap.containsKey(ebPeriodNumber)) {
                    log.info("control-upgrade-checknull: ebPeriodNumber = " + ebPeriodNumber);
                    continue;
                }
                backPeriods.add(new Object[]{bgPeriod.getLong("id"), subEbYearMap.get(yearNumber).getLong("id"), subEbPeriodMap.get(ebPeriodNumber).getLong("id"), modelContext.getModelCache().getId()});
            }
        }
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"delete from t_eb_controlupgrademodel");
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"delete from t_eb_controlupgrademember");
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"insert into t_eb_controlupgrademodel(fid, ftable, foldid) values (?, ?, ?)", (List)backModels);
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"insert into t_eb_controlupgrademember(fid, fyearid, fperiod, fmodelid) values (?, ?, ?, ?)", (List)backPeriods);
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"insert into t_eb_controlupgradctrldim (fentryid, fid, fdimensionid, fseq)  select fentryid, fid, fdimensionid, fseq from t_eb_controldimdetail where fentryid not in(select fentryid from t_eb_controlupgradctrldim)");
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"insert into t_eb_controlupgradecdn (fid, fcontroldim)  select fid, fcontroldim from t_eb_bgmcontroldimension where fid not in (select fid from t_eb_controlupgradecdn)");
    }

    private String getPeriodNumber(boolean isEbModel, BgPeriodHelper.PeriodType periodType) {
        if (4 == periodType.getType()) {
            if (isEbModel) {
                return BgPeriodUtils.getPeriodMonth((int)periodType.getPeriod());
            }
            return BgPeriodUtils.getBgPeriodMonth((int)periodType.getYear(), (int)periodType.getPeriod());
        }
        if (3 == periodType.getType()) {
            if (isEbModel) {
                return BgPeriodUtils.getPeriodQuarter((int)periodType.getPeriod());
            }
            return BgPeriodUtils.getBgPeriodQuarter((int)periodType.getYear(), (int)periodType.getPeriod());
        }
        if (2 == periodType.getType()) {
            if (isEbModel) {
                return BgPeriodUtils.getPeriodHalfYear((int)periodType.getPeriod());
            }
            return BgPeriodUtils.getBgPeriodHalfYear((int)periodType.getYear(), (int)periodType.getPeriod());
        }
        if (1 == periodType.getType()) {
            return BgPeriodUtils.getPeriodYear((int)periodType.getYear());
        }
        return null;
    }

    private Map<String, Map<String, DynamicObject>> convertToMap(DynamicObject[] objects, String modelField, String field) {
        HashMap result = Maps.newHashMap();
        if (objects == null) {
            return result;
        }
        String modelId = null;
        String key = null;
        for (DynamicObject obj : objects) {
            modelId = obj.getString(modelField);
            key = obj.getString(field);
            result.computeIfAbsent(modelId, m -> Maps.newHashMap()).put(key, obj);
        }
        return result;
    }

    private void checkTable() {
        StringBuilder sql;
        if (!SqlBatchUtils.hasTable((String)modelTable)) {
            sql = new StringBuilder();
            sql.append("create table ").append(modelTable).append(" (fid bigint default 0 not null, ftable NVARCHAR(80) NOT NULL DEFAULT ' ', foldid bigint default 0 not null, ");
            sql.append("constraint pk_eb_controlupgmodel").append(" primary key (fid))");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
            DB.execute((DBRoute)BgBaseConstant.epm, (String)"create index ix_eb_controlupgmodo on t_eb_controlupgrademodel(foldid)");
        }
        if (!SqlBatchUtils.hasTable((String)memberTable)) {
            sql = new StringBuilder();
            sql.append("create table ").append(memberTable).append(" (fid bigint default 0 not null, fyearid bigint default 0 not null, fperiod bigint default 0 not null, fmodelid  bigint default 0 not null, ");
            sql.append("constraint pk_eb_controlupgmember").append(" primary key (fid))");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
            DB.execute((DBRoute)BgBaseConstant.epm, (String)"create index ix_eb_controlupgmemm on t_eb_controlupgrademember(fmodelid, fyearid, fperiod)");
        }
        if (!SqlBatchUtils.hasTable((String)ctrlDimTable)) {
            sql = new StringBuilder();
            sql.append("create table ").append(ctrlDimTable).append(" (fentryid bigint default 0 not null, fid bigint default 0 not null, fdimensionid bigint default 0 not null, fseq int default 0 not null, ");
            sql.append("constraint pk_eb_controlupgctrldim").append(" primary key (fentryid))");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        }
        if (!SqlBatchUtils.hasTable((String)ctrlDimNameTable)) {
            sql = new StringBuilder();
            sql.append("create table ").append(ctrlDimNameTable).append(" (fid bigint default 0 not null, fcontroldim nvarchar(200), ");
            sql.append("constraint pk_eb_controlupgcdn").append(" primary key (fid))");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        }
    }

    @Override
    public void execute() {
        this.execute(false);
    }

    public void execute(boolean isRollBack) {
        this.loadConvertData();
        int count = 1;
        for (Long modelId : this.getGlobalContext().getToUpModelIds()) {
            log.info("control-upgrade-execute " + count + "/" + this.getGlobalContext().getToUpModelIds().size() + ": modelid = " + modelId);
            try (TXHandle tx = TX.requiresNew((String)("eb/controlupgrade/" + modelId));){
                this.execute(modelId, isRollBack);
            }
            ++count;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void execute(Long modelId, boolean isRollBack) {
        Object oldColumn;
        Serializable insert;
        Object ctrlDim;
        LogStats stats = new LogStats("budget-control-log : ");
        ModelContext modelContext = this.getGlobalContext().getModelInfo(modelId);
        String ctrlTable = isRollBack ? null : BizModel.getBgControlRecordTable((Long)modelContext.getDefaultBusModel().getId());
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] ctrlVersions = BusinessDataServiceHelper.load((String)"eb_controlversion", (String)"id, datatype, audittrail, bussmodel", (QFilter[])qFilter.toArray());
        if (ctrlVersions == null || ctrlVersions.length != 1) {
            log.info("control-upgrade-execute control version null!");
        } else {
            if (isRollBack) {
                ctrlVersions[0].set("audittrail", null);
                ctrlVersions[0].set("datatype", null);
                ctrlVersions[0].set("bussmodel", null);
            } else {
                ctrlVersions[0].set("audittrail", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.AuditTrail.getNumber()).getMember(Long.valueOf(0L), "ATTotal").getId());
                ctrlVersions[0].set("datatype", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.DataType.getNumber()).getMember(Long.valueOf(0L), "Budget").getId());
                ctrlVersions[0].set("bussmodel", (Object)modelContext.getDefaultBusModel().getId());
            }
            SaveServiceHelper.save((DynamicObject[])ctrlVersions);
            CacheServiceHelper.clearCacheByScenVer();
        }
        String fields = "id, controldim, model.id,businessmodel.id,entryentity.id,entryentity.dimensionid, entryentity.dimensionnumber, entryentity.dimensionname, entryentity.issysdimension, entryentity.seq";
        DynamicObject[] ctrlDims = BusinessDataServiceHelper.load((String)"eb_bgmcontroldimension", (String)fields, (QFilter[])qFilter.toArray());
        ArrayList userDefinedDimensions = Lists.newArrayListWithExpectedSize((int)10);
        if (ctrlDims == null || ctrlDims.length != 1) {
            log.info("control-upgrade-execute control dimension fail!");
        } else {
            if (isRollBack) {
                ctrlDims[0].set("businessmodel", null);
            } else {
                ctrlDims[0].set("businessmodel", (Object)modelContext.getDefaultBusModel().getId());
            }
            DynamicObjectCollection ctrlDimEntries = ctrlDims[0].getDynamicObjectCollection("entryentity");
            ctrlDimEntries.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject arg0, DynamicObject arg1) {
                    if (arg0 == null || arg0.get("seq") == null) {
                        return -1;
                    }
                    if (arg1 == null || arg1.get("seq") == null) {
                        return 1;
                    }
                    return Long.compare(arg0.getLong("seq"), arg1.getLong("seq"));
                }
            });
            int seq = 1;
            Dimension dimension = null;
            int isFirstUseDef = 1;
            int isFirstNull = 1;
            Long id = ctrlDims[0].getLong("id");
            ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)ctrlDimEntries.size());
            if (isRollBack) {
                if (this.getCtrlDimNameMap().containsKey(ctrlDims[0].getLong("id"))) {
                    ctrlDims[0].set("controldim", (Object)this.getCtrlDimNameMap().get(ctrlDims[0].getLong("id")));
                }
                HashSet<Long> hasDimId = new HashSet<Long>(ctrlDimEntries.size());
                Map backupDims = this.getCtrlDimMap().get(id);
                int index = 0;
                Long dimid = null;
                if (backupDims != null) {
                    ArrayList backupDimList = new ArrayList(backupDims.keySet());
                    Iterator it = ctrlDimEntries.iterator();
                    while (it.hasNext()) {
                        DynamicObject ctrlDim2 = (DynamicObject)it.next();
                        dimid = ctrlDim2.getLong("dimensionid");
                        hasDimId.add(dimid);
                        index = backupDimList.indexOf(dimid);
                        if (index >= 0) {
                            ctrlDim2.set("seq", (Object)(index + 1));
                            continue;
                        }
                        it.remove();
                    }
                    for (Map.Entry entry : backupDims.entrySet()) {
                        if (hasDimId.contains(entry.getKey())) continue;
                        ctrlDim = ctrlDimEntries.addNew();
                        ctrlDim.set("dimensionid", entry.getKey());
                        ctrlDim.set("id", entry.getValue());
                        ctrlDim.set("seq", (Object)(backupDimList.indexOf(entry.getKey()) + 1));
                    }
                }
            } else {
                DynamicObject[] ctrlDimArrays = (DynamicObject[])ctrlDimEntries.toArray((Object[])new DynamicObject[ctrlDimEntries.size()]);
                if (ctrlDimArrays.length == 0) {
                    ArrayList<Dimension> dimensions = new ArrayList<Dimension>(modelContext.getModelCache().getDimension());
                    dimensions.sort(Comparator.comparingInt(BaseCache::getSeq));
                    seq = 1;
                    for (Dimension d : dimensions) {
                        DynamicObject entry = ctrlDimEntries.addNew();
                        entry.set("seq", (Object)seq);
                        ++seq;
                        entry.set("dimensionid", (Object)d.getId());
                        entry.set("dimensionnumber", (Object)d.getNumber());
                        entry.set("dimensionname", (Object)d.getName());
                        entry.set("issysdimension", (Object)Boolean.TRUE);
                        if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                            userDefinedDimensions.add(dimension);
                            entry.set("issysdimension", (Object)Boolean.FALSE);
                        }
                        arrayList.add(d);
                    }
                } else {
                    boolean isAddAudittril = false;
                    for (int i = 0; i < ctrlDimArrays.length; ++i) {
                        dimension = modelContext.getModelCache().getDimension(Long.valueOf(ctrlDimArrays[i].getLong("dimensionid")));
                        if (dimension == null) {
                            ctrlDimEntries.remove((Object)ctrlDimArrays[i]);
                            if (isFirstNull == 0) continue;
                            DynamicObject entry = ctrlDimEntries.addNew();
                            entry.set("seq", (Object)seq);
                            ++seq;
                            entry.set("dimensionid", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.BudgetPeriod.getNumber()).getId());
                            entry.set("dimensionnumber", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.BudgetPeriod.getNumber()).getNumber());
                            entry.set("dimensionname", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.BudgetPeriod.getNumber()).getName());
                            entry.set("issysdimension", (Object)Boolean.TRUE);
                            arrayList.add(modelContext.getModelCache().getDimension(SysDimensionEnum.BudgetPeriod.getNumber()));
                            isFirstNull = 0;
                            continue;
                        }
                        ctrlDimArrays[i].set("dimensionnumber", (Object)dimension.getNumber());
                        if (isFirstUseDef != 0 && BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                            isAddAudittril = true;
                            DynamicObject auditTrail = ctrlDimEntries.addNew();
                            auditTrail.set("seq", (Object)seq);
                            ++seq;
                            auditTrail.set("dimensionid", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.DataType.getNumber()).getId());
                            auditTrail.set("dimensionnumber", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.DataType.getNumber()).getNumber());
                            auditTrail.set("dimensionname", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.DataType.getNumber()).getName());
                            auditTrail.set("issysdimension", (Object)Boolean.TRUE);
                            arrayList.add(modelContext.getModelCache().getDimension(SysDimensionEnum.DataType.getNumber()));
                            auditTrail = ctrlDimEntries.addNew();
                            auditTrail.set("seq", (Object)seq);
                            ++seq;
                            auditTrail.set("dimensionid", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber()).getId());
                            auditTrail.set("dimensionnumber", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber()).getNumber());
                            auditTrail.set("dimensionname", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber()).getName());
                            auditTrail.set("issysdimension", (Object)Boolean.TRUE);
                            arrayList.add(modelContext.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber()));
                            isFirstUseDef = 0;
                        }
                        if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                            userDefinedDimensions.add(dimension);
                        }
                        arrayList.add(dimension);
                        ctrlDimArrays[i].set("seq", (Object)seq);
                    }
                    if (!isAddAudittril) {
                        DynamicObject auditTrail = ctrlDimEntries.addNew();
                        auditTrail.set("seq", (Object)seq);
                        ++seq;
                        auditTrail.set("dimensionid", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.DataType.getNumber()).getId());
                        auditTrail.set("dimensionnumber", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.DataType.getNumber()).getNumber());
                        auditTrail.set("dimensionname", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.DataType.getNumber()).getName());
                        auditTrail.set("issysdimension", (Object)Boolean.TRUE);
                        arrayList.add(modelContext.getModelCache().getDimension(SysDimensionEnum.DataType.getNumber()));
                        auditTrail = ctrlDimEntries.addNew();
                        auditTrail.set("seq", (Object)seq);
                        ++seq;
                        auditTrail.set("dimensionid", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber()).getId());
                        auditTrail.set("dimensionnumber", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber()).getNumber());
                        auditTrail.set("dimensionname", (Object)modelContext.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber()).getName());
                        auditTrail.set("issysdimension", (Object)Boolean.TRUE);
                        arrayList.add(modelContext.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber()));
                    }
                }
                StringBuilder name = new StringBuilder();
                for (Dimension _dimension : arrayList) {
                    if (name.length() > 0) {
                        name.append(",");
                    }
                    name.append(_dimension.getName());
                }
                if (name.length() > 199) {
                    name.setLength(196);
                    name.append("...");
                }
                ctrlDims[0].set("controldim", (Object)name.toString());
            }
            SaveServiceHelper.save((DynamicObject[])ctrlDims);
        }
        String sql1 = "Update t_eb_dimmaterulebill Set fbussmodelid = ?, fmetricfield = ? Where fmodelid = ?";
        if (isRollBack) {
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql1, (Object[])new Object[]{0, 0, modelId});
        } else {
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql1, (Object[])new Object[]{modelContext.getDefaultBusModel().getId(), modelContext.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber()).getMember(Long.valueOf(0L), "Money").getId(), modelId});
        }
        fields = "id,model,bussmodel";
        Dimension dimMapping = BusinessDataServiceHelper.load((String)"eb_dimmembermapping", (String)fields, (QFilter[])qFilter.toArray());
        if (dimMapping == null || ((DynamicObject[])dimMapping).length == 0) {
            log.info("control-upgrade-execute control dimmembermapping null!");
        } else {
            for (DynamicObject mapping : dimMapping) {
                if (isRollBack) {
                    mapping.set("bussmodel", null);
                    continue;
                }
                mapping.set("bussmodel", (Object)modelContext.getDefaultBusModel().getId());
            }
            SaveServiceHelper.save((DynamicObject[])dimMapping);
        }
        DynamicObject[] ctrlSetttings = BusinessDataServiceHelper.load((String)"eb_bgcontrolrulemain", (String)fields, (QFilter[])qFilter.toArray());
        if (ctrlSetttings == null || ctrlSetttings.length == 0) {
            log.info("control-upgrade-execute control dimmembermapping fail!");
        } else {
            for (DynamicObject dynamicObject : ctrlSetttings) {
                if (isRollBack) {
                    dynamicObject.set("bussmodel", null);
                    continue;
                }
                dynamicObject.set("bussmodel", (Object)modelContext.getDefaultBusModel().getId());
            }
            SaveServiceHelper.save((DynamicObject[])ctrlSetttings);
        }
        DynamicObject[] centralizeds = BusinessDataServiceHelper.load((String)"eb_centralized_entity", (String)fields, (QFilter[])qFilter.toArray());
        if (centralizeds == null || centralizeds.length == 0) {
            log.info("control-upgrade-execute control centralized fail!");
        } else {
            void var17_30;
            DynamicObject[] isFirstNull = centralizeds;
            int mapping = isFirstNull.length;
            boolean bl = false;
            while (var17_30 < mapping) {
                DynamicObject centralized = isFirstNull[var17_30];
                if (isRollBack) {
                    centralized.set("bussmodel", null);
                } else {
                    centralized.set("bussmodel", (Object)modelContext.getDefaultBusModel().getId());
                }
                ++var17_30;
            }
            SaveServiceHelper.save((DynamicObject[])centralizeds);
            CacheServiceHelper.clearCacheByCentralized((Long)modelId, (LogStats)stats);
        }
        if (ctrlDims != null && ctrlDims.length > 0 && !isRollBack) {
            Long metricid = modelContext.getModelCache().getDimension(SysDimensionEnum.Metric.getNumber()).getMember(Long.valueOf(0L), "Money").getId();
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)("eb/controlupgradechecktable/" + modelId));){
                try {
                    this.checkCtrlTable(modelId, modelContext.getDefaultBusModel().getId(), ctrlDims[0], userDefinedDimensions);
                }
                catch (Throwable ex) {
                    tx.markRollback();
                    throw ex;
                }
            }
            catch (Throwable ex) {
                Throwable throwable2 = ex;
                throw ex;
            }
            Set oldColumns = SqlBatchUtils.getColumns((String)"t_eb_bgcontrolrecord");
            ArrayList arrayList = new ArrayList(SqlBatchUtils.getColumns((String)ctrlTable));
            Collections.sort(arrayList);
            insert = new StringBuilder();
            StringBuilder select = new StringBuilder();
            ((StringBuilder)insert).append("insert into ").append(ctrlTable).append(" (");
            int initLength = ((StringBuilder)insert).length();
            select.append(" select ");
            oldColumn = null;
            for (String newColumn : arrayList) {
                oldColumn = null;
                if ("fdtid".equalsIgnoreCase(newColumn)) {
                    oldColumn = "fdatatypeid";
                } else if ("fatid".equalsIgnoreCase(newColumn)) {
                    oldColumn = "faudittrailid";
                } else if ("fbgperiodid".equalsIgnoreCase(newColumn)) {
                    oldColumn = "?";
                } else if ("fmetricid".equalsIgnoreCase(newColumn)) {
                    oldColumn = "?";
                } else if ("foccperiodid".equalsIgnoreCase(newColumn)) {
                    oldColumn = "?";
                } else if (oldColumns.contains(newColumn)) {
                    oldColumn = newColumn;
                }
                if (oldColumn == null) continue;
                if (((StringBuilder)insert).length() > initLength) {
                    ((StringBuilder)insert).append(", ");
                    select.append(", ");
                }
                ((StringBuilder)insert).append(newColumn);
                select.append((String)oldColumn);
            }
            ((StringBuilder)insert).append(") ").append((CharSequence)select).append(" from ").append("t_eb_bgcontrolrecord").append(" where fmodelid = ? and forgunitid = ? and faccountid = ? and fyearid = ? and fperiodid = ? and foccperiodid = ?");
            HashMap convertParams = Maps.newHashMapWithExpectedSize((int)1000);
            Map<String, Long> convertPeriodMap = this.getConvertPeriodMap().get(modelId);
            if (convertPeriodMap == null) {
                log.info("control-upgrade-execute control convertperiodmap null!");
                return;
            }
            DataSet ds = DB.queryDataSet((String)"queryControlRecord", (DBRoute)BgBaseConstant.epm, (String)"select fmodelid, forgunitid, faccountid, fyearid, fperiodid, foccperiodid from t_eb_bgcontrolrecord where fmodelid = ? group by fmodelid, forgunitid, faccountid, fyearid, fperiodid, foccperiodid", (Object[])new Object[]{modelId});
            ctrlDim = null;
            try {
                if (ds != null) {
                    Long orgunitid = null;
                    Long year = null;
                    Long period = null;
                    Long bgperiodid = null;
                    Long occperiodid = null;
                    Long operiodid = null;
                    List subParams = null;
                    Row row = null;
                    while (ds.hasNext()) {
                        row = ds.next();
                        orgunitid = row.getLong("forgunitid");
                        subParams = convertParams.computeIfAbsent(orgunitid, f -> Lists.newArrayListWithExpectedSize((int)1000));
                        year = row.getLong("fyearid");
                        period = row.getLong("fperiodid");
                        Long l = bgperiodid = convertPeriodMap == null ? null : convertPeriodMap.get(year + "_" + period);
                        if (bgperiodid == null) {
                            log.info("control-upgrade-execute control bgperiod null: year = " + year + " period:" + period);
                            continue;
                        }
                        operiodid = row.getLong("foccperiodid");
                        if (IDUtils.isNull((Long)operiodid)) {
                            occperiodid = 0L;
                        } else {
                            Long l2 = occperiodid = convertPeriodMap == null ? null : convertPeriodMap.get(year + "_" + operiodid);
                            if (occperiodid == null) {
                                log.info("control-upgrade-execute control occperiod null: year = " + year + " period:" + operiodid);
                                continue;
                            }
                        }
                        subParams.add(new Object[]{bgperiodid, metricid, occperiodid, modelId, orgunitid, row.getLong("faccountid"), year, period, operiodid});
                    }
                }
            }
            catch (Throwable orgunitid) {
                ctrlDim = orgunitid;
                throw orgunitid;
            }
            finally {
                if (ds != null) {
                    if (ctrlDim != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable orgunitid) {
                            ((Throwable)ctrlDim).addSuppressed(orgunitid);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            for (Map.Entry entry : convertParams.entrySet()) {
                TXHandle tx2 = TX.requiresNew((String)("eb/controlupgrade/" + entry.getKey()));
                Throwable throwable3 = null;
                try {
                    try {
                        this.excuteSql(((StringBuilder)insert).toString(), (List)entry.getValue());
                    }
                    catch (Throwable ex) {
                        tx2.markRollback();
                        throw ex;
                    }
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (tx2 == null) continue;
                    if (throwable3 != null) {
                        try {
                            tx2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable3.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    tx2.close();
                }
            }
        }
        String backTable = "t_eb_bgcontrolrecord_bak";
        boolean hasBackTable = false;
        if (SqlBatchUtils.hasTable((String)backTable)) {
            hasBackTable = true;
            BgControlRecordUtils.checkExistOccTypeByRecord(backTable);
            TXHandle tXHandle = TX.requiresNew();
            insert = null;
            try {
                DB.execute((DBRoute)BgBaseConstant.epm, (String)String.format("EXEC p_AlterColumn '%s', 'FENTRYID', 'VARCHAR(50)', 'NOT NULL', '1111', ''' '''", backTable));
            }
            catch (Throwable select) {
                insert = select;
                throw select;
            }
            finally {
                if (tXHandle != null) {
                    if (insert != null) {
                        try {
                            tXHandle.close();
                        }
                        catch (Throwable select) {
                            ((Throwable)insert).addSuppressed(select);
                        }
                    } else {
                        tXHandle.close();
                    }
                }
            }
        }
        Set set = SqlBatchUtils.getColumns((String)"t_eb_bgcontrolrecord");
        String alFields = StringUtils.join((Collection)set, (String)",");
        if (isRollBack) {
            if (hasBackTable) {
                Set backColumns = SqlBatchUtils.getColumns((String)backTable);
                set.retainAll(backColumns);
                alFields = StringUtils.join((Collection)set, (String)",");
                DB.execute((DBRoute)BgBaseConstant.epm, (String)("update t_eb_bgcontrolindex t0 set ftable = ? where exists(select fbizId from " + backTable + " t1 where t1.fmodelid = ? and t1.fentitynumber = t0.fentitynumber and t1.fbizid = t0.fbizid)"), (Object[])new Object[]{"t_eb_bgcontrolrecord", modelId});
                String sql = "insert into " + "t_eb_bgcontrolrecord" + "(" + alFields + ") select " + alFields + " from " + backTable + " where fmodelid = ?";
                DB.execute((DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{modelId});
                DB.execute((DBRoute)BgBaseConstant.epm, (String)("delete from " + backTable + " where fmodelid = ?"), (Object[])new Object[]{modelId});
            }
        } else if (SqlBatchUtils.hasTable((String)ctrlTable)) {
            DB.execute((DBRoute)BgBaseConstant.epm, (String)("update t_eb_bgcontrolindex set ftable = ? where ftable = ? and exists (select fbizid from " + ctrlTable + " where fbizid = " + "t_eb_bgcontrolindex" + ".fbizid)"), (Object[])new Object[]{ctrlTable, "t_eb_bgcontrolrecord"});
            boolean hasCr = false;
            DataSet ds = DB.queryDataSet((String)"queryControlRecord", (DBRoute)BgBaseConstant.epm, (String)"select top 1 fid from t_eb_bgcontrolrecord");
            oldColumn = null;
            try {
                if (ds.hasNext()) {
                    hasCr = true;
                }
            }
            catch (Throwable throwable) {
                oldColumn = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (oldColumn != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)oldColumn).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            if (hasCr) {
                if (!hasBackTable) {
                    UpgradesTaskUtil.getInstance().createBackupTable(DBRoute.of((String)"epm"), backTable, "t_eb_bgcontrolrecord");
                    DB.execute((DBRoute)BgBaseConstant.epm, (String)("create index ix_eb_bgcontrolrbk on " + backTable + "(fbizId, fentitynumber)"));
                }
                Set backColumns = SqlBatchUtils.getColumns((String)backTable);
                set.retainAll(backColumns);
                alFields = StringUtils.join((Collection)set, (String)",");
                String sql = "insert into " + backTable + "(" + alFields + ") select " + alFields + " from " + "t_eb_bgcontrolrecord" + " where fmodelid = ?";
                DB.execute((DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{modelId});
                DB.execute((DBRoute)BgBaseConstant.epm, (String)"delete from t_eb_bgcontrolrecord where fmodelid = ?", (Object[])new Object[]{modelId});
            }
        }
    }

    public static boolean hasTable(String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return false;
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            boolean bl = (Boolean)DB.query((DBRoute)BgBaseConstant.epm, (String)("/*dialect*/select top 1 fid from " + tableName + " where 1 = 2"), rs -> true);
            return bl;
        }
        catch (Throwable ex) {
            boolean bl = false;
            return bl;
        }
    }

    private void excuteSql(String sql, List<Object[]> paramsList) {
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, paramsList);
    }

    private void checkCtrlTable(Long modelId, Long bussModelId, DynamicObject ctrlDims, List<Dimension> userDefinedDimensions) {
        BgControlUtils.checkBgControlRecord(modelId, bussModelId, ctrlDims, userDefinedDimensions);
        BgControlUtils.checkBgControlRecordIndex(modelId, bussModelId, ctrlDims);
        String controlTable = BgControlUtils.getBgControlRecordTable(modelId, bussModelId);
        BgControlRecordUtils.checkExistEntryByRecord(controlTable);
        BgControlRecordUtils.checkExistOccPeriodByRecord(controlTable);
    }

    @Override
    public void rollBack() {
        if (this.getGroupContext() == null) {
            this.setGroupContext(new GroupContext());
        }
        this.execute(true);
    }

    @Override
    public void release() {
    }

    @Override
    public void loadData() {
    }

    public void loadConvertData() {
        Long id2;
        this.getPeriodMap().clear();
        this.getPeriodYearMap().clear();
        this.getConvertPeriodMap().clear();
        String sql = "select fid, fyearid, fperiod, fmodelid from t_eb_controlupgrademember";
        try (DataSet ds = DB.queryDataSet((String)"queryMemberTable", (DBRoute)BgBaseConstant.epm, (String)sql);){
            Long modelId = null;
            Long periodId = null;
            Long year = null;
            Long period = null;
            for (Row row : ds) {
                modelId = row.getLong("fmodelid");
                periodId = row.getLong("fid");
                year = row.getLong("fyearid");
                period = row.getLong("fperiod");
                this.getPeriodMap().computeIfAbsent(modelId, m -> Maps.newHashMap()).put(periodId, period);
                this.getPeriodYearMap().computeIfAbsent(modelId, m -> Maps.newHashMap()).put(periodId, year);
                this.getConvertPeriodMap().computeIfAbsent(modelId, m -> Maps.newHashMap()).put(year + "_" + period, periodId);
            }
        }
        this.getCtrlDimMap().clear();
        sql = "select fentryid, fdimensionid, fid from t_eb_controlupgradctrldim";
        ds = DB.queryDataSet((String)"queryCtrlDimTable", (DBRoute)BgBaseConstant.epm, (String)sql);
        var3_3 = null;
        try {
            id2 = null;
            Long entryid = null;
            Long dimensionid = null;
            for (Row row : ds) {
                id2 = row.getLong("fid");
                entryid = row.getLong("fentryid");
                dimensionid = row.getLong("fdimensionid");
                this.getCtrlDimMap().computeIfAbsent(id2, m -> Maps.newLinkedHashMapWithExpectedSize((int)10)).put(dimensionid, entryid);
            }
        }
        catch (Throwable id2) {
            var3_3 = id2;
            throw id2;
        }
        finally {
            if (ds != null) {
                if (var3_3 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable id2) {
                        var3_3.addSuppressed(id2);
                    }
                } else {
                    ds.close();
                }
            }
        }
        this.getCtrlDimNameMap().clear();
        if (SqlBatchUtils.hasTable((String)ctrlDimNameTable)) {
            sql = "select fid, fcontroldim from t_eb_controlupgradecdn";
            ds = DB.queryDataSet((String)"queryCtrlDimNameTable", (DBRoute)BgBaseConstant.epm, (String)sql);
            var3_3 = null;
            try {
                id2 = null;
                for (Row row : ds) {
                    id2 = row.getLong("fid");
                    this.getCtrlDimNameMap().put(id2, row.getString("fcontroldim"));
                }
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var3_3 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
    }

    private Map<Long, Map<Long, Long>> getPeriodYearMap() {
        return this.getMap("periodYearMap");
    }

    private Map<Long, Map<Long, Long>> getPeriodMap() {
        return this.getMap("periodMap");
    }

    private Map<Long, Map<String, Long>> getConvertPeriodMap() {
        return this.getMap("convertPeriodMap");
    }

    private Map<Long, LinkedHashMap<Long, Long>> getCtrlDimMap() {
        return this.getMap("ctrlDimMap");
    }

    private Map<Long, String> getCtrlDimNameMap() {
        return this.getMap("ctrlDimNameMap");
    }

    private Map getMap(String key) {
        Map map = (Map)this.getGroupContext().getParam(key);
        if (map == null) {
            map = Maps.newHashMap();
            this.getGroupContext().addParam(key, map);
        }
        return map;
    }
}

