/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.ebupgrades.context.ModelContext;
import kd.epm.eb.business.ebupgrades.context.OldDataContext;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockPeriodPolymer;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class DataLockUpgradesUtil {
    private static final Log log = LogFactory.getLog(DataLockUpgradesUtil.class);
    private static final List<String> periodNoLeafs = Arrays.asList("q1", "q2", "q3", "q4", "hf1", "hf2", "yeartotal");
    private static final Map<String, Integer> periodSortMap = new LinkedHashMap<String, Integer>(16);

    public static DataLockUpgradesUtil getInstance() {
        return new DataLockUpgradesUtil();
    }

    public Integer getNewPeriodInteger(Integer periodInteger, List<DynamicObject> oldPeriodData) {
        String periodNumber;
        if (oldPeriodData == null) {
            throw new KDBizException("getOldPeriodData error!");
        }
        HashMap<String, Character> map = new HashMap<String, Character>(16);
        String binaryString = Integer.toBinaryString(periodInteger);
        char[] chars = binaryString.toCharArray();
        ArrayList<String> oldPeriodNumbers = new ArrayList<String>(oldPeriodData.size());
        for (DynamicObject dynamicObject : oldPeriodData) {
            String number = dynamicObject.getString("number").toLowerCase();
            oldPeriodNumbers.add(number);
        }
        int j = 1;
        for (String number : oldPeriodNumbers) {
            if ('1' == chars[j] && !map.containsKey(periodNumber = number.split("_")[1])) {
                map.put(periodNumber, Character.valueOf('1'));
                this.fillChildren(map, periodNumber);
            }
            ++j;
        }
        this.dealNoLeafPeriodSelect(map);
        StringBuilder stringBuilder = new StringBuilder("1");
        for (int i = 0; i < 19; ++i) {
            periodNumber = BgmdDataLockPeriodPolymer.getPeriodNumber((int)i);
            Character character = (Character)map.get(periodNumber);
            stringBuilder.append((char)(character != null && '1' == character.charValue() ? 49 : 48));
        }
        return Integer.parseInt(stringBuilder.toString(), 2);
    }

    private void dealNoLeafPeriodSelect(Map<String, Character> map) {
        for (String periodNoLeaf : periodNoLeafs) {
            Set<String> keys = map.keySet();
            String[] periodChildren = BgmdDataLockPeriodPolymer.getPeriodChildren((String)periodNoLeaf);
            if (periodChildren == null) {
                return;
            }
            if (!keys.containsAll(Arrays.asList(periodChildren))) continue;
            map.put(periodNoLeaf, Character.valueOf('1'));
        }
    }

    public List<DynamicObject> getSortOldPeriodData(ModelContext modelContext) {
        OldDataContext oldPeriodData = modelContext.getOldDataContext(SysDimensionEnum.Period.getMemberTreemodel());
        if (oldPeriodData == null) {
            return new ArrayList<DynamicObject>(0);
        }
        List<DynamicObject> oldData = oldPeriodData.getOldData();
        oldData.removeIf(e -> "period".equals(e.getString("number").toLowerCase()));
        oldData.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Integer integer1 = (Integer)periodSortMap.get(o1.getString("number").split("_")[1].toLowerCase());
                Integer integer2 = (Integer)periodSortMap.get(o2.getString("number").split("_")[1].toLowerCase());
                return integer1 - integer2;
            }
        });
        return oldData;
    }

    private void fillChildren(Map<String, Character> map, String periodNumber) {
        String[] periodChildren = BgmdDataLockPeriodPolymer.getPeriodChildren((String)periodNumber);
        if (periodChildren != null) {
            for (String periodChild : periodChildren) {
                map.put(periodChild, Character.valueOf('1'));
                this.fillChildren(map, periodChild);
            }
        }
    }

    static {
        periodSortMap.put("yeartotal", 1);
        periodSortMap.put("hf1", 2);
        periodSortMap.put("q1", 3);
        periodSortMap.put("m01", 4);
        periodSortMap.put("m02", 5);
        periodSortMap.put("m03", 6);
        periodSortMap.put("q2", 7);
        periodSortMap.put("m04", 8);
        periodSortMap.put("m05", 9);
        periodSortMap.put("m06", 10);
        periodSortMap.put("hf2", 11);
        periodSortMap.put("q3", 12);
        periodSortMap.put("m07", 13);
        periodSortMap.put("m08", 14);
        periodSortMap.put("m09", 15);
        periodSortMap.put("q4", 16);
        periodSortMap.put("m10", 17);
        periodSortMap.put("m11", 18);
        periodSortMap.put("m12", 19);
    }
}

