/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.ebupgrades.pojo.EntityMetaPerm;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PermUpgradesUtil {
    private static final PermUpgradesUtil instance = new PermUpgradesUtil();
    private static final int EB_Page_Index = 1;
    private static final int EB_Page_Item_Index = 3;
    private static final int NBG_Page_Index = 5;
    private static final int NBG_Page_Item_Index = 7;

    public static PermUpgradesUtil getInstance() {
        return instance;
    }

    public Map<Long, List<Long>> getModelManagers(List<Long> modelIds) {
        Collection<Long> userGroups;
        HashMap<Long, List<Long>> modelManagers = new HashMap<Long, List<Long>>(16);
        QFilter qFilter = new QFilter("model", "in", modelIds);
        DynamicObjectCollection modelPermDynamics = QueryServiceHelper.query((String)"epm_modelperm", (String)"model.id, modelpermentry.eusers.id, modelpermentry.etype", (QFilter[])new QFilter[]{qFilter});
        if (modelPermDynamics.size() == 0) {
            return modelManagers;
        }
        HashMap modelManageGroups = new HashMap(16);
        HashSet<Long> userGroups_all = new HashSet<Long>(16);
        for (DynamicObject modelPermDynamic : modelPermDynamics) {
            long modelId;
            HashSet<Long> userIds = new HashSet<Long>(16);
            userGroups = new HashSet(16);
            String type = modelPermDynamic.getString("modelpermentry.etype");
            Long uid = modelPermDynamic.getLong("modelpermentry.eusers.id");
            if (uid == 0L) continue;
            if ("bos_user".equals(type)) {
                userIds.add(uid);
            } else {
                userGroups.add(uid);
                userGroups_all.add(uid);
            }
            if ((modelId = modelPermDynamic.getLong("model.id")) == 0L) continue;
            modelManagers.put(modelId, new ArrayList(userIds));
            modelManageGroups.put(modelId, new ArrayList(userGroups));
        }
        Map<Long, List<Long>> groupUsers = this.queryAllUsersByGroupIds(userGroups_all);
        for (Long modelId : modelIds) {
            userGroups = (List)modelManageGroups.get(modelId);
            if (userGroups.size() == 0) continue;
            List manageUsers = modelManagers.computeIfAbsent(modelId, k -> new ArrayList(16));
            for (Long userGroup : userGroups) {
                List<Long> users = groupUsers.get(userGroup);
                if (users == null) continue;
                manageUsers.addAll(users);
            }
        }
        return modelManagers;
    }

    private Map<Long, List<Long>> queryAllUsersByGroupIds(Collection<Long> userGroups) {
        HashMap<Long, List<Long>> groupMap = new HashMap<Long, List<Long>>(16);
        QFilter userGroupFilter = new QFilter("usergroup", "in", userGroups);
        DynamicObjectCollection userGroupCollection = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"user, usergroup", (QFilter[])new QFilter[]{userGroupFilter});
        for (DynamicObject userGroup : userGroupCollection) {
            Long userGroupId = userGroup.getLong("usergroup");
            List userIds = groupMap.computeIfAbsent(userGroupId, k -> new ArrayList(16));
            userIds.add(userGroup.getLong("user"));
        }
        return groupMap;
    }

    public List<String> getEpmRoleIds() {
        ArrayList<String> roleIds = new ArrayList<String>(16);
        String sql = " select fid from t_perm_role where fdimtypeid in (select fid from t_perm_ctrltype where fnumber = 'DIM_EPM_MODEL')";
        try (DataSet ds = DB.queryDataSet((String)"queryRoles", (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
            while (ds.hasNext()) {
                Row row = ds.next();
                roleIds.add(row.getString("fid"));
            }
        }
        return roleIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, EntityMetaPerm> getEbUpgradesPermMap() {
        HashMap<String, EntityMetaPerm> permMap = new HashMap<String, EntityMetaPerm>(16);
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("ebpermupgrades/eb_permupgrades.xlsx");){
            if (in == null) {
                HashMap<String, EntityMetaPerm> hashMap = permMap;
                return hashMap;
            }
            try (XSSFWorkbook book = new XSSFWorkbook(in);){
                XSSFSheet sheet = book.getSheetAt(0);
                int rowIndex = 1;
                int rowCount = sheet.getLastRowNum();
                while (rowIndex <= rowCount) {
                    XSSFRow row = sheet.getRow(rowIndex);
                    if (row != null) {
                        String page_Eb = this.getValue(row.getCell(1));
                        String item_Eb = this.getValue(row.getCell(3));
                        String page_Nbg = this.getValue(row.getCell(5));
                        String item_Nbg = this.getValue(row.getCell(7));
                        if (!(StringUtils.isEmpty((String)page_Eb) || StringUtils.isEmpty((String)page_Nbg) || StringUtils.isEmpty((String)item_Eb) || StringUtils.isEmpty((String)item_Nbg))) {
                            EntityMetaPerm entityMetaPerm = (EntityMetaPerm)permMap.get(page_Eb);
                            if (entityMetaPerm == null) {
                                entityMetaPerm = new EntityMetaPerm();
                                entityMetaPerm.setCurEntity(page_Eb);
                                entityMetaPerm.setMapEntity(page_Nbg);
                                permMap.put(page_Eb, entityMetaPerm);
                            }
                            Map<String, String> permItemMap = entityMetaPerm.getPermItemMap();
                            permItemMap.put(item_Eb, item_Nbg);
                        }
                    }
                    ++rowIndex;
                }
                return permMap;
            }
        }
        catch (IOException ex) {
            throw new KDBizException("load eb_permupgrades error!");
        }
    }

    private String getValue(XSSFCell cell) {
        String value = "";
        if (cell != null) {
            value = cell.getStringCellValue();
        }
        return StringUtils.isNotEmpty((String)value) ? value.trim() : value;
    }
}

